/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.searchEverywhere.frontend.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.platform.searchEverywhere.frontend.SeFilterActionsPresentation;
import com.intellij.platform.searchEverywhere.frontend.SeFilterComponentPresentation;
import com.intellij.platform.searchEverywhere.frontend.SeFilterPresentation;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignKt;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ExtensionsKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.gridLayout.GridLayout;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.ui.dsl.gridLayout.VerticalAlign;
import com.intellij.ui.dsl.gridLayout.builders.RowsGridBuilder;
import com.intellij.util.SwingBindingsKt;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.MutableStateFlow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B<\u0012\u0011\u0010\u0002\u001a\r\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\b\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0013\u0010\u0019\u001a\u00020\u00162\u000b\u0010\u001a\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005J\u0012\u0010\u001b\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\fH\u0002J\u0016\u0010\u001d\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0003H\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/platform/searchEverywhere/frontend/ui/SePopupHeaderPane;", "Lcom/intellij/ui/components/panels/NonOpaquePanel;", "tabNames", "", "", "Lorg/jetbrains/annotations/Nls;", "selectedTabState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "toolbar", "Ljavax/swing/JComponent;", "<init>", "(Ljava/util/List;Lkotlinx/coroutines/flow/MutableStateFlow;Lkotlinx/coroutines/CoroutineScope;Ljavax/swing/JComponent;)V", "tabbedPane", "Lcom/intellij/ui/components/JBTabbedPane;", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "tabFilterContainer", "Ljavax/swing/JPanel;", "setFilterPresentation", "", "filterPresentation", "Lcom/intellij/platform/searchEverywhere/frontend/SeFilterPresentation;", "addTab", "tabName", "setFilterComponent", "filterComponent", "setFilterActions", "actions", "Lcom/intellij/openapi/actionSystem/AnAction;", "Companion", "intellij.platform.searchEverywhere.frontend"})
@ApiStatus.Internal
public final class SePopupHeaderPane
extends NonOpaquePanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private JBTabbedPane tabbedPane;
    @NotNull
    private final DialogPanel panel;
    @NotNull
    private final JPanel tabFilterContainer;
    private static final int MAX_FILTER_WIDTH = 100;

    /*
     * WARNING - void declaration
     */
    public SePopupHeaderPane(@NotNull List<String> tabNames, @NotNull MutableStateFlow<Integer> selectedTabState, @NotNull CoroutineScope coroutineScope, @Nullable JComponent toolbar) {
        void $this$tabFilterContainer_u24lambda_u240;
        Intrinsics.checkNotNullParameter(tabNames, (String)"tabNames");
        Intrinsics.checkNotNullParameter(selectedTabState, (String)"selectedTabState");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        JPanel jPanel = new JPanel(){

            public Dimension getPreferredSize() {
                Component[] componentArray = this.getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                Serializable serializable = (Component)ArraysKt.firstOrNull((Object[])componentArray);
                if (serializable == null || (serializable = serializable.getPreferredSize()) == null) {
                    serializable = new Dimension(0, 0);
                }
                Serializable dimension = serializable;
                return new Dimension(RangesKt.coerceAtMost((int)((Dimension)dimension).width, (int)100), 0);
            }
        };
        JPanel jPanel2 = jPanel;
        SePopupHeaderPane sePopupHeaderPane = this;
        boolean bl = false;
        $this$tabFilterContainer_u24lambda_u240.setLayout((LayoutManager)new GridLayout());
        $this$tabFilterContainer_u24lambda_u240.setBackground(JBUI.CurrentTheme.ComplexPopup.HEADER_BACKGROUND);
        sePopupHeaderPane.tabFilterContainer = jPanel;
        this.setBackground(JBUI.CurrentTheme.ComplexPopup.HEADER_BACKGROUND);
        this.panel = BuilderKt.panel(arg_0 -> SePopupHeaderPane._init_$lambda$3(this, toolbar, arg_0));
        this.panel.setBackground(JBUI.CurrentTheme.ComplexPopup.HEADER_BACKGROUND);
        JBInsets headerInsets = JBUI.CurrentTheme.ComplexPopup.headerInsets();
        this.panel.setBorder(JBUI.Borders.compound((Border)JBUI.Borders.customLineBottom((Color)JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground()), (Border)new EmptyBorder(0, headerInsets.left, 0, headerInsets.right)));
        for (String tab : tabNames) {
            JBTabbedPane jBTabbedPane = this.tabbedPane;
            if (jBTabbedPane == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tabbedPane");
                jBTabbedPane = null;
            }
            jBTabbedPane.addTab(tab, null, (Component)new JPanel(), tab);
        }
        this.add((Component)this.panel);
        JBTabbedPane jBTabbedPane = this.tabbedPane;
        if (jBTabbedPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tabbedPane");
            jBTabbedPane = null;
        }
        SwingBindingsKt.bindSelectedTabIn((JTabbedPane)((JTabbedPane)jBTabbedPane), selectedTabState, (CoroutineScope)coroutineScope);
    }

    public /* synthetic */ SePopupHeaderPane(List list, MutableStateFlow mutableStateFlow, CoroutineScope coroutineScope, JComponent jComponent, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            jComponent = null;
        }
        this(list, (MutableStateFlow<Integer>)mutableStateFlow, coroutineScope, jComponent);
    }

    public final void setFilterPresentation(@Nullable SeFilterPresentation filterPresentation) {
        SeFilterPresentation seFilterPresentation = filterPresentation;
        if (seFilterPresentation instanceof SeFilterActionsPresentation) {
            this.setFilterActions(((SeFilterActionsPresentation)filterPresentation).getActions());
        } else if (seFilterPresentation instanceof SeFilterComponentPresentation) {
            this.setFilterComponent(((SeFilterComponentPresentation)filterPresentation).getComponent());
        } else if (seFilterPresentation == null) {
            this.setFilterComponent(null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public final void addTab(@NotNull String tabName) {
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        JBTabbedPane jBTabbedPane = this.tabbedPane;
        if (jBTabbedPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tabbedPane");
            jBTabbedPane = null;
        }
        jBTabbedPane.addTab(tabName, null, (Component)new JPanel(), tabName);
    }

    private final void setFilterComponent(JComponent filterComponent) {
        int oldCount = this.tabFilterContainer.getComponentCount();
        this.tabFilterContainer.removeAll();
        if (filterComponent != null) {
            RowsGridBuilder.cell$default((RowsGridBuilder)RowsGridBuilder.row$default((RowsGridBuilder)new RowsGridBuilder((JComponent)this.tabFilterContainer, null, 2, null), null, (boolean)true, (int)1, null), (JComponent)filterComponent, (int)0, null, (VerticalAlign)VerticalAlign.CENTER, (boolean)false, (boolean)false, null, null, null, null, (int)1014, null);
        }
        if (this.tabFilterContainer.getComponentCount() + oldCount > 0) {
            this.tabFilterContainer.revalidate();
            this.tabFilterContainer.repaint();
        }
    }

    private final void setFilterActions(List<? extends AnAction> actions) {
        DefaultActionGroup actionGroup = new DefaultActionGroup(actions);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("search.everywhere.toolbar", (ActionGroup)actionGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar toolbar = actionToolbar;
        toolbar.setLayoutStrategy(ToolbarLayoutStrategy.NOWRAP_STRATEGY);
        toolbar.setTargetComponent((JComponent)((Object)this));
        JComponent jComponent = toolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent toolbarComponent = jComponent;
        toolbarComponent.setOpaque(false);
        toolbarComponent.setBorder((Border)JBUI.Borders.empty((int)2, (int)18, (int)2, (int)9));
        this.setFilterComponent(toolbarComponent);
    }

    private static final Unit lambda$3$lambda$2$lambda$1(JBTabbedPane $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setFont((Font)JBFont.regular());
        $this$applyToComponent.setBackground(JBUI.CurrentTheme.ComplexPopup.HEADER_BACKGROUND);
        $this$applyToComponent.setFocusable(false);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$3$lambda$2(SePopupHeaderPane this$0, JComponent $toolbar, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.tabbedPane = (JBTabbedPane)ExtensionsKt.tabbedPaneHeader$default((Row)$this$row, null, (int)1, null).customize(UnscaledGaps.EMPTY).applyToComponent(SePopupHeaderPane::lambda$3$lambda$2$lambda$1).getComponent();
        $this$row.cell((JComponent)this$0.tabFilterContainer).align(AlignKt.plus((AlignY)((AlignY)AlignY.FILL.INSTANCE), (AlignX)((AlignX)AlignX.RIGHT.INSTANCE))).resizableColumn();
        if ($toolbar != null) {
            $toolbar.putClientProperty("ActionToolbarImpl.baseline", true);
            $this$row.cell($toolbar).align((Align)AlignX.RIGHT.INSTANCE).customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)18, (int)0, (int)0, (int)13, null));
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(SePopupHeaderPane this$0, JComponent $toolbar, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> SePopupHeaderPane.lambda$3$lambda$2(this$0, $toolbar, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/searchEverywhere/frontend/ui/SePopupHeaderPane$Companion;", "", "<init>", "()V", "MAX_FILTER_WIDTH", "", "intellij.platform.searchEverywhere.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

