/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.recentFiles.frontend;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.recentFiles.frontend.model.FrontendRecentFilesModel;
import com.intellij.platform.recentFiles.shared.FileChangeKind;
import com.intellij.platform.recentFiles.shared.RecentFileKind;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/recentFiles/frontend/RecentlySelectedEditorListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "<init>", "()V", "fileOpened", "", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileClosed", "selectionChanged", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "intellij.platform.recentFiles.frontend"})
final class RecentlySelectedEditorListener
implements FileEditorManagerListener {
    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Project project = source.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        FrontendRecentFilesModel frontendRecentFilesModel = FrontendRecentFilesModel.Companion.getInstance(project);
        frontendRecentFilesModel.applyFrontendChanges(RecentFileKind.RECENTLY_OPENED, CollectionsKt.listOf((Object)file), FileChangeKind.ADDED);
        frontendRecentFilesModel.applyFrontendChanges(RecentFileKind.RECENTLY_OPENED_UNPINNED, CollectionsKt.listOf((Object)file), FileChangeKind.ADDED);
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Project project = source.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        FrontendRecentFilesModel frontendRecentFilesModel = FrontendRecentFilesModel.Companion.getInstance(project);
        frontendRecentFilesModel.applyFrontendChanges(RecentFileKind.RECENTLY_OPENED_UNPINNED, CollectionsKt.listOf((Object)file), FileChangeKind.REMOVED);
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile virtualFile = event.getNewFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        Project project = event.getManager().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        FrontendRecentFilesModel frontendRecentFilesModel = FrontendRecentFilesModel.Companion.getInstance(project);
        frontendRecentFilesModel.applyFrontendChanges(RecentFileKind.RECENTLY_OPENED, CollectionsKt.listOf((Object)file), FileChangeKind.UPDATED_AND_PUT_ON_TOP);
        frontendRecentFilesModel.applyFrontendChanges(RecentFileKind.RECENTLY_OPENED_UNPINNED, CollectionsKt.listOf((Object)file), FileChangeKind.UPDATED_AND_PUT_ON_TOP);
    }
}

