/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ui.fileTree;

import com.intellij.codeWithMe.ClientId;
import com.intellij.docker.DockerRootType;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.ui.fileTree.FileSystemNode;
import com.intellij.docker.ui.fileTree.FileSystemTree;
import com.intellij.docker.utils.IOUtilsKt;
import com.intellij.docker.vfs.EelVirtualFileResolverKt;
import com.intellij.docker.vfs.RemoteFileService;
import com.intellij.icons.AllIcons;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.eel.path.EelPath;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/docker/ui/fileTree/DownloadFileAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "fileSystemTree", "Lcom/intellij/docker/ui/fileTree/FileSystemTree;", "<init>", "(Lcom/intellij/docker/ui/fileTree/FileSystemTree;)V", "applicationService", "Lcom/intellij/docker/vfs/RemoteFileService;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "getTargetFile", "Ljava/nio/file/Path;", "node", "Lcom/intellij/docker/ui/fileTree/FileSystemNode;", "resolveTargetDirectory", "containerDirectory", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nFileActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileActions.kt\ncom/intellij/docker/ui/fileTree/DownloadFileAction\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,206:1\n40#2,3:207\n*S KotlinDebug\n*F\n+ 1 FileActions.kt\ncom/intellij/docker/ui/fileTree/DownloadFileAction\n*L\n145#1:207,3\n*E\n"})
public final class DownloadFileAction
extends DumbAwareAction {
    @NotNull
    private final FileSystemTree fileSystemTree;
    @NotNull
    private final RemoteFileService applicationService;

    public DownloadFileAction(@NotNull FileSystemTree fileSystemTree) {
        Intrinsics.checkNotNullParameter((Object)((Object)fileSystemTree), (String)"fileSystemTree");
        super(DownloadFileAction::_init_$lambda$0, AllIcons.Actions.Download);
        this.fileSystemTree = fileSystemTree;
        boolean $i$f$service = false;
        Class<RemoteFileService> serviceClass$iv = RemoteFileService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this.applicationService = (RemoteFileService)object;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        FileSystemNode node = this.fileSystemTree.getSelectedNode();
        e.getPresentation().setEnabled(!node.isDirectory());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        FileSystemNode node = this.fileSystemTree.getSelectedNode();
        BuildersKt.launch$default((CoroutineScope)this.applicationService.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, node, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DownloadFileAction this$0;
            final /* synthetic */ FileSystemNode $node;
            {
                this.this$0 = $receiver;
                this.$node = $node;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var5_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        targetFile = DownloadFileAction.access$getTargetFile(this.this$0, this.$node);
                        if (!Files.exists(targetFile, new LinkOption[0])) ** GOTO lbl47
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.L$1 = targetFile;
                        this.label = 1;
                        v0 = EelVirtualFileResolverKt.readFileFromRemoteEnvironment((CoroutineScope)$this$launch, this.$node.getFileTreePath(), (Continuation<? super ReadableByteChannel>)((Continuation)this));
                        ** if (v0 != var5_3) goto lbl16
lbl15:
                        // 1 sources

                        return var5_3;
lbl16:
                        // 1 sources

                        ** GOTO lbl23
                    }
                    case 1: {
                        targetFile = (Path)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl23:
                        // 2 sources

                        fileContentChannel = (ReadableByteChannel)v0;
                        IOUtilsKt.writeToLocalFile(fileContentChannel, targetFile);
                        v1 = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
                        v2 = ModalityState.any();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"any(...)");
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)targetFile);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)fileContentChannel);
                        this.label = 2;
                        v3 = BuildersKt.withContext((CoroutineContext)v1.plus(ModalityKt.asContextElement((ModalityState)v2)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                            int label;

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        VirtualFileManager.getInstance().refreshWithoutFileWatcher(true);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v3 != var5_3) goto lbl35
lbl34:
                        // 1 sources

                        return var5_3;
lbl35:
                        // 1 sources

                        ** GOTO lbl47
                    }
                    case 2: {
                        fileContentChannel = (ReadableByteChannel)this.L$2;
                        targetFile = (Path)this.L$1;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
                        }
                        catch (Exception <unused var>) {
                            var4_8 = new Object[]{this.$node.getFileTreePath().getPath()};
                            new Notification("Docker", DockerBundle.message((String)"ShowFiles.notification.content.error.occurred.while.downloading.file", (Object[])var4_8), NotificationType.ERROR).notify(this.$node.getProject());
                        }
lbl47:
                        // 4 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Path getTargetFile(FileSystemNode node) {
        String string = ScratchFileService.getInstance().getRootPath((RootType)DockerRootType.getInstance());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRootPath(...)");
        String scratchRootPath = string;
        String[] stringArray = new String[]{node.getFileTreePath().getEnvTitle()};
        Path containerDirectory = Paths.get(scratchRootPath, stringArray);
        if (Files.notExists(containerDirectory, new LinkOption[0])) {
            Files.createDirectories(containerDirectory, new FileAttribute[0]);
        }
        Intrinsics.checkNotNull((Object)containerDirectory);
        Path targetDirectory = this.resolveTargetDirectory(containerDirectory, node);
        Path targetFile = targetDirectory.resolve(node.getFileTreePath().getPath().getFileName());
        Files.createFile(targetFile, new FileAttribute[0]);
        Intrinsics.checkNotNull((Object)targetFile);
        return targetFile;
    }

    private final Path resolveTargetDirectory(Path containerDirectory, FileSystemNode node) {
        EelPath eelPath = node.getFileTreePath().getPath().getParent();
        if (eelPath == null) {
            throw new Exception("Parent path cannot be null");
        }
        EelPath parentPath = eelPath;
        String string = parentPath.toString().substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        Path targetDirectory = containerDirectory.resolve(string);
        if (Files.notExists(targetDirectory, new LinkOption[0])) {
            Files.createDirectories(targetDirectory, new FileAttribute[0]);
        }
        Intrinsics.checkNotNull((Object)targetDirectory);
        return targetDirectory;
    }

    private static final String _init_$lambda$0() {
        return DockerBundle.message((String)"ShowFiles.action.download.file.text", (Object[])new Object[0]);
    }

    public static final /* synthetic */ Path access$getTargetFile(DownloadFileAction $this, FileSystemNode node) {
        return $this.getTargetFile(node);
    }
}

