/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.utils;

import com.intellij.docker.DockerAgentConnector;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerMainCoroutineScopeHolder;
import com.intellij.docker.DockerRuntimesManager;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.settings.DockerPathMappingImpl;
import com.intellij.docker.deployment.DockerRunConfig;
import com.intellij.docker.runtimes.DockerContainerRuntime;
import com.intellij.docker.runtimes.DockerGroupRuntime;
import com.intellij.docker.runtimes.DockerImageRuntime;
import com.intellij.docker.runtimes.DockerPhysicalRuntime;
import com.intellij.docker.runtimes.DockerVolumeRuntime;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.docker.utils.TestUtilsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000~\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001c\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00040\u0001\u001a\u0010\u0010\u0005\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u001a\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002\u001a@\u0010\u0013\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u0015*\u00020\u00032\"\u0010\u0016\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00140\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0017H\u0086@\u00a2\u0006\u0002\u0010\u001a\u001a\u0010\u0010\u001b\u001a\u00020\u001c*\b\u0012\u0004\u0012\u00020\u00030\u0002\u001a\u001d\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u000f\b\u0002\u0010\u001e\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u001f\u001a\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001\u001a$\u0010!\u001a\u0004\u0018\u0001H\u0014\"\u000e\b\u0000\u0010\u0014\u0018\u0001*\u0006\u0012\u0002\b\u00030\"*\u00020#H\u0080\b\u00a2\u0006\u0002\u0010$\u001a,\u0010%\u001a\u0004\u0018\u0001H\u0014\"\u000e\b\u0000\u0010\u0014\u0018\u0001*\u0006\u0012\u0002\b\u00030&*\u00020#2\u0006\u0010'\u001a\u00020\u0007H\u0086\b\u00a2\u0006\u0002\u0010(\u001a\u0016\u0010)\u001a\u00020\t2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002\u001a3\u0010+\u001a\b\u0012\u0004\u0012\u0002H\u00140,\"\u0004\b\u0000\u0010\u00142\u0006\u0010-\u001a\u0002H\u00142\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020\u001c0/\u00a2\u0006\u0002\u00100\u001a\u001a\u00101\u001a\u0004\u0018\u00010\u00072\u0006\u00102\u001a\u00020\u00032\b\u00103\u001a\u0004\u0018\u00010\u0007\u001a\u001a\u00104\u001a\u0004\u0018\u00010\u00072\u0006\u00102\u001a\u00020\u00032\b\u00103\u001a\u0004\u0018\u00010\u0007\"\u0015\u0010\b\u001a\u00020\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000b\"\u0017\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00065"}, d2={"allServersExceptKnowns", "", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "Lcom/intellij/docker/deployment/DockerRunConfig$Wrapper;", "getDockerCloudConfiguration", "accountName", "", "isInUse", "", "Lcom/intellij/docker/runtimes/DockerVolumeRuntime;", "(Lcom/intellij/docker/runtimes/DockerVolumeRuntime;)Z", "image", "Lcom/intellij/docker/runtimes/DockerImageRuntime;", "Lcom/intellij/docker/runtimes/DockerContainerRuntime;", "getImage", "(Lcom/intellij/docker/runtimes/DockerContainerRuntime;)Lcom/intellij/docker/runtimes/DockerImageRuntime;", "getOrCreateDockerLocalServer", "getDockerLocalServer", "onTemporaryAgentConnection", "T", "", "onConnected", "Lkotlin/Function2;", "Lcom/intellij/docker/agent/DockerAgent;", "Lkotlin/coroutines/Continuation;", "(Lcom/intellij/docker/DockerCloudConfiguration;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addToServersManagerIfNeeded", "", "createDefaultDockerServer", "name", "Lorg/jetbrains/annotations/Nls;", "getDockerServers", "findRuntimesGroup", "Lcom/intellij/docker/runtimes/DockerGroupRuntime;", "Lcom/intellij/docker/DockerRuntimesManager;", "(Lcom/intellij/docker/DockerRuntimesManager;)Lcom/intellij/docker/runtimes/DockerGroupRuntime;", "findRuntimeById", "Lcom/intellij/docker/runtimes/DockerPhysicalRuntime;", "id", "(Lcom/intellij/docker/DockerRuntimesManager;Ljava/lang/String;)Lcom/intellij/docker/runtimes/DockerPhysicalRuntime;", "isDefaultDockerServer", "server", "atomicObservableProperty", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "default", "listener", "Lkotlin/Function1;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Lcom/intellij/openapi/observable/properties/AtomicProperty;", "convertDockerMachinePathToLocalPath", "config", "hostPath", "convertLocalPathToDockerMachinePath", "intellij.clouds.docker"})
@JvmName(name="DockerUtils")
@SourceDebugExtension(value={"SMAP\ndockerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 dockerUtils.kt\ncom/intellij/docker/utils/DockerUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n98#1:155\n1617#2,9:139\n1869#2:148\n1870#2:150\n1626#2:151\n774#2:152\n865#2,2:153\n808#2,11:156\n808#2,11:169\n1#3:149\n1#3:167\n1#3:168\n*S KotlinDebug\n*F\n+ 1 dockerUtils.kt\ncom/intellij/docker/utils/DockerUtils\n*L\n39#1:155\n21#1:139,9\n21#1:148\n21#1:150\n21#1:151\n23#1:152\n23#1:153,2\n39#1:156,11\n98#1:169,11\n21#1:149\n39#1:167\n*E\n"})
public final class DockerUtils {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<RemoteServer<DockerCloudConfiguration>> allServersExceptKnowns(@NotNull List<DockerRunConfig.Wrapper> $this$allServersExceptKnowns) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$allServersExceptKnowns, (String)"<this>");
        Iterable $this$mapNotNull$iv = $this$allServersExceptKnowns;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            DockerRunConfig.Wrapper it = (DockerRunConfig.Wrapper)element$iv$iv;
            boolean bl2 = false;
            if (it.getConfig().getServerName() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set knownServerNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        List list2 = RemoteServersManager.getInstance().getServers((ServerType)DockerCloudType.getInstance());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getServers(...)");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RemoteServer it = (RemoteServer)element$iv$iv;
            boolean bl = false;
            if (!(!knownServerNames.contains(it.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final DockerCloudConfiguration getDockerCloudConfiguration(@Nullable String accountName) {
        CharSequence charSequence = accountName;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw new IllegalStateException("Docker account not specified");
        }
        RemoteServer remoteServer = RemoteServersManager.getInstance().findByName(accountName, (ServerType)DockerCloudType.getInstance());
        if (remoteServer == null) {
            throw new IllegalStateException("Docker account not found");
        }
        RemoteServer server = remoteServer;
        ServerConfiguration serverConfiguration = server.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)serverConfiguration, (String)"getConfiguration(...)");
        return (DockerCloudConfiguration)serverConfiguration;
    }

    public static final boolean isInUse(@NotNull DockerVolumeRuntime $this$isInUse) {
        Intrinsics.checkNotNullParameter((Object)$this$isInUse, (String)"<this>");
        return UtilKt.nullize($this$isInUse.getAttachedContainers()) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final DockerImageRuntime getImage(@NotNull DockerContainerRuntime $this$image) {
        Object v0;
        block2: {
            void $this$filterIsInstanceTo$iv$iv$iv;
            void $this$findRuntimeById$iv;
            Intrinsics.checkNotNullParameter((Object)$this$image, (String)"<this>");
            DockerRuntimesManager dockerRuntimesManager = $this$image.getContext().getRuntimesManager();
            String id$iv = $this$image.getImageId();
            boolean $i$f$findRuntimeById = false;
            Iterable $this$filterIsInstance$iv$iv = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus($this$findRuntimeById$iv.getContainers().values(), (Iterable)$this$findRuntimeById$iv.getImages().values()), (Iterable)$this$findRuntimeById$iv.getNetworks().values()), (Iterable)$this$findRuntimeById$iv.getVolumes().values());
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                if (!(element$iv$iv$iv instanceof DockerImageRuntime)) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv$iv;
            for (Object e : iterable2) {
                DockerPhysicalRuntime it$iv = (DockerPhysicalRuntime)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it$iv.getId(), (Object)id$iv)) continue;
                v0 = e;
                break block2;
            }
            v0 = null;
        }
        return (DockerImageRuntime)((DockerPhysicalRuntime)v0);
    }

    @NotNull
    public static final RemoteServer<DockerCloudConfiguration> getOrCreateDockerLocalServer() {
        RemoteServer remoteServer = DockerUtils.getDockerLocalServer();
        if (remoteServer == null) {
            RemoteServer remoteServer2;
            RemoteServer server = remoteServer2 = DockerUtils.createDefaultDockerServer$default(null, 1, null);
            boolean bl = false;
            if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManagerEx.isInIntegrationTest()) {
                ServerConfiguration serverConfiguration = server.getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)serverConfiguration, (String)"getConfiguration(...)");
                TestUtilsKt.fixDefaultDockerConfigurationIfNeeded((DockerCloudConfiguration)serverConfiguration);
            }
            remoteServer = remoteServer2;
        }
        return remoteServer;
    }

    @Nullable
    public static final RemoteServer<DockerCloudConfiguration> getDockerLocalServer() {
        Object v0;
        block1: {
            Iterable iterable = DockerUtils.getDockerServers();
            for (Object t : iterable) {
                RemoteServer p0 = (RemoteServer)t;
                boolean bl = false;
                if (!DockerUtils.isDefaultDockerServer((RemoteServer<DockerCloudConfiguration>)p0)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public static final <T> Object onTemporaryAgentConnection(@NotNull DockerCloudConfiguration $this$onTemporaryAgentConnection, @NotNull Function2<? super DockerAgent, ? super Continuation<? super T>, ? extends Object> onConnected, @NotNull Continuation<? super T> $completion) {
        if (!($completion instanceof onTemporaryAgentConnection.1)) ** GOTO lbl-1000
        var8_3 = $completion;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DockerUtils.onTemporaryAgentConnection(null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                agent = DockerAgent.Companion.createInstance(DockerMainCoroutineScopeHolder.createChildScope$default(DockerMainCoroutineScopeHolder.Companion.getInstance(), null, false, 3, null));
                connector = new DockerAgentConnector($this$onTemporaryAgentConnection, agent);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$onTemporaryAgentConnection);
                $continuation.L$1 = onConnected;
                $continuation.L$2 = agent;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)connector);
                $continuation.label = 1;
                v0 = connector.connect((Continuation<? super Unit>)$continuation);
                if (v0 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl31
            }
            case 1: {
                connector = (DockerAgentConnector)$continuation.L$3;
                agent = (DockerAgent)$continuation.L$2;
                onConnected = (Function2)$continuation.L$1;
                $this$onTemporaryAgentConnection = (DockerCloudConfiguration)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl31:
                // 3 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$onTemporaryAgentConnection);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)onConnected);
                $continuation.L$2 = agent;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)connector);
                $continuation.label = 2;
                v1 = onConnected.invoke((Object)agent, $continuation);
                ** if (v1 != var9_5) goto lbl40
lbl39:
                // 1 sources

                return var9_5;
lbl40:
                // 1 sources

                ** GOTO lbl50
            }
            case 2: {
                connector = (DockerAgentConnector)$continuation.L$3;
                agent = (DockerAgent)$continuation.L$2;
                onConnected = (Function2)$continuation.L$1;
                $this$onTemporaryAgentConnection = (DockerCloudConfiguration)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl50:
                    // 2 sources

                    var5_8 = v1;
                }
                catch (Throwable var6_9) {
                    throw var6_9;
                }
                finally {
                    agent.disconnect();
                }
                return var5_8;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final void addToServersManagerIfNeeded(@NotNull RemoteServer<DockerCloudConfiguration> $this$addToServersManagerIfNeeded) {
        Intrinsics.checkNotNullParameter($this$addToServersManagerIfNeeded, (String)"<this>");
        RemoteServer<DockerCloudConfiguration> server = $this$addToServersManagerIfNeeded;
        RemoteServersManager $this$addToServersManagerIfNeeded_u24lambda_u243 = RemoteServersManager.getInstance();
        boolean bl = false;
        if ($this$addToServersManagerIfNeeded_u24lambda_u243.findByName($this$addToServersManagerIfNeeded.getName(), (ServerType)DockerCloudType.getInstance()) == null) {
            $this$addToServersManagerIfNeeded_u24lambda_u243.addServer(server);
        }
    }

    @NotNull
    public static final RemoteServer<DockerCloudConfiguration> createDefaultDockerServer(@Nullable String name) {
        RemoteServersManager remoteServersManager = RemoteServersManager.getInstance();
        DockerCloudType type = DockerCloudType.getInstance();
        if (name != null) {
            RemoteServer remoteServer = remoteServersManager.createServer((ServerType)type, name);
            Intrinsics.checkNotNullExpressionValue((Object)remoteServer, (String)"createServer(...)");
            return remoteServer;
        }
        RemoteServer remoteServer = remoteServersManager.createServer((ServerType)type);
        Intrinsics.checkNotNullExpressionValue((Object)remoteServer, (String)"createServer(...)");
        return remoteServer;
    }

    public static /* synthetic */ RemoteServer createDefaultDockerServer$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return DockerUtils.createDefaultDockerServer(string);
    }

    @NotNull
    public static final List<RemoteServer<DockerCloudConfiguration>> getDockerServers() {
        List list2 = RemoteServersManager.getInstance().getServers((ServerType)DockerCloudType.getInstance());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getServers(...)");
        return list2;
    }

    public static final /* synthetic */ <T extends DockerGroupRuntime<?>> T findRuntimesGroup(DockerRuntimesManager $this$findRuntimesGroup) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$findRuntimesGroup, (String)"<this>");
            boolean $i$f$findRuntimesGroup = false;
            Iterable iterable = $this$findRuntimesGroup.getRuntimeGroups$intellij_clouds_docker();
            for (Object t : iterable) {
                DockerGroupRuntime it = (DockerGroupRuntime)t;
                boolean bl = false;
                Intrinsics.reifiedOperationMarker((int)3, (String)"T");
                if (!(it instanceof DockerGroupRuntime)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)((DockerGroupRuntime)v0);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ <T extends DockerPhysicalRuntime<?>> T findRuntimeById(DockerRuntimesManager $this$findRuntimeById, String id) {
        Object v0;
        block2: {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$findRuntimeById, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            boolean $i$f$findRuntimeById = false;
            Iterable $this$filterIsInstance$iv = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus($this$findRuntimeById.getContainers().values(), (Iterable)$this$findRuntimeById.getImages().values()), (Iterable)$this$findRuntimeById.getNetworks().values()), (Iterable)$this$findRuntimeById.getVolumes().values());
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                Intrinsics.reifiedOperationMarker((int)3, (String)"T");
                if (!(element$iv$iv instanceof Object)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            for (Object e : iterable2) {
                DockerPhysicalRuntime it = (DockerPhysicalRuntime)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v0 = e;
                break block2;
            }
            v0 = null;
        }
        return (T)((DockerPhysicalRuntime)v0);
    }

    private static final boolean isDefaultDockerServer(RemoteServer<DockerCloudConfiguration> server) {
        return Intrinsics.areEqual((Object)((DockerCloudConfiguration)server.getConfiguration()).getCustomConfiguratorId(), (Object)"DockerDefaultConnectionConfigurator");
    }

    @NotNull
    public static final <T> AtomicProperty<T> atomicObservableProperty(T t, @NotNull Function1<? super T, Unit> listener2) {
        AtomicProperty atomicProperty;
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        AtomicProperty property = atomicProperty = new AtomicProperty(t);
        boolean bl = false;
        property.afterChange(listener2);
        return atomicProperty;
    }

    @Nullable
    public static final String convertDockerMachinePathToLocalPath(@NotNull DockerCloudConfiguration config2, @Nullable String hostPath) {
        Intrinsics.checkNotNullParameter((Object)((Object)config2), (String)"config");
        if (hostPath != null && !SystemInfo.isLinux) {
            for (DockerPathMappingImpl mapping : config2.getPathMappings()) {
                String virtualMachinePath = mapping.getVirtualMachinePath();
                Intrinsics.checkNotNull((Object)virtualMachinePath);
                if (!StringsKt.startsWith$default((String)hostPath, (String)virtualMachinePath, (boolean)false, (int)2, null)) continue;
                return FileUtil.toSystemDependentName((String)(mapping.getLocalPath() + StringsKt.removePrefix((String)hostPath, (CharSequence)virtualMachinePath)));
            }
        }
        return hostPath;
    }

    @Nullable
    public static final String convertLocalPathToDockerMachinePath(@NotNull DockerCloudConfiguration config2, @Nullable String hostPath) {
        Intrinsics.checkNotNullParameter((Object)((Object)config2), (String)"config");
        String hostPathVar = hostPath;
        if (hostPath != null && !SystemInfo.isLinux) {
            hostPathVar = FileUtil.toSystemIndependentName((String)hostPath);
            for (DockerPathMappingImpl mapping : config2.getPathMappings()) {
                String localPath;
                Intrinsics.checkNotNullExpressionValue((Object)FileUtil.toSystemIndependentName((String)mapping.getLocalPath()), (String)"toSystemIndependentName(...)");
                if (!StringsKt.startsWith$default((String)hostPathVar, (String)localPath, (boolean)false, (int)2, null)) continue;
                return FileUtil.normalize((String)(mapping.getVirtualMachinePath() + StringsKt.removePrefix((String)hostPathVar, (CharSequence)localPath)));
            }
        }
        return hostPathVar;
    }
}

