/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.searchEverywhere.equalityProviders;

import com.intellij.ide.actions.searcheverywhere.SEResultsEqualityProvider;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.platform.searchEverywhere.SeItem;
import com.intellij.platform.searchEverywhere.SeItemData;
import com.intellij.platform.searchEverywhere.SeLegacyItem;
import com.intellij.platform.searchEverywhere.providers.SeLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001:\u0004\u0012\u0013\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u0004\u0018\u00010\r*\u00020\rH\u0002J\f\u0010\u0010\u001a\u00020\r*\u00020\rH\u0002J\f\u0010\u0011\u001a\u00020\r*\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/searchEverywhere/equalityProviders/SeEqualityChecker;", "", "<init>", "()V", "equalityProvider", "Lcom/intellij/ide/actions/searcheverywhere/SEResultsEqualityProvider;", "alreadyFoundItems", "", "", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereFoundElementInfo;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "checkAndUpdateIfNeeded", "Lcom/intellij/platform/searchEverywhere/SeItemData;", "newItemData", "logSkipAndReturnNull", "logAddAndReturn", "logReplaceAndReturn", "Action", "Add", "Replace", "Skip", "intellij.platform.searchEverywhere"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSeEqualityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeEqualityChecker.kt\ncom/intellij/platform/searchEverywhere/equalityProviders/SeEqualityChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1617#2,9:89\n1869#2:98\n1870#2:100\n1626#2:101\n1869#2,2:102\n1#3:99\n*S KotlinDebug\n*F\n+ 1 SeEqualityChecker.kt\ncom/intellij/platform/searchEverywhere/equalityProviders/SeEqualityChecker\n*L\n46#1:89,9\n46#1:98\n46#1:100\n46#1:101\n47#1:102,2\n46#1:99\n*E\n"})
public final class SeEqualityChecker {
    @NotNull
    private final SEResultsEqualityProvider equalityProvider = SEResultsEqualityProvider.Companion.composite((Collection)SEResultsEqualityProvider.Companion.getEP_NAME().getExtensionList());
    @NotNull
    private final Map<String, SearchEverywhereFoundElementInfo> alreadyFoundItems = new LinkedHashMap();
    @NotNull
    private final ReentrantLock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final SeItemData checkAndUpdateIfNeeded(@NotNull SeItemData newItemData) {
        Intrinsics.checkNotNullParameter((Object)newItemData, (String)"newItemData");
        SeItem seItem = newItemData.fetchItemIfExists();
        if (seItem == null) {
            return newItemData;
        }
        SeItem item = seItem;
        Object object = item instanceof SeLegacyItem ? (SeLegacyItem)item : null;
        if (object == null || (object = object.getRawObject()) == null) {
            return newItemData;
        }
        Object itemObject = object;
        Lock lock = this.lock;
        lock.lock();
        try {
            SeItemData seItemData;
            SEResultsEqualityProvider.SEEqualElementsActionType action;
            boolean bl = false;
            SearchEverywhereFoundElementInfo newItemInfo = new SearchEverywhereFoundElementInfo(newItemData.getUuid(), itemObject, newItemData.getWeight(), ((SeLegacyItem)item).getContributor());
            SEResultsEqualityProvider.SEEqualElementsActionType sEEqualElementsActionType = action = this.equalityProvider.compareItemsCollection(newItemInfo, this.alreadyFoundItems.values());
            if (sEEqualElementsActionType instanceof SEResultsEqualityProvider.SEEqualElementsActionType.Replace) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = ((SEResultsEqualityProvider.SEEqualElementsActionType.Replace)action).getToBeReplaced();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    SearchEverywhereFoundElementInfo it = (SearchEverywhereFoundElementInfo)element$iv$iv;
                    boolean bl3 = false;
                    if (it.uuid == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List toRemove = (List)destination$iv$iv;
                Iterable $this$forEach$iv = toRemove;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl5 = false;
                    this.alreadyFoundItems.remove(it);
                }
                seItemData = this.logReplaceAndReturn(newItemData.withUuidToReplace(toRemove));
            } else if (sEEqualElementsActionType instanceof SEResultsEqualityProvider.SEEqualElementsActionType.Skip) {
                seItemData = this.logSkipAndReturnNull(newItemData);
            } else {
                this.alreadyFoundItems.put(newItemData.getUuid(), newItemInfo);
                seItemData = this.logAddAndReturn(newItemData);
            }
            SeItemData result = seItemData;
            SeLog.Companion.log(SeLog.EQUALITY, (Function0<String>)((Function0)() -> SeEqualityChecker.checkAndUpdateIfNeeded$lambda$3$lambda$2(item, result, newItemInfo)));
            SeItemData seItemData2 = result;
            return seItemData2;
        }
        finally {
            lock.unlock();
        }
    }

    private final SeItemData logSkipAndReturnNull(SeItemData $this$logSkipAndReturnNull) {
        SeLog.Companion.log(SeLog.EQUALITY, (Function0<String>)((Function0)() -> SeEqualityChecker.logSkipAndReturnNull$lambda$4($this$logSkipAndReturnNull)));
        return null;
    }

    private final SeItemData logAddAndReturn(SeItemData $this$logAddAndReturn) {
        SeLog.Companion.log(SeLog.EQUALITY, (Function0<String>)((Function0)() -> SeEqualityChecker.logAddAndReturn$lambda$5($this$logAddAndReturn)));
        return $this$logAddAndReturn;
    }

    private final SeItemData logReplaceAndReturn(SeItemData $this$logReplaceAndReturn) {
        SeLog.Companion.log(SeLog.EQUALITY, (Function0<String>)((Function0)() -> SeEqualityChecker.logReplaceAndReturn$lambda$6($this$logReplaceAndReturn)));
        return $this$logReplaceAndReturn;
    }

    private static final String checkAndUpdateIfNeeded$lambda$3$lambda$2(SeItem $item, SeItemData $result, SearchEverywhereFoundElementInfo $newItemInfo) {
        return "Equality result for " + ((SeLegacyItem)$item).getContributor().getSearchProviderId() + ": " + $result + " for " + $newItemInfo.uuid;
    }

    private static final String logSkipAndReturnNull$lambda$4(SeItemData $this_logSkipAndReturnNull) {
        return "Equality result SKIP: for " + $this_logSkipAndReturnNull.getProviderId() + ": " + $this_logSkipAndReturnNull.getUuid();
    }

    private static final String logAddAndReturn$lambda$5(SeItemData $this_logAddAndReturn) {
        return "Equality result ADD: for " + $this_logAddAndReturn.getProviderId() + ": " + $this_logAddAndReturn.getUuid();
    }

    private static final String logReplaceAndReturn$lambda$6(SeItemData $this_logReplaceAndReturn) {
        return "Equality result REPLACE(itemsIds=" + $this_logReplaceAndReturn.getUuidsToReplace() + "): for " + $this_logReplaceAndReturn.getProviderId() + ": " + $this_logReplaceAndReturn.getUuid();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001\u0082\u0001\u0003\u0002\u0003\u0004\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/searchEverywhere/equalityProviders/SeEqualityChecker$Action;", "", "Lcom/intellij/platform/searchEverywhere/equalityProviders/SeEqualityChecker$Add;", "Lcom/intellij/platform/searchEverywhere/equalityProviders/SeEqualityChecker$Replace;", "Lcom/intellij/platform/searchEverywhere/equalityProviders/SeEqualityChecker$Skip;", "intellij.platform.searchEverywhere"})
    public static interface Action {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/searchEverywhere/equalityProviders/SeEqualityChecker$Add;", "Lcom/intellij/platform/searchEverywhere/equalityProviders/SeEqualityChecker$Action;", "<init>", "()V", "toString", "", "intellij.platform.searchEverywhere"})
    public static final class Add
    implements Action {
        @NotNull
        public static final Add INSTANCE = new Add();

        private Add() {
        }

        @NotNull
        public String toString() {
            return "Add";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\u0004H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/searchEverywhere/equalityProviders/SeEqualityChecker$Replace;", "Lcom/intellij/platform/searchEverywhere/equalityProviders/SeEqualityChecker$Action;", "itemsIds", "", "", "<init>", "(Ljava/util/List;)V", "getItemsIds", "()Ljava/util/List;", "toString", "intellij.platform.searchEverywhere"})
    public static final class Replace
    implements Action {
        @NotNull
        private final List<String> itemsIds;

        public Replace(@NotNull List<String> itemsIds) {
            Intrinsics.checkNotNullParameter(itemsIds, (String)"itemsIds");
            this.itemsIds = itemsIds;
        }

        @NotNull
        public final List<String> getItemsIds() {
            return this.itemsIds;
        }

        @NotNull
        public String toString() {
            return "Replace(itemsIds=" + this.itemsIds + ")";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/searchEverywhere/equalityProviders/SeEqualityChecker$Skip;", "Lcom/intellij/platform/searchEverywhere/equalityProviders/SeEqualityChecker$Action;", "<init>", "()V", "toString", "", "intellij.platform.searchEverywhere"})
    public static final class Skip
    implements Action {
        @NotNull
        public static final Skip INSTANCE = new Skip();

        private Skip() {
        }

        @NotNull
        public String toString() {
            return "Skip";
        }
    }
}

