/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.recentFiles.backend;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.recentFiles.backend.BackendRecentFileEventsModel;
import com.intellij.platform.recentFiles.backend.BackendRecentFilesModel;
import com.intellij.platform.recentFiles.shared.FileChangeKind;
import com.intellij.platform.recentFiles.shared.RecentFileKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/recentFiles/backend/BackendRecentFileEventsController;", "", "<init>", "()V", "applyRelevantEventsToModel", "", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "changeKind", "Lcom/intellij/platform/recentFiles/shared/FileChangeKind;", "project", "Lcom/intellij/openapi/project/Project;", "updateAllExistingFilesInModel", "intellij.platform.recentFiles.backend"})
@SourceDebugExtension(value={"SMAP\nBackendRecentFileEventsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendRecentFileEventsController.kt\ncom/intellij/platform/recentFiles/backend/BackendRecentFileEventsController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,41:1\n774#2:42\n865#2,2:43\n774#2:46\n865#2,2:47\n24#3:45\n1#4:49\n*S KotlinDebug\n*F\n+ 1 BackendRecentFileEventsController.kt\ncom/intellij/platform/recentFiles/backend/BackendRecentFileEventsController\n*L\n19#1:42\n19#1:43,2\n28#1:46\n28#1:47,2\n20#1:45\n*E\n"})
public final class BackendRecentFileEventsController {
    @NotNull
    public static final BackendRecentFileEventsController INSTANCE = new BackendRecentFileEventsController();

    private BackendRecentFileEventsController() {
    }

    /*
     * WARNING - void declaration
     */
    public final void applyRelevantEventsToModel(@NotNull List<? extends VirtualFile> files, @NotNull FileChangeKind changeKind, @NotNull Project project) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)changeKind, (String)"changeKind");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$filter$iv = files;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(!it.isDirectory())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filesWithoutDirectories = (List)destination$iv$iv;
        BackendRecentFileEventsController $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(BackendRecentFileEventsController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Trying to apply changes for " + filesWithoutDirectories.size() + " files out of total " + files.size() + " virtual files to the model, change kind: " + changeKind);
        switch (WhenMappings.$EnumSwitchMapping$0[changeKind.ordinal()]) {
            case 1: 
            case 2: {
                BackendRecentFileEventsModel.Companion.getInstance(project).scheduleApplyBackendChangesToAllFileKinds(changeKind, filesWithoutDirectories);
                break;
            }
            case 3: 
            case 4: {
                for (RecentFileKind filesKind : RecentFileKind.getEntries()) {
                    void $this$filterTo$iv$iv2;
                    Set knownFilesByKind = CollectionsKt.toSet((Iterable)BackendRecentFilesModel.Companion.getInstance(project).getFilesByKind(filesKind));
                    Iterable $this$filter$iv2 = filesWithoutDirectories;
                    boolean $i$f$filter2 = false;
                    Iterable bl = $this$filter$iv2;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo2 = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                        VirtualFile it = (VirtualFile)element$iv$iv;
                        boolean bl2 = false;
                        if (!knownFilesByKind.contains(it)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    List relevantUpdates = (List)destination$iv$iv2;
                    BackendRecentFileEventsModel.Companion.getInstance(project).scheduleApplyBackendChanges(filesKind, changeKind, relevantUpdates);
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void updateAllExistingFilesInModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        for (RecentFileKind filesKind : RecentFileKind.getEntries()) {
            List<VirtualFile> knownFilesByKind;
            List<VirtualFile> list;
            List<VirtualFile> it = list = BackendRecentFilesModel.Companion.getInstance(project).getFilesByKind(filesKind);
            boolean bl = false;
            if ((!((Collection)it).isEmpty() ? list : null) == null) continue;
            knownFilesByKind = knownFilesByKind;
            BackendRecentFileEventsModel.Companion.getInstance(project).scheduleApplyBackendChanges(filesKind, FileChangeKind.UPDATED, knownFilesByKind);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FileChangeKind.values().length];
            try {
                nArray[FileChangeKind.ADDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileChangeKind.REMOVED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileChangeKind.UPDATED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileChangeKind.UPDATED_AND_PUT_ON_TOP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

