/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.debugger.impl.frontend;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.debugger.impl.frontend.EditorLineBreakpointsInfo;
import com.intellij.platform.debugger.impl.frontend.FrontendEditorLinesBreakpointsInfoManager;
import com.intellij.platform.debugger.impl.frontend.FrontendXBreakpointManagerKt;
import com.intellij.platform.debugger.impl.frontend.FrontendXBreakpointProxyKt;
import com.intellij.platform.debugger.impl.frontend.FrontendXBreakpointTypesManager;
import com.intellij.platform.debugger.impl.frontend.FrontendXDependentBreakpointManagerProxy;
import com.intellij.platform.debugger.impl.frontend.FrontendXLightLineBreakpoint;
import com.intellij.platform.debugger.impl.rpc.XBreakpointApi;
import com.intellij.platform.project.ProjectIdKt;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.xdebugger.impl.FrontendXLineBreakpointVariantKt;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.XLineBreakpointInstallationInfo;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerProxy;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointProxy;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointTypeProxy;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointsDialogState;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointManagerProxy;
import com.intellij.xdebugger.impl.breakpoints.XLightLineBreakpointProxy;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointProxy;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointTypeProxy;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.rpc.XBreakpointDto;
import com.intellij.xdebugger.impl.rpc.XBreakpointEvent;
import com.intellij.xdebugger.impl.rpc.XBreakpointId;
import com.intellij.xdebugger.impl.rpc.XBreakpointTypeApi;
import com.intellij.xdebugger.impl.rpc.XBreakpointsSetDto;
import com.intellij.xdebugger.impl.rpc.XDebuggerManagerApi;
import com.intellij.xdebugger.impl.rpc.XLineBreakpointInstalledResponse;
import com.intellij.xdebugger.impl.rpc.XRemoveBreakpointResponse;
import com.intellij.xdebugger.impl.rpc.XToggleLineBreakpointResponse;
import fleet.rpc.core.RpcFlow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.NonCancellable;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001UB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010'\u001a\u0004\u0018\u00010\u00102\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J \u00100\u001a\n\u0012\u0006\u0012\u0004\u0018\u000102012\u0006\u0010,\u001a\u00020-2\u0006\u00103\u001a\u00020/H\u0016J\u0016\u00104\u001a\u00020\f2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000f06H\u0002J\u0010\u00107\u001a\u0004\u0018\u00010\u00102\u0006\u00108\u001a\u00020\u000fJ\u0010\u00109\u001a\u00020\f2\u0006\u0010:\u001a\u00020\u0012H\u0016J\u0010\u0010;\u001a\u00020\f2\u0006\u0010<\u001a\u00020\u001dH\u0016J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>H\u0016J\b\u0010@\u001a\u00020\u0014H\u0016J\u000e\u0010A\u001a\b\u0012\u0004\u0012\u00020B0>H\u0016J\u000e\u0010C\u001a\b\u0012\u0004\u0012\u00020D0>H\u0016J\u001e\u0010E\u001a\u00020\f2\u0006\u0010F\u001a\u00020G2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\f0IH\u0016J\u000e\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00100\u001cH\u0007J\n\u0010K\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010L\u001a\u00020\f2\u0006\u0010M\u001a\u00020\u0010H\u0016J\u0016\u0010N\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u001006H\u0016J&\u0010O\u001a\b\u0012\u0004\u0012\u0002020>2\u0006\u0010P\u001a\u00020D2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020TH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0%8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001f\u00a8\u0006V"}, d2={"Lcom/intellij/platform/debugger/impl/frontend/FrontendXBreakpointManager;", "Lcom/intellij/xdebugger/impl/breakpoints/XBreakpointManagerProxy;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "requestCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "breakpointsChanged", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "breakpoints", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/xdebugger/impl/rpc/XBreakpointId;", "Lcom/intellij/xdebugger/impl/breakpoints/XBreakpointProxy;", "_breakpointsDialogSettings", "Lcom/intellij/xdebugger/impl/breakpoints/XBreakpointsDialogState;", "lineBreakpointManager", "Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager;", "lightBreakpoints", "Lcom/intellij/platform/debugger/impl/frontend/FrontendXBreakpointManager$LightBreakpointPosition;", "Lcom/intellij/platform/debugger/impl/frontend/FrontendXLightLineBreakpoint;", "breakpointsDialogSettings", "getBreakpointsDialogSettings", "()Lcom/intellij/xdebugger/impl/breakpoints/XBreakpointsDialogState;", "allGroups", "", "", "getAllGroups", "()Ljava/util/Set;", "dependentBreakpointManager", "Lcom/intellij/xdebugger/impl/breakpoints/XDependentBreakpointManagerProxy;", "getDependentBreakpointManager", "()Lcom/intellij/xdebugger/impl/breakpoints/XDependentBreakpointManagerProxy;", "breakpointIdsRemovedLocally", "", "getBreakpointIdsRemovedLocally", "addBreakpoint", "breakpointDto", "Lcom/intellij/xdebugger/impl/rpc/XBreakpointDto;", "canToggleLightBreakpoint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "info", "Lcom/intellij/xdebugger/impl/XLineBreakpointInstallationInfo;", "toggleLightBreakpoint", "Lkotlinx/coroutines/Deferred;", "Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointProxy;", "installationInfo", "removeBreakpointsLocally", "breakpointsToRemove", "", "getBreakpointById", "breakpointId", "setBreakpointsDialogSettings", "settings", "setDefaultGroup", "group", "getAllBreakpointItems", "", "Lcom/intellij/xdebugger/impl/breakpoints/ui/BreakpointItem;", "getLineBreakpointManager", "getAllBreakpointTypes", "Lcom/intellij/xdebugger/impl/breakpoints/XBreakpointTypeProxy;", "getLineBreakpointTypes", "Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointTypeProxy;", "subscribeOnBreakpointsChanges", "disposable", "Lcom/intellij/openapi/Disposable;", "listener", "Lkotlin/Function0;", "getBreakpointsSet", "getLastRemovedBreakpoint", "removeBreakpoint", "breakpoint", "removeBreakpoints", "findBreakpointsAtLine", "type", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "LightBreakpointPosition", "intellij.platform.debugger.impl.frontend"})
@ApiStatus.Internal
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nFrontendXBreakpointManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendXBreakpointManager.kt\ncom/intellij/platform/debugger/impl/frontend/FrontendXBreakpointManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,298:1\n1563#2:299\n1634#2,3:300\n808#2,11:303\n774#2:314\n865#2,2:315\n*S KotlinDebug\n*F\n+ 1 FrontendXBreakpointManager.kt\ncom/intellij/platform/debugger/impl/frontend/FrontendXBreakpointManager\n*L\n238#1:299\n238#1:300,3\n291#1:303,11\n291#1:314\n291#1:315,2\n*E\n"})
public final class FrontendXBreakpointManager
implements XBreakpointManagerProxy {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final AtomicInteger requestCounter;
    @NotNull
    private final MutableSharedFlow<Unit> breakpointsChanged;
    @NotNull
    private final ConcurrentMap<XBreakpointId, XBreakpointProxy> breakpoints;
    @Nullable
    private XBreakpointsDialogState _breakpointsDialogSettings;
    @NotNull
    private final XLineBreakpointManager lineBreakpointManager;
    @NotNull
    private final ConcurrentMap<LightBreakpointPosition, FrontendXLightLineBreakpoint> lightBreakpoints;
    @NotNull
    private final XDependentBreakpointManagerProxy dependentBreakpointManager;
    @VisibleForTesting
    @NotNull
    private final Set<XBreakpointId> breakpointIdsRemovedLocally;

    public FrontendXBreakpointManager(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cs = cs;
        this.requestCounter = new AtomicInteger();
        this.breakpointsChanged = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, null, (int)5, null);
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
        this.breakpoints = concurrentMap;
        this.lineBreakpointManager = new XLineBreakpointManager(this.project, this.cs, XDebugSessionProxy.Companion.useFeLineBreakpointProxy());
        ConcurrentMap concurrentMap2 = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"createConcurrentMap(...)");
        this.lightBreakpoints = concurrentMap2;
        this.dependentBreakpointManager = new FrontendXDependentBreakpointManagerProxy(this.project, this.cs, (Function1<? super XBreakpointId, ? extends XBreakpointProxy>)((Function1)arg_0 -> FrontendXBreakpointManager.dependentBreakpointManager$lambda$0(this, arg_0)));
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        this.breakpointIdsRemovedLocally = keySetView;
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ FrontendXBreakpointManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = FrontendXBreakpointTypesManager.Companion.getInstance(FrontendXBreakpointManager.access$getProject$p(this.this$0)).typesInitialized().await((Continuation)this);
                        if (v0 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.label = 2;
                        v1 = XDebuggerManagerApi.Companion.getInstance((Continuation)this);
                        if (v1 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl21
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        this.label = 3;
                        v2 = ((XDebuggerManagerApi)v1).getBreakpoints(ProjectIdKt.projectId((Project)FrontendXBreakpointManager.access$getProject$p(this.this$0)), (Continuation)this);
                        if (v2 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl29
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl29:
                        // 2 sources

                        var2_3 = (XBreakpointsSetDto)v2;
                        initialBreakpoints = var2_3.component1();
                        breakpointEvents = var2_3.component2();
                        for (XBreakpointDto breakpointDto : initialBreakpoints) {
                            this.this$0.addBreakpoint(breakpointDto);
                        }
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)initialBreakpoints);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)breakpointEvents);
                        this.label = 4;
                        v3 = breakpointEvents.toFlow().collect(new FlowCollector(){

                            public final Object emit(XBreakpointEvent event, Continuation<? super Unit> $completion) {
                                XBreakpointEvent xBreakpointEvent = event;
                                if (xBreakpointEvent instanceof XBreakpointEvent.BreakpointAdded) {
                                    v0 = (Comparable)this$0.addBreakpoint(((XBreakpointEvent.BreakpointAdded)event).getBreakpointDto());
                                } else if (xBreakpointEvent instanceof XBreakpointEvent.BreakpointRemoved) {
                                    this$0.removeBreakpointsLocally(SetsKt.setOf((Object)((XBreakpointEvent.BreakpointRemoved)event).getBreakpointId()));
                                    v0 = Boxing.boxBoolean((boolean)this$0.getBreakpointIdsRemovedLocally().remove(((XBreakpointEvent.BreakpointRemoved)event).getBreakpointId()));
                                } else {
                                    throw new NoWhenBranchMatchedException();
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (v3 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl48
                    }
                    case 4: {
                        breakpointEvents = (RpcFlow)this.L$1;
                        initialBreakpoints = (Set)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl48:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public XBreakpointsDialogState getBreakpointsDialogSettings() {
        return this._breakpointsDialogSettings;
    }

    @NotNull
    public Set<String> getAllGroups() {
        return SetsKt.emptySet();
    }

    @NotNull
    public XDependentBreakpointManagerProxy getDependentBreakpointManager() {
        return this.dependentBreakpointManager;
    }

    @NotNull
    public final Set<XBreakpointId> getBreakpointIdsRemovedLocally() {
        return this.breakpointIdsRemovedLocally;
    }

    @Nullable
    public XBreakpointProxy addBreakpoint(@NotNull XBreakpointDto breakpointDto) {
        Intrinsics.checkNotNullParameter((Object)breakpointDto, (String)"breakpointDto");
        if (this.breakpointIdsRemovedLocally.contains(breakpointDto.getId())) {
            return null;
        }
        XBreakpointProxy currentBreakpoint = (XBreakpointProxy)this.breakpoints.get(breakpointDto.getId());
        if (currentBreakpoint != null) {
            return currentBreakpoint;
        }
        XBreakpointTypeProxy type = FrontendXBreakpointTypesManager.Companion.getInstance(this.project).getTypeById(breakpointDto.getTypeId());
        if (type == null) {
            return null;
        }
        XBreakpointProxy newBreakpoint = FrontendXBreakpointProxyKt.createXBreakpointProxy(this.project, this.cs, breakpointDto, type, this, (Function1<? super XBreakpointProxy, Unit>)((Function1)arg_0 -> FrontendXBreakpointManager.addBreakpoint$lambda$1(this, arg_0)));
        XBreakpointProxy previousBreakpoint = this.breakpoints.putIfAbsent(breakpointDto.getId(), newBreakpoint);
        if (previousBreakpoint != null) {
            newBreakpoint.dispose();
            return previousBreakpoint;
        }
        if (newBreakpoint instanceof XLineBreakpointProxy) {
            this.lineBreakpointManager.registerBreakpoint((XLineBreakpointProxy)newBreakpoint, true);
        }
        this.breakpointsChanged.tryEmit((Object)Unit.INSTANCE);
        return newBreakpoint;
    }

    public boolean canToggleLightBreakpoint(@NotNull Editor editor, @NotNull XLineBreakpointInstallationInfo info) {
        EditorLineBreakpointsInfo lineInfo;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        XLineBreakpointTypeProxy xLineBreakpointTypeProxy = (XLineBreakpointTypeProxy)CollectionsKt.singleOrNull((List)info.getTypes());
        if (xLineBreakpointTypeProxy == null) {
            return false;
        }
        XLineBreakpointTypeProxy type = xLineBreakpointTypeProxy;
        VirtualFile virtualFile = info.getPosition().getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        if (!((Collection)this.findBreakpointsAtLine(type, virtualFile, info.getPosition().getLine())).isEmpty()) {
            return false;
        }
        if (info.isTemporary() || info.isConditional()) {
            return false;
        }
        EditorLineBreakpointsInfo editorLineBreakpointsInfo = lineInfo = FrontendEditorLinesBreakpointsInfoManager.Companion.getInstance(this.project).getBreakpointsInfoForLineFast(editor, info.getPosition().getLine());
        return editorLineBreakpointsInfo != null ? editorLineBreakpointsInfo.getSingleBreakpointVariant() : false;
    }

    @NotNull
    public Deferred<XLineBreakpointProxy> toggleLightBreakpoint(@NotNull Editor editor, @NotNull XLineBreakpointInstallationInfo installationInfo) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)installationInfo, (String)"installationInfo");
        int requestId = this.requestCounter.getAndIncrement();
        return BuildersKt.async$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super XLineBreakpointProxy>, Object>(installationInfo, requestId, this, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ XLineBreakpointInstallationInfo $installationInfo;
            final /* synthetic */ int $requestId;
            final /* synthetic */ FrontendXBreakpointManager this$0;
            {
                this.$installationInfo = $installationInfo;
                this.$requestId = $requestId;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var8_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = this.$installationInfo.getPosition().getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getFile(...)");
                        lightBreakpointPosition = new LightBreakpointPosition(v0, this.$installationInfo.getPosition().getLine());
                        v1 = (XLineBreakpointTypeProxy)CollectionsKt.firstOrNull((List)this.$installationInfo.getTypes());
                        if (v1 == null) {
                            return null;
                        }
                        type = v1;
                        if (FrontendXBreakpointManagerKt.access$getLOG$p().isDebugEnabled()) {
                            FrontendXBreakpointManagerKt.access$getLOG$p().debug("[" + this.$requestId + "] Toggling light breakpoint at " + lightBreakpointPosition.getFile().getPath() + ":" + lightBreakpointPosition.getLine() + ", type: " + type.getId());
                        }
                        lightBreakpoint = new FrontendXLightLineBreakpoint(FrontendXBreakpointManager.access$getProject$p(this.this$0), (CoroutineScope)$this$async, type, this.$installationInfo, this.this$0);
                        oldBreakpoint = FrontendXBreakpointManager.access$getLightBreakpoints$p(this.this$0).putIfAbsent(lightBreakpointPosition, lightBreakpoint);
                        if (oldBreakpoint != null) {
                            if (FrontendXBreakpointManagerKt.access$getLOG$p().isDebugEnabled()) {
                                FrontendXBreakpointManagerKt.access$getLOG$p().debug("[" + this.$requestId + "] Found existing light breakpoint at " + lightBreakpointPosition.getFile().getPath() + ":" + lightBreakpointPosition.getLine() + ", disposing new one");
                            }
                            lightBreakpoint.dispose();
                        }
                        if (FrontendXBreakpointManagerKt.access$getLOG$p().isDebugEnabled()) {
                            FrontendXBreakpointManagerKt.access$getLOG$p().debug("[" + this.$requestId + "] Sending toggle request for breakpoint at " + lightBreakpointPosition.getFile().getPath() + ":" + lightBreakpointPosition.getLine() + ", hasExisting: " + (oldBreakpoint != null));
                        }
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$async);
                        this.L$1 = lightBreakpointPosition;
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)type);
                        this.L$3 = lightBreakpoint;
                        this.L$4 = oldBreakpoint;
                        this.label = 1;
                        v2 = XBreakpointTypeApi.Companion.getInstance((Continuation)this);
                        ** if (v2 != var8_3) goto lbl34
lbl33:
                        // 1 sources

                        return var8_3;
lbl34:
                        // 1 sources

                        ** GOTO lbl44
                    }
                    case 1: {
                        oldBreakpoint = (FrontendXLightLineBreakpoint)this.L$4;
                        lightBreakpoint = (FrontendXLightLineBreakpoint)this.L$3;
                        type = (XLineBreakpointTypeProxy)this.L$2;
                        lightBreakpointPosition = (LightBreakpointPosition)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl44:
                        // 2 sources

                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$async);
                        this.L$1 = lightBreakpointPosition;
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)type);
                        this.L$3 = lightBreakpoint;
                        this.L$4 = SpillingKt.nullOutSpilledVariable((Object)oldBreakpoint);
                        this.label = 2;
                        v3 = ((XBreakpointTypeApi)v2).toggleLineBreakpoint(ProjectIdKt.projectId((Project)FrontendXBreakpointManager.access$getProject$p(this.this$0)), FrontendXLineBreakpointVariantKt.toRequest((XLineBreakpointInstallationInfo)this.$installationInfo, (boolean)(oldBreakpoint != null)), (Continuation)this);
                        ** if (v3 != var8_3) goto lbl53
lbl52:
                        // 1 sources

                        return var8_3;
lbl53:
                        // 1 sources

                        ** GOTO lbl63
                    }
                    case 2: {
                        oldBreakpoint = (FrontendXLightLineBreakpoint)this.L$4;
                        lightBreakpoint = (FrontendXLightLineBreakpoint)this.L$3;
                        type = (XLineBreakpointTypeProxy)this.L$2;
                        lightBreakpointPosition = (LightBreakpointPosition)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl63:
                        // 2 sources

                        response = (XToggleLineBreakpointResponse)v3;
                        if (FrontendXBreakpointManagerKt.access$getLOG$p().isDebugEnabled()) {
                            FrontendXBreakpointManagerKt.access$getLOG$p().debug("[" + this.$requestId + "] Received response for toggle request: " + ((v4 = response) != null && (v4 = v4.getClass()) != null ? v4.getSimpleName() : null));
                        }
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$async);
                        this.L$1 = lightBreakpointPosition;
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)type);
                        this.L$3 = lightBreakpoint;
                        this.L$4 = SpillingKt.nullOutSpilledVariable((Object)oldBreakpoint);
                        this.L$5 = SpillingKt.nullOutSpilledVariable((Object)response);
                        this.label = 3;
                        v5 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE).plus((CoroutineContext)NonCancellable.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super XLineBreakpointProxy>, Object>(this.this$0, lightBreakpointPosition, lightBreakpoint, response, this.$requestId, this.$installationInfo, null){
                            int label;
                            final /* synthetic */ FrontendXBreakpointManager this$0;
                            final /* synthetic */ LightBreakpointPosition $lightBreakpointPosition;
                            final /* synthetic */ FrontendXLightLineBreakpoint $lightBreakpoint;
                            final /* synthetic */ XToggleLineBreakpointResponse $response;
                            final /* synthetic */ int $requestId;
                            final /* synthetic */ XLineBreakpointInstallationInfo $installationInfo;
                            {
                                this.this$0 = $receiver;
                                this.$lightBreakpointPosition = $lightBreakpointPosition;
                                this.$lightBreakpoint = $lightBreakpoint;
                                this.$response = $response;
                                this.$requestId = $requestId;
                                this.$installationInfo = $installationInfo;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        XLineBreakpointProxy xLineBreakpointProxy;
                                        ResultKt.throwOnFailure((Object)$result);
                                        FrontendXBreakpointManager.access$getLightBreakpoints$p(this.this$0).remove(this.$lightBreakpointPosition, this.$lightBreakpoint);
                                        this.$lightBreakpoint.dispose();
                                        XToggleLineBreakpointResponse xToggleLineBreakpointResponse = this.$response;
                                        if (xToggleLineBreakpointResponse instanceof XLineBreakpointInstalledResponse) {
                                            XBreakpointDto breakpointDto = ((XLineBreakpointInstalledResponse)this.$response).getBreakpoint();
                                            if (FrontendXBreakpointManagerKt.access$getLOG$p().isDebugEnabled()) {
                                                XBreakpointDto xBreakpointDto = breakpointDto;
                                                FrontendXBreakpointManagerKt.access$getLOG$p().debug("[" + this.$requestId + "] Processing XLineBreakpointInstalledResponse, breakpointDto: " + (XBreakpointId)(xBreakpointDto != null ? xBreakpointDto.getId() : null));
                                            }
                                            if (breakpointDto != null) {
                                                XLineBreakpointProxy result;
                                                XBreakpointProxy xBreakpointProxy = this.this$0.addBreakpoint(breakpointDto);
                                                XLineBreakpointProxy xLineBreakpointProxy2 = result = xBreakpointProxy instanceof XLineBreakpointProxy ? (XLineBreakpointProxy)xBreakpointProxy : null;
                                                if (FrontendXBreakpointManagerKt.access$getLOG$p().isDebugEnabled()) {
                                                    XLineBreakpointProxy xLineBreakpointProxy3 = result;
                                                    XLineBreakpointProxy xLineBreakpointProxy4 = result;
                                                    FrontendXBreakpointManagerKt.access$getLOG$p().debug("[" + this.$requestId + "] Added breakpoint: " + (XBreakpointId)(xLineBreakpointProxy3 != null ? xLineBreakpointProxy3.getId() : null) + ", at line: " + (xLineBreakpointProxy4 != null ? Boxing.boxInt((int)xLineBreakpointProxy4.getLine()) : null));
                                                }
                                                xLineBreakpointProxy = result;
                                            } else {
                                                if (FrontendXBreakpointManagerKt.access$getLOG$p().isDebugEnabled()) {
                                                    FrontendXBreakpointManagerKt.access$getLOG$p().debug("[" + this.$requestId + "] No breakpoint DTO in response, returning null");
                                                }
                                                xLineBreakpointProxy = null;
                                            }
                                        } else if (Intrinsics.areEqual((Object)xToggleLineBreakpointResponse, (Object)XRemoveBreakpointResponse.INSTANCE)) {
                                            if (FrontendXBreakpointManagerKt.access$getLOG$p().isDebugEnabled()) {
                                                FrontendXBreakpointManagerKt.access$getLOG$p().debug("[" + this.$requestId + "] Processing XRemoveBreakpointResponse");
                                            }
                                            List list = XDebuggerUtilImpl.findBreakpointsAtLine((Project)FrontendXBreakpointManager.access$getProject$p(this.this$0), (XLineBreakpointInstallationInfo)this.$installationInfo);
                                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findBreakpointsAtLine(...)");
                                            XLineBreakpointProxy breakpoint = (XLineBreakpointProxy)CollectionsKt.singleOrNull((List)list);
                                            if (FrontendXBreakpointManagerKt.access$getLOG$p().isDebugEnabled()) {
                                                XLineBreakpointProxy xLineBreakpointProxy5 = breakpoint;
                                                FrontendXBreakpointManagerKt.access$getLOG$p().debug("[" + this.$requestId + "] Found breakpoint to remove: " + (XBreakpointId)(xLineBreakpointProxy5 != null ? xLineBreakpointProxy5.getId() : null));
                                            }
                                            if (breakpoint != null) {
                                                XLineBreakpointProxy[] xLineBreakpointProxyArray = new XLineBreakpointProxy[]{breakpoint};
                                                XDebuggerUtilImpl.removeBreakpointIfPossible((Project)FrontendXBreakpointManager.access$getProject$p(this.this$0), (XLineBreakpointInstallationInfo)this.$installationInfo, (XBreakpointProxy[])((XBreakpointProxy[])xLineBreakpointProxyArray));
                                                if (FrontendXBreakpointManagerKt.access$getLOG$p().isDebugEnabled()) {
                                                    FrontendXBreakpointManagerKt.access$getLOG$p().debug("[" + this.$requestId + "] Removed breakpoint: " + breakpoint.getId());
                                                }
                                            }
                                            xLineBreakpointProxy = null;
                                        } else {
                                            if (FrontendXBreakpointManagerKt.access$getLOG$p().isDebugEnabled()) {
                                                Object object;
                                                FrontendXBreakpointManagerKt.access$getLOG$p().debug("[" + this.$requestId + "] Unknown response type: " + ((object = this.$response) != null && (object = object.getClass()) != null ? ((Class)object).getName() : null));
                                            }
                                            xLineBreakpointProxy = null;
                                        }
                                        return xLineBreakpointProxy;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super XLineBreakpointProxy> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v5 != var8_3) goto lbl76
lbl75:
                        // 1 sources

                        return var8_3;
lbl76:
                        // 1 sources

                        ** GOTO lbl87
                    }
                    case 3: {
                        response = (XToggleLineBreakpointResponse)this.L$5;
                        oldBreakpoint = (FrontendXLightLineBreakpoint)this.L$4;
                        lightBreakpoint = (FrontendXLightLineBreakpoint)this.L$3;
                        type = (XLineBreakpointTypeProxy)this.L$2;
                        lightBreakpointPosition = (LightBreakpointPosition)this.L$1;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
lbl87:
                            // 2 sources

                            var6_8 = (XLineBreakpointProxy)v5;
                        }
                        catch (Throwable var7_11) {
                            throw var7_11;
                        }
                        finally {
                            FrontendXBreakpointManager.access$getLightBreakpoints$p(this.this$0).remove(lightBreakpointPosition, lightBreakpoint);
                            lightBreakpoint.dispose();
                        }
                        return var6_8;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super XLineBreakpointProxy> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void removeBreakpointsLocally(Collection<XBreakpointId> breakpointsToRemove) {
        for (XBreakpointId breakpointToRemove : breakpointsToRemove) {
            XBreakpointProxy removedBreakpoint;
            XBreakpointProxy xBreakpointProxy = removedBreakpoint = (XBreakpointProxy)this.breakpoints.remove(breakpointToRemove);
            if (xBreakpointProxy != null) {
                xBreakpointProxy.dispose();
            }
            if (removedBreakpoint instanceof XLineBreakpointProxy) {
                this.lineBreakpointManager.unregisterBreakpoint((XLineBreakpointProxy)removedBreakpoint);
            }
            this.breakpointIdsRemovedLocally.add(breakpointToRemove);
        }
        this.breakpointsChanged.tryEmit((Object)Unit.INSTANCE);
    }

    @Nullable
    public final XBreakpointProxy getBreakpointById(@NotNull XBreakpointId breakpointId) {
        Intrinsics.checkNotNullParameter((Object)breakpointId, (String)"breakpointId");
        return (XBreakpointProxy)this.breakpoints.get(breakpointId);
    }

    public void setBreakpointsDialogSettings(@NotNull XBreakpointsDialogState settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this._breakpointsDialogSettings = settings;
    }

    public void setDefaultGroup(@NotNull String group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<BreakpointItem> getAllBreakpointItems() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.breakpoints.values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void proxy;
            XBreakpointProxy xBreakpointProxy = (XBreakpointProxy)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new XBreakpointItem((XBreakpointProxy)proxy, (XBreakpointManagerProxy)this));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public XLineBreakpointManager getLineBreakpointManager() {
        return this.lineBreakpointManager;
    }

    @NotNull
    public List<XBreakpointTypeProxy> getAllBreakpointTypes() {
        return FrontendXBreakpointTypesManager.Companion.getInstance(this.project).getBreakpointTypes();
    }

    @NotNull
    public List<XLineBreakpointTypeProxy> getLineBreakpointTypes() {
        return FrontendXBreakpointTypesManager.Companion.getInstance(this.project).getLineBreakpointTypes();
    }

    public void subscribeOnBreakpointsChanges(@NotNull Disposable disposable, @NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        CoroutineScope scope = CoroutineScopeKt.childScope$default((CoroutineScope)this.cs, (String)"BreakpointsChangesListener", null, (boolean)false, (int)6, null);
        Disposable childDisposable = () -> FrontendXBreakpointManager.subscribeOnBreakpointsChanges$lambda$3(scope);
        Disposer.register((Disposable)disposable, (Disposable)childDisposable);
        BuildersKt.launch$default((CoroutineScope)scope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, listener, null){
            int label;
            final /* synthetic */ FrontendXBreakpointManager this$0;
            final /* synthetic */ Function0<Unit> $listener;
            {
                this.this$0 = $receiver;
                this.$listener = $listener;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FrontendXBreakpointManager.access$getBreakpointsChanged$p(this.this$0).collect(new FlowCollector(this.$listener){
                            final /* synthetic */ Function0<Unit> $listener;
                            {
                                this.$listener = $listener;
                            }

                            public final Object emit(Unit it, Continuation<? super Unit> $completion) {
                                this.$listener.invoke();
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @VisibleForTesting
    @NotNull
    public final Set<XBreakpointProxy> getBreakpointsSet() {
        return CollectionsKt.toSet((Iterable)this.breakpoints.values());
    }

    @Nullable
    public XBreakpointProxy getLastRemovedBreakpoint() {
        return null;
    }

    public void removeBreakpoint(@NotNull XBreakpointProxy breakpoint) {
        Intrinsics.checkNotNullParameter((Object)breakpoint, (String)"breakpoint");
        this.removeBreakpointsLocally(SetsKt.setOf((Object)breakpoint.getId()));
        this.breakpointsChanged.tryEmit((Object)Unit.INSTANCE);
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(breakpoint, null){
            int label;
            final /* synthetic */ XBreakpointProxy $breakpoint;
            {
                this.$breakpoint = $breakpoint;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = XBreakpointApi.Companion.getInstance((Continuation)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.label = 2;
                        v1 = ((XBreakpointApi)v0).removeBreakpoint(this.$breakpoint.getId(), (Continuation)this);
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl21
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void removeBreakpoints(@NotNull Collection<? extends XBreakpointProxy> breakpoints) {
        Intrinsics.checkNotNullParameter(breakpoints, (String)"breakpoints");
        for (XBreakpointProxy xBreakpointProxy : breakpoints) {
            this.removeBreakpoint(xBreakpointProxy);
        }
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public List<XLineBreakpointProxy> findBreakpointsAtLine(@NotNull XLineBreakpointTypeProxy type, @NotNull VirtualFile file, int line) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        $this$filterIsInstance$iv = this.breakpoints.values();
        $i$f$filterIsInstance = false;
        var6_6 = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterIsInstanceTo = false;
        for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof XLineBreakpointProxy)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (XLineBreakpointProxy)element$iv$iv;
            $i$a$-filter-FrontendXBreakpointManager$findBreakpointsAtLine$1 = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)type)) ** GOTO lbl-1000
            v0 = it.getFile();
            if (Intrinsics.areEqual((Object)(v0 != null ? v0.getUrl() : null), (Object)file.getUrl()) && it.getLine() == line) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final XBreakpointProxy dependentBreakpointManager$lambda$0(FrontendXBreakpointManager this$0, XBreakpointId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (XBreakpointProxy)this$0.breakpoints.get(it);
    }

    private static final Unit addBreakpoint$lambda$1(FrontendXBreakpointManager this$0, XBreakpointProxy it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.breakpointsChanged.tryEmit((Object)Unit.INSTANCE);
        if (it instanceof XLineBreakpointProxy) {
            this$0.lineBreakpointManager.breakpointChanged((XLightLineBreakpointProxy)it);
        }
        return Unit.INSTANCE;
    }

    private static final void subscribeOnBreakpointsChanges$lambda$3(CoroutineScope $scope) {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)$scope, (String)"disposed", null, (int)2, null);
    }

    public static final /* synthetic */ Project access$getProject$p(FrontendXBreakpointManager $this) {
        return $this.project;
    }

    public static final /* synthetic */ ConcurrentMap access$getLightBreakpoints$p(FrontendXBreakpointManager $this) {
        return $this.lightBreakpoints;
    }

    public static final /* synthetic */ MutableSharedFlow access$getBreakpointsChanged$p(FrontendXBreakpointManager $this) {
        return $this.breakpointsChanged;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/platform/debugger/impl/frontend/FrontendXBreakpointManager$LightBreakpointPosition;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;I)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getLine", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.debugger.impl.frontend"})
    private static final class LightBreakpointPosition {
        @NotNull
        private final VirtualFile file;
        private final int line;

        public LightBreakpointPosition(@NotNull VirtualFile file, int line) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
            this.line = line;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        public final int getLine() {
            return this.line;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.file;
        }

        public final int component2() {
            return this.line;
        }

        @NotNull
        public final LightBreakpointPosition copy(@NotNull VirtualFile file, int line) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return new LightBreakpointPosition(file, line);
        }

        public static /* synthetic */ LightBreakpointPosition copy$default(LightBreakpointPosition lightBreakpointPosition, VirtualFile virtualFile, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                virtualFile = lightBreakpointPosition.file;
            }
            if ((n2 & 2) != 0) {
                n = lightBreakpointPosition.line;
            }
            return lightBreakpointPosition.copy(virtualFile, n);
        }

        @NotNull
        public String toString() {
            return "LightBreakpointPosition(file=" + this.file + ", line=" + this.line + ")";
        }

        public int hashCode() {
            int result = this.file.hashCode();
            result = result * 31 + Integer.hashCode(this.line);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LightBreakpointPosition)) {
                return false;
            }
            LightBreakpointPosition lightBreakpointPosition = (LightBreakpointPosition)other;
            if (!Intrinsics.areEqual((Object)this.file, (Object)lightBreakpointPosition.file)) {
                return false;
            }
            return this.line == lightBreakpointPosition.line;
        }
    }
}

