/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.RepositoryChangesBrowserNodeKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.CurrentBranchComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.ui.CheckboxIcon;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.branch.BranchData;
import com.intellij.vcs.branch.BranchPresentation;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogColorManagerFactory;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001aB\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/dvcs/ui/RepositoryChangesBrowserNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "Lcom/intellij/dvcs/repo/Repository;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$NodeWithFilePath;", "repository", "colorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "<init>", "(Lcom/intellij/dvcs/repo/Repository;Lcom/intellij/vcs/log/ui/VcsLogColorManager;)V", "render", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "", "expanded", "hasFocus", "appendCurrentBranch", "getSortWeight", "", "compareUserObjects", "o2", "getTextPresentation", "", "getNodeFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "Companion", "intellij.platform.vcs.dvcs.impl"})
public class RepositoryChangesBrowserNode
extends ChangesBrowserNode<Repository>
implements ChangesBrowserNode.NodeWithFilePath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VcsLogColorManager colorManager;

    public RepositoryChangesBrowserNode(@NotNull Repository repository, @NotNull VcsLogColorManager colorManager) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)colorManager, (String)"colorManager");
        super((Object)repository);
        this.colorManager = colorManager;
    }

    public /* synthetic */ RepositoryChangesBrowserNode(Repository repository, VcsLogColorManager vcsLogColorManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Project project = repository.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            vcsLogColorManager = Companion.getColorManager(project);
        }
        this(repository, vcsLogColorManager);
    }

    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Object object = this.getUserObject();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getUserObject(...)");
        renderer.setIcon((Icon)Companion.getRepositoryIcon((Repository)object, this.colorManager));
        renderer.append(" " + this.getTextPresentation(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.appendCount((ColoredTreeCellRenderer)renderer);
        if (renderer.isShowingLocalChanges()) {
            this.appendCurrentBranch(renderer);
        }
    }

    private final void appendCurrentBranch(ChangesBrowserNodeRenderer renderer) {
        Repository repository = (Repository)this.getUserObject();
        Project project = repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile virtualFile = repository.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        BranchData branch = CurrentBranchComponent.Companion.getCurrentBranch(project, virtualFile);
        if (branch != null) {
            renderer.append(FontUtil.spaceAndThinSpace());
            String string = " " + BranchPresentation.INSTANCE.getPresentableText(branch) + " ";
            Color color = renderer.getBackground();
            if (color == null) {
                Color color2 = UIUtil.getTreeBackground();
                color = color2;
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getTreeBackground(...)");
            }
            renderer.append(string, RepositoryChangesBrowserNodeKt.access$getBranchLabelAttributes(color));
            renderer.setBackgroundInsets(RepositoryChangesBrowserNodeKt.access$getBRANCH_BACKGROUND_INSETS$p());
            renderer.setToolTipText(BranchPresentation.INSTANCE.getSingleTooltip(branch));
        }
    }

    public int getSortWeight() {
        return 3;
    }

    public int compareUserObjects(@NotNull Repository o2) {
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        return ChangesBrowserNode.compareFileNames((String)DvcsUtil.getShortRepositoryName((Repository)this.getUserObject()), (String)DvcsUtil.getShortRepositoryName(o2));
    }

    @NotNull
    public String getTextPresentation() {
        String string = DvcsUtil.getShortRepositoryName((Repository)this.getUserObject());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortRepositoryName(...)");
        return string;
    }

    @NotNull
    public FilePath getNodeFilePath() {
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)((Repository)this.getUserObject()).getRoot());
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        return filePath;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/dvcs/ui/RepositoryChangesBrowserNode$Companion;", "", "<init>", "()V", "getColorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "project", "Lcom/intellij/openapi/project/Project;", "getRepositoryIcon", "Lcom/intellij/util/ui/ColorIcon;", "repository", "Lcom/intellij/dvcs/repo/Repository;", "colorManager", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.vcs.dvcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VcsLogColorManager getColorManager(@NotNull Project project) {
            VcsLogColorManager colorManager;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            VcsLogManager vcsLogManager = VcsProjectLog.Companion.getInstance(project).getLogManager();
            Object object = colorManager = vcsLogManager != null ? vcsLogManager.getColorManager() : null;
            if (colorManager != null) {
                return colorManager;
            }
            VcsRoot[] vcsRootArray = ProjectLevelVcsManager.getInstance((Project)project).getAllVcsRoots();
            Intrinsics.checkNotNullExpressionValue((Object)vcsRootArray, (String)"getAllVcsRoots(...)");
            Set roots = VcsLogManager.findLogProviders((Collection)ArraysKt.asList((Object[])vcsRootArray), (Project)project).keySet();
            return VcsLogColorManagerFactory.create(roots);
        }

        @NotNull
        public final ColorIcon getRepositoryIcon(@NotNull Repository repository, @NotNull VcsLogColorManager colorManager) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)colorManager, (String)"colorManager");
            VirtualFile virtualFile = repository.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
            return this.getRepositoryIcon(colorManager, virtualFile);
        }

        public static /* synthetic */ ColorIcon getRepositoryIcon$default(Companion companion, Repository repository, VcsLogColorManager vcsLogColorManager, int n, Object object) {
            if ((n & 2) != 0) {
                Project project = repository.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                vcsLogColorManager = companion.getColorManager(project);
            }
            return companion.getRepositoryIcon(repository, vcsLogColorManager);
        }

        @ApiStatus.Internal
        @NotNull
        public final ColorIcon getRepositoryIcon(@NotNull VcsLogColorManager colorManager, @NotNull VirtualFile root) {
            Intrinsics.checkNotNullParameter((Object)colorManager, (String)"colorManager");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Color color = colorManager.getRootColor(root);
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getRootColor(...)");
            return CheckboxIcon.createAndScale((Color)color);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

