/*
 * Decompiled with CFR 0.152.
 */
package runtime.routing;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.MutableProperty;
import runtime.reactive.PropertyKt;
import runtime.reactive.SourceKt;
import runtime.routing.RouteDescriptor;
import runtime.routing.UiReadyKey;
import runtime.routing.UiReadyReporter;
import runtime.routing.UiReadyReporterKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\r\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lruntime/routing/UiReadyReporterImpl;", "Lruntime/routing/UiReadyReporter;", "keySets", "", "", "Lruntime/routing/UiReadyKey;", "<init>", "(Ljava/util/List;)V", "getKeySets", "()Ljava/util/List;", "allKeys", "uiReadyKeys", "Lruntime/reactive/MutableProperty;", "awaitUiReady", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "notifyUiReady", "descriptor", "Lruntime/routing/RouteDescriptor;", "key", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nUiReadyReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiReadyReporter.kt\nruntime/routing/UiReadyReporterImpl\n+ 2 KLogger.kt\nlibraries/klogging/KLogger\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n14#2,5:54\n14#2,5:59\n1755#3,3:64\n*S KotlinDebug\n*F\n+ 1 UiReadyReporter.kt\nruntime/routing/UiReadyReporterImpl\n*L\n45#1:54,5\n49#1:59,5\n36#1:64,3\n*E\n"})
final class UiReadyReporterImpl
implements UiReadyReporter {
    @NotNull
    private final List<Set<UiReadyKey>> keySets;
    @NotNull
    private final Set<UiReadyKey> allKeys;
    @NotNull
    private final MutableProperty<Set<UiReadyKey>> uiReadyKeys;

    public UiReadyReporterImpl(@NotNull List<? extends Set<? extends UiReadyKey>> keySets) {
        Intrinsics.checkNotNullParameter(keySets, (String)"keySets");
        this.keySets = keySets;
        this.allKeys = CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)this.keySets));
        this.uiReadyKeys = PropertyKt.mutableProperty(SetsKt.emptySet());
    }

    @NotNull
    public final List<Set<UiReadyKey>> getKeySets() {
        return this.keySets;
    }

    @Override
    @Nullable
    public Object awaitUiReady(@NotNull Continuation<? super Unit> $completion) {
        Object object = SourceKt.await$default(this.uiReadyKeys, null, null, (arg_0, arg_1) -> UiReadyReporterImpl.awaitUiReady$lambda$1(this, arg_0, arg_1), $completion, 3, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void notifyUiReady(@NotNull RouteDescriptor descriptor, @NotNull UiReadyKey key) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        if (this.allKeys.contains((Object)key)) {
            if (!this.uiReadyKeys.getValue().contains((Object)key)) {
                Object this_$iv = UiReadyReporterKt.access$getLog$p();
                boolean $i$f$debug = false;
                if (((KLogger)this_$iv).isDebugEnabled()) {
                    boolean bl = false;
                    String msgStr$iv = Reflection.getOrCreateKotlinClass(descriptor.getClass()).getSimpleName() + ": '" + key.name() + "' is ready";
                    ((KLogger)this_$iv).debug(msgStr$iv);
                }
                this_$iv = this.uiReadyKeys;
                this_$iv.setValue(SetsKt.plus((Set)((Set)this_$iv.getValue()), (Object)((Object)key)));
            }
        } else {
            KLogger this_$iv = UiReadyReporterKt.access$getLog$p();
            boolean $i$f$debug = false;
            if (this_$iv.isDebugEnabled()) {
                boolean bl = false;
                String msgStr$iv = Reflection.getOrCreateKotlinClass(descriptor.getClass()).getSimpleName() + ": '" + key.name() + "' is not used to determine UI readiness";
                this_$iv.debug(msgStr$iv);
            }
        }
    }

    private static final Unit awaitUiReady$lambda$1(UiReadyReporterImpl this$0, Set readyKeys, Continuation continuation) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)readyKeys, (String)"readyKeys");
            Intrinsics.checkNotNullParameter((Object)continuation, (String)"continuation");
            Iterable $this$any$iv = this$0.keySets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Set it = (Set)element$iv;
                    boolean bl2 = false;
                    if (!readyKeys.containsAll(it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            continuation.resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
        }
        return Unit.INSTANCE;
    }
}

