/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryLogUiProvider;
import com.intellij.vcs.log.history.VcsLogFileHistoryProviderImplKt;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabLocation;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J2\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J2\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001a\u0010\u0016\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J \u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0011H\u0002\u00a8\u0006\u001f"}, d2={"Lcom/intellij/vcs/log/history/VcsLogDirectoryHistoryProvider;", "Lcom/intellij/vcs/log/history/FileHistoryLogUiProvider;", "<init>", "()V", "canShowFileHistory", "", "project", "Lcom/intellij/openapi/project/Project;", "paths", "", "Lcom/intellij/openapi/vcs/FilePath;", "revisionNumber", "", "showFileHistoryUi", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "selectRow", "createPathsFilter", "Lcom/intellij/vcs/log/VcsLogFilter;", "logProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "createHashFilter", "hash", "Lcom/intellij/vcs/log/Hash;", "root", "matches", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "pathsFilter", "hashFilter", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nVcsLogFileHistoryProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogFileHistoryProviderImpl.kt\ncom/intellij/vcs/log/history/VcsLogDirectoryHistoryProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,203:1\n1#2:204\n*E\n"})
public final class VcsLogDirectoryHistoryProvider
implements FileHistoryLogUiProvider {
    @NotNull
    public static final VcsLogDirectoryHistoryProvider INSTANCE = new VcsLogDirectoryHistoryProvider();

    private VcsLogDirectoryHistoryProvider() {
    }

    @Override
    public boolean canShowFileHistory(@NotNull Project project, @NotNull Collection<? extends FilePath> paths, @Nullable String revisionNumber) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        if (paths.isEmpty()) {
            return false;
        }
        VcsLogData vcsLogData = VcsProjectLog.Companion.getInstance(project).getDataManager();
        if (vcsLogData == null) {
            return false;
        }
        VcsLogData dataManager = vcsLogData;
        Map<VirtualFile, VcsLogProvider> map = dataManager.getLogProviders();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getLogProviders(...)");
        return this.createPathsFilter(project, map, paths) != null;
    }

    @Override
    @Nullable
    public VcsLogUiEx showFileHistoryUi(@NotNull Project project, @NotNull Collection<? extends FilePath> paths, @Nullable String revisionNumber, boolean selectRow) {
        boolean firstTime;
        Hash hash;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        String string = revisionNumber;
        if (string != null) {
            String it = string;
            boolean bl = false;
            hash = HashImpl.build(it);
        } else {
            hash = null;
        }
        Hash hash2 = hash;
        VirtualFile virtualFile = VcsLogUtil.getActualRoot(project, (FilePath)CollectionsKt.first((Iterable)paths));
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile root = virtualFile;
        VcsLogFileHistoryProviderImplKt.access$triggerFileHistoryUsage(project, paths, hash2);
        VcsLogManager vcsLogManager = VcsProjectLog.Companion.getInstance(project).getLogManager();
        Intrinsics.checkNotNull((Object)vcsLogManager);
        VcsLogManager logManager2 = vcsLogManager;
        Map<VirtualFile, VcsLogProvider> map = logManager2.getDataManager().getLogProviders();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getLogProviders(...)");
        VcsLogFilter vcsLogFilter = this.createPathsFilter(project, map, paths);
        Intrinsics.checkNotNull((Object)vcsLogFilter);
        VcsLogFilter pathsFilter = vcsLogFilter;
        VcsLogFilter hashFilter = this.createHashFilter(hash2, root);
        MainVcsLogUi ui = VcsLogTabLocation.Companion.findLogUi(logManager2, VcsLogTabLocation.TOOL_WINDOW, MainVcsLogUi.class, true, arg_0 -> VcsLogDirectoryHistoryProvider.showFileHistoryUi$lambda$1(pathsFilter, hashFilter, arg_0));
        boolean bl = firstTime = ui == null;
        if (firstTime) {
            VcsLogFilter[] vcsLogFilterArray = new VcsLogFilter[]{pathsFilter, hashFilter};
            VcsLogFilterCollection filters = VcsLogFilterObject.collection(vcsLogFilterArray);
            MainVcsLogUi mainVcsLogUi = VcsProjectLog.Companion.getInstance(project).openLogTab(filters);
            if (mainVcsLogUi == null) {
                return null;
            }
            ui = mainVcsLogUi;
            MainVcsLogUiProperties mainVcsLogUiProperties = ui.getProperties();
            VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty = MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES;
            Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty, (String)"SHOW_ONLY_AFFECTED_CHANGES");
            mainVcsLogUiProperties.set(vcsLogUiProperty, true);
        }
        if (selectRow) {
            MainVcsLogUi mainVcsLogUi = ui;
            Intrinsics.checkNotNull((Object)mainVcsLogUi);
            VcsLogFileHistoryProviderImplKt.access$selectRowWhenOpen(logManager2, hash2, root, mainVcsLogUi, firstTime);
        }
        return ui;
    }

    @Nullable
    public final VcsLogFilter createPathsFilter(@NotNull Project project, @NotNull Map<VirtualFile, ? extends VcsLogProvider> logProviders, @NotNull Collection<? extends FilePath> paths) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(logProviders, (String)"logProviders");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Set forRootFilter = new LinkedHashSet();
        List forPathsFilter = new ArrayList();
        for (FilePath filePath : paths) {
            VirtualFile root = VcsLogUtil.getActualRoot(project, filePath);
            if (root == null) {
                return null;
            }
            if (!logProviders.keySet().contains(root) || !((Boolean)VcsLogProperties.SUPPORTS_LOG_DIRECTORY_HISTORY.getOrDefault(logProviders.get(root))).booleanValue()) {
                return null;
            }
            FilePath correctedPath = VcsLogFileHistoryProviderImplKt.access$getCorrectedPath(project, filePath, false);
            if (!correctedPath.isDirectory()) {
                return null;
            }
            boolean bl = Intrinsics.areEqual((Object)filePath.getVirtualFile(), (Object)root) ? forRootFilter.add(root) : forPathsFilter.add(correctedPath);
            if (!(!((Collection)forPathsFilter).isEmpty()) || !(!((Collection)forRootFilter).isEmpty())) continue;
            return null;
        }
        if (!((Collection)forPathsFilter).isEmpty()) {
            return (VcsLogFilter)VcsLogFilterObject.fromPaths(forPathsFilter);
        }
        return (VcsLogFilter)VcsLogFilterObject.fromRoots(forRootFilter);
    }

    private final VcsLogFilter createHashFilter(Hash hash, VirtualFile root) {
        if (hash == null) {
            return (VcsLogFilter)VcsLogFilterObject.fromBranch("HEAD");
        }
        return (VcsLogFilter)VcsLogFilterObject.fromCommit(new CommitId(hash, root));
    }

    private final boolean matches(VcsLogFilterCollection filters, VcsLogFilter pathsFilter, VcsLogFilter hashFilter) {
        VcsLogFilterCollection.FilterKey[] filterKeyArray = new VcsLogFilterCollection.FilterKey[2];
        Intrinsics.checkNotNullExpressionValue((Object)hashFilter.getKey(), (String)"getKey(...)");
        Intrinsics.checkNotNullExpressionValue((Object)pathsFilter.getKey(), (String)"getKey(...)");
        if (!VcsLogFiltersKt.matches(filters, filterKeyArray)) {
            return false;
        }
        return Intrinsics.areEqual((Object)filters.get(pathsFilter.getKey()), (Object)pathsFilter) && Intrinsics.areEqual((Object)filters.get(hashFilter.getKey()), (Object)hashFilter);
    }

    private static final boolean showFileHistoryUi$lambda$1(VcsLogFilter $pathsFilter, VcsLogFilter $hashFilter, MainVcsLogUi logUi) {
        Intrinsics.checkNotNullParameter((Object)logUi, (String)"logUi");
        VcsLogFilterCollection vcsLogFilterCollection = logUi.getFilterUi().getFilters();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogFilterCollection, (String)"getFilters(...)");
        return INSTANCE.matches(vcsLogFilterCollection, $pathsFilter, $hashFilter);
    }
}

