/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogTabsWatcherExtension;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\b\u0000\u0018\u0000 '2\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0004$%&'B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001c\u0010\u0015\u001a\u00020\u00102\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u001c\u0010\u0017\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010\u001f\u001a\u00020\u00102\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001e0!H\u0016J\b\u0010\"\u001a\u00020\u0010H\u0002J\b\u0010#\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006("}, d2={"Lcom/intellij/vcs/log/impl/VcsLogToolWindowTabsWatcher;", "Lcom/intellij/vcs/log/impl/VcsLogTabsWatcherExtension;", "Lcom/intellij/vcs/log/impl/VcsLogToolWindowTabsWatcher$VcsLogToolWindowTab;", "project", "Lcom/intellij/openapi/project/Project;", "toolWindowId", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/openapi/Disposable;)V", "mainDisposable", "Lorg/jetbrains/annotations/NotNull;", "toolwindowListenerDisposable", "tabSelectedCallback", "Lkotlin/Function1;", "", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "getToolWindow", "()Lcom/intellij/openapi/wm/ToolWindow;", "setTabSelectedCallback", "callback", "createLogTab", "ui", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "isClosedOnDispose", "", "isOwnerOf", "tab", "Lcom/intellij/vcs/log/impl/PostponableLogRefresher$VcsLogWindow;", "closeTabs", "tabs", "", "installContentListeners", "removeContentListeners", "VcsLogToolWindowTab", "MyToolWindowManagerListener", "VcsLogTabsListener", "Companion", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogToolWindowTabsWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogToolWindowTabsWatcher.kt\ncom/intellij/vcs/log/impl/VcsLogToolWindowTabsWatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n808#2,11:180\n774#2:191\n865#2,2:192\n1563#2:194\n1634#2,3:195\n*S KotlinDebug\n*F\n+ 1 VcsLogToolWindowTabsWatcher.kt\ncom/intellij/vcs/log/impl/VcsLogToolWindowTabsWatcher\n*L\n55#1:180,11\n55#1:191\n55#1:192,2\n55#1:194\n55#1:195,3\n*E\n"})
public final class VcsLogToolWindowTabsWatcher
implements VcsLogTabsWatcherExtension<VcsLogToolWindowTab> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String toolWindowId;
    @NotNull
    private final Disposable mainDisposable;
    @NotNull
    private final Disposable toolwindowListenerDisposable;
    @NotNull
    private Function1<? super String, Unit> tabSelectedCallback;
    @NotNull
    private static final Logger LOG;

    public VcsLogToolWindowTabsWatcher(@NotNull Project project, @NotNull String toolWindowId, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindowId, (String)"toolWindowId");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        this.toolWindowId = toolWindowId;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.mainDisposable = disposable;
        Disposable disposable2 = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"newDisposable(...)");
        this.toolwindowListenerDisposable = disposable2;
        this.tabSelectedCallback = VcsLogToolWindowTabsWatcher::tabSelectedCallback$lambda$0;
        MessageBusConnection connection = this.project.getMessageBus().connect(this.mainDisposable);
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new MyToolWindowManagerListener());
        this.installContentListeners();
        Disposer.register((Disposable)parentDisposable, (Disposable)this.mainDisposable);
        Disposer.register((Disposable)parentDisposable, (Disposable)this.toolwindowListenerDisposable);
    }

    private final ToolWindow getToolWindow() {
        return ToolWindowManager.Companion.getInstance(this.project).getToolWindow(this.toolWindowId);
    }

    @Override
    public void setTabSelectedCallback(@NotNull Function1<? super String, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.tabSelectedCallback = callback;
    }

    @Override
    @NotNull
    public VcsLogToolWindowTab createLogTab(@NotNull VcsLogUiEx ui, boolean isClosedOnDispose) {
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        return new VcsLogToolWindowTab(ui, isClosedOnDispose);
    }

    @Override
    public boolean isOwnerOf(@NotNull PostponableLogRefresher.VcsLogWindow tab) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        return tab instanceof VcsLogToolWindowTab;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeTabs(@NotNull List<? extends PostponableLogRefresher.VcsLogWindow> tabs) {
        block5: {
            void $this$mapTo$iv$iv;
            VcsLogToolWindowTab it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter(tabs, (String)"tabs");
            Iterable $this$filterIsInstance$iv = tabs;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof VcsLogToolWindowTab)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (VcsLogToolWindowTab)element$iv$iv;
                boolean bl = false;
                if (!it.isClosedOnDispose()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (VcsLogToolWindowTab)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId());
            }
            List tabIds = (List)destination$iv$iv;
            if (tabIds.isEmpty()) {
                return;
            }
            ToolWindow toolWindow = this.getToolWindow();
            if (toolWindow == null) break block5;
            ToolWindow window = toolWindow;
            boolean bl = false;
            for (Object e : tabIds) {
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                String tabId = (String)e;
                ContentManager contentManager = window.getContentManager();
                Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
                boolean closed = VcsLogContentUtil.INSTANCE.closeLogTab(contentManager, tabId);
                String string = Arrays.toString(window.getContentManager().getContents());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                LOG.assertTrue(closed, (Object)StringsKt.trimIndent((String)("\n           Could not find content component for tab " + tabId + "\n           Existing content: " + string + "\n           Tabs to close: " + tabIds + "\n           ")));
            }
        }
    }

    private final void installContentListeners() {
        block0: {
            ThreadingAssertions.assertEventDispatchThread();
            ToolWindow toolWindow = this.getToolWindow();
            if (toolWindow == null) break block0;
            ToolWindow window = toolWindow;
            boolean bl = false;
            Project project = this.project;
            Disposable disposable = this.mainDisposable;
            VcsLogToolWindowTabsWatcher.Companion.addContentManagerListener(window, new VcsLogTabsListener(window, this, project, disposable){
                final /* synthetic */ VcsLogToolWindowTabsWatcher this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1, $window, $super_call_param$2);
                }

                protected void selectionChanged(String tabId) {
                    Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
                    VcsLogToolWindowTabsWatcher.access$getTabSelectedCallback$p(this.this$0).invoke((Object)tabId);
                }
            }, this.toolwindowListenerDisposable);
        }
    }

    private final void removeContentListeners() {
        Disposer.dispose((Disposable)this.toolwindowListenerDisposable);
    }

    private static final Unit tabSelectedCallback$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Function1 access$getTabSelectedCallback$p(VcsLogToolWindowTabsWatcher $this) {
        return $this.tabSelectedCallback;
    }

    static {
        Logger logger = Logger.getInstance(VcsLogToolWindowTabsWatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogToolWindowTabsWatcher$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getSelectedToolWindowTabId", "", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "addContentManagerListener", "", "window", "listener", "Lcom/intellij/ui/content/ContentManagerListener;", "disposable", "Lcom/intellij/openapi/Disposable;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final String getSelectedToolWindowTabId(ToolWindow toolWindow) {
            if (toolWindow == null || !toolWindow.isVisible()) {
                return null;
            }
            Content content = toolWindow.getContentManager().getSelectedContent();
            if (content == null) {
                return null;
            }
            Content content2 = content;
            return VcsLogContentUtil.INSTANCE.getId(content2);
        }

        private final void addContentManagerListener(ToolWindow window, ContentManagerListener listener2, Disposable disposable) {
            window.addContentManagerListener(listener2);
            Disposer.register((Disposable)disposable, () -> Companion.addContentManagerListener$lambda$0(window, listener2));
        }

        private static final void addContentManagerListener$lambda$0(ToolWindow $window, ContentManagerListener $listener) {
            block1: {
                if ($window.isDisposed()) break block1;
                ContentManager contentManager = $window.getContentManagerIfCreated();
                if (contentManager != null) {
                    contentManager.removeContentManagerListener($listener);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogToolWindowTabsWatcher$MyToolWindowManagerListener;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "<init>", "(Lcom/intellij/vcs/log/impl/VcsLogToolWindowTabsWatcher;)V", "toolWindowsRegistered", "", "ids", "", "", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "toolWindowUnregistered", "id", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "intellij.platform.vcs.log.impl"})
    private final class MyToolWindowManagerListener
    implements ToolWindowManagerListener {
        public void toolWindowsRegistered(@NotNull List<String> ids2, @NotNull ToolWindowManager toolWindowManager) {
            Intrinsics.checkNotNullParameter(ids2, (String)"ids");
            Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
            if (ids2.contains(VcsLogToolWindowTabsWatcher.this.toolWindowId)) {
                VcsLogToolWindowTabsWatcher.this.installContentListeners();
            }
        }

        public void toolWindowUnregistered(@NotNull String id, @NotNull ToolWindow toolWindow) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
            if (Intrinsics.areEqual((Object)id, (Object)VcsLogToolWindowTabsWatcher.this.toolWindowId)) {
                VcsLogToolWindowTabsWatcher.this.removeContentListeners();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH$J\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogToolWindowTabsWatcher$VcsLogTabsListener;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "Ljava/beans/PropertyChangeListener;", "Lcom/intellij/ui/content/ContentManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "window", "Lcom/intellij/openapi/wm/ToolWindow;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/ToolWindow;Lcom/intellij/openapi/Disposable;)V", "selectionChanged", "", "tabId", "", "event", "Lcom/intellij/ui/content/ContentManagerEvent;", "contentAdded", "contentRemoved", "toolWindowShown", "toolWindow", "propertyChange", "evt", "Ljava/beans/PropertyChangeEvent;", "intellij.platform.vcs.log.impl"})
    @SourceDebugExtension(value={"SMAP\nVcsLogToolWindowTabsWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogToolWindowTabsWatcher.kt\ncom/intellij/vcs/log/impl/VcsLogToolWindowTabsWatcher$VcsLogTabsListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1#2:180\n*E\n"})
    private static abstract class VcsLogTabsListener
    implements ToolWindowManagerListener,
    PropertyChangeListener,
    ContentManagerListener {
        @NotNull
        private final ToolWindow window;

        public VcsLogTabsListener(@NotNull Project project, @NotNull ToolWindow window, @NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)window, (String)"window");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            this.window = window;
            MessageBusConnection messageBusConnection = project.getMessageBus().connect(disposable);
            Topic topic = ToolWindowManagerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)this);
            Disposer.register((Disposable)disposable, () -> VcsLogTabsListener._init_$lambda$0(this));
        }

        protected abstract void selectionChanged(@NotNull String var1);

        private final void selectionChanged() {
            block0: {
                String string = Companion.getSelectedToolWindowTabId(this.window);
                if (string == null) break block0;
                String it = string;
                boolean bl = false;
                this.selectionChanged(it);
            }
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
            block1: {
                String tabId;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (ContentManagerEvent.ContentOperation.add != event.getOperation()) break block1;
                Content content = event.getContent();
                Intrinsics.checkNotNullExpressionValue((Object)content, (String)"getContent(...)");
                String string = tabId = VcsLogContentUtil.INSTANCE.getId(content);
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    this.selectionChanged(it);
                }
            }
        }

        public void contentAdded(@NotNull ContentManagerEvent event) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Content content = event.getContent();
                Intrinsics.checkNotNullExpressionValue((Object)content, (String)"getContent(...)");
                Content content2 = content;
                TabbedContent tabbedContent = content2 instanceof TabbedContent ? (TabbedContent)content2 : null;
                if (tabbedContent == null) break block0;
                tabbedContent.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Content content = event.getContent();
                Intrinsics.checkNotNullExpressionValue((Object)content, (String)"getContent(...)");
                Content content2 = content;
                TabbedContent tabbedContent = content2 instanceof TabbedContent ? (TabbedContent)content2 : null;
                if (tabbedContent == null) break block0;
                tabbedContent.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void toolWindowShown(@NotNull ToolWindow toolWindow) {
            Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
            if (this.window == toolWindow) {
                this.selectionChanged();
            }
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent evt) {
            Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
            if (Intrinsics.areEqual((Object)evt.getPropertyName(), (Object)"component")) {
                this.selectionChanged();
            }
        }

        private static final void _init_$lambda$0(VcsLogTabsListener this$0) {
            ContentManager contentManager = this$0.window.getContentManagerIfCreated();
            if (contentManager == null) {
                return;
            }
            ContentManager contentManager2 = contentManager;
            for (Content content : contentManager2.getContents()) {
                TabbedContent tabbedContent = content instanceof TabbedContent ? (TabbedContent)content : null;
                if (tabbedContent == null) continue;
                tabbedContent.removePropertyChangeListener((PropertyChangeListener)this$0);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\t\u001a\u00020\u0005H\u0016J\r\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\b\u00a8\u0006\r"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogToolWindowTabsWatcher$VcsLogToolWindowTab;", "Lcom/intellij/vcs/log/impl/PostponableLogRefresher$VcsLogWindow;", "ui", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "isClosedOnDispose", "", "<init>", "(Lcom/intellij/vcs/log/impl/VcsLogToolWindowTabsWatcher;Lcom/intellij/vcs/log/ui/VcsLogUiEx;Z)V", "()Z", "isVisible", "toString", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.platform.vcs.log.impl"})
    public final class VcsLogToolWindowTab
    extends PostponableLogRefresher.VcsLogWindow {
        private final boolean isClosedOnDispose;

        public VcsLogToolWindowTab(VcsLogUiEx ui, boolean isClosedOnDispose) {
            Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
            super(ui);
            this.isClosedOnDispose = isClosedOnDispose;
        }

        public final boolean isClosedOnDispose() {
            return this.isClosedOnDispose;
        }

        @Override
        public boolean isVisible() {
            String selectedTab = Companion.getSelectedToolWindowTabId(VcsLogToolWindowTabsWatcher.this.getToolWindow());
            return Intrinsics.areEqual((Object)this.getId(), (Object)selectedTab);
        }

        @Override
        @NotNull
        public String toString() {
            return "VcsLogToolWindowTab '" + this.getId() + "'";
        }
    }
}

