/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.application.options.editor.CheckboxDescriptor;
import com.intellij.application.options.editor.CheckboxDescriptorKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.history.FileHistoryUiProperties;
import com.intellij.vcs.log.history.VcsLogFileHistoryProviderImplKt;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogApplicationSettings;
import com.intellij.vcs.log.impl.VcsLogIndexer;
import com.intellij.vcs.log.impl.VcsLogSharedSettings;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogIndexAvailabilityPredicate;
import com.intellij.vcs.log.ui.table.column.VcsLogColumn;
import com.intellij.vcs.log.ui.table.column.VcsLogColumnUtilKt;
import com.intellij.vcs.log.ui.table.column.VcsLogCustomColumn;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010\u001a\u001a\u00020\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001b\u001a\u00020\u0016*\u00020\u00172\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J9\u0010\u001e\u001a\u00020\u0016*\u00020\u00172\u0015\u0010\u001f\u001a\u00110 \u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J5\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(*\u00020*2\u000b\u0010+\u001a\u00070 \u00a2\u0006\u0002\b,2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010-\u001a\u00020 H\u0002J\b\u0010.\u001a\u00020&H\u0002J\b\u0010/\u001a\u00020 H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00060"}, d2={"Lcom/intellij/vcs/log/ui/VcsLogConfigurable;", "Lcom/intellij/openapi/options/BoundConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "sharedSettings", "Lcom/intellij/vcs/log/impl/VcsLogSharedSettings;", "getSharedSettings", "()Lcom/intellij/vcs/log/impl/VcsLogSharedSettings;", "applicationSettings", "Lcom/intellij/vcs/log/impl/VcsLogApplicationSettings;", "getApplicationSettings", "()Lcom/intellij/vcs/log/impl/VcsLogApplicationSettings;", "fileHistorySettings", "Lcom/intellij/vcs/log/history/FileHistoryUiProperties;", "getFileHistorySettings", "()Lcom/intellij/vcs/log/history/FileHistoryUiProperties;", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "columnVisibilityGroup", "", "Lcom/intellij/ui/dsl/builder/Panel;", "properties", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties;", "diffPreviewLocationGroup", "columnCheckboxRow", "column", "Lcom/intellij/vcs/log/ui/table/column/VcsLogColumn;", "booleanPropertyCheckboxRow", "textKey", "", "Lorg/jetbrains/annotations/PropertyKey;", "resourceBundle", "messages.VcsLogBundle", "property", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties$VcsLogUiProperty;", "", "booleanPropertyCheckbox", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/intellij/ui/components/JBCheckBox;", "Lcom/intellij/ui/dsl/builder/Row;", "text", "Lorg/jetbrains/annotations/Nls;", "getVcsNames", "isNewFileHistoryAvailable", "getId", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogConfigurable.kt\ncom/intellij/vcs/log/ui/VcsLogConfigurable\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 ButtonsGroup.kt\ncom/intellij/ui/dsl/builder/ButtonsGroupKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n30#2,2:169\n30#2,2:171\n30#2,2:173\n27#3:175\n11563#4,3:176\n1634#5,3:179\n1617#5,9:182\n1869#5:191\n1870#5:193\n1626#5:194\n1761#5,3:195\n774#5:198\n865#5,2:199\n1#6:192\n*S KotlinDebug\n*F\n+ 1 VcsLogConfigurable.kt\ncom/intellij/vcs/log/ui/VcsLogConfigurable\n*L\n33#1:169,2\n34#1:171,2\n35#1:173,2\n99#1:175\n132#1:176,3\n133#1:179,3\n135#1:182,9\n135#1:191\n135#1:193\n135#1:194\n142#1:195,3\n76#1:198\n76#1:199,2\n135#1:192\n*E\n"})
public final class VcsLogConfigurable
extends BoundConfigurable
implements SearchableConfigurable {
    @NotNull
    private final Project project;

    public VcsLogConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = VcsLogBundle.message("vcs.log.settings.group.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, null, 2, null);
        this.project = project;
    }

    private final VcsLogSharedSettings getSharedSettings() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<VcsLogSharedSettings> serviceClass$iv = VcsLogSharedSettings.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (VcsLogSharedSettings)object;
    }

    private final VcsLogApplicationSettings getApplicationSettings() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        ComponentManager $this$service$iv = (ComponentManager)application;
        boolean $i$f$service = false;
        Class<VcsLogApplicationSettings> serviceClass$iv = VcsLogApplicationSettings.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (VcsLogApplicationSettings)object;
    }

    private final FileHistoryUiProperties getFileHistorySettings() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<FileHistoryUiProperties> serviceClass$iv = FileHistoryUiProperties.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (FileHistoryUiProperties)object;
    }

    @NotNull
    public DialogPanel createPanel() {
        String vcsNamesToShow = this.getVcsNames();
        return BuilderKt.panel(arg_0 -> VcsLogConfigurable.createPanel$lambda$4(this, vcsNamesToShow, arg_0));
    }

    private final void columnVisibilityGroup(Panel $this$columnVisibilityGroup, VcsLogUiProperties properties) {
        if (VcsLogColumnUtilKt.supportsColumnsToggling(properties)) {
            Panel.group$default((Panel)$this$columnVisibilityGroup, (String)VcsLogBundle.message("vcs.log.settings.visible.columns", new Object[0]), (boolean)false, arg_0 -> VcsLogConfigurable.columnVisibilityGroup$lambda$6(this, properties, arg_0), (int)2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void diffPreviewLocationGroup(Panel $this$diffPreviewLocationGroup, VcsLogUiProperties properties) {
        VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty = CommonUiProperties.SHOW_DIFF_PREVIEW;
        Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty, (String)"SHOW_DIFF_PREVIEW");
        if (!properties.exists(vcsLogUiProperty)) {
            return;
        }
        Ref.ObjectRef diffPreviewCheckbox = new Ref.ObjectRef();
        Panel.row$default((Panel)$this$diffPreviewLocationGroup, null, arg_0 -> VcsLogConfigurable.diffPreviewLocationGroup$lambda$7(diffPreviewCheckbox, this, properties, arg_0), (int)1, null);
        VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty2 = MainVcsLogUiProperties.DIFF_PREVIEW_VERTICAL_SPLIT;
        Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty2, (String)"DIFF_PREVIEW_VERTICAL_SPLIT");
        if (properties.exists(vcsLogUiProperty2)) {
            Cell cell;
            void getter$iv;
            void $this$bind$iv;
            ButtonsGroup buttonsGroup = Panel.buttonsGroup$default((Panel)$this$diffPreviewLocationGroup, null, (boolean)true, VcsLogConfigurable::diffPreviewLocationGroup$lambda$9, (int)1, null);
            Function0 function0 = () -> VcsLogConfigurable.diffPreviewLocationGroup$lambda$10(properties);
            Function1 setter$iv = arg_0 -> VcsLogConfigurable.diffPreviewLocationGroup$lambda$11(properties, arg_0);
            boolean $i$f$bind = false;
            ButtonsGroup buttonsGroup2 = $this$bind$iv.bind(MutablePropertyKt.MutableProperty((Function0)getter$iv, (Function1)setter$iv), Boolean.class);
            if (diffPreviewCheckbox.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"diffPreviewCheckbox");
                cell = null;
            } else {
                cell = (Cell)diffPreviewCheckbox.element;
            }
            buttonsGroup2.enabledIf(ButtonKt.getSelected((Cell)cell));
        }
    }

    private final void columnCheckboxRow(Panel $this$columnCheckboxRow, VcsLogColumn<?> column, VcsLogUiProperties properties) {
        Panel.row$default((Panel)$this$columnCheckboxRow, null, arg_0 -> VcsLogConfigurable.columnCheckboxRow$lambda$14(column, properties, arg_0), (int)1, null);
    }

    private final void booleanPropertyCheckboxRow(Panel $this$booleanPropertyCheckboxRow, String textKey, VcsLogUiProperties.VcsLogUiProperty<Boolean> property, VcsLogUiProperties properties) {
        if (!properties.exists(property)) {
            return;
        }
        Panel.row$default((Panel)$this$booleanPropertyCheckboxRow, null, arg_0 -> VcsLogConfigurable.booleanPropertyCheckboxRow$lambda$15(this, textKey, property, properties, arg_0), (int)1, null);
    }

    private final Cell<JBCheckBox> booleanPropertyCheckbox(Row $this$booleanPropertyCheckbox, String text, VcsLogUiProperties.VcsLogUiProperty<Boolean> property, VcsLogUiProperties properties) {
        return CheckboxDescriptorKt.checkBox((Row)$this$booleanPropertyCheckbox, (CheckboxDescriptor)new CheckboxDescriptor(text, () -> VcsLogConfigurable.booleanPropertyCheckbox$lambda$16(properties, property), arg_0 -> VcsLogConfigurable.booleanPropertyCheckbox$lambda$17(properties, property, arg_0), null, null, 24, null));
    }

    /*
     * WARNING - void declaration
     */
    private final String getVcsNames() {
        void destination$iv;
        void $this$mapTo$iv;
        VcsLogIndexer it;
        Collection collection;
        void $this$mapTo$iv2;
        AbstractVcs[] abstractVcsArray = ProjectLevelVcsManager.getInstance((Project)this.project).getAllActiveVcss();
        Intrinsics.checkNotNullExpressionValue((Object)abstractVcsArray, (String)"getAllActiveVcss(...)");
        Object[] objectArray = abstractVcsArray;
        Iterable destination$iv2 = new LinkedHashSet();
        boolean $i$f$mapTo22 = false;
        for (Object item$iv : $this$mapTo$iv2) {
            AbstractVcs abstractVcs = (AbstractVcs)item$iv;
            collection = destination$iv2;
            boolean bl = false;
            collection.add(it.getKeyInstanceMethod());
        }
        Set allVcsKeys = (Set)destination$iv2;
        Collection<VcsLogIndexer> collection2 = VcsLogPersistentIndex.getAvailableIndexers(this.project);
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"getAvailableIndexers(...)");
        destination$iv2 = collection2;
        Collection $i$f$mapTo22 = new LinkedHashSet();
        boolean $i$f$mapTo3 = false;
        for (Object item$iv : $this$mapTo$iv) {
            it = (VcsLogIndexer)item$iv;
            collection = destination$iv;
            boolean bl = false;
            collection.add(it.getSupportedVcs());
        }
        Set indexedVcsKeys = (Set)destination$iv;
        if (!Intrinsics.areEqual((Object)indexedVcsKeys, (Object)allVcsKeys)) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = indexedVcsKeys;
            boolean $i$f$mapNotNull = false;
            Iterable $i$f$mapTo3 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                VcsKey it2 = (VcsKey)element$iv$iv;
                boolean bl2 = false;
                AbstractVcs abstractVcs = VcsUtil.findVcsByKey((Project)this.project, (VcsKey)it2);
                if ((abstractVcs != null ? abstractVcs.getDisplayName() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, null, (int)63, null);
        }
        return "";
    }

    private final boolean isNewFileHistoryAvailable() {
        boolean bl;
        block4: {
            if (!VcsLogFileHistoryProviderImplKt.isNewHistoryEnabled()) {
                return false;
            }
            Iterable $this$any$iv = VcsProjectLog.Companion.getLogProviders(this.project).values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VcsLogProvider it = (VcsLogProvider)element$iv;
                    boolean bl2 = false;
                    if (!VcsLogFileHistoryProviderImplKt.isNewFileHistoryAvailable(this.project, it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public String getId() {
        return "vcs.log";
    }

    private static final Unit createPanel$lambda$4$lambda$0(VcsLogConfigurable this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty = CommonUiProperties.COMPACT_REFERENCES_VIEW;
        Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty, (String)"COMPACT_REFERENCES_VIEW");
        this$0.booleanPropertyCheckboxRow($this$group, "action.Vcs.Log.CompactReferencesView.description", vcsLogUiProperty, this$0.getApplicationSettings());
        VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty2 = CommonUiProperties.SHOW_TAG_NAMES;
        Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty2, (String)"SHOW_TAG_NAMES");
        this$0.booleanPropertyCheckboxRow($this$group, "action.Vcs.Log.ShowTagNames.description", vcsLogUiProperty2, this$0.getApplicationSettings());
        VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty3 = CommonUiProperties.PREFER_COMMIT_DATE;
        Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty3, (String)"PREFER_COMMIT_DATE");
        this$0.booleanPropertyCheckboxRow($this$group, "action.Vcs.Log.PreferCommitDate.description", vcsLogUiProperty3, this$0.getApplicationSettings());
        VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty4 = CommonUiProperties.LABELS_LEFT_ALIGNED;
        Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty4, (String)"LABELS_LEFT_ALIGNED");
        this$0.booleanPropertyCheckboxRow($this$group, "action.Vcs.Log.AlignLabels.description", vcsLogUiProperty4, this$0.getApplicationSettings());
        VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty5 = MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS;
        Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty5, (String)"SHOW_CHANGES_FROM_PARENTS");
        this$0.booleanPropertyCheckboxRow($this$group, "action.Vcs.Log.ShowChangesFromParents.description", vcsLogUiProperty5, this$0.getApplicationSettings());
        this$0.diffPreviewLocationGroup($this$group, this$0.getApplicationSettings());
        this$0.columnVisibilityGroup($this$group, this$0.getApplicationSettings());
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$4$lambda$2$lambda$1(String $vcsNamesToShow, VcsLogConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{$vcsNamesToShow.length(), $vcsNamesToShow};
        String string = VcsLogBundle.message("vcs.log.settings.enable.index.checkbox", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = Cell.comment$default((Cell)CheckboxDescriptorKt.checkBox((Row)$this$row, (CheckboxDescriptor)new CheckboxDescriptor(string, (Function0)new Function0<Boolean>((Object)this$0.getSharedSettings()){

            public final Boolean invoke() {
                return ((VcsLogSharedSettings)this.receiver).isIndexSwitchedOn();
            }
        }, (Function1)new Function1<Boolean, Unit>((Object)this$0.getSharedSettings()){

            public final void invoke(boolean p0) {
                ((VcsLogSharedSettings)this.receiver).setIndexSwitchedOn(p0);
            }
        }, null, null, 24, null)), (String)VcsLogBundle.message("vcs.log.settings.enable.index.checkbox.comment", new Object[0]), (int)0, null, (int)6, null);
        Project project = this$0.project;
        Disposable disposable = this$0.getDisposable();
        Intrinsics.checkNotNull((Object)disposable);
        cell.enabledIf((ComponentPredicate)new VcsLogIndexAvailabilityPredicate(project, disposable));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$4$lambda$2(String $vcsNamesToShow, VcsLogConfigurable this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.row$default((Panel)$this$group, null, arg_0 -> VcsLogConfigurable.createPanel$lambda$4$lambda$2$lambda$1($vcsNamesToShow, this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$4$lambda$3(VcsLogConfigurable this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty = CommonUiProperties.SHOW_DETAILS;
        Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty, (String)"SHOW_DETAILS");
        this$0.booleanPropertyCheckboxRow($this$group, "action.Vcs.Log.ShowDetailsAction.description", vcsLogUiProperty, this$0.getFileHistorySettings());
        VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty2 = CommonUiProperties.SHOW_ROOT_NAMES;
        Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty2, (String)"SHOW_ROOT_NAMES");
        this$0.booleanPropertyCheckboxRow($this$group, "vcs.log.settings.show.file.names", vcsLogUiProperty2, this$0.getFileHistorySettings());
        this$0.diffPreviewLocationGroup($this$group, this$0.getFileHistorySettings());
        this$0.columnVisibilityGroup($this$group, this$0.getFileHistorySettings());
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$4(VcsLogConfigurable this$0, String $vcsNamesToShow, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.group$default((Panel)$this$panel, (String)VcsLogBundle.message("group.Vcs.Log.PresentationSettings.text", new Object[0]), (boolean)false, arg_0 -> VcsLogConfigurable.createPanel$lambda$4$lambda$0(this$0, arg_0), (int)2, null);
        Collection<VcsLogIndexer> collection = VcsLogPersistentIndex.getAvailableIndexers(this$0.project);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getAvailableIndexers(...)");
        if (!collection.isEmpty()) {
            Panel.group$default((Panel)$this$panel, (String)VcsLogBundle.message("vcs.log.settings.group.indexing.title", new Object[0]), (boolean)false, arg_0 -> VcsLogConfigurable.createPanel$lambda$4$lambda$2($vcsNamesToShow, this$0, arg_0), (int)2, null);
        }
        if (this$0.isNewFileHistoryAvailable()) {
            Panel.group$default((Panel)$this$panel, (String)VcsLogBundle.message("vcs.log.settings.group.file.history.title", new Object[0]), (boolean)false, arg_0 -> VcsLogConfigurable.createPanel$lambda$4$lambda$3(this$0, arg_0), (int)2, null);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit columnVisibilityGroup$lambda$6(VcsLogConfigurable this$0, VcsLogUiProperties $properties, Panel $this$group) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Iterable $this$filter$iv = VcsLogColumnUtilKt.getDynamicColumns();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VcsLogColumn it = (VcsLogColumn)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof VcsLogCustomColumn) || ((VcsLogCustomColumn)it).isAvailable(this$0.project, (Collection<VirtualFile>)VcsProjectLog.Companion.getLogProviders(this$0.project).keySet()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List availableColumns = (List)destination$iv$iv;
        for (VcsLogColumn column : availableColumns) {
            this$0.columnCheckboxRow($this$group, column, $properties);
        }
        return Unit.INSTANCE;
    }

    private static final Unit diffPreviewLocationGroup$lambda$7(Ref.ObjectRef $diffPreviewCheckbox, VcsLogConfigurable this$0, VcsLogUiProperties $properties, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = VcsLogBundle.message("action.Vcs.Log.ShowDiffPreview.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty = CommonUiProperties.SHOW_DIFF_PREVIEW;
        Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty, (String)"SHOW_DIFF_PREVIEW");
        $diffPreviewCheckbox.element = this$0.booleanPropertyCheckbox($this$row, string, vcsLogUiProperty, $properties);
        return Unit.INSTANCE;
    }

    private static final Unit diffPreviewLocationGroup$lambda$9$lambda$8(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = VcsLogBundle.message("action.Vcs.Log.MoveDiffPreviewToBottom.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.radioButton(string, (Object)true);
        String string2 = VcsLogBundle.message("action.Vcs.Log.MoveDiffPreviewToRight.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$row.radioButton(string2, (Object)false);
        return Unit.INSTANCE;
    }

    private static final Unit diffPreviewLocationGroup$lambda$9(Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        String string = VcsLogBundle.message("vcs.log.settings.diff.preview.location", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$buttonsGroup.row(string, VcsLogConfigurable::diffPreviewLocationGroup$lambda$9$lambda$8);
        return Unit.INSTANCE;
    }

    private static final Boolean diffPreviewLocationGroup$lambda$10(VcsLogUiProperties $properties) {
        VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty = MainVcsLogUiProperties.DIFF_PREVIEW_VERTICAL_SPLIT;
        Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty, (String)"DIFF_PREVIEW_VERTICAL_SPLIT");
        return $properties.get(vcsLogUiProperty);
    }

    private static final Unit diffPreviewLocationGroup$lambda$11(VcsLogUiProperties $properties, Boolean it) {
        VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty = MainVcsLogUiProperties.DIFF_PREVIEW_VERTICAL_SPLIT;
        Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty, (String)"DIFF_PREVIEW_VERTICAL_SPLIT");
        $properties.set(vcsLogUiProperty, it);
        return Unit.INSTANCE;
    }

    private static final boolean columnCheckboxRow$lambda$14$lambda$12(VcsLogColumn $column, VcsLogUiProperties $properties) {
        return VcsLogColumnUtilKt.isVisible($column, $properties);
    }

    private static final Unit columnCheckboxRow$lambda$14$lambda$13(VcsLogUiProperties $properties, VcsLogColumn $column, boolean it) {
        if (it) {
            VcsLogColumnUtilKt.addColumn($properties, $column);
        } else {
            VcsLogColumnUtilKt.removeColumn($properties, $column);
        }
        return Unit.INSTANCE;
    }

    private static final Unit columnCheckboxRow$lambda$14(VcsLogColumn $column, VcsLogUiProperties $properties, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        CheckboxDescriptorKt.checkBox((Row)$this$row, (CheckboxDescriptor)new CheckboxDescriptor($column.getLocalizedName(), () -> VcsLogConfigurable.columnCheckboxRow$lambda$14$lambda$12($column, $properties), arg_0 -> VcsLogConfigurable.columnCheckboxRow$lambda$14$lambda$13($properties, $column, arg_0), null, null, 24, null));
        return Unit.INSTANCE;
    }

    private static final Unit booleanPropertyCheckboxRow$lambda$15(VcsLogConfigurable this$0, String $textKey, VcsLogUiProperties.VcsLogUiProperty $property, VcsLogUiProperties $properties, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = VcsLogBundle.message($textKey, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.booleanPropertyCheckbox($this$row, string, $property, $properties);
        return Unit.INSTANCE;
    }

    private static final boolean booleanPropertyCheckbox$lambda$16(VcsLogUiProperties $properties, VcsLogUiProperties.VcsLogUiProperty $property) {
        return (Boolean)$properties.get($property);
    }

    private static final Unit booleanPropertyCheckbox$lambda$17(VcsLogUiProperties $properties, VcsLogUiProperties.VcsLogUiProperty $property, boolean it) {
        $properties.set($property, it);
        return Unit.INSTANCE;
    }
}

