/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.TaskCancellation;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.impl.VcsProjectLogErrorHandlerKt;
import com.intellij.vcs.log.ui.actions.InvalidateVcsLogCachesKt;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/vcs/log/ui/actions/InvalidateVcsLogCaches;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.vcs.log.impl"})
final class InvalidateVcsLogCaches
extends DumbAwareAction {
    public InvalidateVcsLogCaches() {
        String string = VcsLogBundle.message("vcs", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(InvalidateVcsLogCachesKt.access$actionText(string));
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        VcsLogManager logManager2 = VcsProjectLog.Companion.getInstance(project).getLogManager();
        if (logManager2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(!((Collection)VcsProjectLogErrorHandlerKt.storageIds(logManager2)).isEmpty());
        Presentation presentation = e.getPresentation();
        String string = VcsLogUtil.getVcsDisplayName(project, logManager2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVcsDisplayName(...)");
        presentation.setText(InvalidateVcsLogCachesKt.access$actionText(string));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        VcsProjectLog projectLog = VcsProjectLog.Companion.getInstance(project2);
        VcsLogManager vcsLogManager = projectLog.getLogManager();
        if (vcsLogManager == null) {
            return;
        }
        VcsLogManager logManager2 = vcsLogManager;
        String string = VcsLogUtil.getVcsDisplayName(project2, logManager2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVcsDisplayName(...)");
        String vcsName = string;
        ModalTaskOwner modalTaskOwner = ModalTaskOwner.project((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)modalTaskOwner, (String)"project(...)");
        Object[] objectArray = new Object[]{vcsName};
        String string2 = VcsLogBundle.message("vcs.log.invalidate.caches.progress", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        TasksKt.runWithModalProgressBlocking((ModalTaskOwner)modalTaskOwner, (String)string2, (TaskCancellation)((TaskCancellation)TaskCancellation.Companion.nonCancellable()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(projectLog, logManager2, null){
            int label;
            final /* synthetic */ VcsProjectLog $projectLog;
            final /* synthetic */ VcsLogManager $logManager;
            {
                this.$projectLog = $projectLog;
                this.$logManager = $logManager;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = VcsProjectLogErrorHandlerKt.invalidateCaches(this.$projectLog, this.$logManager, (Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

