/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions.history;

import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.actions.AnnotationData;
import com.intellij.openapi.vcs.actions.ShowAnnotateOperationsPopup;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.util.io.CoroutinesKt;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.history.VcsLogFileHistoryProviderImplKt;
import com.intellij.vcs.log.impl.VcsLogNavigationUtil;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/log/ui/actions/history/ShowInFileHistoryAnnotationAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "annotation", "Lcom/intellij/openapi/vcs/annotate/FileAnnotation;", "<init>", "(Lcom/intellij/openapi/vcs/annotate/FileAnnotation;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getLineRevisionNumber", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.vcs.log.impl"})
final class ShowInFileHistoryAnnotationAction
extends DumbAwareAction {
    @NotNull
    private final FileAnnotation annotation;

    public ShowInFileHistoryAnnotationAction(@NotNull FileAnnotation annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        super(VcsLogBundle.message("vcs.log.action.show.in.file.history.text", new Object[0]));
        this.annotation = annotation;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        VirtualFile file = this.annotation.getFile();
        String lineRevisionNumber = this.getLineRevisionNumber(e);
        if (project == null || file == null || lineRevisionNumber == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        AnnotationData annotationData = AnnotationData.Companion.extractFrom(project, file);
        AnnotationData annotationData2 = annotationData;
        if (annotationData2 == null || (annotationData2 = annotationData2.getFilePath()) == null) {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
            annotationData2 = filePath;
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        }
        AnnotationData annotatedFilePath = annotationData2;
        AnnotationData annotationData3 = annotationData;
        String annotatedRevisionNumber = annotationData3 != null && (annotationData3 = annotationData3.getRevisionNumber()) != null ? annotationData3.asString() : null;
        e.getPresentation().setEnabledAndVisible(VcsLogFileHistoryProviderImplKt.canShowFileHistory(project, CollectionsKt.listOf((Object)annotatedFilePath), annotatedRevisionNumber));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        VirtualFile virtualFile = this.annotation.getFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        String string = this.getLineRevisionNumber(e);
        if (string == null) {
            return;
        }
        String lineRevisionNumber = string;
        AnnotationData annotationData = AnnotationData.Companion.extractFrom(project2, file);
        AnnotationData annotationData2 = annotationData;
        if (annotationData2 == null || (annotationData2 = annotationData2.getFilePath()) == null) {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
            annotationData2 = filePath;
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        }
        AnnotationData annotatedFilePath = annotationData2;
        AnnotationData annotationData3 = annotationData;
        String annotatedRevisionNumber = annotationData3 != null && (annotationData3 = annotationData3.getRevisionNumber()) != null ? annotationData3.asString() : null;
        VcsLogUiEx vcsLogUiEx = VcsLogFileHistoryProviderImplKt.showFileHistoryUi$default(project2, CollectionsKt.listOf((Object)annotatedFilePath), annotatedRevisionNumber, false, 8, null);
        if (vcsLogUiEx == null) {
            return;
        }
        VcsLogUiEx ui = vcsLogUiEx;
        ListenableFuture<Boolean> future = VcsLogNavigationUtil.jumpToHash(ui, lineRevisionNumber, false, true);
        BuildersKt.launch$default((CoroutineScope)VcsProjectLog.Companion.getInstance(project2).getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project2, lineRevisionNumber, future, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $lineRevisionNumber;
            final /* synthetic */ ListenableFuture<Boolean> $future;
            {
                this.$project = $project;
                this.$lineRevisionNumber = $lineRevisionNumber;
                this.$future = $future;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object[] objectArray = new Object[]{VcsLogUtil.getShortHash(this.$lineRevisionNumber)};
                        String string = VcsLogBundle.message("file.history.show.commit.in.history.process", objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        this.label = 1;
                        Object object2 = TasksKt.withBackgroundProgress((Project)this.$project, (String)string, (boolean)true, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$future, null){
                            int label;
                            final /* synthetic */ ListenableFuture<Boolean> $future;
                            {
                                this.$future = $future;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = CoroutinesKt.await((Future)((Future)this.$future), (Continuation)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final String getLineRevisionNumber(AnActionEvent e) {
        int lineNumber = ShowAnnotateOperationsPopup.getAnnotationLineNumber((DataContext)e.getDataContext());
        VcsRevisionNumber vcsRevisionNumber = this.annotation.getLineRevisionNumber(lineNumber);
        return vcsRevisionNumber != null ? vcsRevisionNumber.asString() : null;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

