/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.frontend.split;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.station.frontend.split.Fix;
import com.intellij.station.frontend.split.InEditorStatus;
import com.intellij.station.frontend.split.StatusType;
import com.intellij.station.frontend.split.ToolboxProblemEditorNotificationService;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/station/frontend/split/ToolboxProblemEditorNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createEditorNotification", "Lcom/intellij/ui/EditorNotificationPanel;", "editor", "problem", "Lcom/intellij/station/frontend/split/InEditorStatus;", "intellij.station.frontend.split"})
@SourceDebugExtension(value={"SMAP\nToolboxProblemEditorNotificationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolboxProblemEditorNotificationProvider.kt\ncom/intellij/station/frontend/split/ToolboxProblemEditorNotificationProvider\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,55:1\n40#2,3:56\n*S KotlinDebug\n*F\n+ 1 ToolboxProblemEditorNotificationProvider.kt\ncom/intellij/station/frontend/split/ToolboxProblemEditorNotificationProvider\n*L\n23#1:56,3\n*E\n"})
public final class ToolboxProblemEditorNotificationProvider
implements EditorNotificationProvider {
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean $i$f$service = false;
        Class<ToolboxProblemEditorNotificationService> serviceClass$iv = ToolboxProblemEditorNotificationService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        InEditorStatus inEditorStatus = (InEditorStatus)((ToolboxProblemEditorNotificationService)object).getStatusInEditor().getValue();
        if (inEditorStatus == null) {
            return null;
        }
        InEditorStatus problem = inEditorStatus;
        return arg_0 -> ToolboxProblemEditorNotificationProvider.collectNotificationData$lambda$0(this, problem, arg_0);
    }

    private final EditorNotificationPanel createEditorNotification(FileEditor editor, InEditorStatus problem) {
        EditorNotificationPanel.Status status;
        StatusType statusType = problem.getType();
        if (Intrinsics.areEqual((Object)statusType, (Object)StatusType.Error.INSTANCE) || Intrinsics.areEqual((Object)statusType, (Object)StatusType.FatalError.INSTANCE)) {
            status = EditorNotificationPanel.Status.Error;
        } else if (Intrinsics.areEqual((Object)statusType, (Object)StatusType.Progress.INSTANCE)) {
            status = EditorNotificationPanel.Status.Info;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        EditorNotificationPanel.Status status2 = status;
        EditorNotificationPanel panel = new EditorNotificationPanel(editor, status2);
        panel.setText(problem.getMessage());
        for (Fix fix : problem.getFixes()) {
            panel.createActionLabel(fix.getActionText(), () -> ToolboxProblemEditorNotificationProvider.createEditorNotification$lambda$1(fix));
        }
        return panel;
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$0(ToolboxProblemEditorNotificationProvider this$0, InEditorStatus $problem, FileEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this$0.createEditorNotification(editor, $problem);
    }

    private static final void createEditorNotification$lambda$1(Fix $fix) {
        $fix.getApplyFix().invoke();
    }
}

