/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.openapi.editor.markup.TextAttributeKeyColorType;
import com.intellij.util.ui.ComparableColor;
import com.intellij.util.ui.PresentableColor;
import java.awt.Color;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000f\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/editor/markup/TextAttributeKeyColor;", "Ljava/awt/Color;", "Lcom/intellij/util/ui/PresentableColor;", "Lcom/intellij/util/ui/ComparableColor;", "color", "keyName", "", "type", "Lcom/intellij/openapi/editor/markup/TextAttributeKeyColorType;", "<init>", "(Ljava/awt/Color;Ljava/lang/String;Lcom/intellij/openapi/editor/markup/TextAttributeKeyColorType;)V", "getKeyName", "()Ljava/lang/String;", "getType", "()Lcom/intellij/openapi/editor/markup/TextAttributeKeyColorType;", "getPresentableName", "Lcom/intellij/openapi/util/NlsSafe;", "colorEquals", "", "other", "colorHashCode", "", "intellij.platform.core"})
@ApiStatus.Internal
public final class TextAttributeKeyColor
extends Color
implements PresentableColor,
ComparableColor {
    @NotNull
    private final String keyName;
    @NotNull
    private final TextAttributeKeyColorType type;

    public TextAttributeKeyColor(@NotNull Color color, @NotNull String keyName, @NotNull TextAttributeKeyColorType type) {
        Intrinsics.checkNotNullParameter(color, "color");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        super(color.getRGB(), true);
        this.keyName = keyName;
        this.type = type;
    }

    @NotNull
    public final String getKeyName() {
        return this.keyName;
    }

    @NotNull
    public final TextAttributeKeyColorType getType() {
        return this.type;
    }

    @Override
    @Nullable
    public String getPresentableName() {
        return "TextAttributeKey: " + this.keyName;
    }

    @Override
    public boolean colorEquals(@NotNull ComparableColor other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return other instanceof TextAttributeKeyColor && Intrinsics.areEqual(this.keyName, ((TextAttributeKeyColor)other).keyName) && this.type == ((TextAttributeKeyColor)other).type && Intrinsics.areEqual(this, other);
    }

    @Override
    public int colorHashCode() {
        Object[] objectArray = new Object[]{this.keyName, this.type};
        return Objects.hash(objectArray);
    }
}

