/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.StorageUpdate;
import com.intellij.util.indexing.impl.EmptyInputDataDiffBuilder;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.IndexStorageLayout;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.MapReduceIndexMappingException;
import com.intellij.util.indexing.impl.UpdateData;
import com.intellij.util.indexing.impl.UpdatedEntryProcessor;
import com.intellij.util.indexing.impl.ValueContainerProcessor;
import com.intellij.util.indexing.impl.ValueSerializationChecker;
import com.intellij.util.indexing.impl.ValueSerializationProblemReporter;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.IntForwardIndex;
import com.intellij.util.indexing.impl.forward.IntForwardIndexAccessor;
import com.intellij.util.io.MeasurableIndexStore;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class MapReduceIndex<Key, Value, Input>
implements InvertedIndex<Key, Value, Input>,
MeasurableIndexStore {
    private static final Logger LOG = Logger.getInstance(MapReduceIndex.class);
    private final IndexExtension<Key, Value, Input> myExtension;
    private final IndexId<Key, Value> myIndexId;
    private final DataIndexer<Key, Value, Input> myIndexer;
    private final IndexStorage<Key, Value> myStorage;
    @Nullable
    private final ForwardIndex myForwardIndex;
    @Nullable
    private final ForwardIndexAccessor<Key, Value> myForwardIndexAccessor;
    private final boolean myUseIntForwardIndex;
    private final AtomicLong myModificationStamp;
    @Nullable
    private final ValueSerializationChecker<Value, Input> myValueSerializationChecker;
    private volatile boolean myDisposed;
    private final LowMemoryWatcher myLowMemoryFlusher;
    private final UpdatedEntryProcessor<Key, Value> changedEntriesProcessor;

    protected MapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull IndexStorageLayout<Key, Value> indexStorageLayout) throws IOException {
        if (extension == null) {
            MapReduceIndex.$$$reportNull$$$0(0);
        }
        if (indexStorageLayout == null) {
            MapReduceIndex.$$$reportNull$$$0(1);
        }
        this(extension, indexStorageLayout.openIndexStorage(), indexStorageLayout.openForwardIndex(), indexStorageLayout.getForwardIndexAccessor());
    }

    protected MapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull IndexStorage<Key, Value> storage, @Nullable ForwardIndex forwardIndex, @Nullable ForwardIndexAccessor<Key, Value> forwardIndexAccessor) throws IOException {
        if (extension == null) {
            MapReduceIndex.$$$reportNull$$$0(2);
        }
        if (storage == null) {
            MapReduceIndex.$$$reportNull$$$0(3);
        }
        this(extension, () -> storage, (ThrowableComputable<? extends ForwardIndex, ? extends IOException>)((ThrowableComputable)() -> forwardIndex), forwardIndexAccessor);
    }

    protected MapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull ThrowableComputable<? extends IndexStorage<Key, Value>, ? extends IOException> storageFactory, @Nullable ThrowableComputable<? extends ForwardIndex, ? extends IOException> forwardIndexFactory, @Nullable ForwardIndexAccessor<Key, Value> forwardIndexAccessor) throws IOException {
        if (extension == null) {
            MapReduceIndex.$$$reportNull$$$0(4);
        }
        if (storageFactory == null) {
            MapReduceIndex.$$$reportNull$$$0(5);
        }
        this.myModificationStamp = new AtomicLong();
        this.changedEntriesProcessor = new UpdatedEntryProcessor<Key, Value>(){

            @Override
            public void process(@NotNull UpdatedEntryProcessor.UpdateKind kind2, Key key, Value value, int inputId) throws StorageException {
                if (kind2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                MapReduceIndex.this.incrementModificationStamp();
                switch (kind2) {
                    case ADDED: {
                        MapReduceIndex.this.myStorage.addValue(key, inputId, value);
                        break;
                    }
                    case UPDATED: {
                        MapReduceIndex.this.myStorage.updateValue(key, inputId, value);
                        break;
                    }
                    case REMOVED: {
                        MapReduceIndex.this.myStorage.removeAllValues(key, inputId);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/util/indexing/impl/MapReduceIndex$1", "process"));
            }
        };
        this.myIndexId = extension.getName();
        this.myExtension = extension;
        this.myIndexer = this.myExtension.getIndexer();
        this.myStorage = (IndexStorage)storageFactory.compute();
        try {
            this.myForwardIndex = forwardIndexFactory == null ? null : (ForwardIndex)forwardIndexFactory.compute();
        }
        catch (IOException e) {
            this.tryDispose();
            throw e;
        }
        this.myForwardIndexAccessor = forwardIndexAccessor;
        this.myUseIntForwardIndex = this.myForwardIndex instanceof IntForwardIndex && this.myForwardIndexAccessor instanceof IntForwardIndexAccessor;
        LOG.assertTrue(this.myForwardIndex instanceof IntForwardIndex == this.myForwardIndexAccessor instanceof IntForwardIndexAccessor, "Invalid index configuration for " + this.myIndexId);
        this.myValueSerializationChecker = new ValueSerializationChecker(extension, this.getSerializationProblemReporter());
        this.myLowMemoryFlusher = LowMemoryWatcher.register(() -> this.clearCaches());
    }

    @NotNull
    public IndexExtension<Key, Value, Input> getExtension() {
        IndexExtension<Key, Value, Input> indexExtension = this.myExtension;
        if (indexExtension == null) {
            MapReduceIndex.$$$reportNull$$$0(6);
        }
        return indexExtension;
    }

    public IndexId<Key, Value> indexId() {
        return this.myIndexId;
    }

    protected DataIndexer<Key, Value, Input> indexer() {
        return this.myIndexer;
    }

    @NotNull
    public IndexStorage<Key, Value> getStorage() {
        IndexStorage<Key, Value> indexStorage = this.myStorage;
        if (indexStorage == null) {
            MapReduceIndex.$$$reportNull$$$0(7);
        }
        return indexStorage;
    }

    @NotNull
    protected ValueSerializationProblemReporter getSerializationProblemReporter() {
        ValueSerializationProblemReporter valueSerializationProblemReporter = ValueSerializationChecker.DEFAULT_SERIALIZATION_PROBLEM_REPORTER;
        if (valueSerializationProblemReporter == null) {
            MapReduceIndex.$$$reportNull$$$0(8);
        }
        return valueSerializationProblemReporter;
    }

    @Nullable
    public ForwardIndex getForwardIndex() {
        return this.myForwardIndex;
    }

    @Nullable
    public ForwardIndexAccessor<Key, Value> getForwardIndexAccessor() {
        return this.myForwardIndexAccessor;
    }

    public long getModificationStamp() {
        return this.myModificationStamp.get();
    }

    public void clearCaches() {
        try {
            this.myStorage.clearCaches();
            this.flush();
        }
        catch (Throwable e) {
            this.requestRebuild(e);
        }
    }

    protected void tryDispose() {
        try {
            this.dispose();
        }
        catch (Exception e) {
            LOG.info(e);
        }
    }

    @Override
    public void clear() {
        try {
            this.incrementModificationStamp();
            this.doClear();
        }
        catch (StorageException | IOException e) {
            LOG.info(e);
        }
    }

    protected void doClear() throws StorageException, IOException {
        this.myStorage.clear();
        if (this.myForwardIndex != null) {
            this.myForwardIndex.clear();
        }
    }

    @Override
    public void flush() throws StorageException {
        try {
            this.doFlush();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StorageException || cause instanceof IOException) {
                throw new StorageException(cause);
            }
            throw e;
        }
    }

    public boolean isDirty() {
        if (this.myForwardIndex != null && this.myForwardIndex.isDirty()) {
            return true;
        }
        return this.myStorage.isDirty();
    }

    protected void doFlush() throws IOException, StorageException {
        if (this.myForwardIndex != null) {
            this.myForwardIndex.force();
        }
        this.myStorage.flush();
    }

    @Override
    public void dispose() {
        this.myLowMemoryFlusher.stop();
        try {
            this.myDisposed = true;
            this.doDispose();
        }
        catch (StorageException e) {
            LOG.error(e);
        }
    }

    @Override
    public int keysCountApproximately() {
        return MeasurableIndexStore.keysCountApproximatelyIfPossible(this.myStorage);
    }

    protected boolean isDisposed() {
        return this.myDisposed;
    }

    protected void doDispose() throws StorageException {
        try {
            this.myStorage.close();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        finally {
            try {
                if (this.myForwardIndex != null) {
                    this.myForwardIndex.close();
                }
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    @Override
    public <E extends Exception> boolean withData(@NotNull Key key, @NotNull ValueContainerProcessor<Value, E> processor) throws StorageException, E {
        if (key == null) {
            MapReduceIndex.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            MapReduceIndex.$$$reportNull$$$0(10);
        }
        return this.myStorage.read(key, processor);
    }

    @Override
    @NotNull
    public StorageUpdate mapInputAndPrepareUpdate(int inputId, @Nullable Input content) throws MapReduceIndexMappingException, ProcessCanceledException {
        InputData<Key, Value> data;
        try {
            data = this.mapInput(inputId, content);
        }
        catch (ProcessCanceledException | MapReduceIndexMappingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MapReduceIndexMappingException(e, this.myExtension.getClass());
        }
        StorageUpdate storageUpdate = this.prepareUpdate(inputId, data);
        if (storageUpdate == null) {
            MapReduceIndex.$$$reportNull$$$0(11);
        }
        return storageUpdate;
    }

    @Override
    @NotNull
    public StorageUpdate prepareUpdate(int inputId, @NotNull InputData<Key, Value> inputData) {
        if (inputData == null) {
            MapReduceIndex.$$$reportNull$$$0(12);
        }
        UpdateData<Key, Value> updateData = new UpdateData<Key, Value>(inputId, this.indexId(), changedEntriesProcessor -> {
            try {
                InputDataDiffBuilder diffBuilder = this.getKeysDiffBuilder(inputId);
                Map newData = inputData.getKeyValues();
                return diffBuilder.differentiate(newData, changedEntriesProcessor);
            }
            catch (IOException e) {
                throw new StorageException("Error while applying " + this, e);
            }
        }, () -> this.updateForwardIndex(inputId, inputData));
        return new IndexStorageUpdate(inputData, updateData);
    }

    @ApiStatus.Internal
    protected void checkNonCancellableSection() {
    }

    protected void updateForwardIndex(int inputId, @NotNull InputData<Key, Value> data) throws IOException {
        if (data == null) {
            MapReduceIndex.$$$reportNull$$$0(13);
        }
        if (this.myForwardIndex == null) {
            return;
        }
        if (this.myUseIntForwardIndex) {
            IntForwardIndex forwardIndex = (IntForwardIndex)this.myForwardIndex;
            IntForwardIndexAccessor forwardIndexAccessor = (IntForwardIndexAccessor)this.myForwardIndexAccessor;
            int value = forwardIndexAccessor.serializeIndexedDataToInt(data);
            forwardIndex.putInt(inputId, value);
            return;
        }
        this.myForwardIndex.put(inputId, this.myForwardIndexAccessor.serializeIndexedData(data));
    }

    @NotNull
    protected InputDataDiffBuilder<Key, Value> getKeysDiffBuilder(int inputId) throws IOException {
        if (this.myForwardIndex == null) {
            return new EmptyInputDataDiffBuilder(inputId);
        }
        if (this.myUseIntForwardIndex) {
            IntForwardIndex forwardIndex = (IntForwardIndex)this.myForwardIndex;
            IntForwardIndexAccessor accessor = (IntForwardIndexAccessor)this.myForwardIndexAccessor;
            int value = forwardIndex.getInt(inputId);
            InputDataDiffBuilder inputDataDiffBuilder = accessor.getDiffBuilderFromInt(inputId, value);
            if (inputDataDiffBuilder == null) {
                MapReduceIndex.$$$reportNull$$$0(14);
            }
            return inputDataDiffBuilder;
        }
        InputDataDiffBuilder<Key, Value> inputDataDiffBuilder = this.myForwardIndexAccessor.getDiffBuilder(inputId, this.myForwardIndex.get(inputId));
        if (inputDataDiffBuilder == null) {
            MapReduceIndex.$$$reportNull$$$0(15);
        }
        return inputDataDiffBuilder;
    }

    @NotNull
    protected InputData<Key, Value> mapInput(int inputId, @Nullable Input content) {
        if (content == null) {
            InputData inputData = InputData.empty();
            if (inputData == null) {
                MapReduceIndex.$$$reportNull$$$0(16);
            }
            return inputData;
        }
        Map<Key, Value> data = this.mapByIndexer(inputId, content);
        if (this.myValueSerializationChecker != null) {
            this.myValueSerializationChecker.checkValueSerialization(data, content);
        }
        this.checkCanceled();
        return new InputData<Key, Value>(data);
    }

    @NotNull
    protected Map<Key, Value> mapByIndexer(int inputId, @NotNull Input content) {
        if (content == null) {
            MapReduceIndex.$$$reportNull$$$0(17);
        }
        Map<Key, Value> map2 = this.myIndexer.map(content);
        if (map2 == null) {
            MapReduceIndex.$$$reportNull$$$0(18);
        }
        return map2;
    }

    public abstract void checkCanceled();

    protected abstract void requestRebuild(@NotNull Throwable var1);

    protected void incrementModificationStamp() {
        this.myModificationStamp.incrementAndGet();
    }

    public void updateWith(@NotNull UpdateData<Key, Value> updateData) throws StorageException {
        if (updateData == null) {
            MapReduceIndex.$$$reportNull$$$0(19);
        }
        IndexId<?, ?> oldIndexId = IndexDebugProperties.DEBUG_INDEX_ID.get();
        try {
            IndexDebugProperties.DEBUG_INDEX_ID.set(this.myIndexId);
            boolean hasDifference = updateData.iterateChanges(this.changedEntriesProcessor);
            if (hasDifference) {
                updateData.updateForwardIndex();
            }
        }
        catch (CancellationException e) {
            LOG.error("CancellationException is not expected here! (" + e + ")");
            throw e;
        }
        catch (Throwable e) {
            throw new StorageException(e);
        }
        finally {
            IndexDebugProperties.DEBUG_INDEX_ID.set(oldIndexId);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexStorageLayout";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageFactory";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/impl/MapReduceIndex";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/impl/MapReduceIndex";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializationProblemReporter";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "mapInputAndPrepareUpdate";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeysDiffBuilder";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "mapInput";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "mapByIndexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "withData";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "prepareUpdate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateForwardIndex";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "mapByIndexer";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "updateWith";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    public final class IndexStorageUpdate
    implements StorageUpdate {
        private final InputData<Key, Value> inputData;
        private final UpdateData<Key, Value> updateData;

        private IndexStorageUpdate(@NotNull InputData<Key, Value> inputData, UpdateData<Key, Value> updateData) {
            if (inputData == null) {
                IndexStorageUpdate.$$$reportNull$$$0(0);
            }
            if (updateData == null) {
                IndexStorageUpdate.$$$reportNull$$$0(1);
            }
            this.inputData = inputData;
            this.updateData = updateData;
        }

        @NotNull
        public InputData<Key, Value> getInputData() {
            InputData inputData = this.inputData;
            if (inputData == null) {
                IndexStorageUpdate.$$$reportNull$$$0(2);
            }
            return inputData;
        }

        @Override
        public boolean update() {
            MapReduceIndex.this.checkNonCancellableSection();
            try {
                MapReduceIndex.this.updateWith(this.updateData);
            }
            catch (StorageException | CancellationException ex) {
                this.logStorageUpdateException(ex);
                MapReduceIndex.this.requestRebuild(ex);
                return false;
            }
            catch (Throwable t) {
                LOG.error("An exception during updateWithMap(). Index " + MapReduceIndex.this.myIndexId.getName(), t);
                throw t;
            }
            return true;
        }

        private void logStorageUpdateException(@NotNull Exception ex) {
            if (ex == null) {
                IndexStorageUpdate.$$$reportNull$$$0(3);
            }
            String message = "An exception during updateWithMap(). Index " + MapReduceIndex.this.myIndexId.getName() + " will be rebuilt.";
            if (ex instanceof CancellationException) {
                LOG.error(message + " (CancellationException: " + ex + ")");
            } else if (IndexDebugProperties.IS_UNIT_TEST_MODE) {
                LOG.error(message, ex);
            } else {
                LOG.info(message, ex);
            }
        }

        public String toString() {
            return "IndexUpdate[" + MapReduceIndex.this.myIndexId + "][fileId: " + this.updateData.inputId() + "]{" + this.inputData.getKeyValues().size() + " values}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updateData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/indexing/impl/MapReduceIndex$IndexStorageUpdate";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ex";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/indexing/impl/MapReduceIndex$IndexStorageUpdate";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInputData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "logStorageUpdateException";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

