/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.messages.MessageBusOwner;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.CompositeMessageBusKt;
import com.intellij.util.messages.impl.DescriptorBasedMessageBusConnection;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusEx;
import com.intellij.util.messages.impl.MessageBusImpl;
import com.intellij.util.messages.impl.MessagePublisher;
import com.intellij.util.messages.impl.PluginListenerDescriptor;
import com.intellij.util.messages.impl.ToDirectChildrenMessagePublisher;
import com.intellij.util.messages.impl.ToParentMessagePublisher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\bJ \u0010\u0012\u001a\u00020\u00132\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\n0\u0015J\r\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0001J\u0015\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0001H\u0000\u00a2\u0006\u0002\b\u001dJ/\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H 0\u001f\"\u0004\b\u0000\u0010 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\"2\u0006\u0010#\u001a\u00020$H\u0000\u00a2\u0006\u0002\b%J#\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0'2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0000\u00a2\u0006\u0004\b)\u0010*J1\u0010+\u001a\u00020\u00132\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"2\u000e\u0010,\u001a\n\u0012\u0006\b\u0000\u0012\u00020(0\n2\u0006\u0010-\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b.J\u001c\u0010-\u001a\u00020\u0013\"\u0004\b\u0000\u0010 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\"H\u0002J\u0019\u0010/\u001a\u00020\u00132\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0000\u00a2\u0006\u0002\b0J\u001d\u00101\u001a\u00020\u00172\f\u00102\u001a\b\u0012\u0004\u0012\u00020(0'H\u0000\u00a2\u0006\u0004\b3\u00104J\u001d\u00105\u001a\u00020\u00132\f\u00102\u001a\b\u0012\u0004\u0012\u00020(0'H\u0000\u00a2\u0006\u0004\b6\u00107J\u0006\u00108\u001a\u00020\u0013J\u0006\u00109\u001a\u00020\u0013J\u001c\u0010:\u001a\u00020\u00132\u0006\u0010;\u001a\u00020<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\rJ\u0018\u0010?\u001a\u00020\u00132\u0010\u0010@\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030B0AJ\b\u0010C\u001a\u00020\u0013H\u0007J\r\u0010D\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\bER:\u0010\t\u001a.\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00010\u0001 \u000b*\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00010\u00010\r\u00a2\u0006\u0002\b\f0\n\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\n0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/intellij/util/messages/impl/CompositeMessageBus;", "Lcom/intellij/util/messages/impl/MessageBusImpl;", "Lcom/intellij/util/messages/impl/MessageBusEx;", "owner", "Lcom/intellij/util/messages/MessageBusOwner;", "parentBus", "<init>", "(Lcom/intellij/util/messages/MessageBusOwner;Lcom/intellij/util/messages/impl/CompositeMessageBus;)V", "(Lcom/intellij/util/messages/MessageBusOwner;)V", "childBuses", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "topicClassToListenerDescriptor", "", "", "Lcom/intellij/util/messages/impl/PluginListenerDescriptor;", "setLazyListeners", "", "map", "Ljava/util/concurrent/ConcurrentMap;", "hasChildren", "", "hasChildren$intellij_platform_core", "addChild", "bus", "onChildBusDisposed", "childBus", "onChildBusDisposed$intellij_platform_core", "createPublisher", "Lcom/intellij/util/messages/impl/MessagePublisher;", "L", "topic", "Lcom/intellij/util/messages/Topic;", "direction", "Lcom/intellij/util/messages/Topic$BroadcastDirection;", "createPublisher$intellij_platform_core", "computeSubscribers", "", "", "computeSubscribers$intellij_platform_core", "(Lcom/intellij/util/messages/Topic;)[Ljava/lang/Object;", "doComputeSubscribers", "result", "subscribeLazyListeners", "doComputeSubscribers$intellij_platform_core", "notifyOnSubscriptionToTopicToChildren", "notifyOnSubscriptionToTopicToChildren$intellij_platform_core", "notifyConnectionTerminated", "topicAndHandlerPairs", "notifyConnectionTerminated$intellij_platform_core", "([Ljava/lang/Object;)Z", "clearSubscriberCache", "clearSubscriberCache$intellij_platform_core", "([Ljava/lang/Object;)V", "removeEmptyConnectionsRecursively", "clearPublisherCache", "unsubscribeLazyListeners", "module", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "listenerDescriptors", "Lcom/intellij/util/messages/ListenerDescriptor;", "disconnectPluginConnections", "predicate", "Ljava/util/function/Predicate;", "Ljava/lang/Class;", "clearAllSubscriberCache", "disposeChildren", "disposeChildren$intellij_platform_core", "intellij.platform.core"})
@VisibleForTesting
@ApiStatus.Internal
public class CompositeMessageBus
extends MessageBusImpl
implements MessageBusEx {
    @NotNull
    private final List<MessageBusImpl> childBuses;
    @NotNull
    private volatile Map<String, List<PluginListenerDescriptor>> topicClassToListenerDescriptor;

    public CompositeMessageBus(@NotNull MessageBusOwner owner, @NotNull CompositeMessageBus parentBus) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(parentBus, "parentBus");
        super(owner, parentBus);
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue(list, "createLockFreeCopyOnWriteList(...)");
        this.childBuses = list;
        this.topicClassToListenerDescriptor = CompositeMessageBusKt.access$getEMPTY_MAP$p();
    }

    public CompositeMessageBus(@NotNull MessageBusOwner owner) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        super(owner);
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue(list, "createLockFreeCopyOnWriteList(...)");
        this.childBuses = list;
        this.topicClassToListenerDescriptor = CompositeMessageBusKt.access$getEMPTY_MAP$p();
    }

    @Override
    public final void setLazyListeners(@NotNull ConcurrentMap<String, List<PluginListenerDescriptor>> map2) {
        Intrinsics.checkNotNullParameter(map2, "map");
        Map<String, List<PluginListenerDescriptor>> topicClassToListenerDescriptor = this.topicClassToListenerDescriptor;
        if (topicClassToListenerDescriptor == CompositeMessageBusKt.access$getEMPTY_MAP$p()) {
            this.topicClassToListenerDescriptor = map2;
        } else {
            topicClassToListenerDescriptor.putAll((Map<String, List<PluginListenerDescriptor>>)map2);
            if (this.rootBus != this) {
                this.rootBus.subscriberCache.clear();
            }
            this.subscriberCache.clear();
        }
    }

    @Override
    public final boolean hasChildren$intellij_platform_core() {
        return !((Collection)this.childBuses).isEmpty();
    }

    public final void addChild(@NotNull MessageBusImpl bus) {
        Intrinsics.checkNotNullParameter(bus, "bus");
        CompositeMessageBusKt.access$childrenListChanged(this);
        this.childBuses.add(bus);
    }

    public final void onChildBusDisposed$intellij_platform_core(@NotNull MessageBusImpl childBus) {
        Intrinsics.checkNotNullParameter(childBus, "childBus");
        boolean removed = this.childBuses.remove(childBus);
        CompositeMessageBusKt.access$childrenListChanged(this);
        MessageBusImpl.LOG.assertTrue(removed);
    }

    @Override
    @NotNull
    public final <L> MessagePublisher<L> createPublisher$intellij_platform_core(@NotNull Topic<L> topic, @NotNull Topic.BroadcastDirection direction) {
        MessagePublisher messagePublisher;
        Intrinsics.checkNotNullParameter(topic, "topic");
        Intrinsics.checkNotNullParameter(direction, "direction");
        switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                messagePublisher = new ToParentMessagePublisher<L>(topic, this);
                break;
            }
            case 2: {
                if (!(this.parentBus == null)) {
                    boolean bl = false;
                    String string = "Broadcast direction TO_DIRECT_CHILDREN is allowed only for app level message bus. Please publish to app level message bus or change topic " + topic.getListenerClass() + " broadcast direction to NONE or TO_PARENT";
                    throw new IllegalArgumentException(string.toString());
                }
                messagePublisher = new ToDirectChildrenMessagePublisher<L>(topic, this, this.childBuses);
                break;
            }
            default: {
                messagePublisher = new MessagePublisher(topic, this);
            }
        }
        return messagePublisher;
    }

    @Override
    @NotNull
    public final Object[] computeSubscribers$intellij_platform_core(@NotNull Topic<?> topic) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(topic, "topic");
        if (this.owner.isDisposed()) {
            objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            Intrinsics.checkNotNullExpressionValue(ArrayUtilRt.EMPTY_OBJECT_ARRAY, "EMPTY_OBJECT_ARRAY");
        } else {
            objectArray = super.computeSubscribers$intellij_platform_core(topic);
        }
        return objectArray;
    }

    @Override
    public final void doComputeSubscribers$intellij_platform_core(@NotNull Topic<?> topic, @NotNull List<? super Object> result, boolean subscribeLazyListeners) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        Intrinsics.checkNotNullParameter(result, "result");
        if (subscribeLazyListeners) {
            this.subscribeLazyListeners(topic);
        }
        super.doComputeSubscribers$intellij_platform_core(topic, result, subscribeLazyListeners);
        if (topic.getBroadcastDirection() == Topic.BroadcastDirection.TO_CHILDREN) {
            for (MessageBusImpl childBus : this.childBuses) {
                if (childBus.isDisposed()) continue;
                childBus.doComputeSubscribers$intellij_platform_core(topic, result, !childBus.owner.isParentLazyListenersIgnored());
            }
        }
    }

    private final <L> void subscribeLazyListeners(Topic<L> topic) {
        if (topic.getListenerClass() == Runnable.class) {
            return;
        }
        Map<String, List<PluginListenerDescriptor>> topicClassToListenerDescriptor = this.topicClassToListenerDescriptor;
        if (topicClassToListenerDescriptor == CompositeMessageBusKt.access$getEMPTY_MAP$p()) {
            return;
        }
        Cancellation.computeInNonCancelableSection(() -> CompositeMessageBus.subscribeLazyListeners$lambda$4(topicClassToListenerDescriptor, topic, this));
    }

    @Override
    public final void notifyOnSubscriptionToTopicToChildren$intellij_platform_core(@NotNull Topic<?> topic) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        for (MessageBusImpl childBus : this.childBuses) {
            childBus.subscriberCache.remove(topic);
            childBus.notifyOnSubscriptionToTopicToChildren$intellij_platform_core(topic);
        }
    }

    @Override
    public final boolean notifyConnectionTerminated$intellij_platform_core(@NotNull Object[] topicAndHandlerPairs) {
        Intrinsics.checkNotNullParameter(topicAndHandlerPairs, "topicAndHandlerPairs");
        boolean isChildClearingNeeded = super.notifyConnectionTerminated$intellij_platform_core(topicAndHandlerPairs);
        if (!isChildClearingNeeded) {
            return false;
        }
        for (MessageBusImpl bus : this.childBuses) {
            bus.clearSubscriberCache$intellij_platform_core(topicAndHandlerPairs);
        }
        this.rootBus.getQueue$intellij_platform_core().queue.removeIf(arg_0 -> CompositeMessageBus.notifyConnectionTerminated$lambda$6(arg_0 -> CompositeMessageBus.notifyConnectionTerminated$lambda$5(topicAndHandlerPairs, arg_0), arg_0));
        return false;
    }

    @Override
    public final void clearSubscriberCache$intellij_platform_core(@NotNull Object[] topicAndHandlerPairs) {
        Intrinsics.checkNotNullParameter(topicAndHandlerPairs, "topicAndHandlerPairs");
        super.clearSubscriberCache$intellij_platform_core(topicAndHandlerPairs);
        for (MessageBusImpl bus : this.childBuses) {
            bus.clearSubscriberCache$intellij_platform_core(topicAndHandlerPairs);
        }
    }

    @Override
    public final void removeEmptyConnectionsRecursively() {
        super.removeEmptyConnectionsRecursively();
        for (MessageBusImpl bus : this.childBuses) {
            bus.removeEmptyConnectionsRecursively();
        }
    }

    @Override
    public final void clearPublisherCache() {
        this.publisherCache.clear();
        for (MessageBusImpl childBus : this.childBuses) {
            if (childBus instanceof CompositeMessageBus) {
                ((CompositeMessageBus)childBus).clearPublisherCache();
                continue;
            }
            childBus.publisherCache.clear();
        }
    }

    @Override
    public final void unsubscribeLazyListeners(@NotNull IdeaPluginDescriptor module, @NotNull List<ListenerDescriptor> listenerDescriptors) {
        Intrinsics.checkNotNullParameter(module, "module");
        Intrinsics.checkNotNullParameter(listenerDescriptors, "listenerDescriptors");
        this.topicClassToListenerDescriptor.values().removeIf(arg_0 -> CompositeMessageBus.unsubscribeLazyListeners$lambda$9(module, arg_0));
        if (listenerDescriptors.isEmpty() || this.subscribers.isEmpty()) {
            return;
        }
        HashMap<Object, Set> topicToDescriptors = new HashMap<Object, Set>();
        for (ListenerDescriptor descriptor2 : listenerDescriptors) {
            topicToDescriptors.computeIfAbsent(descriptor2.topicClassName, arg_0 -> CompositeMessageBus.unsubscribeLazyListeners$lambda$11(CompositeMessageBus::unsubscribeLazyListeners$lambda$10, arg_0)).add(descriptor2.listenerClassName);
        }
        boolean isChanged = false;
        List newSubscribers = null;
        Iterator iterator2 = this.subscribers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator connectionIterator = iterator2;
        while (connectionIterator.hasNext()) {
            List newHandlers;
            Set listenerClassNames;
            DescriptorBasedMessageBusConnection connection;
            Object e = connectionIterator.next();
            if ((e instanceof DescriptorBasedMessageBusConnection ? (DescriptorBasedMessageBusConnection)e : null) == null) continue;
            connection = connection;
            if (module != connection.module || (Set)topicToDescriptors.get(connection.topic.getListenerClass().getName()) == null || CompositeMessageBusKt.access$computeNewHandlers(connection.handlers, listenerClassNames) == null) continue;
            isChanged = true;
            connectionIterator.remove();
            if (!(!((Collection)newHandlers).isEmpty())) continue;
            if (newSubscribers == null) {
                newSubscribers = new ArrayList();
            }
            newSubscribers.add(new DescriptorBasedMessageBusConnection(module, connection.topic, newHandlers));
        }
        if (newSubscribers != null) {
            this.subscribers.addAll(newSubscribers);
        }
        if (isChanged) {
            if (this.rootBus != this) {
                this.rootBus.subscriberCache.clear();
            }
            this.subscriberCache.clear();
        }
    }

    @Override
    public final void disconnectPluginConnections(@NotNull Predicate<Class<?>> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        super.disconnectPluginConnections(predicate);
        for (MessageBusImpl bus : this.childBuses) {
            bus.disconnectPluginConnections(predicate);
        }
    }

    @Override
    @TestOnly
    public final void clearAllSubscriberCache() {
        MessageBusImpl.LOG.assertTrue(this.rootBus != this);
        this.rootBus.subscriberCache.clear();
        this.subscriberCache.clear();
        for (MessageBusImpl bus : this.childBuses) {
            bus.subscriberCache.clear();
        }
    }

    @Override
    public final void disposeChildren$intellij_platform_core() {
        for (MessageBusImpl childBus : this.childBuses) {
            Disposer.dispose((Disposable)((Object)childBus));
        }
    }

    private static final List subscribeLazyListeners$lambda$4$lambda$1(PluginDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new ArrayList();
    }

    private static final List subscribeLazyListeners$lambda$4$lambda$2(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final void subscribeLazyListeners$lambda$4$lambda$3(CompositeMessageBus this$0, Topic $topic, PluginDescriptor key, List listeners) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(listeners, "listeners");
        this$0.subscribers.add(new DescriptorBasedMessageBusConnection(key, $topic, listeners));
    }

    private static final Unit subscribeLazyListeners$lambda$4(Map $topicClassToListenerDescriptor, Topic $topic, CompositeMessageBus this$0) {
        List list = (List)$topicClassToListenerDescriptor.remove($topic.getListenerClass().getName());
        if (list == null) {
            return Unit.INSTANCE;
        }
        List listenerDescriptors = list;
        LinkedHashMap<Object, List> listenerMap = new LinkedHashMap<Object, List>();
        for (PluginListenerDescriptor listenerDescriptor : listenerDescriptors) {
            try {
                Object object = this$0.owner.createListener(listenerDescriptor);
                Intrinsics.checkNotNullExpressionValue(object, "createListener(...)");
                listenerMap.computeIfAbsent(listenerDescriptor.getPluginDescriptor(), arg_0 -> CompositeMessageBus.subscribeLazyListeners$lambda$4$lambda$2(CompositeMessageBus::subscribeLazyListeners$lambda$4$lambda$1, arg_0)).add(object);
            }
            catch (ExtensionNotApplicableException extensionNotApplicableException) {
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                MessageBusImpl.LOG.error("Cannot create listener", e);
            }
        }
        listenerMap.forEach((arg_0, arg_1) -> CompositeMessageBus.subscribeLazyListeners$lambda$4$lambda$3(this$0, $topic, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final boolean notifyConnectionTerminated$lambda$5(Object[] $topicAndHandlerPairs, Message it) {
        Intrinsics.checkNotNull(it);
        return CompositeMessageBusKt.access$nullizeHandlersFromMessage(it, $topicAndHandlerPairs);
    }

    private static final boolean notifyConnectionTerminated$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean unsubscribeLazyListeners$lambda$9$lambda$7(IdeaPluginDescriptor $module, PluginListenerDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getPluginDescriptor() == $module;
    }

    private static final boolean unsubscribeLazyListeners$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean unsubscribeLazyListeners$lambda$9(IdeaPluginDescriptor $module, List descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, "descriptors");
        if (descriptors.removeIf(arg_0 -> CompositeMessageBus.unsubscribeLazyListeners$lambda$9$lambda$8(arg_0 -> CompositeMessageBus.unsubscribeLazyListeners$lambda$9$lambda$7($module, arg_0), arg_0))) {
            return descriptors.isEmpty();
        }
        return false;
    }

    private static final Set unsubscribeLazyListeners$lambda$10(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new HashSet();
    }

    private static final Set unsubscribeLazyListeners$lambda$11(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Topic.BroadcastDirection.values().length];
            try {
                nArray[Topic.BroadcastDirection.TO_PARENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Topic.BroadcastDirection.TO_DIRECT_CHILDREN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

