/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.files;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.io.JvmCoreKt;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.files.FileMetadata;
import kotlinx.io.files.FileSystem;
import kotlinx.io.files.Mover;
import kotlinx.io.files.NioMover;
import kotlinx.io.files.Path;
import kotlinx.io.files.PathsJvmKt;
import kotlinx.io.files.PathsKt;
import kotlinx.io.files.SystemFileSystemImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000e*\n\u0010\n\"\u00020\u000b2\u00020\u000b\u00a8\u0006\u000f"}, d2={"mover", "Lkotlinx/io/files/Mover;", "getMover", "()Lkotlinx/io/files/Mover;", "mover$delegate", "Lkotlin/Lazy;", "SystemFileSystem", "Lkotlinx/io/files/FileSystem;", "SystemTemporaryDirectory", "Lkotlinx/io/files/Path;", "FileNotFoundException", "Ljava/io/FileNotFoundException;", "isWindows", "", "()Z", "kotlinx-io-core"})
public final class FileSystemJvmKt {
    @NotNull
    private static final Lazy mover$delegate = LazyKt.lazy(FileSystemJvmKt::mover_delegate$lambda$0);
    @JvmField
    @NotNull
    public static final FileSystem SystemFileSystem = new SystemFileSystemImpl(){

        public boolean exists(Path path) {
            Intrinsics.checkNotNullParameter(path, "path");
            return path.getFile$kotlinx_io_core().exists();
        }

        public void delete(Path path, boolean mustExist) {
            Intrinsics.checkNotNullParameter(path, "path");
            if (!this.exists(path)) {
                if (mustExist) {
                    throw new FileNotFoundException("File does not exist: " + path.getFile$kotlinx_io_core());
                }
                return;
            }
            if (!path.getFile$kotlinx_io_core().delete()) {
                throw new IOException("Deletion failed");
            }
        }

        public void createDirectories(Path path, boolean mustCreate) {
            Intrinsics.checkNotNullParameter(path, "path");
            if (!path.getFile$kotlinx_io_core().mkdirs()) {
                if (mustCreate) {
                    throw new IOException("Path already exist: " + path);
                }
                if (path.getFile$kotlinx_io_core().isFile()) {
                    throw new IOException("Path already exists and it's a file: " + path);
                }
            }
        }

        public void atomicMove(Path source, Path destination) {
            Intrinsics.checkNotNullParameter(source, "source");
            Intrinsics.checkNotNullParameter(destination, "destination");
            FileSystemJvmKt.access$getMover().move(source, destination);
        }

        public FileMetadata metadataOrNull(Path path) {
            Intrinsics.checkNotNullParameter(path, "path");
            if (!path.getFile$kotlinx_io_core().exists()) {
                return null;
            }
            return new FileMetadata(path.getFile$kotlinx_io_core().isFile(), path.getFile$kotlinx_io_core().isDirectory(), path.getFile$kotlinx_io_core().isFile() ? path.getFile$kotlinx_io_core().length() : -1L);
        }

        public RawSource source(Path path) {
            Intrinsics.checkNotNullParameter(path, "path");
            return JvmCoreKt.asSource(new FileInputStream(path.getFile$kotlinx_io_core()));
        }

        public RawSink sink(Path path, boolean append) {
            Intrinsics.checkNotNullParameter(path, "path");
            return JvmCoreKt.asSink(new FileOutputStream(path.getFile$kotlinx_io_core(), append));
        }

        public Path resolve(Path path) {
            Intrinsics.checkNotNullParameter(path, "path");
            if (!path.getFile$kotlinx_io_core().exists()) {
                throw new FileNotFoundException(path.getFile$kotlinx_io_core().getAbsolutePath());
            }
            File file = path.getFile$kotlinx_io_core().getCanonicalFile();
            Intrinsics.checkNotNullExpressionValue(file, "getCanonicalFile(...)");
            return new Path(file);
        }

        public Collection<Path> list(Path directory) {
            List<Path> list;
            block3: {
                Intrinsics.checkNotNullParameter(directory, "directory");
                File file = directory.getFile$kotlinx_io_core();
                if (!file.exists()) {
                    throw new FileNotFoundException(file.getAbsolutePath());
                }
                if (!file.isDirectory()) {
                    throw new IOException("Not a directory: " + file.getAbsolutePath());
                }
                List<Path> $this$list_u24lambda_u241 = list = CollectionsKt.createListBuilder();
                boolean bl = false;
                String[] stringArray = file.list();
                if (stringArray == null) break block3;
                String[] $this$forEach$iv = stringArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    String element$iv;
                    String childName = element$iv = $this$forEach$iv[i];
                    boolean bl2 = false;
                    String[] stringArray2 = new String[]{childName};
                    $this$list_u24lambda_u241.add(PathsKt.Path(directory, stringArray2));
                }
            }
            return CollectionsKt.build(list);
        }
    };
    @JvmField
    @NotNull
    public static final Path SystemTemporaryDirectory;
    private static final boolean isWindows;

    private static final Mover getMover() {
        Lazy lazy = mover$delegate;
        return (Mover)lazy.getValue();
    }

    public static final boolean isWindows() {
        return isWindows;
    }

    private static final Mover mover_delegate$lambda$0() {
        Mover mover2;
        try {
            Class.forName("java.nio.file.Files");
            mover2 = new NioMover();
        }
        catch (ClassNotFoundException e) {
            mover2 = new Mover(){

                public void move(Path source, Path destination) {
                    Intrinsics.checkNotNullParameter(source, "source");
                    Intrinsics.checkNotNullParameter(destination, "destination");
                    throw new UnsupportedOperationException("Atomic move not supported");
                }
            };
        }
        return mover2;
    }

    public static final /* synthetic */ Mover access$getMover() {
        return FileSystemJvmKt.getMover();
    }

    static {
        String string = System.getProperty("java.io.tmpdir");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
        SystemTemporaryDirectory = PathsJvmKt.Path(string);
        String string2 = System.getProperty("os.name");
        isWindows = string2 != null ? StringsKt.startsWith$default(string2, "Windows", false, 2, null) : false;
    }
}

