/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.EmptyEventLogFilesProvider;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.EventLogListenersManager;
import com.intellij.internal.statistic.eventLog.FilteredEventMergeStrategy;
import com.intellij.internal.statistic.eventLog.StatisticsEventEscaperKt;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.StatisticsEventMergeStrategy;
import com.intellij.internal.statistic.eventLog.validator.IntellijSensitiveDataValidator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import com.jetbrains.fus.reporting.model.lion3.LogEventAction;
import com.jetbrains.fus.reporting.model.lion3.LogEventGroup;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002:\u00018B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJB\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\u001a\u0010\u001c\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e0\u001d2\u0006\u0010 \u001a\u00020!H\u0016J+\u0010\"\u001a\u00020#2!\u0010$\u001a\u001d\u0012\u0013\u0012\u00110&\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b()\u0012\u0004\u0012\u00020#0%H\u0016J:\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u000fH\u0002J\b\u0010/\u001a\u00020#H\u0002J\n\u00100\u001a\u0004\u0018\u000101H\u0016J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u00020#H\u0016J\b\u00105\u001a\u00020#H\u0016J\b\u00106\u001a\u00020#H\u0016J\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/internal/statistic/eventLog/LocalStatisticsFileEventLogger;", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogger;", "Lcom/intellij/openapi/Disposable;", "recorderId", "", "build", "recorderVersion", "mergeStrategy", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventMergeStrategy;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/internal/statistic/eventLog/StatisticsEventMergeStrategy;)V", "logExecutor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "eventMergeTimeoutMs", "", "lastEvent", "Lcom/intellij/internal/statistic/eventLog/LocalStatisticsFileEventLogger$FusEvent;", "lastEventTime", "lastEventCreatedTime", "lastEventFlushFuture", "Ljava/util/concurrent/ScheduledFuture;", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "logAsync", "group", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "eventId", "dataProvider", "Lkotlin/Function0;", "", "", "isState", "", "computeAsync", "", "computation", "Lkotlin/Function1;", "Ljava/util/concurrent/Executor;", "Lkotlin/ParameterName;", "name", "backgroundThreadExecutor", "data", "log", "event", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "createdTime", "logLastEvent", "getActiveLogFile", "", "getLogFilesProvider", "Lcom/intellij/internal/statistic/eventLog/EmptyEventLogFilesProvider;", "cleanup", "rollOver", "dispose", "flush", "FusEvent", "intellij.platform.statistics"})
@SourceDebugExtension(value={"SMAP\nLocalStatisticsFileEventLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalStatisticsFileEventLogger.kt\ncom/intellij/internal/statistic/eventLog/LocalStatisticsFileEventLogger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class LocalStatisticsFileEventLogger
implements StatisticsEventLogger,
Disposable {
    @NotNull
    private final String recorderId;
    @NotNull
    private final String build;
    @NotNull
    private final String recorderVersion;
    @NotNull
    private final StatisticsEventMergeStrategy mergeStrategy;
    @NotNull
    private final ExecutorService logExecutor;
    private final long eventMergeTimeoutMs;
    @Nullable
    private FusEvent lastEvent;
    private long lastEventTime;
    private long lastEventCreatedTime;
    @Nullable
    private ScheduledFuture<CompletableFuture<Void>> lastEventFlushFuture;

    public LocalStatisticsFileEventLogger(@NotNull String recorderId, @NotNull String build, @NotNull String recorderVersion, @NotNull StatisticsEventMergeStrategy mergeStrategy) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Intrinsics.checkNotNullParameter((Object)build, (String)"build");
        Intrinsics.checkNotNullParameter((Object)recorderVersion, (String)"recorderVersion");
        Intrinsics.checkNotNullParameter((Object)mergeStrategy, (String)"mergeStrategy");
        this.recorderId = recorderId;
        this.build = build;
        this.recorderVersion = recorderVersion;
        this.mergeStrategy = mergeStrategy;
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"LocalStatisticsFileEventLogger", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.logExecutor = executorService;
        this.eventMergeTimeoutMs = 3000L;
    }

    public /* synthetic */ LocalStatisticsFileEventLogger(String string, String string2, String string3, StatisticsEventMergeStrategy statisticsEventMergeStrategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            statisticsEventMergeStrategy = new FilteredEventMergeStrategy(SetsKt.emptySet());
        }
        this(string, string2, string3, statisticsEventMergeStrategy);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> logAsync(@NotNull EventLogGroup group, @NotNull String eventId, @NotNull Function0<? extends Map<String, ? extends Object>> dataProvider, boolean isState) {
        CompletableFuture<Void> completableFuture;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter(dataProvider, (String)"dataProvider");
        long eventTime = System.currentTimeMillis();
        group.validateEventId$intellij_platform_statistics(eventId);
        try {
            completableFuture = CompletableFuture.runAsync(() -> LocalStatisticsFileEventLogger.logAsync$lambda$0(this, group, dataProvider, eventTime, eventId, isState), this.logExecutor);
            Intrinsics.checkNotNull(completableFuture);
        }
        catch (RejectedExecutionException e) {
            CompletableFuture completableFuture2;
            CompletableFuture it = completableFuture2 = new CompletableFuture();
            boolean bl = false;
            it.completeExceptionally(e);
            completableFuture = completableFuture2;
        }
        return completableFuture;
    }

    @Override
    public void computeAsync(@NotNull Function1<? super Executor, Unit> computation) {
        Intrinsics.checkNotNullParameter(computation, (String)"computation");
    }

    @Override
    @NotNull
    public CompletableFuture<Void> logAsync(@NotNull EventLogGroup group, @NotNull String eventId, @NotNull Map<String, ? extends Object> data, boolean isState) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        return this.logAsync(group, eventId, (Function0<? extends Map<String, ? extends Object>>)((Function0)() -> LocalStatisticsFileEventLogger.logAsync$lambda$2(data)), isState);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void log(LogEvent event, long createdTime) {
        if (this.lastEvent != null && event.getTime() - this.lastEventTime <= this.eventMergeTimeoutMs) {
            FusEvent fusEvent = this.lastEvent;
            Intrinsics.checkNotNull((Object)fusEvent);
            if (this.mergeStrategy.shouldMerge(fusEvent.getValidatedEvent(), event)) {
                this.lastEventTime = event.getTime();
                FusEvent fusEvent2 = this.lastEvent;
                Intrinsics.checkNotNull((Object)fusEvent2);
                fusEvent2.getValidatedEvent().getEvent().increment();
                return;
            }
        }
        this.logLastEvent();
        this.lastEvent = new FusEvent(event, null, null);
        this.lastEventTime = event.getTime();
        this.lastEventCreatedTime = createdTime;
    }

    private final void logLastEvent() {
        FusEvent fusEvent = this.lastEvent;
        if (fusEvent != null) {
            FusEvent it = fusEvent;
            boolean bl = false;
            LogEventAction event = it.getValidatedEvent().getEvent();
            if (event.isEventGroup()) {
                event.getData().put("last", this.lastEventTime);
            }
            event.getData().put("created", this.lastEventCreatedTime);
            ((EventLogListenersManager)ApplicationManager.getApplication().getService(EventLogListenersManager.class)).notifySubscribers(this.recorderId, it.getValidatedEvent(), it.getRawEventId(), it.getRawData(), true);
        }
        this.lastEvent = null;
    }

    @Nullable
    public Void getActiveLogFile() {
        return null;
    }

    @Override
    @NotNull
    public EmptyEventLogFilesProvider getLogFilesProvider() {
        return EmptyEventLogFilesProvider.INSTANCE;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void rollOver() {
    }

    public void dispose() {
        ScheduledFuture<CompletableFuture<Void>> scheduledFuture = this.lastEventFlushFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.flush();
        this.logExecutor.shutdown();
    }

    @NotNull
    public final CompletableFuture<Void> flush() {
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> LocalStatisticsFileEventLogger.flush$lambda$4(this), this.logExecutor);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"runAsync(...)");
        return completableFuture;
    }

    private static final void logAsync$lambda$0(LocalStatisticsFileEventLogger this$0, EventLogGroup $group, Function0 $dataProvider, long $eventTime, String $eventId, boolean $isState) {
        IntellijSensitiveDataValidator intellijSensitiveDataValidator = IntellijSensitiveDataValidator.getInstance(this$0.recorderId);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)intellijSensitiveDataValidator), (String)"getInstance(...)");
        IntellijSensitiveDataValidator validator = intellijSensitiveDataValidator;
        if (!validator.isGroupAllowed($group)) {
            return;
        }
        Map map = (Map)$dataProvider.invoke();
        if (map == null) {
            return;
        }
        Map data = map;
        LogEvent event = StatisticsEventEscaperKt.escapeExceptData((LogEvent)new LogEvent("local", this$0.build, "", $eventTime, new LogEventGroup($group.getId(), String.valueOf($group.getVersion())), this$0.recorderVersion, new LogEventAction($eventId, $isState, (Map)new HashMap(data), 0, 8, null)));
        LogEvent validatedEvent = validator.validateEvent(event);
        if (validatedEvent != null) {
            this$0.log(validatedEvent, System.currentTimeMillis());
        }
    }

    private static final Map logAsync$lambda$2(Map $data) {
        return $data;
    }

    private static final void flush$lambda$4(LocalStatisticsFileEventLogger this$0) {
        this$0.logLastEvent();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0017\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0007H\u00c6\u0003J7\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001f\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/internal/statistic/eventLog/LocalStatisticsFileEventLogger$FusEvent;", "", "validatedEvent", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "rawEventId", "", "rawData", "", "<init>", "(Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;Ljava/lang/String;Ljava/util/Map;)V", "getValidatedEvent", "()Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "getRawEventId", "()Ljava/lang/String;", "getRawData", "()Ljava/util/Map;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.statistics"})
    private static final class FusEvent {
        @NotNull
        private final LogEvent validatedEvent;
        @Nullable
        private final String rawEventId;
        @Nullable
        private final Map<String, Object> rawData;

        public FusEvent(@NotNull LogEvent validatedEvent, @Nullable String rawEventId, @Nullable Map<String, ? extends Object> rawData) {
            Intrinsics.checkNotNullParameter((Object)validatedEvent, (String)"validatedEvent");
            this.validatedEvent = validatedEvent;
            this.rawEventId = rawEventId;
            this.rawData = rawData;
        }

        @NotNull
        public final LogEvent getValidatedEvent() {
            return this.validatedEvent;
        }

        @Nullable
        public final String getRawEventId() {
            return this.rawEventId;
        }

        @Nullable
        public final Map<String, Object> getRawData() {
            return this.rawData;
        }

        @NotNull
        public final LogEvent component1() {
            return this.validatedEvent;
        }

        @Nullable
        public final String component2() {
            return this.rawEventId;
        }

        @Nullable
        public final Map<String, Object> component3() {
            return this.rawData;
        }

        @NotNull
        public final FusEvent copy(@NotNull LogEvent validatedEvent, @Nullable String rawEventId, @Nullable Map<String, ? extends Object> rawData) {
            Intrinsics.checkNotNullParameter((Object)validatedEvent, (String)"validatedEvent");
            return new FusEvent(validatedEvent, rawEventId, rawData);
        }

        public static /* synthetic */ FusEvent copy$default(FusEvent fusEvent, LogEvent logEvent, String string, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                logEvent = fusEvent.validatedEvent;
            }
            if ((n & 2) != 0) {
                string = fusEvent.rawEventId;
            }
            if ((n & 4) != 0) {
                map = fusEvent.rawData;
            }
            return fusEvent.copy(logEvent, string, map);
        }

        @NotNull
        public String toString() {
            return "FusEvent(validatedEvent=" + this.validatedEvent + ", rawEventId=" + this.rawEventId + ", rawData=" + this.rawData + ")";
        }

        public int hashCode() {
            int result = this.validatedEvent.hashCode();
            result = result * 31 + (this.rawEventId == null ? 0 : this.rawEventId.hashCode());
            result = result * 31 + (this.rawData == null ? 0 : ((Object)this.rawData).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FusEvent)) {
                return false;
            }
            FusEvent fusEvent = (FusEvent)other;
            if (!Intrinsics.areEqual((Object)this.validatedEvent, (Object)fusEvent.validatedEvent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.rawEventId, (Object)fusEvent.rawEventId)) {
                return false;
            }
            return Intrinsics.areEqual(this.rawData, fusEvent.rawData);
        }
    }
}

