/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.EmptyStatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.PluginType;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.util.PlatformUtils;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0007J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fJ\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\bH\u0002R \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogProvidersHolder;", "", "<init>", "()V", "eventLoggerProviders", "Ljava/util/concurrent/atomic/AtomicReference;", "", "", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;", "getEventLogProvider", "recorderId", "getEventLogProviders", "", "calculateEventLogProvider", "getAllEventLogProviders", "Lkotlin/sequences/Sequence;", "isJetBrainsProduct", "", "isProviderApplicable", "extension", "intellij.platform.statistics"})
@SourceDebugExtension(value={"SMAP\nStatisticsEventLogProvidersHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatisticsEventLogProvidersHolder.kt\ncom/intellij/internal/statistic/eventLog/StatisticsEventLogProvidersHolder\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,69:1\n682#2:70\n712#2,4:71\n*S KotlinDebug\n*F\n+ 1 StatisticsEventLogProvidersHolder.kt\ncom/intellij/internal/statistic/eventLog/StatisticsEventLogProvidersHolder\n*L\n34#1:70\n34#1:71,4\n*E\n"})
public final class StatisticsEventLogProvidersHolder {
    @NotNull
    private final AtomicReference<Map<String, StatisticsEventLoggerProvider>> eventLoggerProviders = new AtomicReference<Map<String, StatisticsEventLoggerProvider>>(this.calculateEventLogProvider());

    public StatisticsEventLogProvidersHolder() {
        if (ApplicationManager.getApplication().getExtensionArea().hasExtensionPoint(StatisticsEventLoggerProvider.Companion.getEP_NAME())) {
            StatisticsEventLoggerProvider.Companion.getEP_NAME().addChangeListener(() -> StatisticsEventLogProvidersHolder._init_$lambda$0(this), null);
        }
    }

    @NotNull
    public final StatisticsEventLoggerProvider getEventLogProvider(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        StatisticsEventLoggerProvider statisticsEventLoggerProvider = this.eventLoggerProviders.get().get(recorderId);
        if (statisticsEventLoggerProvider == null) {
            statisticsEventLoggerProvider = new EmptyStatisticsEventLoggerProvider(recorderId);
        }
        return statisticsEventLoggerProvider;
    }

    @NotNull
    public final Collection<StatisticsEventLoggerProvider> getEventLogProviders() {
        return this.eventLoggerProviders.get().values();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, StatisticsEventLoggerProvider> calculateEventLogProvider() {
        void $this$associateByTo$iv$iv;
        Sequence<StatisticsEventLoggerProvider> $this$associateBy$iv = this.getAllEventLogProviders();
        boolean $i$f$associateBy = false;
        Sequence<StatisticsEventLoggerProvider> sequence = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            StatisticsEventLoggerProvider statisticsEventLoggerProvider = (StatisticsEventLoggerProvider)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getRecorderId(), element$iv$iv);
        }
        return destination$iv$iv;
    }

    private final Sequence<StatisticsEventLoggerProvider> getAllEventLogProviders() {
        List providers = StatisticsEventLoggerProvider.Companion.getEP_NAME().getExtensionsIfPointIsRegistered();
        if (providers.isEmpty()) {
            return SequencesKt.emptySequence();
        }
        boolean isJetBrainsProduct = this.isJetBrainsProduct();
        return SequencesKt.distinctBy((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)providers), arg_0 -> StatisticsEventLogProvidersHolder.getAllEventLogProviders$lambda$2(this, isJetBrainsProduct, arg_0)), StatisticsEventLogProvidersHolder::getAllEventLogProviders$lambda$3);
    }

    private final boolean isJetBrainsProduct() {
        CharSequence charSequence;
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        return appInfo == null || (charSequence = (CharSequence)appInfo.getShortCompanyName()) == null || charSequence.length() == 0 ? true : PlatformUtils.isJetBrainsProduct();
    }

    private final boolean isProviderApplicable(boolean isJetBrainsProduct, String recorderId, StatisticsEventLoggerProvider extension) {
        if (Intrinsics.areEqual((Object)recorderId, (Object)extension.getRecorderId())) {
            if (!isJetBrainsProduct || !StatisticsRecorderUtil.isBuildInRecorder(recorderId)) {
                return true;
            }
            PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfo(extension.getClass());
            return Intrinsics.areEqual((Object)recorderId, (Object)"MLSE") || Intrinsics.areEqual((Object)recorderId, (Object)"ML") ? pluginInfo.isDevelopedByJetBrains() : pluginInfo.getType() == PluginType.PLATFORM || pluginInfo.getType() == PluginType.FROM_SOURCES || pluginInfo.isAllowedToInjectIntoFUS();
        }
        return false;
    }

    private static final void _init_$lambda$0(StatisticsEventLogProvidersHolder this$0) {
        this$0.eventLoggerProviders.set(this$0.calculateEventLogProvider());
    }

    private static final boolean getAllEventLogProviders$lambda$2(StatisticsEventLogProvidersHolder this$0, boolean $isJetBrainsProduct, StatisticsEventLoggerProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isProviderApplicable($isJetBrainsProduct, it.getRecorderId(), it);
    }

    private static final String getAllEventLogProviders$lambda$3(StatisticsEventLoggerProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getRecorderId();
    }
}

