/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.InitialVfsRefreshService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.Ignored;
import com.intellij.openapi.vcs.IgnoredCheckResult;
import com.intellij.openapi.vcs.NotIgnored;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsIgnoreChecker;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vcs.changes.VcsIgnoreManager;
import com.intellij.openapi.vcs.changes.VcsIgnoreManagerImpl;
import com.intellij.openapi.vcs.changes.VcsIgnoreManagerImplKt;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SlowOperations;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/vcs/changes/VcsIgnoreManagerImpl;", "Lcom/intellij/openapi/vcs/changes/VcsIgnoreManager;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "ignoreRefreshQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "getIgnoreRefreshQueue", "()Lcom/intellij/util/ui/update/MergingUpdateQueue;", "awaitRefreshQueue", "", "findIgnoreFileType", "Lcom/intellij/openapi/vcs/changes/ignore/lang/IgnoreFileType;", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "isDirectoryVcsIgnored", "", "dirPath", "", "getDirectoryVcsIgnoredStatus", "Lcom/intellij/openapi/vcs/IgnoredCheckResult;", "dirPathString", "isRunConfigurationVcsIgnored", "configurationName", "removeRunConfigurationFromVcsIgnore", "isPotentiallyIgnoredFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "Companion", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nVcsIgnoreManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsIgnoreManagerImpl.kt\ncom/intellij/openapi/vcs/changes/VcsIgnoreManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,233:1\n1761#2,3:234\n*S KotlinDebug\n*F\n+ 1 VcsIgnoreManagerImpl.kt\ncom/intellij/openapi/vcs/changes/VcsIgnoreManagerImpl\n*L\n165#1:234,3\n*E\n"})
public final class VcsIgnoreManagerImpl
implements VcsIgnoreManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final MergingUpdateQueue ignoreRefreshQueue;
    @JvmField
    @NotNull
    public static final ExtensionPointName<VcsIgnoreChecker> EP_NAME = new ExtensionPointName("com.intellij.vcsIgnoreChecker");

    public VcsIgnoreManagerImpl(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.ignoreRefreshQueue = MergingUpdateQueue.Companion.mergingUpdateQueue("VcsIgnoreUpdate", 500, coroutineScope);
        VcsIgnoreManagerImplKt.access$checkProjectNotDefault(this.project);
        this.ignoreRefreshQueue.queue(new Update(){

            public void run() {
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<InitialVfsRefreshService> serviceClass$iv = InitialVfsRefreshService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                InitialVfsRefreshService vfsRefreshService = (InitialVfsRefreshService)object;
                CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(vfsRefreshService, null){
                    int label;
                    final /* synthetic */ InitialVfsRefreshService $vfsRefreshService;
                    {
                        this.$vfsRefreshService = $vfsRefreshService;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = this.$vfsRefreshService.awaitInitialVfsRefreshFinished((Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }

            /*
             * Unable to fully structure code
             */
            public Object execute(Continuation<? super Unit> $completion) {
                if (!($completion instanceof execute.1)) ** GOTO lbl-1000
                var5_2 = $completion;
                if ((var5_2.label & -2147483648) != 0) {
                    var5_2.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        int I$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ 1 this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.execute((Continuation<? super Unit>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $this$serviceAsync$iv = (ComponentManager)VcsIgnoreManagerImpl.access$getProject$p(this);
                        $i$f$serviceAsync = 0;
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv);
                        $continuation.I$0 = $i$f$serviceAsync;
                        $continuation.label = 1;
                        v0 = ServicesKt.serviceAsync((ComponentManager)$this$serviceAsync$iv, InitialVfsRefreshService.class, (Continuation)$continuation);
                        if (v0 == var6_4) {
                            return var6_4;
                        }
                        ** GOTO lbl27
                    }
                    case 1: {
                        $i$f$serviceAsync = $continuation.I$0;
                        $this$serviceAsync$iv = (ComponentManager)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl27:
                        // 2 sources

                        $continuation.L$0 = null;
                        $continuation.label = 2;
                        v1 = ((InitialVfsRefreshService)v0).awaitInitialVfsRefreshFinished((Continuation)$continuation);
                        if (v1 == var6_4) {
                            return var6_4;
                        }
                        ** GOTO lbl36
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl36:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
        });
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.project.getMessageBus().connect(coroutineScope).subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectCloseListener(){

                public void projectClosing(Project project) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    if (project == project) {
                        try {
                            this.getIgnoreRefreshQueue().waitForAllExecuted(10L, TimeUnit.SECONDS);
                        }
                        catch (Exception e) {
                            VcsIgnoreManagerImplKt.access$getLOG$p().warn("Queue '" + this.getIgnoreRefreshQueue() + "' wait for all executed failed with error:", (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    @NotNull
    public final MergingUpdateQueue getIgnoreRefreshQueue() {
        return this.ignoreRefreshQueue;
    }

    public final void awaitRefreshQueue() {
        boolean bl;
        boolean bl2 = bl = !ApplicationManager.getApplication().isReadAccessAllowed();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (this.ignoreRefreshQueue.isEmpty()) {
            return;
        }
        CountDownLatch waiter = new CountDownLatch(1);
        this.ignoreRefreshQueue.queue(Update.Companion.create((Object)waiter, () -> VcsIgnoreManagerImpl.awaitRefreshQueue$lambda$0(waiter)));
        ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)waiter);
    }

    @Nullable
    public final IgnoreFileType findIgnoreFileType(@NotNull AbstractVcs vcs) {
        Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
        IgnoredFileContentProvider ignoredFileContentProvider = VcsImplUtil.findIgnoredFileContentProvider(vcs);
        if (ignoredFileContentProvider == null) {
            return null;
        }
        IgnoredFileContentProvider ignoredFileContentProvider2 = ignoredFileContentProvider;
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(ignoredFileContentProvider2.getFileName());
        return fileType instanceof IgnoreFileType ? (IgnoreFileType)fileType : null;
    }

    public boolean isDirectoryVcsIgnored(@NotNull String dirPath) {
        Intrinsics.checkNotNullParameter((Object)dirPath, (String)"dirPath");
        try {
            Function0 checkForIgnore = () -> VcsIgnoreManagerImpl.isDirectoryVcsIgnored$lambda$1(this, dirPath);
            Object object = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> VcsIgnoreManagerImpl.isDirectoryVcsIgnored$lambda$2(checkForIgnore), VcsBundle.message((String)"checking.vcs.status.progress", (Object[])new Object[0]), false, this.project);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runProcessWithProgressSynchronously(...)");
            return (Boolean)object;
        }
        catch (IOException e) {
            VcsIgnoreManagerImplKt.access$getLOG$p().warn((Throwable)e);
            return false;
        }
    }

    private final IgnoredCheckResult getDirectoryVcsIgnoredStatus(Project project, String dirPathString) {
        FilePath filePath = VcsContextFactory.getInstance().createFilePath(dirPathString, true);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"createFilePath(...)");
        FilePath dirPath = filePath;
        VirtualFile virtualFile = VcsUtil.getVcsRootFor((Project)project, (FilePath)dirPath);
        if (virtualFile == null) {
            return (IgnoredCheckResult)NotIgnored.INSTANCE;
        }
        VirtualFile vcsRoot = virtualFile;
        VcsIgnoreChecker vcsIgnoreChecker = VcsIgnoreManagerImplKt.access$getCheckerForFile(project, dirPath);
        if (vcsIgnoreChecker == null || (vcsIgnoreChecker = vcsIgnoreChecker.isFilePatternIgnored(vcsRoot, dirPathString)) == null) {
            vcsIgnoreChecker = (IgnoredCheckResult)NotIgnored.INSTANCE;
        }
        return vcsIgnoreChecker;
    }

    public boolean isRunConfigurationVcsIgnored(@NotNull String configurationName) {
        Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
        try {
            String configurationFileName = VcsIgnoreManagerImplKt.access$configurationNameToFileName(configurationName);
            Function0 checkForIgnore = () -> VcsIgnoreManagerImpl.isRunConfigurationVcsIgnored$lambda$3(this, configurationFileName);
            Object[] objectArray = new Object[]{configurationName};
            Object object = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> VcsIgnoreManagerImpl.isRunConfigurationVcsIgnored$lambda$4(checkForIgnore), VcsBundle.message((String)"changes.checking.configuration.0.for.ignore", (Object[])objectArray), false, this.project);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runProcessWithProgressSynchronously(...)");
            return (Boolean)object;
        }
        catch (IOException e) {
            VcsIgnoreManagerImplKt.access$getLOG$p().warn((Throwable)e);
            return false;
        }
    }

    public void removeRunConfigurationFromVcsIgnore(@NotNull String configurationName) {
        Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
        try {
            Function0 removeFromIgnore = () -> VcsIgnoreManagerImpl.removeRunConfigurationFromVcsIgnore$lambda$6(this, configurationName);
            Object[] objectArray = new Object[]{configurationName};
            Unit cfr_ignored_0 = (Unit)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> VcsIgnoreManagerImpl.removeRunConfigurationFromVcsIgnore$lambda$7(removeFromIgnore), VcsBundle.message((String)"changes.removing.configuration.0.from.ignore", (Object[])objectArray), false, this.project);
        }
        catch (IOException io) {
            VcsIgnoreManagerImplKt.access$getLOG$p().warn((Throwable)io);
        }
    }

    public boolean isPotentiallyIgnoredFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        return this.isPotentiallyIgnoredFile(filePath);
    }

    public boolean isPotentiallyIgnoredFile(@NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return (Boolean)ActionsKt.runReadAction(() -> VcsIgnoreManagerImpl.isPotentiallyIgnoredFile$lambda$9(this, filePath));
    }

    private static final void awaitRefreshQueue$lambda$0(CountDownLatch $waiter) {
        $waiter.countDown();
    }

    private static final boolean isDirectoryVcsIgnored$lambda$1(VcsIgnoreManagerImpl this$0, String $dirPath) {
        return this$0.getDirectoryVcsIgnoredStatus(this$0.project, $dirPath) instanceof Ignored;
    }

    private static final Boolean isDirectoryVcsIgnored$lambda$2(Function0 $tmp0) {
        return (Boolean)$tmp0.invoke();
    }

    private static final boolean isRunConfigurationVcsIgnored$lambda$3(VcsIgnoreManagerImpl this$0, String $configurationFileName) {
        return VcsIgnoreManagerImplKt.access$checkConfigurationVcsIgnored(this$0.project, $configurationFileName) instanceof Ignored;
    }

    private static final Boolean isRunConfigurationVcsIgnored$lambda$4(Function0 $tmp0) {
        return (Boolean)$tmp0.invoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit removeRunConfigurationFromVcsIgnore$lambda$6(VcsIgnoreManagerImpl this$0, String $configurationName) {
        AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.knownIssue((String)"IDEA-338210, EA-660187");
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            VcsIgnoreManagerImplKt.access$removeConfigurationFromVcsIgnore(this$0.project, $configurationName);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }

    private static final Unit removeRunConfigurationFromVcsIgnore$lambda$7(Function0 $tmp0) {
        return (Unit)$tmp0.invoke();
    }

    private static final boolean isPotentiallyIgnoredFile$lambda$9(VcsIgnoreManagerImpl this$0, FilePath $filePath) {
        boolean bl;
        block4: {
            if (this$0.project.isDisposed()) {
                return false;
            }
            Iterable $this$any$iv = IgnoredFileProvider.IGNORE_FILE.getExtensionList();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IgnoredFileProvider it = (IgnoredFileProvider)element$iv;
                    boolean bl2 = false;
                    if (!it.isIgnoredFile(this$0.project, $filePath)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final VcsIgnoreManagerImpl getInstanceImpl(@NotNull Project project) {
        return Companion.getInstanceImpl(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/changes/VcsIgnoreManagerImpl$Companion;", "", "<init>", "()V", "getInstanceImpl", "Lcom/intellij/openapi/vcs/changes/VcsIgnoreManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/openapi/vcs/VcsIgnoreChecker;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final VcsIgnoreManagerImpl getInstanceImpl(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            VcsIgnoreManager vcsIgnoreManager = VcsIgnoreManager.getInstance((Project)project);
            Intrinsics.checkNotNull((Object)vcsIgnoreManager, (String)"null cannot be cast to non-null type com.intellij.openapi.vcs.changes.VcsIgnoreManagerImpl");
            return (VcsIgnoreManagerImpl)vcsIgnoreManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

