/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.vcs.commit.AbstractCommitMessagePolicy;
import com.intellij.vcs.commit.CommitMessage;
import com.intellij.vcs.commit.CommitMessageUi;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0014J\b\u0010\u0016\u001a\u00020\u0014H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0014J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0007J\b\u0010\u001a\u001a\u00020\u0014H\u0004J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0004J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0004R\u0014\u0010\n\u001a\u00020\u000b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/intellij/vcs/commit/ChangeListCommitMessagePolicy;", "Lcom/intellij/vcs/commit/AbstractCommitMessagePolicy;", "project", "Lcom/intellij/openapi/project/Project;", "commitMessageUi", "Lcom/intellij/vcs/commit/CommitMessageUi;", "initialChangeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/commit/CommitMessageUi;Lcom/intellij/openapi/vcs/changes/LocalChangeList;)V", "changeListManager", "Lcom/intellij/openapi/vcs/changes/ChangeListManager;", "getChangeListManager", "()Lcom/intellij/openapi/vcs/changes/ChangeListManager;", "currentChangeList", "getCurrentChangeList", "()Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "setCurrentChangeList", "(Lcom/intellij/openapi/vcs/changes/LocalChangeList;)V", "onBeforeCommit", "", "saveStateOnDispose", "dispose", "cleanupStoredMessage", "onChangelistChanged", "newChangeList", "saveMessageToChangeListDescription", "getCommitMessageForCurrentList", "Lcom/intellij/vcs/commit/CommitMessage;", "getCommitMessageFromChangelistDescription", "intellij.platform.vcs.impl"})
public abstract class ChangeListCommitMessagePolicy
extends AbstractCommitMessagePolicy {
    @NotNull
    private LocalChangeList currentChangeList;

    public ChangeListCommitMessagePolicy(@NotNull Project project, @NotNull CommitMessageUi commitMessageUi, @NotNull LocalChangeList initialChangeList) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)commitMessageUi, (String)"commitMessageUi");
        Intrinsics.checkNotNullParameter((Object)initialChangeList, (String)"initialChangeList");
        super(project, commitMessageUi);
        this.currentChangeList = initialChangeList;
    }

    @NotNull
    protected final ChangeListManager getChangeListManager() {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        return changeListManager;
    }

    @NotNull
    protected final LocalChangeList getCurrentChangeList() {
        return this.currentChangeList;
    }

    protected final void setCurrentChangeList(@NotNull LocalChangeList localChangeList) {
        Intrinsics.checkNotNullParameter((Object)localChangeList, (String)"<set-?>");
        this.currentChangeList = localChangeList;
    }

    @Override
    public void onBeforeCommit() {
        super.onBeforeCommit();
        this.saveMessageToChangeListDescription();
    }

    public final void saveStateOnDispose() {
        if (this.getChangeListManager().areChangeListsEnabled()) {
            this.saveMessageToChangeListDescription();
        }
    }

    @Override
    public void dispose() {
        this.saveStateOnDispose();
    }

    @Override
    protected void cleanupStoredMessage() {
        this.getChangeListManager().editComment(this.currentChangeList.getName(), "");
    }

    public final void onChangelistChanged(@NotNull LocalChangeList newChangeList) {
        Intrinsics.checkNotNullParameter((Object)newChangeList, (String)"newChangeList");
        LocalChangeList oldChangeList = this.currentChangeList;
        this.currentChangeList = newChangeList;
        if (!Intrinsics.areEqual((Object)oldChangeList.getId(), (Object)newChangeList.getId())) {
            this.getChangeListManager().editComment(oldChangeList.getName(), this.getCommitMessageUi().getText());
            CommitMessage commitMessage = this.getCommitMessageForCurrentList();
            if (commitMessage == null) {
                commitMessage = CommitMessage.Companion.getEMPTY();
            }
            CommitMessage newMessage = commitMessage;
            this.setCommitMessage(newMessage);
        }
    }

    protected final void saveMessageToChangeListDescription() {
        if (!this.getCurrentMessageIsDisposable()) {
            this.getChangeListManager().editComment(this.currentChangeList.getName(), this.getCommitMessageUi().getText());
        }
    }

    @Nullable
    protected final CommitMessage getCommitMessageForCurrentList() {
        CommitMessage providerMessage = AbstractCommitMessagePolicy.Companion.getCommitMessageFromProvider(this.getProject(), this.currentChangeList);
        CommitMessage commitMessage = providerMessage;
        if (commitMessage == null) {
            commitMessage = this.getCommitMessageFromChangelistDescription();
        }
        return commitMessage;
    }

    @Nullable
    protected final CommitMessage getCommitMessageFromChangelistDescription() {
        String changeListDescription = this.currentChangeList.getComment();
        CharSequence charSequence = changeListDescription;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            return new CommitMessage(changeListDescription, false, 2, null);
        }
        if (this.currentChangeList.hasDefaultName()) {
            return null;
        }
        String string = this.currentChangeList.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new CommitMessage(string, false, 2, null);
    }
}

