/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.options.advanced.AdvancedSettingsChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.impl.VcsEP;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsStartupActivity;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.commit.CommitMode;
import com.intellij.vcs.commit.CommitModeManager;
import com.intellij.vcs.commit.CommitModeManagerKt;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0004\u0013\u0014\u0015\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0003J\b\u0010\r\u001a\u00020\tH\u0002J\u0006\u0010\u000e\u001a\u00020\tJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u000bH\u0002J\b\u0010\u0012\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/vcs/commit/CommitModeManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "commitMode", "Lcom/intellij/vcs/commit/CommitMode;", "scheduleUpdateCommitMode", "", "updateCommitMode", "getNewCommitMode", "getCurrentCommitMode", "canSetNonModal", "", "subscribeToChanges", "dispose", "MyStartupActivity", "Companion", "SettingsListener", "CommitModeListener", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nCommitModeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommitModeManager.kt\ncom/intellij/vcs/commit/CommitModeManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,166:1\n12434#2,2:167\n*S KotlinDebug\n*F\n+ 1 CommitModeManager.kt\ncom/intellij/vcs/commit/CommitModeManager\n*L\n113#1:167,2\n*E\n"})
public final class CommitModeManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private CommitMode commitMode;
    @JvmField
    @Topic.AppLevel
    @NotNull
    public static final Topic<SettingsListener> SETTINGS = new Topic(SettingsListener.class, Topic.BroadcastDirection.TO_DIRECT_CHILDREN, true);
    @Topic.ProjectLevel
    @NotNull
    private static final Topic<CommitModeListener> COMMIT_MODE_TOPIC = new Topic(CommitModeListener.class, Topic.BroadcastDirection.NONE, true);

    public CommitModeManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.commitMode = (CommitMode)CommitMode.PendingCommitMode.INSTANCE;
    }

    private final void scheduleUpdateCommitMode() {
        ApplicationManager.getApplication().invokeLater(this::updateCommitMode, ModalityState.nonModal(), this.project.getDisposed());
    }

    @RequiresEdt
    private final void updateCommitMode() {
        CommitMode newCommitMode = this.getNewCommitMode();
        if (Intrinsics.areEqual((Object)this.commitMode, (Object)newCommitMode)) {
            return;
        }
        this.commitMode = newCommitMode;
        ((CommitModeListener)this.project.getMessageBus().syncPublisher(COMMIT_MODE_TOPIC)).commitModeChanged();
    }

    private final CommitMode getNewCommitMode() {
        CommitMode forcedCommitMode;
        Object[] objectArray = ProjectLevelVcsManager.getInstance((Project)this.project).getAllActiveVcss();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getAllActiveVcss(...)");
        Object[] activeVcses = objectArray;
        AbstractVcs singleVcs = (AbstractVcs)ArraysKt.singleOrNull((Object[])activeVcses);
        if (activeVcses.length == 0) {
            return (CommitMode)CommitMode.PendingCommitMode.INSTANCE;
        }
        if (Boolean.parseBoolean(System.getProperty("vcs.force.modal.commit"))) {
            return (CommitMode)CommitMode.ModalCommitMode.INSTANCE;
        }
        AbstractVcs abstractVcs = singleVcs;
        Object object = forcedCommitMode = abstractVcs != null ? abstractVcs.getForcedCommitMode() : null;
        if (forcedCommitMode != null) {
            return forcedCommitMode;
        }
        if (this.canSetNonModal()) {
            return (CommitMode)new CommitMode.NonModalCommitMode(CommitModeManagerKt.access$isToggleCommitUi());
        }
        return (CommitMode)CommitMode.ModalCommitMode.INSTANCE;
    }

    @NotNull
    public final CommitMode getCurrentCommitMode() {
        return this.commitMode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canSetNonModal() {
        if (CommitModeManagerKt.access$isForceNonModalCommit().asBoolean()) {
            return true;
        }
        AbstractVcs[] abstractVcsArray = ProjectLevelVcsManager.getInstance((Project)this.project).getAllActiveVcss();
        Intrinsics.checkNotNullExpressionValue((Object)abstractVcsArray, (String)"getAllActiveVcss(...)");
        AbstractVcs[] activeVcses = abstractVcsArray;
        if (activeVcses.length == 0) {
            return false;
        }
        boolean bl = false;
        if (bl) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        AbstractVcs[] $this$all$iv = activeVcses;
        boolean $i$f$all = false;
        int n = 0;
        int n2 = $this$all$iv.length;
        while (n < n2) {
            AbstractVcs element$iv;
            AbstractVcs it = element$iv = $this$all$iv[n];
            boolean bl3 = false;
            if (it.getType() != VcsType.distributed) return false;
            boolean bl4 = true;
            if (!bl4) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private final void subscribeToChanges() {
        CommitModeManagerKt.access$isForceNonModalCommit().addListener(new RegistryValueListener(this){
            final /* synthetic */ CommitModeManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void afterValueChanged(RegistryValue value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                CommitModeManager.access$updateCommitMode(this.this$0);
            }
        }, this.coroutineScope);
        SimpleMessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(this.coroutineScope);
        connection.subscribe(AdvancedSettingsChangeListener.TOPIC, (Object)new AdvancedSettingsChangeListener(this){
            final /* synthetic */ CommitModeManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void advancedSettingChanged(String id, Object oldValue, Object newValue) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
                Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
                if (Intrinsics.areEqual((Object)id, (Object)"vcs.non.modal.commit.toggle.ui")) {
                    CommitModeManager.access$updateCommitMode(this.this$0);
                }
            }
        });
        connection.subscribe(SETTINGS, (Object)new SettingsListener(this){
            final /* synthetic */ CommitModeManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void settingsChanged() {
                CommitModeManager.access$updateCommitMode(this.this$0);
            }
        });
        VcsEP.EP_NAME.addChangeListener(this::scheduleUpdateCommitMode, (Disposable)this);
        SimpleMessageBusConnection simpleMessageBusConnection = this.project.getMessageBus().connect(this.coroutineScope);
        Topic topic = ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VCS_CONFIGURATION_CHANGED");
        simpleMessageBusConnection.subscribe(topic, this::scheduleUpdateCommitMode);
    }

    public void dispose() {
    }

    @JvmStatic
    public static final void subscribeOnCommitModeChange(@NotNull SimpleMessageBusConnection connection, @NotNull CommitModeListener listener2) {
        Companion.subscribeOnCommitModeChange(connection, listener2);
    }

    @JvmStatic
    @NotNull
    public static final CommitModeManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(CommitModeManager $this) {
        return $this.coroutineScope;
    }

    public static final /* synthetic */ void access$subscribeToChanges(CommitModeManager $this) {
        $this.subscribeToChanges();
    }

    public static final /* synthetic */ void access$updateCommitMode(CommitModeManager $this) {
        $this.updateCommitMode();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/intellij/vcs/commit/CommitModeManager$CommitModeListener;", "Ljava/util/EventListener;", "commitModeChanged", "", "intellij.platform.vcs.impl"})
    public static interface CommitModeListener
    extends EventListener {
        @RequiresEdt
        public void commitModeChanged();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/vcs/commit/CommitModeManager$Companion;", "", "<init>", "()V", "SETTINGS", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/vcs/commit/CommitModeManager$SettingsListener;", "COMMIT_MODE_TOPIC", "Lcom/intellij/vcs/commit/CommitModeManager$CommitModeListener;", "subscribeOnCommitModeChange", "", "connection", "Lcom/intellij/util/messages/SimpleMessageBusConnection;", "listener", "getInstance", "Lcom/intellij/vcs/commit/CommitModeManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nCommitModeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommitModeManager.kt\ncom/intellij/vcs/commit/CommitModeManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,166:1\n30#2,2:167\n*S KotlinDebug\n*F\n+ 1 CommitModeManager.kt\ncom/intellij/vcs/commit/CommitModeManager$Companion\n*L\n151#1:167,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void subscribeOnCommitModeChange(@NotNull SimpleMessageBusConnection connection, @NotNull CommitModeListener listener2) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            connection.subscribe(COMMIT_MODE_TOPIC, (Object)listener2);
        }

        @JvmStatic
        @NotNull
        public final CommitModeManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<CommitModeManager> serviceClass$iv = CommitModeManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (CommitModeManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/vcs/commit/CommitModeManager$MyStartupActivity;", "Lcom/intellij/openapi/vcs/impl/VcsStartupActivity;", "<init>", "()V", "order", "", "getOrder", "()I", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nCommitModeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommitModeManager.kt\ncom/intellij/vcs/commit/CommitModeManager$MyStartupActivity\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,166:1\n75#2:167\n*S KotlinDebug\n*F\n+ 1 CommitModeManager.kt\ncom/intellij/vcs/commit/CommitModeManager$MyStartupActivity\n*L\n57#1:167\n*E\n"})
    public static final class MyStartupActivity
    implements VcsStartupActivity {
        @Override
        public int getOrder() {
            return VcsInitObject.MAPPINGS.getOrder() + 50;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            if (!($completion instanceof execute.1)) ** GOTO lbl-1000
            var7_3 = $completion;
            if ((var7_3.label & -2147483648) != 0) {
                var7_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ MyStartupActivity this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.execute(null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (project instanceof ProjectEx && ((ProjectEx)project).isLight()) {
                        return Unit.INSTANCE;
                    }
                    $this$serviceAsync$iv = (ComponentManager)project;
                    $i$f$serviceAsync = 0;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv);
                    $continuation.I$0 = $i$f$serviceAsync;
                    $continuation.label = 1;
                    v0 = ServicesKt.serviceAsync((ComponentManager)$this$serviceAsync$iv, CommitModeManager.class, (Continuation)$continuation);
                    if (v0 == var8_5) {
                        return var8_5;
                    }
                    ** GOTO lbl31
                }
                case 1: {
                    $i$f$serviceAsync = $continuation.I$0;
                    $this$serviceAsync$iv = (ComponentManager)$continuation.L$1;
                    project = (Project)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl31:
                    // 2 sources

                    commitModeManager = (CommitModeManager)v0;
                    BuildersKt.launch$default((CoroutineScope)CommitModeManager.access$getCoroutineScope$p(commitModeManager), (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(commitModeManager, null){
                        int label;
                        final /* synthetic */ CommitModeManager $commitModeManager;
                        {
                            this.$commitModeManager = $commitModeManager;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = CoroutinesKt.writeIntentReadAction(() -> execute.2.invokeSuspend$lambda$0(this.$commitModeManager), (Continuation)((Continuation)this));
                                    if (object2 != object) return Unit.INSTANCE;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }

                        private static final Unit invokeSuspend$lambda$0(CommitModeManager $commitModeManager) {
                            CommitModeManager.access$subscribeToChanges($commitModeManager);
                            CommitModeManager.access$updateCommitMode($commitModeManager);
                            return Unit.INSTANCE;
                        }
                    }), (int)2, null);
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/intellij/vcs/commit/CommitModeManager$SettingsListener;", "Ljava/util/EventListener;", "settingsChanged", "", "intellij.platform.vcs.impl"})
    public static interface SettingsListener
    extends EventListener {
        public void settingsChanged();
    }
}

