/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api;

import circlet.platform.api.annotations.HttpApiInlineUrlParameter;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import platform.db.annotations.DbSerializable;

@DbSerializable
@HttpApiInlineUrlParameter
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcirclet/client/api/ProjectKey;", "", "key", "", "<init>", "(Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "equals", "", "other", "hashCode", "", "toString", "toIssueId", "number", "toReviewId", "toMergeRequestId", "spaceport-client-api"})
public final class ProjectKey {
    @NotNull
    private final String key;

    public ProjectKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.key = key;
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ProjectKey)) return false;
        String string = ((ProjectKey)other).key.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        String string2 = this.key.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        if (!Intrinsics.areEqual((Object)string, (Object)string2)) return false;
        return true;
    }

    public int hashCode() {
        String string = this.key.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return string.hashCode();
    }

    @NotNull
    public String toString() {
        String string = this.key.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return string;
    }

    @NotNull
    public final String toIssueId(int number2) {
        String string = this.key.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return string + "-T-" + number2;
    }

    @NotNull
    public final String toReviewId(int number2) {
        String string = this.key.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return string + "-CR-" + number2;
    }

    @NotNull
    public final String toMergeRequestId(int number2) {
        String string = this.key.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return string + "-MR-" + number2;
    }
}

