/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.delete.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BidirectionalMap<K, V>
implements Map<K, V> {
    private final Map<K, V> myKeyToValueMap = new HashMap();
    private final Map<V, List<K>> myValueToKeysMap = new HashMap<V, List<K>>();

    BidirectionalMap() {
    }

    @Override
    public final V put(K key, V value) {
        V oldValue = this.myKeyToValueMap.put(key, value);
        if (oldValue != null) {
            if (oldValue.equals(value)) {
                return oldValue;
            }
            List<K> array = this.myValueToKeysMap.get(oldValue);
            array.remove(key);
            if (array.isEmpty()) {
                this.myValueToKeysMap.remove(oldValue);
            }
        }
        this.myValueToKeysMap.computeIfAbsent((List)value, (Function<List, List<Object>>)((Function<Object, List>)__ -> new ArrayList())).add(key);
        return oldValue;
    }

    @Override
    public final void clear() {
        this.myKeyToValueMap.clear();
        this.myValueToKeysMap.clear();
    }

    @Nullable
    public final List<K> getKeysByValue(V value) {
        return this.myValueToKeysMap.get(value);
    }

    @Override
    @NotNull
    public final Set<K> keySet() {
        Set<K> set = this.myKeyToValueMap.keySet();
        if (set == null) {
            BidirectionalMap.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    public final int size() {
        return this.myKeyToValueMap.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.myKeyToValueMap.isEmpty();
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.myKeyToValueMap.containsKey(key);
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.myValueToKeysMap.containsKey(value);
    }

    @Override
    public final V get(Object key) {
        return this.myKeyToValueMap.get(key);
    }

    @Override
    public final V remove(Object key) {
        V value = this.myKeyToValueMap.remove(key);
        List<K> ks = this.myValueToKeysMap.get(value);
        if (ks != null) {
            if (ks.size() > 1) {
                ks.remove(key);
            } else {
                this.myValueToKeysMap.remove(value);
            }
        }
        return value;
    }

    @Override
    public final void putAll(@NotNull Map<? extends K, ? extends V> t) {
        if (t == null) {
            BidirectionalMap.$$$reportNull$$$0(1);
        }
        for (Map.Entry<K, V> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @NotNull
    public final Collection<V> values() {
        Set<V> set = this.myValueToKeysMap.keySet();
        if (set == null) {
            BidirectionalMap.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    @NotNull
    public final Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.myKeyToValueMap.entrySet();
        if (set == null) {
            BidirectionalMap.$$$reportNull$$$0(3);
        }
        return set;
    }

    public final String toString() {
        return this.myKeyToValueMap.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/agent/delete/helper/BidirectionalMap";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/agent/delete/helper/BidirectionalMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

