/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.debugger.impl.frontend;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.debugger.impl.frontend.EditorLineBreakpointsInfo;
import com.intellij.platform.debugger.impl.frontend.FrontendEditorLinesBreakpointsInfoManager;
import com.intellij.platform.debugger.impl.frontend.FrontendXBreakpointManager;
import com.intellij.platform.debugger.impl.frontend.FrontendXBreakpointManagerKt;
import com.intellij.platform.debugger.impl.frontend.FrontendXBreakpointProxyKt;
import com.intellij.platform.debugger.impl.frontend.FrontendXBreakpointTypesManager;
import com.intellij.platform.debugger.impl.frontend.FrontendXDependentBreakpointManagerProxy;
import com.intellij.platform.debugger.impl.frontend.FrontendXLightLineBreakpoint;
import com.intellij.platform.debugger.impl.frontend.FrontendXLineBreakpointProxy;
import com.intellij.platform.debugger.impl.frontend.RegistrationStatus;
import com.intellij.platform.project.ProjectIdKt;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.xdebugger.impl.XLineBreakpointInstallationInfo;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerProxy;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointProxy;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointTypeProxy;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointsDialogState;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointManagerProxy;
import com.intellij.xdebugger.impl.breakpoints.XLightLineBreakpointProxy;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointProxy;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointTypeProxy;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.rpc.XBreakpointDto;
import com.intellij.xdebugger.impl.rpc.XBreakpointEvent;
import com.intellij.xdebugger.impl.rpc.XBreakpointId;
import com.intellij.xdebugger.impl.rpc.XBreakpointTypeApi;
import com.intellij.xdebugger.impl.rpc.XBreakpointsSetDto;
import com.intellij.xdebugger.impl.rpc.XDebuggerManagerApi;
import fleet.rpc.core.RpcFlow;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.SharingStarted;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00dc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001_B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010'\u001a\u0004\u0018\u00010\u00102\u0006\u0010(\u001a\u00020)H\u0096@\u00a2\u0006\u0002\u0010*J\u001a\u0010+\u001a\u0004\u0018\u00010\u00102\u0006\u0010(\u001a\u00020)2\u0006\u0010,\u001a\u00020-H\u0002J\u0018\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002JD\u00103\u001a\u0002H4\"\u0004\b\u0000\u001042\b\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u0002022\u001c\u00105\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H407\u0012\u0006\u0012\u0004\u0018\u00010806H\u0096@\u00a2\u0006\u0002\u00109J4\u0010:\u001a\u0004\u0018\u00010\u0017*\u00020\u00052\u0006\u0010;\u001a\u00020\u00162\u0006\u0010<\u001a\u00020=2\u0006\u00101\u001a\u0002022\u0006\u0010/\u001a\u000200H\u0082@\u00a2\u0006\u0002\u0010>J\u0010\u0010?\u001a\u00020\n2\u0006\u0010@\u001a\u00020\u000fH\u0002J\u0010\u0010A\u001a\u0004\u0018\u00010\u00102\u0006\u0010@\u001a\u00020\u000fJ\u0010\u0010B\u001a\u00020\n2\u0006\u0010C\u001a\u00020\u0012H\u0016J\u0010\u0010D\u001a\u00020\n2\u0006\u0010E\u001a\u00020\u001dH\u0016J\u000e\u0010F\u001a\b\u0012\u0004\u0012\u00020H0GH\u0016J\b\u0010I\u001a\u00020\u0014H\u0016J\u000e\u0010J\u001a\b\u0012\u0004\u0012\u00020K0GH\u0016J\u000e\u0010L\u001a\b\u0012\u0004\u0012\u00020=0GH\u0016J\u001e\u0010M\u001a\u00020\n2\u0006\u0010N\u001a\u00020O2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020\n0QH\u0016J\u000e\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00100\u001cH\u0007J\n\u0010S\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010T\u001a\u00020\n2\u0006\u0010U\u001a\u00020\u0010H\u0016J&\u0010V\u001a\b\u0012\u0004\u0012\u00020W0G2\u0006\u0010<\u001a\u00020=2\u0006\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020[H\u0016J\u0014\u0010\\\u001a\u00020\n*\u00020]2\u0006\u0010,\u001a\u00020-H\u0002J\f\u0010^\u001a\u00020\n*\u00020]H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0%8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001f\u00a8\u0006`"}, d2={"Lcom/intellij/platform/debugger/impl/frontend/FrontendXBreakpointManager;", "Lcom/intellij/xdebugger/impl/breakpoints/XBreakpointManagerProxy;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "breakpointsChanged", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "breakpointsChangedWithReplay", "Lkotlinx/coroutines/flow/SharedFlow;", "breakpoints", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/xdebugger/impl/rpc/XBreakpointId;", "Lcom/intellij/xdebugger/impl/breakpoints/XBreakpointProxy;", "_breakpointsDialogSettings", "Lcom/intellij/xdebugger/impl/breakpoints/XBreakpointsDialogState;", "lineBreakpointManager", "Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager;", "lightBreakpoints", "Lcom/intellij/platform/debugger/impl/frontend/FrontendXBreakpointManager$LightBreakpointPosition;", "Lcom/intellij/platform/debugger/impl/frontend/FrontendXLightLineBreakpoint;", "breakpointsDialogSettings", "getBreakpointsDialogSettings", "()Lcom/intellij/xdebugger/impl/breakpoints/XBreakpointsDialogState;", "allGroups", "", "", "getAllGroups", "()Ljava/util/Set;", "dependentBreakpointManager", "Lcom/intellij/xdebugger/impl/breakpoints/XDependentBreakpointManagerProxy;", "getDependentBreakpointManager", "()Lcom/intellij/xdebugger/impl/breakpoints/XDependentBreakpointManagerProxy;", "breakpointIdsRemovedLocally", "", "getBreakpointIdsRemovedLocally", "awaitBreakpointCreation", "breakpointDto", "Lcom/intellij/xdebugger/impl/rpc/XBreakpointDto;", "(Lcom/intellij/xdebugger/impl/rpc/XBreakpointDto;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addBreakpoint", "updateUI", "", "canToggleLightBreakpoint", "editor", "Lcom/intellij/openapi/editor/Editor;", "info", "Lcom/intellij/xdebugger/impl/XLineBreakpointInstallationInfo;", "withLightBreakpointIfPossible", "T", "block", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/xdebugger/impl/XLineBreakpointInstallationInfo;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createLightBreakpointIfPossible", "lightBreakpointPosition", "type", "Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointTypeProxy;", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/platform/debugger/impl/frontend/FrontendXBreakpointManager$LightBreakpointPosition;Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointTypeProxy;Lcom/intellij/xdebugger/impl/XLineBreakpointInstallationInfo;Lcom/intellij/openapi/editor/Editor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeBreakpointLocally", "breakpointId", "getBreakpointById", "setBreakpointsDialogSettings", "settings", "setDefaultGroup", "group", "getAllBreakpointItems", "", "Lcom/intellij/xdebugger/impl/breakpoints/ui/BreakpointItem;", "getLineBreakpointManager", "getAllBreakpointTypes", "Lcom/intellij/xdebugger/impl/breakpoints/XBreakpointTypeProxy;", "getLineBreakpointTypes", "subscribeOnBreakpointsChanges", "disposable", "Lcom/intellij/openapi/Disposable;", "listener", "Lkotlin/Function0;", "getBreakpointsSet", "getLastRemovedBreakpoint", "removeBreakpoint", "breakpoint", "findBreakpointsAtLine", "Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointProxy;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "registerInManager", "Lcom/intellij/platform/debugger/impl/frontend/FrontendXLineBreakpointProxy;", "unregisterInManager", "LightBreakpointPosition", "intellij.platform.debugger.impl.frontend"})
@ApiStatus.Internal
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nFrontendXBreakpointManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendXBreakpointManager.kt\ncom/intellij/platform/debugger/impl/frontend/FrontendXBreakpointManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,352:1\n1563#2:353\n1634#2,3:354\n808#2,11:357\n774#2:368\n865#2,2:369\n1#3:371\n*S KotlinDebug\n*F\n+ 1 FrontendXBreakpointManager.kt\ncom/intellij/platform/debugger/impl/frontend/FrontendXBreakpointManager\n*L\n228#1:353\n228#1:354,3\n276#1:357,11\n276#1:368\n276#1:369,2\n*E\n"})
public final class FrontendXBreakpointManager
implements XBreakpointManagerProxy {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final MutableSharedFlow<Unit> breakpointsChanged;
    @NotNull
    private final SharedFlow<Unit> breakpointsChangedWithReplay;
    @NotNull
    private final ConcurrentMap<XBreakpointId, XBreakpointProxy> breakpoints;
    @Nullable
    private XBreakpointsDialogState _breakpointsDialogSettings;
    @NotNull
    private final XLineBreakpointManager lineBreakpointManager;
    @NotNull
    private final ConcurrentMap<LightBreakpointPosition, FrontendXLightLineBreakpoint> lightBreakpoints;
    @NotNull
    private final XDependentBreakpointManagerProxy dependentBreakpointManager;
    @VisibleForTesting
    @NotNull
    private final Set<XBreakpointId> breakpointIdsRemovedLocally;

    public FrontendXBreakpointManager(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cs = cs;
        this.breakpointsChanged = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)1, null);
        this.breakpointsChangedWithReplay = FlowKt.shareIn((Flow)((Flow)this.breakpointsChanged), (CoroutineScope)this.cs, (SharingStarted)SharingStarted.Companion.getEagerly(), (int)1);
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
        this.breakpoints = concurrentMap;
        this.lineBreakpointManager = new XLineBreakpointManager(this.project, this.cs, XDebugSessionProxy.Companion.useFeLineBreakpointProxy());
        ConcurrentMap concurrentMap2 = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"createConcurrentMap(...)");
        this.lightBreakpoints = concurrentMap2;
        this.dependentBreakpointManager = new FrontendXDependentBreakpointManagerProxy(this.project, this.cs, (Function1<? super XBreakpointId, ? extends XBreakpointProxy>)((Function1)arg_0 -> FrontendXBreakpointManager.dependentBreakpointManager$lambda$0(this, arg_0)));
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        this.breakpointIdsRemovedLocally = keySetView;
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ FrontendXBreakpointManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = FrontendXBreakpointTypesManager.Companion.getInstance(FrontendXBreakpointManager.access$getProject$p(this.this$0)).typesInitialized().await((Continuation)this);
                        if (v0 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.label = 2;
                        v1 = XDebuggerManagerApi.Companion.getInstance((Continuation)this);
                        if (v1 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl21
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        this.label = 3;
                        v2 = ((XDebuggerManagerApi)v1).getBreakpoints(ProjectIdKt.projectId((Project)FrontendXBreakpointManager.access$getProject$p(this.this$0)), (Continuation)this);
                        if (v2 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl29
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl29:
                        // 2 sources

                        var2_3 = (XBreakpointsSetDto)v2;
                        initialBreakpoints = var2_3.component1();
                        breakpointEvents = var2_3.component2();
                        for (XBreakpointDto breakpointDto : initialBreakpoints) {
                            FrontendXBreakpointManager.access$addBreakpoint(this.this$0, breakpointDto, false);
                        }
                        FrontendXBreakpointManager.access$getLineBreakpointManager$p(this.this$0).queueAllBreakpointsUpdate();
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)initialBreakpoints);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)breakpointEvents);
                        this.label = 4;
                        v3 = breakpointEvents.toFlow().collect(new FlowCollector(){

                            public final Object emit(XBreakpointEvent event, Continuation<? super Unit> $completion) {
                                XBreakpointEvent xBreakpointEvent = event;
                                if (xBreakpointEvent instanceof XBreakpointEvent.BreakpointAdded) {
                                    FrontendXBreakpointManagerKt.access$getLog$p().info("Breakpoint add request from backend: " + ((XBreakpointEvent.BreakpointAdded)event).getBreakpointDto().getId());
                                    v0 = (Comparable)this$0.addBreakpoint(((XBreakpointEvent.BreakpointAdded)event).getBreakpointDto(), true);
                                } else if (xBreakpointEvent instanceof XBreakpointEvent.BreakpointRemoved) {
                                    FrontendXBreakpointManagerKt.access$getLog$p().info("Breakpoint removal request from backend: " + ((XBreakpointEvent.BreakpointRemoved)event).getBreakpointId());
                                    this$0.removeBreakpointLocally(((XBreakpointEvent.BreakpointRemoved)event).getBreakpointId());
                                    v0 = Boxing.boxBoolean((boolean)this$0.getBreakpointIdsRemovedLocally().remove(((XBreakpointEvent.BreakpointRemoved)event).getBreakpointId()));
                                } else {
                                    throw new NoWhenBranchMatchedException();
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (v3 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl49
                    }
                    case 4: {
                        breakpointEvents = (RpcFlow)this.L$1;
                        initialBreakpoints = (Set)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl49:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public XBreakpointsDialogState getBreakpointsDialogSettings() {
        return this._breakpointsDialogSettings;
    }

    @NotNull
    public Set<String> getAllGroups() {
        return SetsKt.emptySet();
    }

    @NotNull
    public XDependentBreakpointManagerProxy getDependentBreakpointManager() {
        return this.dependentBreakpointManager;
    }

    @NotNull
    public final Set<XBreakpointId> getBreakpointIdsRemovedLocally() {
        return this.breakpointIdsRemovedLocally;
    }

    @Nullable
    public Object awaitBreakpointCreation(@NotNull XBreakpointDto breakpointDto, @NotNull Continuation<? super XBreakpointProxy> $completion) {
        return FrontendXBreakpointManagerKt.findOrAwaitElement$default((Flow)this.breakpointsChangedWithReplay, breakpointDto.getId().toString(), 0, () -> FrontendXBreakpointManager.awaitBreakpointCreation$lambda$1(breakpointDto, this), $completion, 4, null);
    }

    private final XBreakpointProxy addBreakpoint(XBreakpointDto breakpointDto, boolean updateUI) {
        XBreakpointProxy currentBreakpoint = (XBreakpointProxy)this.breakpoints.get(breakpointDto.getId());
        if (currentBreakpoint != null) {
            FrontendXBreakpointManagerKt.access$getLog$p().info("Breakpoint creation skipped for " + breakpointDto.getId() + ", because it already exists");
            return currentBreakpoint;
        }
        if (this.breakpointIdsRemovedLocally.contains(breakpointDto.getId())) {
            FrontendXBreakpointManagerKt.access$getLog$p().info("Breakpoint creation skipped for " + breakpointDto.getId() + ", because it was removed locally");
            return null;
        }
        XBreakpointTypeProxy xBreakpointTypeProxy = FrontendXBreakpointTypesManager.Companion.getInstance(this.project).getTypeById(breakpointDto.getTypeId());
        if (xBreakpointTypeProxy == null) {
            return null;
        }
        XBreakpointTypeProxy type = xBreakpointTypeProxy;
        XBreakpointProxy newBreakpoint = FrontendXBreakpointProxyKt.createXBreakpointProxy(this.project, this.cs, breakpointDto, type, this, (Function1<? super XBreakpointProxy, Unit>)((Function1)arg_0 -> FrontendXBreakpointManager.addBreakpoint$lambda$2(this, arg_0)));
        XBreakpointProxy previousBreakpoint = this.breakpoints.putIfAbsent(breakpointDto.getId(), newBreakpoint);
        if (previousBreakpoint != null) {
            newBreakpoint.dispose();
            FrontendXBreakpointManagerKt.access$getLog$p().info("Breakpoint creation skipped for " + breakpointDto.getId() + ", because it is already created");
            return previousBreakpoint;
        }
        FrontendXLineBreakpointProxy frontendXLineBreakpointProxy = newBreakpoint instanceof FrontendXLineBreakpointProxy ? (FrontendXLineBreakpointProxy)newBreakpoint : null;
        if (frontendXLineBreakpointProxy != null) {
            this.registerInManager(frontendXLineBreakpointProxy, updateUI);
        }
        FrontendXBreakpointManagerKt.access$getLog$p().info("Breakpoint created for " + breakpointDto.getId());
        this.breakpointsChanged.tryEmit((Object)Unit.INSTANCE);
        return newBreakpoint;
    }

    private final boolean canToggleLightBreakpoint(Editor editor, XLineBreakpointInstallationInfo info) {
        EditorLineBreakpointsInfo lineInfo;
        XLineBreakpointTypeProxy xLineBreakpointTypeProxy = (XLineBreakpointTypeProxy)CollectionsKt.singleOrNull((List)info.getTypes());
        if (xLineBreakpointTypeProxy == null) {
            return false;
        }
        XLineBreakpointTypeProxy type = xLineBreakpointTypeProxy;
        VirtualFile virtualFile = info.getPosition().getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        if (!((Collection)this.findBreakpointsAtLine(type, virtualFile, info.getPosition().getLine())).isEmpty()) {
            return false;
        }
        if (info.isTemporary() || info.isConditional()) {
            return false;
        }
        EditorLineBreakpointsInfo editorLineBreakpointsInfo = lineInfo = FrontendEditorLinesBreakpointsInfoManager.Companion.getInstance(this.project).getBreakpointsInfoForLineFast(editor, info.getPosition().getLine());
        return editorLineBreakpointsInfo != null ? editorLineBreakpointsInfo.getSingleBreakpointVariant() : false;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public <T> Object withLightBreakpointIfPossible(@Nullable Editor editor, @NotNull XLineBreakpointInstallationInfo info, @NotNull Function1<? super Continuation<? super T>, ? extends Object> block, @NotNull Continuation<? super T> $completion) {
        if (!($completion instanceof withLightBreakpointIfPossible.1)) ** GOTO lbl-1000
        var8_5 = $completion;
        if ((var8_5.label & -2147483648) != 0) {
            var8_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ FrontendXBreakpointManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.withLightBreakpointIfPossible(null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (editor == null) ** GOTO lbl28
                $continuation.L$0 = editor;
                $continuation.L$1 = info;
                $continuation.L$2 = block;
                $continuation.label = 1;
                v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, withLightBreakpointIfPossible$lambda$3(com.intellij.platform.debugger.impl.frontend.FrontendXBreakpointManager com.intellij.openapi.editor.Editor com.intellij.xdebugger.impl.XLineBreakpointInstallationInfo ), ()Ljava/lang/Boolean;)((FrontendXBreakpointManager)this, (Editor)editor, (XLineBreakpointInstallationInfo)info), $continuation);
                if (v0 == var9_7) {
                    return var9_7;
                }
                ** GOTO lbl27
            }
            case 1: {
                block = (Function1)$continuation.L$2;
                info = (XLineBreakpointInstallationInfo)$continuation.L$1;
                editor = (Editor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                if (((Boolean)v0).booleanValue()) break;
lbl28:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)editor);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)info);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)block);
                $continuation.label = 2;
                v1 = block.invoke($continuation);
                if (v1 == var9_7) {
                    return var9_7;
                }
                ** GOTO lbl42
            }
            case 2: {
                block = (Function1)$continuation.L$2;
                info = (XLineBreakpointInstallationInfo)$continuation.L$1;
                editor = (Editor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl42:
                // 2 sources

                return v1;
            }
        }
        v2 = info.getPosition().getFile();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getFile(...)");
        lightBreakpointPosition = new LightBreakpointPosition(v2, info.getPosition().getLine());
        type = (XLineBreakpointTypeProxy)CollectionsKt.first((List)info.getTypes());
        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)editor);
        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)info);
        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)block);
        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)lightBreakpointPosition);
        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)type);
        $continuation.label = 3;
        v3 = kotlinx.coroutines.CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(this, lightBreakpointPosition, type, info, editor, block, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ FrontendXBreakpointManager this$0;
            final /* synthetic */ LightBreakpointPosition $lightBreakpointPosition;
            final /* synthetic */ XLineBreakpointTypeProxy $type;
            final /* synthetic */ XLineBreakpointInstallationInfo $info;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ Function1<Continuation<? super T>, Object> $block;
            {
                this.this$0 = $receiver;
                this.$lightBreakpointPosition = $lightBreakpointPosition;
                this.$type = $type;
                this.$info = $info;
                this.$editor = $editor;
                this.$block = $block;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var6_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$coroutineScope);
                        this.label = 1;
                        v0 = FrontendXBreakpointManager.access$createLightBreakpointIfPossible(this.this$0, (CoroutineScope)$this$coroutineScope, this.$lightBreakpointPosition, this.$type, this.$info, this.$editor, (Continuation)this);
                        if (v0 == var6_3) {
                            return var6_3;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        lightBreakpoint = (FrontendXLightLineBreakpoint)v0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$coroutineScope);
                        this.L$1 = lightBreakpoint;
                        this.label = 2;
                        v1 = this.$block.invoke((Object)this);
                        ** if (v1 != var6_3) goto lbl24
lbl23:
                        // 1 sources

                        return var6_3;
lbl24:
                        // 1 sources

                        ** GOTO lbl31
                    }
                    case 2: {
                        lightBreakpoint = (FrontendXLightLineBreakpoint)this.L$1;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl31:
                            // 2 sources

                            var4_5 = v1;
                        }
                        catch (Throwable var5_6) {
                            throw var5_6;
                        }
                        finally {
                            FrontendXBreakpointManager.access$getLightBreakpoints$p(this.this$0).remove(this.$lightBreakpointPosition, lightBreakpoint);
                            v2 = lightBreakpoint;
                            if (v2 != null) {
                                v2.dispose();
                            }
                        }
                        return var4_5;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $continuation);
        if (v3 == var9_7) {
            return var9_7;
        }
        ** GOTO lbl65
        {
            case 3: {
                type = (XLineBreakpointTypeProxy)$continuation.L$4;
                lightBreakpointPosition = (LightBreakpointPosition)$continuation.L$3;
                block = (Function1)$continuation.L$2;
                info = (XLineBreakpointInstallationInfo)$continuation.L$1;
                editor = (Editor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl65:
                // 2 sources

                return v3;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object createLightBreakpointIfPossible(CoroutineScope $this$createLightBreakpointIfPossible, LightBreakpointPosition lightBreakpointPosition, XLineBreakpointTypeProxy type, XLineBreakpointInstallationInfo info, Editor editor, Continuation<? super FrontendXLightLineBreakpoint> $completion) {
        if (!($completion instanceof createLightBreakpointIfPossible.1)) ** GOTO lbl-1000
        var10_7 = $completion;
        if ((var10_7.label & -2147483648) != 0) {
            var10_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                /* synthetic */ Object result;
                final /* synthetic */ FrontendXBreakpointManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return FrontendXBreakpointManager.access$createLightBreakpointIfPossible(this.this$0, null, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                while (true) {
                    newBreakpoint = new FrontendXLightLineBreakpoint(this.project, $this$createLightBreakpointIfPossible, type, info, this);
                    oldBreakpoint = this.lightBreakpoints.putIfAbsent(lightBreakpointPosition, newBreakpoint);
                    if (oldBreakpoint == null) {
                        return newBreakpoint;
                    }
                    newBreakpoint.dispose();
                    $continuation.L$0 = $this$createLightBreakpointIfPossible;
                    $continuation.L$1 = lightBreakpointPosition;
                    $continuation.L$2 = type;
                    $continuation.L$3 = info;
                    $continuation.L$4 = editor;
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)newBreakpoint);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)oldBreakpoint);
                    $continuation.label = 1;
                    v0 = oldBreakpoint.awaitDispose((Continuation<? super Unit>)$continuation);
                    if (v0 != var11_9) continue;
                    return var11_9;
                }
            }
            case 1: {
                oldBreakpoint = (FrontendXLightLineBreakpoint)$continuation.L$6;
                newBreakpoint = (FrontendXLightLineBreakpoint)$continuation.L$5;
                editor = (Editor)$continuation.L$4;
                info = (XLineBreakpointInstallationInfo)$continuation.L$3;
                type = (XLineBreakpointTypeProxy)$continuation.L$2;
                lightBreakpointPosition = (LightBreakpointPosition)$continuation.L$1;
                $this$createLightBreakpointIfPossible = (CoroutineScope)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
                if (this.canToggleLightBreakpoint(editor, info)) ** continue;
                return null;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void removeBreakpointLocally(XBreakpointId breakpointId) {
        XBreakpointProxy removedBreakpoint;
        this.breakpointIdsRemovedLocally.add(breakpointId);
        XBreakpointProxy xBreakpointProxy = removedBreakpoint = (XBreakpointProxy)this.breakpoints.remove(breakpointId);
        if (xBreakpointProxy != null) {
            xBreakpointProxy.dispose();
        }
        if (removedBreakpoint == null) {
            FrontendXBreakpointManagerKt.access$getLog$p().info("Breakpoint removal has no effect for " + breakpointId + ", because it doesn't exist locally");
        } else {
            FrontendXBreakpointManagerKt.access$getLog$p().info("Breakpoint removed for " + breakpointId);
        }
        FrontendXLineBreakpointProxy frontendXLineBreakpointProxy = removedBreakpoint instanceof FrontendXLineBreakpointProxy ? (FrontendXLineBreakpointProxy)removedBreakpoint : null;
        if (frontendXLineBreakpointProxy != null) {
            this.unregisterInManager(frontendXLineBreakpointProxy);
        }
        this.breakpointsChanged.tryEmit((Object)Unit.INSTANCE);
    }

    @Nullable
    public final XBreakpointProxy getBreakpointById(@NotNull XBreakpointId breakpointId) {
        Intrinsics.checkNotNullParameter((Object)breakpointId, (String)"breakpointId");
        return (XBreakpointProxy)this.breakpoints.get(breakpointId);
    }

    public void setBreakpointsDialogSettings(@NotNull XBreakpointsDialogState settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this._breakpointsDialogSettings = settings;
    }

    public void setDefaultGroup(@NotNull String group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<BreakpointItem> getAllBreakpointItems() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.breakpoints.values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void proxy;
            XBreakpointProxy xBreakpointProxy = (XBreakpointProxy)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new XBreakpointItem((XBreakpointProxy)proxy, (XBreakpointManagerProxy)this));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public XLineBreakpointManager getLineBreakpointManager() {
        return this.lineBreakpointManager;
    }

    @NotNull
    public List<XBreakpointTypeProxy> getAllBreakpointTypes() {
        return FrontendXBreakpointTypesManager.Companion.getInstance(this.project).getBreakpointTypes();
    }

    @NotNull
    public List<XLineBreakpointTypeProxy> getLineBreakpointTypes() {
        return FrontendXBreakpointTypesManager.Companion.getInstance(this.project).getLineBreakpointTypes();
    }

    public void subscribeOnBreakpointsChanges(@NotNull Disposable disposable, @NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        CoroutineScope scope = CoroutineScopeKt.childScope$default((CoroutineScope)this.cs, (String)"BreakpointsChangesListener", null, (boolean)false, (int)6, null);
        Disposable childDisposable = () -> FrontendXBreakpointManager.subscribeOnBreakpointsChanges$lambda$5(scope);
        Disposer.register((Disposable)disposable, (Disposable)childDisposable);
        BuildersKt.launch$default((CoroutineScope)scope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, listener, null){
            int label;
            final /* synthetic */ FrontendXBreakpointManager this$0;
            final /* synthetic */ Function0<Unit> $listener;
            {
                this.this$0 = $receiver;
                this.$listener = $listener;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FrontendXBreakpointManager.access$getBreakpointsChanged$p(this.this$0).collect(new FlowCollector(this.$listener){
                            final /* synthetic */ Function0<Unit> $listener;
                            {
                                this.$listener = $listener;
                            }

                            public final Object emit(Unit it, Continuation<? super Unit> $completion) {
                                this.$listener.invoke();
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @VisibleForTesting
    @NotNull
    public final Set<XBreakpointProxy> getBreakpointsSet() {
        return CollectionsKt.toSet((Iterable)this.breakpoints.values());
    }

    @Nullable
    public XBreakpointProxy getLastRemovedBreakpoint() {
        return null;
    }

    public void removeBreakpoint(@NotNull XBreakpointProxy breakpoint) {
        Intrinsics.checkNotNullParameter((Object)breakpoint, (String)"breakpoint");
        FrontendXBreakpointManagerKt.access$getLog$p().info("Breakpoint removal request from frontend: " + breakpoint.getId());
        this.removeBreakpointLocally(breakpoint.getId());
        this.breakpointsChanged.tryEmit((Object)Unit.INSTANCE);
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(breakpoint, null){
            int label;
            final /* synthetic */ XBreakpointProxy $breakpoint;
            {
                this.$breakpoint = $breakpoint;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = XBreakpointTypeApi.Companion.getInstance((Continuation)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.label = 2;
                        v1 = ((XBreakpointTypeApi)v0).removeBreakpoint(this.$breakpoint.getId(), (Continuation)this);
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl21
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public List<XLineBreakpointProxy> findBreakpointsAtLine(@NotNull XLineBreakpointTypeProxy type, @NotNull VirtualFile file, int line) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        $this$filterIsInstance$iv = this.breakpoints.values();
        $i$f$filterIsInstance = false;
        var6_6 = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterIsInstanceTo = false;
        for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof XLineBreakpointProxy)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (XLineBreakpointProxy)element$iv$iv;
            $i$a$-filter-FrontendXBreakpointManager$findBreakpointsAtLine$1 = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)type)) ** GOTO lbl-1000
            v0 = it.getFile();
            if (Intrinsics.areEqual((Object)(v0 != null ? v0.getUrl() : null), (Object)file.getUrl()) && it.getLine() == line) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void registerInManager(FrontendXLineBreakpointProxy $this$registerInManager, boolean updateUI) {
        block5: while (true) {
            RegistrationStatus status;
            RegistrationStatus registrationStatus = status = $this$registerInManager.getRegistrationInLineManagerStatus$intellij_platform_debugger_impl_frontend().get();
            switch (registrationStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[registrationStatus.ordinal()]) {
                case 1: {
                    return;
                }
                case 2: 
                case 3: {
                    throw new IllegalStateException(("Breakpoint " + $this$registerInManager.getId() + " is already registered").toString());
                }
                case 4: {
                    if (!$this$registerInManager.getRegistrationInLineManagerStatus$intellij_platform_debugger_impl_frontend().compareAndSet(RegistrationStatus.NOT_STARTED, RegistrationStatus.IN_PROGRESS)) continue block5;
                    this.lineBreakpointManager.registerBreakpoint((XLineBreakpointProxy)$this$registerInManager, updateUI);
                    if (!$this$registerInManager.getRegistrationInLineManagerStatus$intellij_platform_debugger_impl_frontend().compareAndSet(RegistrationStatus.IN_PROGRESS, RegistrationStatus.REGISTERED)) {
                        RegistrationStatus newStatus = $this$registerInManager.getRegistrationInLineManagerStatus$intellij_platform_debugger_impl_frontend().get();
                        if (!(newStatus == RegistrationStatus.DEREGISTERED)) {
                            boolean bl = false;
                            String string = "Unexpected status: " + newStatus;
                            throw new IllegalStateException(string.toString());
                        }
                        this.unregisterInManager($this$registerInManager);
                    }
                    return;
                }
            }
            break;
        }
        throw new NoWhenBranchMatchedException();
    }

    private final void unregisterInManager(FrontendXLineBreakpointProxy $this$unregisterInManager) {
        $this$unregisterInManager.getRegistrationInLineManagerStatus$intellij_platform_debugger_impl_frontend().set(RegistrationStatus.DEREGISTERED);
        this.lineBreakpointManager.unregisterBreakpoint((XLineBreakpointProxy)$this$unregisterInManager);
    }

    private static final XBreakpointProxy dependentBreakpointManager$lambda$0(FrontendXBreakpointManager this$0, XBreakpointId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (XBreakpointProxy)this$0.breakpoints.get(it);
    }

    private static final Ref awaitBreakpointCreation$lambda$1(XBreakpointDto $breakpointDto, FrontendXBreakpointManager this$0) {
        XBreakpointId breakpointId = $breakpointDto.getId();
        XBreakpointProxy currentBreakpoint = (XBreakpointProxy)this$0.breakpoints.get($breakpointDto.getId());
        return currentBreakpoint != null ? Ref.create((Object)currentBreakpoint) : (this$0.breakpointIdsRemovedLocally.contains(breakpointId) ? Ref.create(null) : null);
    }

    private static final Unit addBreakpoint$lambda$2(FrontendXBreakpointManager this$0, XBreakpointProxy it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.breakpointsChanged.tryEmit((Object)Unit.INSTANCE);
        if (it instanceof XLineBreakpointProxy) {
            this$0.lineBreakpointManager.breakpointChanged((XLightLineBreakpointProxy)it);
        }
        return Unit.INSTANCE;
    }

    private static final boolean withLightBreakpointIfPossible$lambda$3(FrontendXBreakpointManager this$0, Editor $editor, XLineBreakpointInstallationInfo $info) {
        return this$0.canToggleLightBreakpoint($editor, $info);
    }

    private static final void subscribeOnBreakpointsChanges$lambda$5(CoroutineScope $scope) {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)$scope, (String)"disposed", null, (int)2, null);
    }

    public static final /* synthetic */ Object access$createLightBreakpointIfPossible(FrontendXBreakpointManager $this, CoroutineScope $receiver, LightBreakpointPosition lightBreakpointPosition, XLineBreakpointTypeProxy type, XLineBreakpointInstallationInfo info, Editor editor, Continuation $completion) {
        return $this.createLightBreakpointIfPossible($receiver, lightBreakpointPosition, type, info, editor, (Continuation<? super FrontendXLightLineBreakpoint>)$completion);
    }

    public static final /* synthetic */ ConcurrentMap access$getLightBreakpoints$p(FrontendXBreakpointManager $this) {
        return $this.lightBreakpoints;
    }

    public static final /* synthetic */ MutableSharedFlow access$getBreakpointsChanged$p(FrontendXBreakpointManager $this) {
        return $this.breakpointsChanged;
    }

    public static final /* synthetic */ Project access$getProject$p(FrontendXBreakpointManager $this) {
        return $this.project;
    }

    public static final /* synthetic */ XLineBreakpointManager access$getLineBreakpointManager$p(FrontendXBreakpointManager $this) {
        return $this.lineBreakpointManager;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/platform/debugger/impl/frontend/FrontendXBreakpointManager$LightBreakpointPosition;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;I)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getLine", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.debugger.impl.frontend"})
    private static final class LightBreakpointPosition {
        @NotNull
        private final VirtualFile file;
        private final int line;

        public LightBreakpointPosition(@NotNull VirtualFile file, int line) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
            this.line = line;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        public final int getLine() {
            return this.line;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.file;
        }

        public final int component2() {
            return this.line;
        }

        @NotNull
        public final LightBreakpointPosition copy(@NotNull VirtualFile file, int line) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return new LightBreakpointPosition(file, line);
        }

        public static /* synthetic */ LightBreakpointPosition copy$default(LightBreakpointPosition lightBreakpointPosition, VirtualFile virtualFile, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                virtualFile = lightBreakpointPosition.file;
            }
            if ((n2 & 2) != 0) {
                n = lightBreakpointPosition.line;
            }
            return lightBreakpointPosition.copy(virtualFile, n);
        }

        @NotNull
        public String toString() {
            return "LightBreakpointPosition(file=" + this.file + ", line=" + this.line + ")";
        }

        public int hashCode() {
            int result = this.file.hashCode();
            result = result * 31 + Integer.hashCode(this.line);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LightBreakpointPosition)) {
                return false;
            }
            LightBreakpointPosition lightBreakpointPosition = (LightBreakpointPosition)other;
            if (!Intrinsics.areEqual((Object)this.file, (Object)lightBreakpointPosition.file)) {
                return false;
            }
            return this.line == lightBreakpointPosition.line;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RegistrationStatus.values().length];
            try {
                nArray[RegistrationStatus.DEREGISTERED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RegistrationStatus.IN_PROGRESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RegistrationStatus.REGISTERED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RegistrationStatus.NOT_STARTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

