/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.tokenizer;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spellchecker.DictionaryLayer;
import com.intellij.spellchecker.DictionaryLayersProvider;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.SpellCheckingInspection;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFixFactory;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.tokenizer.CommentTokenizer;
import com.intellij.spellchecker.tokenizer.CustomFileTypeTokenizer;
import com.intellij.spellchecker.tokenizer.PsiIdentifierOwnerTokenizer;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.tokenizer.TokenizerBase;
import com.intellij.util.KeyedLazyInstance;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpellcheckingStrategy
implements PossiblyDumbAware {
    protected final Tokenizer<PsiComment> myCommentTokenizer = new CommentTokenizer();
    public static final ExtensionPointName<KeyedLazyInstance<SpellcheckingStrategy>> EP_NAME = new ExtensionPointName("com.intellij.spellchecker.support");
    public static final Tokenizer EMPTY_TOKENIZER = new Tokenizer(){

        public void tokenize(@NotNull PsiElement element, @NotNull TokenConsumer consumer) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                1.$$$reportNull$$$0(1);
            }
        }

        public String toString() {
            return "EMPTY_TOKENIZER";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy$1";
            objectArray[2] = "tokenize";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final Tokenizer<PsiElement> TEXT_TOKENIZER = new TokenizerBase<PsiElement>(PlainTextSplitter.getInstance());

    @NotNull
    public Tokenizer getTokenizer(@NotNull PsiElement element, @NotNull Set<SpellCheckingInspection.SpellCheckingScope> scope) {
        if (element == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(1);
        }
        Tokenizer tokenizer = this.getTokenizer(element);
        if (tokenizer == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(2);
        }
        return tokenizer;
    }

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (element instanceof PsiWhiteSpace) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                SpellcheckingStrategy.$$$reportNull$$$0(3);
            }
            return tokenizer;
        }
        if (SpellcheckingStrategy.isInjectedLanguageFragment(element)) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                SpellcheckingStrategy.$$$reportNull$$$0(4);
            }
            return tokenizer;
        }
        if (element instanceof PsiNameIdentifierOwner) {
            PsiIdentifierOwnerTokenizer psiIdentifierOwnerTokenizer = PsiIdentifierOwnerTokenizer.INSTANCE;
            if (psiIdentifierOwnerTokenizer == null) {
                SpellcheckingStrategy.$$$reportNull$$$0(5);
            }
            return psiIdentifierOwnerTokenizer;
        }
        if (element instanceof PsiComment) {
            if (SuppressionUtil.isSuppressionComment((PsiElement)element)) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    SpellcheckingStrategy.$$$reportNull$$$0(6);
                }
                return tokenizer;
            }
            if (element.getTextOffset() == 0 && element.getText().startsWith("#!")) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    SpellcheckingStrategy.$$$reportNull$$$0(7);
                }
                return tokenizer;
            }
            Tokenizer<PsiComment> tokenizer = this.myCommentTokenizer;
            if (tokenizer == null) {
                SpellcheckingStrategy.$$$reportNull$$$0(8);
            }
            return tokenizer;
        }
        if (element instanceof PsiPlainText) {
            FileType fileType;
            PsiFile file = element.getContainingFile();
            FileType fileType2 = fileType = file == null ? null : file.getFileType();
            if (fileType instanceof CustomSyntaxTableFileType) {
                return new CustomFileTypeTokenizer(((CustomSyntaxTableFileType)fileType).getSyntaxTable());
            }
            Tokenizer<PsiElement> tokenizer = TEXT_TOKENIZER;
            if (tokenizer == null) {
                SpellcheckingStrategy.$$$reportNull$$$0(9);
            }
            return tokenizer;
        }
        Tokenizer tokenizer = EMPTY_TOKENIZER;
        if (tokenizer == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(10);
        }
        return tokenizer;
    }

    public boolean elementFitsScope(@NotNull PsiElement element, Set<SpellCheckingInspection.SpellCheckingScope> scope) {
        if (element == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(11);
        }
        Language language = element.getLanguage();
        IElementType elementType = element.getNode().getElementType();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        return parserDefinition == null || !(parserDefinition.getStringLiteralElements().contains(elementType) ? !scope.contains((Object)SpellCheckingInspection.SpellCheckingScope.Literals) : (parserDefinition.getCommentTokens().contains(elementType) ? !scope.contains((Object)SpellCheckingInspection.SpellCheckingScope.Comments) : !scope.contains((Object)SpellCheckingInspection.SpellCheckingScope.Code)));
    }

    protected static boolean isInjectedLanguageFragment(@Nullable PsiElement element) {
        return element instanceof PsiLanguageInjectionHost && InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)((PsiLanguageInjectionHost)element));
    }

    public LocalQuickFix[] getRegularFixes(@NotNull PsiElement element, @NotNull TextRange textRange, boolean useRename, String typo) {
        if (element == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(12);
        }
        if (textRange == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(13);
        }
        return SpellcheckingStrategy.getDefaultRegularFixes(useRename, typo, element, textRange);
    }

    public static LocalQuickFix[] getDefaultRegularFixes(boolean useRename, String typo, @NotNull PsiElement element, @NotNull TextRange range) {
        if (element == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(14);
        }
        if (range == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(15);
        }
        ArrayList<LocalQuickFix> result = new ArrayList<LocalQuickFix>();
        if (useRename && PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiNamedElement.class}) != null) {
            result.add(SpellCheckerQuickFixFactory.rename(element));
        } else {
            result.addAll(SpellCheckerQuickFixFactory.changeToVariants(element, range, typo));
        }
        SpellCheckerSettings settings = SpellCheckerSettings.getInstance(element.getProject());
        if (settings.isUseSingleDictionaryToSave()) {
            DictionaryLayer layer = DictionaryLayersProvider.getLayer(element.getProject(), settings.getDictionaryToSave());
            result.add(SpellCheckerQuickFixFactory.saveTo(element, range, typo, layer));
            return result.toArray(LocalQuickFix.EMPTY_ARRAY);
        }
        result.add(SpellCheckerQuickFixFactory.saveTo(element, range, typo));
        return result.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    public static LocalQuickFix[] getDefaultBatchFixes(@NotNull PsiElement element, @NotNull TextRange textRange, @NotNull String word) {
        if (element == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(16);
        }
        if (textRange == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(17);
        }
        if (word == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(18);
        }
        return (LocalQuickFix[])DictionaryLayersProvider.getAllLayers(element.getProject()).stream().map(it -> SpellCheckerQuickFixFactory.saveTo(element, textRange, word, it)).toArray(LocalQuickFix[]::new);
    }

    public boolean isMyContext(@NotNull PsiElement element) {
        if (element == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(19);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTokenizer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "elementFitsScope";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRegularFixes";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRegularFixes";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultBatchFixes";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isMyContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

