/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.service.commands;

import com.intellij.docker.DockerAgentPathMapperImpl;
import com.intellij.docker.agent.compose.beans.DockerComposePort;
import com.intellij.docker.agent.compose.beans.ExtraHost;
import com.intellij.docker.agent.compose.beans.RestartPolicy;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumesFrom;
import com.intellij.docker.compose.service.commands.SharedVolume;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractServiceCmd<T extends AbstractServiceCmd<T>> {
    @NotNull
    private final RemoteDockerRuntime myDockerRuntime;
    private String myServiceName;
    private String myProjectName;
    private DockerVolumesFrom[] myVolumesFrom;
    private String[] myEntrypoint;
    private String[] myCommand;
    private String myWorkingDir;
    private Map<String, String> myEnvironment;
    private List<String> myConfigurationPaths;
    private DockerVolumeBinding[] myVolumesBinding;
    private List<DockerComposePort> myPorts;
    private String myUser;
    private RestartPolicy myRestartPolicy;
    private Map<String, String> myEnvs;
    private SharedVolume mySharedVolume;
    private boolean myDetached;
    @Nullable
    private List<ExtraHost> myExtraHosts;
    private List<String> mySubcommandOptions;

    protected AbstractServiceCmd(@NotNull RemoteDockerRuntime dockerRuntime) {
        if (dockerRuntime == null) {
            AbstractServiceCmd.$$$reportNull$$$0(0);
        }
        this.myDockerRuntime = dockerRuntime;
    }

    @NotNull
    public RemoteDockerRuntime getDockerRuntime() {
        RemoteDockerRuntime remoteDockerRuntime = this.myDockerRuntime;
        if (remoteDockerRuntime == null) {
            AbstractServiceCmd.$$$reportNull$$$0(1);
        }
        return remoteDockerRuntime;
    }

    @Nullable
    public String getServiceName() {
        return this.myServiceName;
    }

    @Nullable
    public String getProjectName() {
        return this.myProjectName;
    }

    @NotNull
    public T withServiceName(@Nullable String serviceName) {
        this.myServiceName = serviceName;
        T t = this.getThis();
        if (t == null) {
            AbstractServiceCmd.$$$reportNull$$$0(2);
        }
        return t;
    }

    @NotNull
    public T withProjectName(@Nullable String projectName) {
        this.myProjectName = projectName;
        T t = this.getThis();
        if (t == null) {
            AbstractServiceCmd.$$$reportNull$$$0(3);
        }
        return t;
    }

    @NotNull
    public T withExtraHosts(@Nullable List<ExtraHost> extraHosts) {
        this.myExtraHosts = extraHosts != null ? List.copyOf(extraHosts) : extraHosts;
        T t = this.getThis();
        if (t == null) {
            AbstractServiceCmd.$$$reportNull$$$0(4);
        }
        return t;
    }

    @Nullable
    public List<ExtraHost> getExtraHosts() {
        return this.myExtraHosts;
    }

    public DockerVolumesFrom @Nullable [] getVolumesFrom() {
        return this.myVolumesFrom;
    }

    @NotNull
    public T withVolumesFrom(DockerVolumesFrom @Nullable [] volumesFrom) {
        this.myVolumesFrom = volumesFrom;
        T t = this.getThis();
        if (t == null) {
            AbstractServiceCmd.$$$reportNull$$$0(5);
        }
        return t;
    }

    public String[] getEntrypoint() {
        return this.myEntrypoint;
    }

    public T withEntrypoint(String ... entrypoint) {
        this.myEntrypoint = entrypoint;
        return this.getThis();
    }

    public String @Nullable [] getCommand() {
        return this.myCommand;
    }

    @NotNull
    public T withCommand(String ... command) {
        this.myCommand = command;
        T t = this.getThis();
        if (t == null) {
            AbstractServiceCmd.$$$reportNull$$$0(6);
        }
        return t;
    }

    @Nullable
    public String getWorkingDir() {
        return this.myWorkingDir;
    }

    @NotNull
    public T withWorkingDir(@Nullable String workingDir) {
        this.myWorkingDir = workingDir;
        T t = this.getThis();
        if (t == null) {
            AbstractServiceCmd.$$$reportNull$$$0(7);
        }
        return t;
    }

    @Nullable
    public Map<String, String> getEnvironment() {
        return this.myEnvironment;
    }

    @NotNull
    public T withEnvironment(@Nullable Map<String, String> environment) {
        this.myEnvironment = environment;
        T t = this.getThis();
        if (t == null) {
            AbstractServiceCmd.$$$reportNull$$$0(8);
        }
        return t;
    }

    @Nullable
    public List<String> getConfigurationPaths() {
        return this.myConfigurationPaths;
    }

    @NotNull
    public T withConfigurationPath(@Nullable List<String> configurationPath) {
        this.myConfigurationPaths = configurationPath;
        T t = this.getThis();
        if (t == null) {
            AbstractServiceCmd.$$$reportNull$$$0(9);
        }
        return t;
    }

    @Nullable
    public Map<String, String> getEnvs() {
        return this.myEnvs;
    }

    @NotNull
    public T withEnvs(@Nullable Map<String, String> envs) {
        this.myEnvs = envs != null ? Map.copyOf(envs) : null;
        T t = this.getThis();
        if (t == null) {
            AbstractServiceCmd.$$$reportNull$$$0(10);
        }
        return t;
    }

    public DockerVolumeBinding[] getVolumesBinding() {
        return this.myVolumesBinding;
    }

    @NotNull
    public T withVolumes(DockerVolumeBinding @Nullable [] volumesBinding) {
        DockerAgentPathMapperImpl mapper = new DockerAgentPathMapperImpl(this.myDockerRuntime.getProject(), this.myDockerRuntime.getAccount());
        this.myVolumesBinding = volumesBinding != null ? (DockerVolumeBinding[])Arrays.stream(volumesBinding).map(e -> {
            DockerVolumeBindingImpl binding = new DockerVolumeBindingImpl(e.getContainerPath(), mapper.mapPath(e.getHostPath()), e.isReadOnly());
            binding.setEditable(e.isEditable());
            return binding;
        }).toArray(DockerVolumeBinding[]::new) : null;
        T t = this.getThis();
        if (t == null) {
            AbstractServiceCmd.$$$reportNull$$$0(11);
        }
        return t;
    }

    @Nullable
    public String getUser() {
        return this.myUser;
    }

    @NotNull
    public T withUser(@Nullable String user) {
        this.myUser = user;
        T t = this.getThis();
        if (t == null) {
            AbstractServiceCmd.$$$reportNull$$$0(12);
        }
        return t;
    }

    @Nullable
    public RestartPolicy getRestartPolicy() {
        return this.myRestartPolicy;
    }

    @NotNull
    public T withRestartPolicy(@Nullable RestartPolicy restartPolicy) {
        this.myRestartPolicy = restartPolicy;
        T t = this.getThis();
        if (t == null) {
            AbstractServiceCmd.$$$reportNull$$$0(13);
        }
        return t;
    }

    @Nullable
    public List<DockerComposePort> getPorts() {
        return this.myPorts;
    }

    @NotNull
    public T withPorts(@Nullable List<DockerComposePort> ports) {
        this.myPorts = ports;
        T t = this.getThis();
        if (t == null) {
            AbstractServiceCmd.$$$reportNull$$$0(14);
        }
        return t;
    }

    @Nullable
    public SharedVolume getSharedVolume() {
        return this.mySharedVolume;
    }

    @NotNull
    public T withSharedVolume(@Nullable SharedVolume sharedVolume) {
        this.mySharedVolume = sharedVolume;
        T t = this.getThis();
        if (t == null) {
            AbstractServiceCmd.$$$reportNull$$$0(15);
        }
        return t;
    }

    public boolean isDetached() {
        return this.myDetached;
    }

    public T withDetached(boolean detached) {
        this.myDetached = detached;
        return this.getThis();
    }

    @Nullable
    protected List<String> getSubcommandOptions() {
        return this.mySubcommandOptions;
    }

    @NotNull
    public T withSubcommandOptions(@Nullable List<String> subcommandOptions) {
        this.mySubcommandOptions = subcommandOptions != null ? List.copyOf(subcommandOptions) : null;
        T t = this.getThis();
        if (t == null) {
            AbstractServiceCmd.$$$reportNull$$$0(16);
        }
        return t;
    }

    @NotNull
    protected abstract T getThis();

    @NotNull
    public abstract KillableColoredProcessHandler execute() throws IOException, ExecutionException;

    @NotNull
    public abstract GeneralCommandLine buildCommandLine(@NotNull RemoteDockerRuntime var1) throws IOException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/compose/service/commands/AbstractServiceCmd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/compose/service/commands/AbstractServiceCmd";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerRuntime";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "withServiceName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withProjectName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withExtraHosts";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withVolumesFrom";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withCommand";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withWorkingDir";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "withEnvironment";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "withConfigurationPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "withEnvs";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "withVolumes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "withUser";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "withRestartPolicy";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "withPorts";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "withSharedVolume";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "withSubcommandOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16 -> new IllegalStateException(string);
        };
    }
}

