/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.permissions;

import circlet.common.permissions.PermissionContextType;
import circlet.common.permissions.PermissionRoleScope;
import circlet.common.permissions.RoleCode;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0010\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\u0005\"'\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\"\u0013\u0010\f\u001a\u00020\r\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000f\"\u0013\u0010\u0011\u001a\u00020\r\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u0012\u0010\u000f\"\u0013\u0010\u0013\u001a\u00020\r\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006\u0015"}, d2={"toObsoleteScope", "Lcirclet/common/permissions/PermissionRoleScope;", "Lcirclet/common/permissions/PermissionContextType;", "permissionContextTypeByCode", "", "", "getPermissionContextTypeByCode", "()Ljava/util/Map;", "permissionContextTypeByCode$delegate", "Lkotlin/Lazy;", "parsePermissionContextTypeOrNull", "code", "requestedRoleCode", "Lcirclet/common/permissions/RoleCode;", "getRequestedRoleCode", "()Ljava/lang/String;", "Ljava/lang/String;", "authorizedRoleCode", "getAuthorizedRoleCode", "customRoleCode", "getCustomRoleCode", "spaceport-common"})
@SourceDebugExtension(value={"SMAP\nRoles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Roles.kt\ncirclet/common/permissions/RolesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,415:1\n1202#2,2:416\n1230#2,4:418\n*S KotlinDebug\n*F\n+ 1 Roles.kt\ncirclet/common/permissions/RolesKt\n*L\n52#1:416,2\n52#1:418,4\n*E\n"})
public final class RolesKt {
    @NotNull
    private static final Lazy permissionContextTypeByCode$delegate = LazyKt.lazy(RolesKt::permissionContextTypeByCode_delegate$lambda$1);
    @NotNull
    private static final String requestedRoleCode = RoleCode.constructor-impl("Requested");
    @NotNull
    private static final String authorizedRoleCode = RoleCode.constructor-impl("Authorized");
    @NotNull
    private static final String customRoleCode = RoleCode.constructor-impl("Custom");

    @NotNull
    public static final PermissionRoleScope toObsoleteScope(@NotNull PermissionContextType $this$toObsoleteScope) {
        PermissionRoleScope permissionRoleScope;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toObsoleteScope), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toObsoleteScope.ordinal()]) {
            case 1: {
                permissionRoleScope = PermissionRoleScope.GLOBAL;
                break;
            }
            case 2: {
                permissionRoleScope = PermissionRoleScope.PROJECT;
                break;
            }
            case 3: {
                throw new IllegalStateException("can not transform channel context type".toString());
            }
            case 4: {
                throw new IllegalStateException("can not transform profile context type".toString());
            }
            case 5: {
                throw new IllegalStateException("can not transform team context type".toString());
            }
            case 6: {
                throw new IllegalStateException("can not transform document context type".toString());
            }
            case 7: {
                throw new IllegalStateException("can not transform folder context type".toString());
            }
            case 8: {
                throw new IllegalStateException("can not transform package repository context type".toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return permissionRoleScope;
    }

    private static final Map<String, PermissionContextType> getPermissionContextTypeByCode() {
        Lazy lazy = permissionContextTypeByCode$delegate;
        return (Map)lazy.getValue();
    }

    @Nullable
    public static final PermissionContextType parsePermissionContextTypeOrNull(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return RolesKt.getPermissionContextTypeByCode().get(code);
    }

    @NotNull
    public static final String getRequestedRoleCode() {
        return requestedRoleCode;
    }

    @NotNull
    public static final String getAuthorizedRoleCode() {
        return authorizedRoleCode;
    }

    @NotNull
    public static final String getCustomRoleCode() {
        return customRoleCode;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map permissionContextTypeByCode_delegate$lambda$1() {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = (Iterable)PermissionContextType.getEntries();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            PermissionContextType permissionContextType = (PermissionContextType)((Object)element$iv$iv);
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getCode(), element$iv$iv);
        }
        return destination$iv$iv;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PermissionContextType.values().length];
            try {
                nArray[PermissionContextType.GLOBAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionContextType.PROJECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionContextType.CHANNEL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionContextType.PROFILE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionContextType.TEAM.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionContextType.DOCUMENT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionContextType.DOCUMENT_FOLDER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionContextType.PACKAGE_REPOSITORY.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

