/*
 * Decompiled with CFR 0.152.
 */
package libraries.io.storage;

import java.nio.channels.ReadableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import libraries.io.channels.FileChannelsKt;
import libraries.io.channels.TemporaryFileReadableChannel;
import libraries.io.storage.Blob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u001a\u001a\u00020\u0001H\u0096@\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u001dH\u0096@\u00a2\u0006\u0002\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0014\u0010\u0015\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006\u001e"}, d2={"Llibraries/io/storage/FileBlob;", "Llibraries/io/storage/Blob;", "filePath", "Ljava/nio/file/Path;", "path", "", "createDate", "", "contentType", "temporary", "", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;Z)V", "getFilePath", "()Ljava/nio/file/Path;", "getPath", "()Ljava/lang/String;", "Ljava/lang/Long;", "getContentType", "name", "getName", "created", "getCreated", "()J", "length", "getLength", "copy", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getContent", "Ljava/nio/channels/ReadableByteChannel;", "libraries-io"})
public final class FileBlob
implements Blob {
    @NotNull
    private final Path filePath;
    @NotNull
    private final String path;
    @Nullable
    private final Long createDate;
    @NotNull
    private final String contentType;
    private final boolean temporary;

    public FileBlob(@NotNull Path filePath, @NotNull String path, @Nullable Long createDate, @NotNull String contentType, boolean temporary) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.filePath = filePath;
        this.path = path;
        this.createDate = createDate;
        this.contentType = contentType;
        this.temporary = temporary;
    }

    public /* synthetic */ FileBlob(Path path, String string, Long l, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = null;
        }
        if ((n & 8) != 0) {
            string2 = "application/octet-stream";
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(path, string, l, string2, bl);
    }

    @NotNull
    public final Path getFilePath() {
        return this.filePath;
    }

    @Override
    @NotNull
    public String getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public String getContentType() {
        return this.contentType;
    }

    @Override
    @NotNull
    public String getName() {
        return ((Object)this.filePath.getFileName()).toString();
    }

    @Override
    public long getCreated() {
        Long l = this.createDate;
        return l != null ? l.longValue() : Files.getLastModifiedTime(this.filePath, new LinkOption[0]).toInstant().getEpochSecond();
    }

    @Override
    public long getLength() {
        return Files.size(this.filePath);
    }

    @Override
    @Nullable
    public Object copy(@NotNull Continuation<? super Blob> $completion) {
        FileBlob $this$copy_u24lambda_u240 = this;
        boolean bl = false;
        Path filePathCopy = Files.createTempFile("FileBlob-", "-copy", new FileAttribute[0]);
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.copy($this$copy_u24lambda_u240.filePath, filePathCopy, copyOptionArray);
        Intrinsics.checkNotNull((Object)filePathCopy);
        return new FileBlob(filePathCopy, $this$copy_u24lambda_u240.getPath(), $this$copy_u24lambda_u240.createDate, $this$copy_u24lambda_u240.getContentType(), true);
    }

    @Override
    @Nullable
    public Object getContent(@NotNull Continuation<? super ReadableByteChannel> $completion) {
        return this.temporary ? (ReadableByteChannel)new TemporaryFileReadableChannel(this.filePath) : FileChannelsKt.readableChannel$default(this.filePath, 0L, 1, null);
    }
}

