/*
 * Decompiled with CFR 0.152.
 */
package libraries.klogging;

import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggerFactory;
import libraries.klogging.KLoggerStaticFactoryKt;
import libraries.klogging.ShutdownListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J!\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0012\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0014j\u0002`\u0013H\u0016\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Llibraries/klogging/KLoggerStaticFactory;", "Llibraries/klogging/KLoggerFactory;", "<init>", "()V", "shutdownListener", "Llibraries/klogging/ShutdownListener;", "customFactory", "getCustomFactory", "()Llibraries/klogging/KLoggerFactory;", "setCustomFactory", "(Llibraries/klogging/KLoggerFactory;)V", "logger", "Llibraries/klogging/KLogger;", "name", "", "owner", "", "Lkotlin/reflect/KClass;", "nameSource", "Llibraries/klogging/LoggerNameSource;", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Llibraries/klogging/KLogger;", "libraries-klogging"})
public final class KLoggerStaticFactory
implements KLoggerFactory {
    @NotNull
    public static final KLoggerStaticFactory INSTANCE = new KLoggerStaticFactory();
    @NotNull
    private static final ShutdownListener shutdownListener = ShutdownListener.INSTANCE;
    @Nullable
    private static KLoggerFactory customFactory;

    private KLoggerStaticFactory() {
    }

    @Nullable
    public final KLoggerFactory getCustomFactory() {
        return customFactory;
    }

    public final void setCustomFactory(@Nullable KLoggerFactory kLoggerFactory) {
        customFactory = kLoggerFactory;
    }

    @Override
    @NotNull
    public KLogger logger(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = customFactory;
        if (object == null || (object = object.logger(name)) == null) {
            object = KLoggerStaticFactoryKt.access$defaultLogger(name);
        }
        return object;
    }

    @Override
    @NotNull
    public KLogger logger(@NotNull Object owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Object object = customFactory;
        if (object == null || (object = object.logger(owner)) == null) {
            object = KLoggerStaticFactoryKt.access$defaultLogger(JvmClassMappingKt.getKotlinClass(owner.getClass()));
        }
        return object;
    }

    @Override
    @NotNull
    public KLogger logger(@NotNull KClass<?> owner) {
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        Object object = customFactory;
        if (object == null || (object = object.logger(owner)) == null) {
            object = KLoggerStaticFactoryKt.access$defaultLogger(owner);
        }
        return object;
    }

    @Override
    @NotNull
    public KLogger logger(@NotNull Function0<String> nameSource) {
        Intrinsics.checkNotNullParameter(nameSource, (String)"nameSource");
        Object object = customFactory;
        if (object == null || (object = object.logger(nameSource)) == null) {
            object = KLoggerStaticFactoryKt.access$defaultLogger(KLoggerStaticFactoryKt.loggerNameFromSource(nameSource));
        }
        return object;
    }
}

