/*
 * Decompiled with CFR 0.152.
 */
package runtime.stringUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import runtime.stringUtils.FullName;
import runtime.stringUtils.StringUtilsKt;
import runtime.stringUtils.UnicodeUtilKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0003\u001a\u0014\u0010\u0004\u001a\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u001a\f\u0010\b\u001a\u00020\u0003*\u00020\u0003H\u0002\u001a\u000e\u0010\t\u001a\u0004\u0018\u00010\u0003*\u00020\u0003H\u0002\u001a\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u0003*\u00020\u0003H\u0002\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0003H\u0002\u001a\f\u0010\u0011\u001a\u00020\u0003*\u00020\u0003H\u0002\u001a\u0014\u0010\u0012\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0002\u001a\f\u0010\u0014\u001a\u00020\u0010*\u00020\u0003H\u0002\u001a\f\u0010\u0015\u001a\u00020\u0010*\u00020\u0003H\u0002\"\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"extractFullNameFromEmail", "Lruntime/stringUtils/FullName;", "email", "", "parseFullName", "fullName", "words", "", "normalize", "takeIfSalutation", "sufficesMap", "", "prefixes", "", "takeIfSuffix", "isInitial", "", "fixCase", "safeUCFirst", "separator", "isMixedCase", "isCompoundLastName", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nFullNameUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullNameUtils.kt\nruntime/stringUtils/FullNameUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,203:1\n774#2:204\n865#2,2:205\n1557#2:207\n1628#2,3:208\n1202#2,2:214\n1230#2,4:216\n1#3:211\n1088#4,2:212\n*S KotlinDebug\n*F\n+ 1 FullNameUtils.kt\nruntime/stringUtils/FullNameUtilsKt\n*L\n45#1:204\n45#1:205,2\n106#1:207\n106#1:208,3\n145#1:214,2\n145#1:216,4\n194#1:212,2\n*E\n"})
public final class FullNameUtilsKt {
    @NotNull
    private static final Map<String, String> sufficesMap;
    @NotNull
    private static final Set<String> prefixes;

    @NotNull
    public static final FullName extractFullNameFromEmail(@NotNull String email) {
        List list2;
        char[] cArray;
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        String username = StringsKt.substringBefore$default((String)email, (char)'@', null, (int)2, null);
        if (StringsKt.contains$default((CharSequence)username, (char)'.', (boolean)false, (int)2, null)) {
            cArray = new char[]{'.'};
            list2 = StringsKt.split$default((CharSequence)username, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        } else {
            cArray = new char[]{'-'};
            list2 = StringUtilsKt.splitByCamelHumpsAndPunctuation(username, cArray);
        }
        List nameParts = list2;
        return FullNameUtilsKt.parseFullName(nameParts);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FullName parseFullName(@NotNull String fullName) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String string;
        Object object;
        Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
        int openIndex = StringsKt.indexOf$default((CharSequence)fullName, (char)'(', (int)0, (boolean)false, (int)6, null);
        int closeIndex = StringsKt.indexOf$default((CharSequence)fullName, (char)')', (int)0, (boolean)false, (int)6, null);
        if (openIndex >= 0 && closeIndex >= 0) {
            object = fullName;
            int n = closeIndex + 1;
            string = ((Object)StringsKt.removeRange((CharSequence)((CharSequence)object), (int)openIndex, (int)n)).toString();
        } else {
            string = fullName;
        }
        object = new char[1];
        object[0] = 32;
        object = StringsKt.split$default((CharSequence)string, (char[])object, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nameParts = (List)destination$iv$iv;
        return FullNameUtilsKt.parseFullName(nameParts);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FullName parseFullName(@NotNull List<String> words) {
        void it;
        String string;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(words, (String)"words");
        List nameParts = null;
        nameParts = words;
        if (nameParts.isEmpty()) {
            return FullName.Companion.getEMPTY();
        }
        String string2 = (String)CollectionsKt.firstOrNull(nameParts);
        String salutation = string2 != null ? FullNameUtilsKt.takeIfSalutation(string2) : null;
        nameParts = CollectionsKt.drop((Iterable)nameParts, (int)(salutation != null ? 1 : 0));
        String string3 = (String)CollectionsKt.lastOrNull((List)nameParts);
        String suffix = string3 != null ? FullNameUtilsKt.takeIfSuffix(string3) : null;
        nameParts = CollectionsKt.dropLast((List)nameParts, (int)(suffix != null ? 1 : 0));
        List firstName = new ArrayList();
        List initials = new ArrayList();
        String string4 = (String)CollectionsKt.firstOrNull((List)nameParts);
        if (string4 != null) {
            String firstNamePart = string4;
            boolean bl = false;
            if (FullNameUtilsKt.isInitial(firstNamePart)) {
                String string5 = (String)CollectionsKt.getOrNull((List)nameParts, (int)1);
                boolean bl2 = string5 != null ? FullNameUtilsKt.isInitial(string5) : false;
                if (bl2) {
                    Collection collection = firstName;
                    String string6 = firstNamePart.toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toUpperCase(...)");
                    collection.add(string6);
                } else {
                    Collection collection = initials;
                    String string7 = firstNamePart.toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toUpperCase(...)");
                    collection.add(string7);
                }
            } else {
                ((Collection)firstName).add(FullNameUtilsKt.fixCase(firstNamePart));
            }
            nameParts = CollectionsKt.drop((Iterable)nameParts, (int)1);
        }
        while (nameParts.size() > 1) {
            String word = (String)CollectionsKt.first((List)nameParts);
            if (FullNameUtilsKt.isCompoundLastName(word)) {
                if (!FullNameUtilsKt.isInitial(word)) break;
                String string8 = word.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toUpperCase(...)");
                if (!Intrinsics.areEqual((Object)word, (Object)string8)) break;
            }
            if (FullNameUtilsKt.isInitial(word)) {
                Collection collection = initials;
                String string9 = word.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toUpperCase(...)");
                collection.add(string9);
            } else {
                ((Collection)firstName).add(FullNameUtilsKt.fixCase(word));
            }
            nameParts = CollectionsKt.drop((Iterable)nameParts, (int)1);
        }
        Iterable $this$map$iv = nameParts;
        boolean $i$f$map22 = false;
        Iterable bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            String string10 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(FullNameUtilsKt.fixCase((String)it2));
        }
        List lastName = (List)destination$iv$iv;
        String $i$f$map22 = string = ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)initials, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null))).toString();
        String string11 = ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)firstName, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null))).toString();
        String string12 = salutation;
        boolean bl4 = false;
        boolean bl5 = ((CharSequence)it).length() > 0;
        String string13 = bl5 ? string : null;
        String string14 = suffix;
        String string15 = ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)lastName, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null))).toString();
        String string16 = string13;
        String string17 = string11;
        String string18 = string12;
        return new FullName(string18, string17, string16, string15, string14);
    }

    private static final String normalize(String $this$normalize) {
        String string = StringsKt.replace$default((String)$this$normalize, (String)".", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }

    private static final String takeIfSalutation(String $this$takeIfSalutation) {
        String string;
        switch (FullNameUtilsKt.normalize($this$takeIfSalutation)) {
            case "mr": 
            case "mister": 
            case "master": {
                string = "Mr.";
                break;
            }
            case "mrs": {
                string = "Mrs.";
                break;
            }
            case "ms": 
            case "miss": {
                string = "Ms.";
                break;
            }
            case "dr": {
                string = "Dr.";
                break;
            }
            case "rev": {
                string = "Rev.";
                break;
            }
            case "fr": {
                string = "Fr.";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    private static final String takeIfSuffix(String $this$takeIfSuffix) {
        String string = StringsKt.replace$default((String)$this$takeIfSuffix, (String)".", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String normalized = string;
        return sufficesMap.get(normalized);
    }

    private static final boolean isInitial(String $this$isInitial) {
        return FullNameUtilsKt.normalize($this$isInitial).length() == 1;
    }

    private static final String fixCase(String $this$fixCase) {
        return FullNameUtilsKt.safeUCFirst(FullNameUtilsKt.safeUCFirst($this$fixCase, "-"), ".");
    }

    private static final String safeUCFirst(String $this$safeUCFirst, String separator) {
        String[] stringArray = new String[]{separator};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)$this$safeUCFirst, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)separator, null, null, (int)0, null, FullNameUtilsKt::safeUCFirst$lambda$5, (int)30, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isMixedCase(String $this$isMixedCase) {
        char it;
        char element$iv;
        int n;
        boolean $i$f$any;
        CharSequence $this$any$iv;
        block5: {
            $this$any$iv = $this$isMixedCase;
            $i$f$any = false;
            n = 0;
            while (n < $this$any$iv.length()) {
                it = element$iv = $this$any$iv.charAt(n);
                boolean bl = false;
                if (!(UnicodeUtilKt.isAlpha(it) && UnicodeUtilKt.isUpperCase(it))) {
                    ++n;
                    continue;
                }
                break block5;
            }
            return false;
        }
        boolean bl = true;
        if (!bl) return false;
        $this$any$iv = $this$isMixedCase;
        $i$f$any = false;
        n = 0;
        while (n < $this$any$iv.length()) {
            it = element$iv = $this$any$iv.charAt(n);
            boolean bl2 = false;
            if (UnicodeUtilKt.isAlpha(it) && UnicodeUtilKt.isLowerCase(it)) {
                return true;
            }
            boolean bl3 = false;
            if (bl3) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static final boolean isCompoundLastName(String $this$isCompoundLastName) {
        String string = $this$isCompoundLastName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return prefixes.contains(string);
    }

    private static final CharSequence safeUCFirst$lambda$5(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FullNameUtilsKt.isMixedCase(it) ? (CharSequence)it : (CharSequence)StringsKt.capitalize((String)it);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        Object[] objectArray = new String[]{"I", "II", "III", "IV", "V", "Senior", "Junior", "Jr", "Sr", "PhD", "APR", "RPh", "PE", "MD", "MA", "DMD", "CME", "BVM", "CFRE", "CLU", "CPA", "CSC", "CSJ", "DC", "DD", "DDS", "DO", "DVM", "EdD", "Esq", "JD", "LLD", "OD", "OSB", "PC", "Ret", "RGS", "RN", "RNC", "SHCJ", "SJ", "SNJM", "SSMO", "USA", "USAF", "USAFR", "USAR", "USCG", "USMC", "USMCR", "USN", "USNR"};
        Iterable $this$associateBy$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            String string = (String)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            String string2 = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            map2.put(string2, element$iv$iv);
        }
        sufficesMap = destination$iv$iv;
        objectArray = new String[]{"vere", "von", "van", "de", "del", "della", "di", "da", "pietro", "vanden", "du", "st.", "st", "la", "lo", "ter", "o", "o", "mac", "fitz"};
        prefixes = SetsKt.setOf((Object[])objectArray);
    }
}

