/*
 * Decompiled with CFR 0.152.
 */
package runtime.system;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a8\u0006\n"}, d2={"Lruntime/system/JStack;", "", "<init>", "()V", "dumpThreads", "", "threadSelector", "Lkotlin/Function1;", "Ljava/lang/Thread;", "", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nJStack.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JStack.kt\nruntime/system/JStack\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,98:1\n8578#2,2:99\n8838#2,4:101\n*S KotlinDebug\n*F\n+ 1 JStack.kt\nruntime/system/JStack\n*L\n11#1:99,2\n11#1:101,4\n*E\n"})
public final class JStack {
    @NotNull
    public static final JStack INSTANCE = new JStack();

    private JStack() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String dumpThreads(@NotNull Function1<? super Thread, Boolean> threadSelector) {
        Object object;
        Intrinsics.checkNotNullParameter(threadSelector, (String)"threadSelector");
        StringBuilder $this$dumpThreads_u24lambda_u243 = new StringBuilder();
        boolean bl = false;
        try {
            ThreadMXBean bean = ManagementFactory.getThreadMXBean();
            ThreadInfo[] threadInfoArray = bean.dumpAllThreads(true, true);
            Intrinsics.checkNotNullExpressionValue((Object)threadInfoArray, (String)"dumpAllThreads(...)");
            Object[] $this$associateBy$iv = threadInfoArray;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
            Object[] object2 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : object2) {
                void it;
                ThreadInfo threadInfo = (ThreadInfo)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl2 = false;
                map2.put(it.getThreadId(), element$iv$iv);
            }
            object = destination$iv$iv;
        }
        catch (Throwable t) {
            object = MapsKt.emptyMap();
        }
        Map threadsInfos = object;
        Object $this$dumpThreads_u24lambda_u243_u24lambda_u242 = object = new StringBuilder();
        boolean bl3 = false;
        StringBuilder stringBuilder = ((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append("Full thread dump ").append(System.getProperty("java.vm.name")).append(" ").append(System.getProperty("java.vm.version")).append(" ").append(System.getProperty("java.vm.info"));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        Map<Thread, StackTraceElement[]> map3 = Thread.getAllStackTraces();
        Intrinsics.checkNotNullExpressionValue(map3, (String)"getAllStackTraces(...)");
        for (Map.Entry<Thread, StackTraceElement[]> entry : map3.entrySet()) {
            Object[] locks;
            StringBuilder stringBuilder2;
            ThreadInfo thInfo;
            ThreadGroup group;
            Thread thread = entry.getKey();
            Object[] stackTrace = entry.getValue();
            Intrinsics.checkNotNull((Object)thread);
            if (!((Boolean)threadSelector.invoke((Object)thread)).booleanValue()) continue;
            ((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append("\"" + thread.getName() + "\" ");
            if (thread.isDaemon()) {
                ((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append("daemon ");
            }
            if ((group = thread.getThreadGroup()) != null) {
                ((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append("group=\"" + group.getName() + "\" ");
            }
            ((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append("prio=" + thread.getPriority() + " ");
            ((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append("tid=" + thread.getId() + " ");
            ((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append("nid=" + thread.getId() + " ");
            Thread.State state = thread.getState();
            if (state == Thread.State.RUNNABLE) {
                ((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append("runnable ");
            }
            if (state == Thread.State.WAITING || state == Thread.State.TIMED_WAITING) {
                ((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append("waiting ");
            }
            if (state == Thread.State.BLOCKED) {
                ((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append("blocked ");
            }
            if ((thInfo = (ThreadInfo)threadsInfos.get(thread.getId())) != null) {
                if (thInfo.getLockName() != null) {
                    ((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append("on " + thInfo.getLockName());
                }
                if (thInfo.getLockOwnerName() != null) {
                    ((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append(" owned by \"").append(thInfo.getLockOwnerName()).append("\" Id=").append(thInfo.getLockOwnerId());
                }
                if (thInfo.isSuspended()) {
                    ((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append(" (suspended)");
                }
                if (thInfo.isInNative()) {
                    ((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append(" (in native)");
                }
                Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append('\n'), (String)"append(...)");
                StringBuilder stringBuilder3 = ((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append("   java.lang.Thread.State: " + state.name());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                StringBuilder stringBuilder4 = stringBuilder3.append('\n');
                stringBuilder2 = stringBuilder4;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            } else {
                StringBuilder stringBuilder5 = ((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append('\n');
                stringBuilder2 = stringBuilder5;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            }
            int i = -1;
            Iterator bl2 = ArrayIteratorKt.iterator((Object[])stackTrace);
            while (bl2.hasNext()) {
                Iterator iterator2;
                StackTraceElement ste = (StackTraceElement)bl2.next();
                ++i;
                Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append("\tat "), (String)"append(...)");
                StringBuilder stringBuilder6 = ((StringBuilder)((Object)iterator2)).append(ste.toString());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
                if (thInfo == null) continue;
                if (i == 0 && thInfo.getLockInfo() != null) {
                    Thread.State state2 = thInfo.getThreadState();
                    switch (state2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[state2.ordinal()]) {
                        case 1: {
                            StringBuilder stringBuilder7;
                            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append("\t\t-  blocked on "), (String)"append(...)");
                            StringBuilder stringBuilder8 = stringBuilder7.append(thInfo.getLockInfo());
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
                            StringBuilder stringBuilder9 = stringBuilder8.append('\n');
                            Object object2 = stringBuilder9;
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(...)");
                            break;
                        }
                        case 2: {
                            StringBuilder stringBuilder7;
                            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append("\t\t-  waiting on "), (String)"append(...)");
                            StringBuilder stringBuilder10 = stringBuilder7.append(thInfo.getLockInfo());
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(...)");
                            StringBuilder stringBuilder11 = stringBuilder10.append('\n');
                            Object object2 = stringBuilder11;
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(...)");
                            break;
                        }
                        case 3: {
                            StringBuilder stringBuilder7;
                            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append("\t\t-  waiting on "), (String)"append(...)");
                            StringBuilder stringBuilder12 = stringBuilder7.append(thInfo.getLockInfo());
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12, (String)"append(...)");
                            StringBuilder stringBuilder13 = stringBuilder12.append('\n');
                            Object object2 = stringBuilder13;
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13, (String)"append(...)");
                            break;
                        }
                        default: {
                            Object object2 = Unit.INSTANCE;
                        }
                    }
                }
                iterator2 = ArrayIteratorKt.iterator((Object[])thInfo.getLockedMonitors());
                while (iterator2.hasNext()) {
                    MonitorInfo mi = (MonitorInfo)iterator2.next();
                    if (mi.getLockedStackDepth() != i) continue;
                    StringBuilder stringBuilder14 = ((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append("\t-  locked ");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14, (String)"append(...)");
                    StringBuilder stringBuilder15 = stringBuilder14.append(mi);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15.append('\n'), (String)"append(...)");
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append('\n'), (String)"append(...)");
            if (thInfo == null || (locks = thInfo.getLockedSynchronizers()) == null || !(!(locks.length == 0))) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append('\n'), (String)"append(...)");
            StringBuilder stringBuilder16 = ((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append("  Locked ownable synchronizers:\n");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder16, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder16.append('\n'), (String)"append(...)");
            Iterator iterator3 = ArrayIteratorKt.iterator((Object[])locks);
            while (iterator3.hasNext()) {
                LockInfo lock = (LockInfo)iterator3.next();
                StringBuilder stringBuilder17 = ((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append("\t- " + lock);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder17, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder17.append('\n'), (String)"append(...)");
            }
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append('\n'), (String)"append(...)");
        }
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$dumpThreads_u24lambda_u243_u24lambda_u242).append('\n'), (String)"append(...)");
        String string = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String dumpThreads$default(JStack jStack, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = JStack::dumpThreads$lambda$0;
        }
        return jStack.dumpThreads((Function1<? super Thread, Boolean>)function1);
    }

    private static final boolean dumpThreads$lambda$0(Thread it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Thread.State.values().length];
            try {
                nArray[Thread.State.BLOCKED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Thread.State.WAITING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Thread.State.TIMED_WAITING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

