/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.nativecerts.mac;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.mac.CoreFoundation;
import com.sun.jna.ptr.PointerByReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.nativecerts.mac.CoreFoundationExt;

public interface SecurityFramework
extends Library {
    public static final SecurityFramework INSTANCE = (SecurityFramework)Native.load((String)"Security", SecurityFramework.class);
    public static final CoreFoundation.CFStringRef kSecClass = SecurityFramework.resolveStringConstant("kSecClass");
    public static final CoreFoundation.CFStringRef kSecMatchLimit = SecurityFramework.resolveStringConstant("kSecMatchLimit");
    public static final CoreFoundation.CFStringRef kSecMatchSearchList = SecurityFramework.resolveStringConstant("kSecMatchSearchList");
    public static final CoreFoundation.CFStringRef kSecMatchLimitAll = SecurityFramework.resolveStringConstant("kSecMatchLimitAll");
    public static final CoreFoundation.CFStringRef kSecReturnRef = SecurityFramework.resolveStringConstant("kSecReturnRef");
    public static final CoreFoundation.CFStringRef kSecClassCertificate = SecurityFramework.resolveStringConstant("kSecClassCertificate");
    public static final CoreFoundation.CFTypeID SEC_CERTIFICATE_TYPE_ID = INSTANCE.SecCertificateGetTypeID();
    public static final CoreFoundation.CFTypeID SEC_SEC_KEYCHAIN_REF_TYPE_ID = INSTANCE.SecKeychainGetTypeID();
    public static final CoreFoundation.CFTypeID SEC_POLICY_TYPE_ID = INSTANCE.SecPolicyGetTypeID();
    public static final CoreFoundation.CFTypeID SEC_TRUST_TYPE_ID = INSTANCE.SecTrustGetTypeID();
    public static final CoreFoundation.CFStringRef kSecPolicyAppleSSL = SecurityFramework.resolveStringConstant("kSecPolicyAppleSSL");
    public static final CoreFoundation.CFStringRef kSecPolicyOid = SecurityFramework.resolveStringConstant("kSecPolicyOid");
    public static final CoreFoundation.CFStringRef kSecTrustSettingsResult = CoreFoundation.CFStringRef.createCFString((String)"kSecTrustSettingsResult");
    public static final CoreFoundation.CFStringRef kSecTrustSettingsAllowedError = CoreFoundation.CFStringRef.createCFString((String)"kSecTrustSettingsAllowedError");
    public static final CoreFoundation.CFStringRef kSecTrustSettingsPolicyName = CoreFoundation.CFStringRef.createCFString((String)"kSecTrustSettingsPolicyName");
    public static final CoreFoundation.CFStringRef kSecTrustSettingsPolicy = CoreFoundation.CFStringRef.createCFString((String)"kSecTrustSettingsPolicy");

    @Nullable
    public CoreFoundation.CFStringRef SecCopyErrorMessageString(@NotNull OSStatus var1, @Nullable Pointer var2);

    @NotNull
    public OSStatus SecTrustSettingsCopyCertificates(@NotNull SecTrustSettingsDomain var1, @NotNull CoreFoundationExt.CFArrayRefByReference var2);

    @NotNull
    public OSStatus SecItemCopyMatching(@NotNull CoreFoundation.CFDictionaryRef var1, CoreFoundationExt.CFArrayRefByReference var2);

    public OSStatus SecKeychainOpen(String var1, SecKeychainRefByReference var2);

    @NotNull
    public OSStatus SecCertificateCopyCommonName(@NotNull SecCertificateRef var1, @NotNull CoreFoundationExt.CFStringRefByReference var2);

    public CoreFoundation.CFTypeID SecCertificateGetTypeID();

    public CoreFoundation.CFTypeID SecPolicyGetTypeID();

    public CoreFoundation.CFTypeID SecKeychainGetTypeID();

    public CoreFoundation.CFTypeID SecTrustGetTypeID();

    public SecPolicyRef SecPolicyCreateSSL(boolean var1, CoreFoundation.CFStringRef var2);

    public CoreFoundation.CFDictionaryRef SecPolicyCopyProperties(SecPolicyRef var1);

    public CoreFoundation.CFDataRef SecCertificateCopyData(SecCertificateRef var1);

    public OSStatus SecTrustSettingsCopyTrustSettings(SecCertificateRef var1, SecTrustSettingsDomain var2, CoreFoundationExt.CFArrayRefByReference var3);

    public OSStatus SecTrustCreateWithCertificates(CoreFoundation.CFArrayRef var1, SecPolicyRef var2, SecTrustRefByReference var3);

    public boolean SecTrustEvaluateWithError(SecTrustRef var1, Pointer var2);

    public OSStatus SecKeychainCopyDomainSearchList(SecTrustSettingsDomain var1, CoreFoundationExt.CFArrayRefByReference var2);

    private static CoreFoundation.CFStringRef resolveStringConstant(String name) {
        Pointer pointer = NativeLibrary.getInstance((String)"Security").getGlobalVariableAddress(name);
        return new CoreFoundation.CFStringRef(pointer.getPointer(0L));
    }

    public static class SecTrustSettingsDomain
    extends NativeLong {
        public static final SecTrustSettingsDomain user = new SecTrustSettingsDomain(0L);
        public static final SecTrustSettingsDomain admin = new SecTrustSettingsDomain(1L);
        public static final SecTrustSettingsDomain system = new SecTrustSettingsDomain(2L);

        public SecTrustSettingsDomain() {
        }

        public SecTrustSettingsDomain(long value) {
            super(value);
        }
    }

    public static class OSStatus
    extends NativeLong {
        public static final OSStatus errSecSuccess = new OSStatus(0L);
        public static final OSStatus errSecItemNotFound = new OSStatus(-25300L);
        public static final OSStatus errSecNoTrustSettings = new OSStatus(-25263L);

        public OSStatus() {
        }

        public OSStatus(long value) {
            super(value);
        }

        @NotNull
        public String getErrorMessageString() {
            CoreFoundation.CFStringRef string = INSTANCE.SecCopyErrorMessageString(this, Pointer.NULL);
            if (string == null) {
                return "OSStatus:" + this.longValue();
            }
            try {
                String string2 = string.stringValue();
                return string2;
            }
            finally {
                string.release();
            }
        }

        public boolean equals(Object rhs) {
            if (!(rhs instanceof OSStatus)) {
                return false;
            }
            return this.intValue() == ((OSStatus)((Object)rhs)).intValue();
        }

        public int hashCode() {
            return this.intValue();
        }

        public String toString() {
            return this.getErrorMessageString();
        }
    }

    public static class SecTrustSettingsResult
    extends NativeLong {
        public static final SecTrustSettingsResult kSecTrustSettingsResultInvalid = new SecTrustSettingsResult(0L);
        public static final SecTrustSettingsResult kSecTrustSettingsResultTrustRoot = new SecTrustSettingsResult(1L);
        public static final SecTrustSettingsResult kSecTrustSettingsResultTrustAsRoot = new SecTrustSettingsResult(2L);
        public static final SecTrustSettingsResult kSecTrustSettingsResultDeny = new SecTrustSettingsResult(3L);
        public static final SecTrustSettingsResult kSecTrustSettingsResultUnspecified = new SecTrustSettingsResult(4L);

        public SecTrustSettingsResult() {
        }

        public SecTrustSettingsResult(long value) {
            super(value);
        }
    }

    public static class SecTrustRefByReference
    extends PointerByReference {
        public SecTrustRefByReference() {
        }

        public SecTrustRefByReference(SecTrustRef value) {
            super(value.getPointer());
        }

        @Nullable
        public SecTrustRef getSecTrustRef() {
            Pointer value = super.getValue();
            if (value == null) {
                return null;
            }
            return new SecTrustRef(value);
        }
    }

    public static class SecTrustRef
    extends CoreFoundation.CFTypeRef {
        public SecTrustRef() {
        }

        public SecTrustRef(Pointer p) {
            super(p);
            if (!this.isTypeID(SEC_TRUST_TYPE_ID)) {
                throw new ClassCastException("Unable to cast to SecTrustRef. Type ID: " + this.getTypeID());
            }
        }
    }

    public static class SecPolicyRef
    extends CoreFoundation.CFTypeRef {
        public SecPolicyRef() {
        }

        public SecPolicyRef(Pointer p) {
            super(p);
            if (!this.isTypeID(SEC_POLICY_TYPE_ID)) {
                throw new ClassCastException("Unable to cast to SecPolicyRef. Type ID: " + this.getTypeID());
            }
        }
    }

    public static class SecKeychainRefByReference
    extends PointerByReference {
        public SecKeychainRefByReference() {
        }

        public SecKeychainRefByReference(SecKeychainRef value) {
            super(value.getPointer());
        }

        @Nullable
        public SecKeychainRef getSecKeychainRef() {
            Pointer value = super.getValue();
            if (value == null) {
                return null;
            }
            return new SecKeychainRef(value);
        }
    }

    public static class SecKeychainRef
    extends CoreFoundation.CFTypeRef {
        public SecKeychainRef() {
        }

        public SecKeychainRef(Pointer p) {
            super(p);
            if (!this.isTypeID(SEC_SEC_KEYCHAIN_REF_TYPE_ID)) {
                throw new ClassCastException("Unable to cast to SecCertificateRef. Type ID: " + this.getTypeID());
            }
        }
    }

    public static class SecCertificateRef
    extends CoreFoundation.CFTypeRef {
        public SecCertificateRef() {
        }

        public SecCertificateRef(Pointer p) {
            super(p);
            if (!this.isTypeID(SEC_CERTIFICATE_TYPE_ID)) {
                throw new ClassCastException("Unable to cast to SecCertificateRef. Type ID: " + this.getTypeID());
            }
        }
    }
}

