/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.backend;

import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.TerminalExecutorServiceManagerImpl;
import com.intellij.terminal.backend.BackendTerminalInputKt;
import com.intellij.terminal.backend.BackendTerminalSession;
import com.intellij.terminal.backend.BackendTerminalSessionImpl;
import com.intellij.terminal.backend.JediTermServices;
import com.intellij.terminal.backend.ObservableJediTerminal;
import com.intellij.terminal.backend.ObservableTtyConnector;
import com.intellij.terminal.backend.TerminalDisplayImpl;
import com.intellij.terminal.backend.TerminalOutputKt;
import com.intellij.terminal.backend.TerminalSessionStartKt;
import com.intellij.terminal.backend.TerminalShellIntegrationController;
import com.intellij.terminal.backend.TerminalShellIntegrationStatisticsListener;
import com.intellij.terminal.backend.TerminalStarterEx;
import com.intellij.terminal.session.TerminalInputEvent;
import com.intellij.terminal.session.TerminalOutputEvent;
import com.intellij.terminal.session.TerminalSessionTerminatedEvent;
import com.intellij.util.CoroutinesKt;
import com.jediterm.core.typeahead.TerminalTypeAheadManager;
import com.jediterm.core.typeahead.TypeAheadTerminalModel;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalDataStream;
import com.jediterm.terminal.TerminalExecutorServiceManager;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TtyBasedArrayDataStream;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.JediTermTypeAheadModel;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.settings.DefaultSettingsProvider;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import com.pty4j.PtyProcess;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.LocalBlockTerminalRunner;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.util.TerminalUtilKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H\u0000\u001a0\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"startTerminalProcess", "Lkotlin/Pair;", "Lcom/jediterm/terminal/TtyConnector;", "Lorg/jetbrains/plugins/terminal/ShellStartupOptions;", "project", "Lcom/intellij/openapi/project/Project;", "options", "createTerminalSession", "Lcom/intellij/terminal/backend/BackendTerminalSession;", "ttyConnector", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "createJediTermServices", "Lcom/intellij/terminal/backend/JediTermServices;", "connector", "Lcom/intellij/terminal/backend/ObservableTtyConnector;", "maxHistoryLinesCount", "", "startTerminalEmulation", "", "terminalStarter", "Lcom/jediterm/terminal/TerminalStarter;", "intellij.terminal.backend"})
public final class TerminalSessionStartKt {
    @NotNull
    public static final Pair<TtyConnector, ShellStartupOptions> startTerminalProcess(@NotNull Project project, @NotNull ShellStartupOptions options) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        LocalBlockTerminalRunner runner = new LocalBlockTerminalRunner(project);
        ShellStartupOptions shellStartupOptions = runner.configureStartupOptions(options);
        Intrinsics.checkNotNullExpressionValue((Object)shellStartupOptions, (String)"configureStartupOptions(...)");
        ShellStartupOptions configuredOptions = shellStartupOptions;
        PtyProcess ptyProcess = runner.createProcess(configuredOptions);
        Intrinsics.checkNotNullExpressionValue((Object)ptyProcess, (String)"createProcess(...)");
        PtyProcess process = ptyProcess;
        TtyConnector ttyConnector = runner.createTtyConnector(process);
        Intrinsics.checkNotNullExpressionValue((Object)ttyConnector, (String)"createTtyConnector(...)");
        TtyConnector connector = ttyConnector;
        return TuplesKt.to((Object)connector, (Object)configuredOptions);
    }

    @NotNull
    public static final BackendTerminalSession createTerminalSession(@NotNull Project project, @NotNull TtyConnector ttyConnector, @NotNull ShellStartupOptions options, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ttyConnector, (String)"ttyConnector");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        ObservableTtyConnector observableTtyConnector = ttyConnector instanceof ObservableTtyConnector ? (ObservableTtyConnector)ttyConnector : null;
        if (observableTtyConnector == null) {
            observableTtyConnector = new ObservableTtyConnector(ttyConnector);
        }
        ObservableTtyConnector observableTtyConnector2 = observableTtyConnector;
        int maxHistoryLinesCount = AdvancedSettings.Companion.getInt("terminal.buffer.max.lines.count");
        JediTermServices services = TerminalSessionStartKt.createJediTermServices(observableTtyConnector2, options, maxHistoryLinesCount, settings);
        CoroutineScope outputScope = CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)"Terminal output forwarding", null, (boolean)false, (int)6, null);
        TerminalShellIntegrationController shellIntegrationController = new TerminalShellIntegrationController((Terminal)services.getController());
        shellIntegrationController.addListener(new TerminalShellIntegrationStatisticsListener(project));
        MutableSharedFlow<List<TerminalOutputEvent>> outputFlow = TerminalOutputKt.createTerminalOutputFlow(services, shellIntegrationController, outputScope);
        CoroutineScope inputScope = CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)"Terminal input handling", null, (boolean)false, (int)6, null);
        SendChannel<TerminalInputEvent> inputChannel = BackendTerminalInputKt.createTerminalInputChannel(services, inputScope);
        services.getExecutorService().getUnboundedExecutorService().submit(() -> TerminalSessionStartKt.createTerminalSession$lambda$0(services, coroutineScope, outputFlow));
        CoroutinesKt.awaitCancellationAndInvoke$default((CoroutineScope)coroutineScope, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(services, null){
            int label;
            final /* synthetic */ JediTermServices $services;
            {
                this.$services = $services;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        TerminalStarterEx starter = this.$services.getTerminalStarter();
                        starter.close();
                        TtyConnector ttyConnector = starter.getTtyConnector();
                        Intrinsics.checkNotNullExpressionValue((Object)ttyConnector, (String)"getTtyConnector(...)");
                        TerminalUtilKt.waitFor(ttyConnector, TerminalUtilKt.STOP_EMULATOR_TIMEOUT, (Function0<Unit>)((Function0)() -> createTerminalSession.2.invokeSuspend$lambda$0(starter)));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(TerminalStarterEx $starter) {
                $starter.requestEmulatorStop();
                return Unit.INSTANCE;
            }
        }), (int)1, null);
        return new BackendTerminalSessionImpl(inputChannel, (Flow<? extends List<? extends TerminalOutputEvent>>)((Flow)FlowKt.asSharedFlow(outputFlow)), coroutineScope);
    }

    private static final JediTermServices createJediTermServices(ObservableTtyConnector connector, ShellStartupOptions options, int maxHistoryLinesCount, JBTerminalSystemSettingsProviderBase settings) {
        StyleState styleState = new StyleState();
        TermSize termSize = options.getInitialTermSize();
        if (termSize == null) {
            throw new IllegalStateException("Initial term size must be set".toString());
        }
        TermSize initialSize = termSize;
        TerminalTextBuffer textBuffer = new TerminalTextBuffer(initialSize.getColumns(), initialSize.getRows(), styleState, maxHistoryLinesCount);
        TerminalDisplayImpl terminalDisplay = new TerminalDisplayImpl((DefaultSettingsProvider)settings);
        ObservableJediTerminal controller = new ObservableJediTerminal(terminalDisplay, textBuffer, styleState);
        TerminalTypeAheadManager typeAheadManager = new TerminalTypeAheadManager((TypeAheadTerminalModel)new JediTermTypeAheadModel((Terminal)controller, textBuffer, (SettingsProvider)settings));
        TerminalExecutorServiceManagerImpl executorService = new TerminalExecutorServiceManagerImpl();
        TerminalStarterEx terminalStarter = new TerminalStarterEx(controller, connector, (TerminalDataStream)new TtyBasedArrayDataStream((TtyConnector)connector), typeAheadManager, (TerminalExecutorServiceManager)executorService);
        return new JediTermServices(textBuffer, terminalDisplay, controller, (TerminalExecutorServiceManager)executorService, terminalStarter, connector, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void startTerminalEmulation(TerminalStarter terminalStarter) {
        try {
            terminalStarter.start();
        }
        catch (Throwable t) {
            BackendTerminalSession.Companion.getLOG().error(t);
        }
        finally {
            try {
                terminalStarter.getTtyConnector().close();
            }
            catch (Throwable t) {
                BackendTerminalSession.Companion.getLOG().error("Error closing TtyConnector", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void createTerminalSession$lambda$0(JediTermServices $services, CoroutineScope $coroutineScope, MutableSharedFlow $outputFlow) {
        try {
            TerminalSessionStartKt.startTerminalEmulation($services.getTerminalStarter());
        }
        catch (Throwable throwable) {
            BuildersKt.launch$default((CoroutineScope)$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((MutableSharedFlow<List<TerminalOutputEvent>>)$outputFlow, $coroutineScope, null){
                int label;
                final /* synthetic */ MutableSharedFlow<List<TerminalOutputEvent>> $outputFlow;
                final /* synthetic */ CoroutineScope $coroutineScope;
                {
                    this.$outputFlow = $outputFlow;
                    this.$coroutineScope = $coroutineScope;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.$outputFlow.emit((Object)CollectionsKt.listOf((Object)TerminalSessionTerminatedEvent.INSTANCE), (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            Object object2;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                object2 = $result;
                                return Unit.INSTANCE;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.$coroutineScope, null, (int)1, null);
                            }
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            throw throwable;
        }
        BuildersKt.launch$default((CoroutineScope)$coroutineScope, null, null, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (int)3, null);
    }
}

