/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.terminal.frontend.TerminalSessionController;
import com.intellij.terminal.frontend.TerminalVfsSynchronizer;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.reworked.TerminalShellIntegrationEventsListener;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/terminal/frontend/TerminalVfsSynchronizer;", "", "<init>", "()V", "Companion", "intellij.terminal.frontend"})
public final class TerminalVfsSynchronizer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private TerminalVfsSynchronizer() {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\f\u001a\u00020\n\u00a8\u0006\r"}, d2={"Lcom/intellij/terminal/frontend/TerminalVfsSynchronizer$Companion;", "", "<init>", "()V", "install", "", "sessionController", "Lcom/intellij/terminal/frontend/TerminalSessionController;", "focusListenerRegistrar", "Lkotlin/Function2;", "Lcom/intellij/openapi/Disposable;", "Ljava/awt/event/FocusListener;", "parentDisposable", "intellij.terminal.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull TerminalSessionController sessionController, @NotNull Function2<? super Disposable, ? super FocusListener, Unit> focusListenerRegistrar, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)sessionController, (String)"sessionController");
            Intrinsics.checkNotNullParameter(focusListenerRegistrar, (String)"focusListenerRegistrar");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            sessionController.addShellIntegrationListener(parentDisposable, new TerminalShellIntegrationEventsListener(){

                public void commandFinished(String command2, int exitCode, String currentDirectory) {
                    Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
                    Intrinsics.checkNotNullParameter((Object)currentDirectory, (String)"currentDirectory");
                    SaveAndSyncHandler.Companion.getInstance().scheduleRefresh();
                }
            });
            focusListenerRegistrar.invoke((Object)parentDisposable, (Object)new FocusListener(){

                public void focusGained(FocusEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (GeneralSettings.Companion.getInstance().isSaveOnFrameDeactivation()) {
                        WriteIntentReadAction.run(install.2::focusGained$lambda$0);
                    }
                }

                public void focusLost(FocusEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (GeneralSettings.Companion.getInstance().isSyncOnFrameActivation()) {
                        SaveAndSyncHandler.Companion.getInstance().scheduleRefresh();
                    }
                }

                private static final void focusGained$lambda$0() {
                    FileDocumentManager.getInstance().saveAllDocuments();
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

