/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history.actions;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.ExtendableAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.formove.TriggerAdditionOrDeletion;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.ui.ReplaceFileConfirmationDialog;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.VcsActivity;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class GetVersionAction
extends ExtendableAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(GetVersionAction.class);
    private static final ExtensionPointName<AnActionExtensionProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.openapi.vcs.history.actions.GetVersionAction.ExtensionProvider");

    public GetVersionAction() {
        super(EP_NAME);
    }

    public static void doGet(@NotNull Project project, @NotNull VcsFileRevision revision, @NotNull FilePath filePath) {
        if (project == null) {
            GetVersionAction.$$$reportNull$$$0(0);
        }
        if (revision == null) {
            GetVersionAction.$$$reportNull$$$0(1);
        }
        if (filePath == null) {
            GetVersionAction.$$$reportNull$$$0(2);
        }
        String activityName = VcsBundle.message((String)"activity.name.get.from", (Object[])new Object[]{revision.getRevisionNumber()});
        GetVersionAction.doGet(project, activityName, Collections.singletonList(new VcsFileRevisionProvider(filePath, revision)), null);
    }

    public static void doGet(@NotNull Project project, @NlsContexts.Label @NotNull String activityName, @NotNull List<? extends FileRevisionProvider> providers, @Nullable Runnable onFinished) {
        List files;
        if (project == null) {
            GetVersionAction.$$$reportNull$$$0(3);
        }
        if (activityName == null) {
            GetVersionAction.$$$reportNull$$$0(4);
        }
        if (providers == null) {
            GetVersionAction.$$$reportNull$$$0(5);
        }
        if (!(files = ContainerUtil.mapNotNull(providers, it -> it.getFilePath().getVirtualFile())).isEmpty()) {
            ReplaceFileConfirmationDialog confirmationDialog = new ReplaceFileConfirmationDialog(project, VcsBundle.message((String)"acton.name.get.revision", (Object[])new Object[0]));
            if (!confirmationDialog.confirmFor(VfsUtilCore.toVirtualFileArray((Collection)files))) {
                return;
            }
            if (ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable((Collection)files).hasReadonlyFiles()) {
                return;
            }
        }
        new MyWriteVersionTask(project, activityName, providers, onFinished).queue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "revision";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "filePath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "activityName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "providers";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vcs/history/actions/GetVersionAction";
        objectArray[2] = "doGet";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class VcsFileRevisionProvider
    implements FileRevisionProvider {
        @NotNull
        private final FilePath myFilePath;
        @NotNull
        private final VcsFileRevision myRevision;

        private VcsFileRevisionProvider(@NotNull FilePath filePath, @NotNull VcsFileRevision revision) {
            if (filePath == null) {
                VcsFileRevisionProvider.$$$reportNull$$$0(0);
            }
            if (revision == null) {
                VcsFileRevisionProvider.$$$reportNull$$$0(1);
            }
            this.myFilePath = filePath;
            this.myRevision = revision;
        }

        @Override
        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = this.myFilePath;
            if (filePath == null) {
                VcsFileRevisionProvider.$$$reportNull$$$0(2);
            }
            return filePath;
        }

        @Override
        @Nullable
        public FileRevisionContent getContent() throws VcsException {
            try {
                byte[] bytes = VcsHistoryUtil.loadRevisionContent(this.myRevision);
                return new FileRevisionContent(bytes, null);
            }
            catch (IOException e) {
                throw new VcsException((Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/history/actions/GetVersionAction$VcsFileRevisionProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/history/actions/GetVersionAction$VcsFileRevisionProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyWriteVersionTask
    extends Task.Backgroundable {
        private final @NlsContexts.Label @NotNull String myActivityName;
        @NotNull
        private final List<? extends FileRevisionProvider> myProviders;
        @Nullable
        private final Runnable myOnFinished;

        MyWriteVersionTask(@NotNull Project project, @NlsContexts.Label @NotNull String activityName, @NotNull List<? extends FileRevisionProvider> providers, @Nullable Runnable onFinished) {
            if (project == null) {
                MyWriteVersionTask.$$$reportNull$$$0(0);
            }
            if (activityName == null) {
                MyWriteVersionTask.$$$reportNull$$$0(1);
            }
            if (providers == null) {
                MyWriteVersionTask.$$$reportNull$$$0(2);
            }
            super(project, VcsBundle.message((String)"show.diff.progress.title", (Object[])new Object[0]));
            this.myActivityName = activityName;
            this.myProviders = providers;
            this.myOnFinished = onFinished;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyWriteVersionTask.$$$reportNull$$$0(3);
            }
            LocalHistoryAction action = LocalHistory.getInstance().startAction(this.myActivityName, VcsActivity.Get);
            try {
                TriggerAdditionOrDeletion trigger = new TriggerAdditionOrDeletion(this.myProject);
                Object commandGroup = new Object();
                for (FileRevisionProvider fileRevisionProvider : this.myProviders) {
                    FilePath localFilePath = fileRevisionProvider.getFilePath();
                    FileRevisionContent revisionContent = fileRevisionProvider.getContent();
                    Ref exRef = new Ref();
                    ApplicationManager.getApplication().invokeAndWait(() -> {
                        try {
                            CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
                                VirtualFile virtualFile = localFilePath.getVirtualFile();
                                if (revisionContent == null && virtualFile == null) {
                                    return;
                                }
                                if (revisionContent == null) {
                                    trigger.prepare(Collections.emptyList(), Collections.singletonList(localFilePath));
                                } else if (virtualFile == null) {
                                    trigger.prepare(Collections.singletonList(localFilePath), Collections.emptyList());
                                }
                                ApplicationManager.getApplication().runWriteAction(() -> {
                                    try {
                                        if (revisionContent == null) {
                                            MyWriteVersionTask.writeDeletion(virtualFile);
                                        } else if (virtualFile == null) {
                                            FilePath path = (FilePath)ObjectUtils.chooseNotNull((Object)revisionContent.oldFilePath, (Object)localFilePath);
                                            MyWriteVersionTask.writeCreation(path, revisionContent.bytes);
                                        } else {
                                            if (revisionContent.oldFilePath != null && !localFilePath.equals(revisionContent.oldFilePath)) {
                                                MyWriteVersionTask.writeRename(virtualFile, revisionContent.oldFilePath);
                                            }
                                            MyWriteVersionTask.writeModification(virtualFile, revisionContent.bytes);
                                        }
                                    }
                                    catch (IOException e) {
                                        exRef.set((Object)e);
                                    }
                                });
                            }, VcsBundle.message((String)"message.title.get.version", (Object[])new Object[0]), commandGroup);
                        }
                        finally {
                            trigger.cleanup();
                        }
                    });
                    if (exRef.isNull()) continue;
                    throw (IOException)exRef.get();
                }
                trigger.processIt();
            }
            catch (IOException e) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((String)VcsBundle.message((String)"message.text.cannot.save.content", (Object[])new Object[]{e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.get.revision.content", (Object[])new Object[0]), (Icon)Messages.getErrorIcon()));
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
                ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((String)VcsBundle.message((String)"message.text.cannot.load.revision", (Object[])new Object[]{e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.get.revision.content", (Object[])new Object[0]), (Icon)Messages.getInformationIcon()));
            }
            finally {
                action.finish();
            }
        }

        private static void writeDeletion(@NotNull VirtualFile virtualFile) throws IOException {
            if (virtualFile == null) {
                MyWriteVersionTask.$$$reportNull$$$0(4);
            }
            virtualFile.delete(MyWriteVersionTask.class);
        }

        private static void writeCreation(@NotNull FilePath filePath, byte @NotNull [] revisionContent) throws IOException {
            FilePath parentPath;
            VirtualFile parent;
            if (filePath == null) {
                MyWriteVersionTask.$$$reportNull$$$0(5);
            }
            if (revisionContent == null) {
                MyWriteVersionTask.$$$reportNull$$$0(6);
            }
            if ((parent = VfsUtil.createDirectories((String)(parentPath = Objects.requireNonNull(filePath.getParentPath())).getPath())) == null) {
                throw new IOException("Can't create directory: " + String.valueOf(parentPath));
            }
            VirtualFile virtualFile = parent.createChildData(MyWriteVersionTask.class, filePath.getName());
            virtualFile.setBinaryContent(revisionContent);
        }

        private static void writeModification(@NotNull VirtualFile virtualFile, byte @NotNull [] revisionContent) throws IOException {
            if (virtualFile == null) {
                MyWriteVersionTask.$$$reportNull$$$0(7);
            }
            if (revisionContent == null) {
                MyWriteVersionTask.$$$reportNull$$$0(8);
            }
            virtualFile.setBinaryContent(revisionContent);
            FileDocumentManager.getInstance().reloadFiles(new VirtualFile[]{virtualFile});
        }

        private static void writeRename(@NotNull VirtualFile virtualFile, @NotNull FilePath filePath) throws IOException {
            VirtualFile parentFile;
            FilePath parentPath;
            if (virtualFile == null) {
                MyWriteVersionTask.$$$reportNull$$$0(9);
            }
            if (filePath == null) {
                MyWriteVersionTask.$$$reportNull$$$0(10);
            }
            if ((parentPath = filePath.getParentPath()) != null && (parentFile = VfsUtil.createDirectories((String)parentPath.getPath())) != null && !parentFile.equals(virtualFile.getParent())) {
                virtualFile.move(MyWriteVersionTask.class, parentFile);
            }
            if (!virtualFile.getName().equals(filePath.getName())) {
                virtualFile.rename(MyWriteVersionTask.class, filePath.getName());
            }
        }

        public void onFinished() {
            if (this.myOnFinished != null) {
                this.myOnFinished.run();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "activityName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "providers";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 4: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
                case 5: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revisionContent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/history/actions/GetVersionAction$MyWriteVersionTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeDeletion";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeCreation";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeModification";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeRename";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface FileRevisionProvider {
        @NotNull
        public FilePath getFilePath();

        @Nullable
        public FileRevisionContent getContent() throws VcsException;
    }

    public static class FileRevisionContent {
        public final byte @NotNull [] bytes;
        @Nullable
        public final FilePath oldFilePath;

        public FileRevisionContent(byte @NotNull [] bytes, @Nullable FilePath oldFilePath) {
            if (bytes == null) {
                FileRevisionContent.$$$reportNull$$$0(0);
            }
            this.bytes = bytes;
            this.oldFilePath = oldFilePath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/vcs/history/actions/GetVersionAction$FileRevisionContent", "<init>"));
        }
    }
}

