/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.core.services;

import com.intellij.ui.JBColor;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBCachingScalableIcon;
import com.intellij.util.ui.JBScalableIcon;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J,\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0000H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/station/core/services/ModelIcon;", "Lcom/intellij/util/ui/JBCachingScalableIcon;", "dark", "Ljavax/swing/Icon;", "light", "<init>", "(Ljavax/swing/Icon;Ljavax/swing/Icon;)V", "getDark", "()Ljavax/swing/Icon;", "getLight", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "", "y", "getIconWidth", "getIconHeight", "copy", "intellij.station.core"})
final class ModelIcon
extends JBCachingScalableIcon<ModelIcon> {
    @NotNull
    private final Icon dark;
    @NotNull
    private final Icon light;

    public ModelIcon(@NotNull Icon dark, @NotNull Icon light) {
        Intrinsics.checkNotNullParameter((Object)dark, (String)"dark");
        Intrinsics.checkNotNullParameter((Object)light, (String)"light");
        this.dark = dark;
        this.light = light;
    }

    @NotNull
    public final Icon getDark() {
        return this.dark;
    }

    @NotNull
    public final Icon getLight() {
        return this.light;
    }

    public void paintIcon(@Nullable Component c, @Nullable Graphics g, int x, int y) {
        Icon icon = JBColor.isBright() ? this.light : this.dark;
        Icon scaledIcon = IconUtil.scale((Icon)icon, (Component)c, (float)this.getScale());
        scaledIcon.paintIcon(c, g, x, y);
    }

    public int getIconWidth() {
        int width = Math.max(this.dark.getIconWidth(), this.light.getIconWidth());
        return (int)this.scaleVal(width);
    }

    public int getIconHeight() {
        int height = Math.max(this.dark.getIconHeight(), this.light.getIconHeight());
        return (int)this.scaleVal(height);
    }

    @NotNull
    public ModelIcon copy() {
        ModelIcon copy = new ModelIcon(this.dark, this.light);
        copy.updateContextFrom((JBScalableIcon)this);
        return copy;
    }
}

