/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.recentFiles.backend;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.platform.recentFiles.backend.BackendRecentFileEventsController;
import com.intellij.platform.recentFiles.backend.RecentFilesVfsListener;
import com.intellij.platform.recentFiles.shared.FileChangeKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/recentFiles/backend/RecentFilesVfsListener;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "<init>", "()V", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "filterProjectFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "files", "project", "Lcom/intellij/openapi/project/Project;", "collectRenamedFiles", "collectMovedFiles", "collectRemovedFiles", "collectFilesWithChangedContents", "intellij.platform.recentFiles.backend"})
@SourceDebugExtension(value={"SMAP\nRecentFilesVfsListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentFilesVfsListener.kt\ncom/intellij/platform/recentFiles/backend/RecentFilesVfsListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n774#2:83\n865#2,2:84\n808#2,11:86\n774#2:97\n865#2,2:98\n1563#2:100\n1634#2,3:101\n808#2,11:104\n1563#2:115\n1634#2,3:116\n808#2,11:119\n1563#2:130\n1634#2,3:131\n808#2,11:134\n1563#2:145\n1634#2,3:146\n*S KotlinDebug\n*F\n+ 1 RecentFilesVfsListener.kt\ncom/intellij/platform/recentFiles/backend/RecentFilesVfsListener\n*L\n57#1:83\n57#1:84,2\n63#1:86,11\n64#1:97\n64#1:98,2\n65#1:100\n65#1:101,3\n69#1:104,11\n70#1:115\n70#1:116,3\n74#1:119,11\n75#1:130\n75#1:131,3\n79#1:134,11\n80#1:145\n80#1:146,3\n*E\n"})
public final class RecentFilesVfsListener
implements AsyncFileListener {
    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        List<VirtualFile> removedFiles = this.collectRemovedFiles(events);
        List<VirtualFile> movedFiles = this.collectMovedFiles(events);
        List<VirtualFile> renamedFiles = this.collectRenamedFiles(events);
        List<VirtualFile> filesWithChangedContents = this.collectFilesWithChangedContents(events);
        return new AsyncFileListener.ChangeApplier(this, removedFiles, renamedFiles, movedFiles, filesWithChangedContents){
            final /* synthetic */ RecentFilesVfsListener this$0;
            final /* synthetic */ List<VirtualFile> $removedFiles;
            final /* synthetic */ List<VirtualFile> $renamedFiles;
            final /* synthetic */ List<VirtualFile> $movedFiles;
            final /* synthetic */ List<VirtualFile> $filesWithChangedContents;
            {
                this.this$0 = $receiver;
                this.$removedFiles = $removedFiles;
                this.$renamedFiles = $renamedFiles;
                this.$movedFiles = $movedFiles;
                this.$filesWithChangedContents = $filesWithChangedContents;
            }

            /*
             * WARNING - void declaration
             */
            public void beforeVfsChange() {
                for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                    void $this$trace$iv;
                    List projectFilesWithChangedContents;
                    List projectFilesToMove;
                    List projectFilesToUpdate;
                    List projectFilesToRename;
                    void var13_17;
                    Intrinsics.checkNotNull((Object)project);
                    Project project2 = project;
                    List projectFilesToRemove = RecentFilesVfsListener.access$filterProjectFiles(this.this$0, this.$removedFiles, project2);
                    if (!((Collection)projectFilesToRemove).isEmpty()) {
                        void $this$trace$iv2;
                        prepareChange.1 $this$thisLogger$iv = this;
                        boolean $i$f$thisLogger = false;
                        Logger logger = Logger.getInstance(prepareChange.1.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        $this$thisLogger$iv = logger;
                        boolean $i$f$trace = false;
                        if ($this$trace$iv2.isTraceEnabled()) {
                            var13_17 = $this$trace$iv2;
                            boolean bl = false;
                            var13_17.trace("Removed files to apply changes for: " + CollectionsKt.joinToString$default((Iterable)projectFilesToRemove, null, null, null, (int)0, null, prepareChange.1::beforeVfsChange$lambda$1$lambda$0, (int)31, null));
                        }
                        BackendRecentFileEventsController.INSTANCE.applyRelevantEventsToModel(projectFilesToRemove, FileChangeKind.REMOVED, project2);
                    }
                    if (!((Collection)(projectFilesToRename = RecentFilesVfsListener.access$filterProjectFiles(this.this$0, this.$renamedFiles, project2))).isEmpty()) {
                        void $this$trace$iv3;
                        prepareChange.1 $this$thisLogger$iv = this;
                        boolean $i$f$thisLogger = false;
                        Logger logger = Logger.getInstance(prepareChange.1.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        $this$thisLogger$iv = logger;
                        boolean $i$f$trace = false;
                        if ($this$trace$iv3.isTraceEnabled()) {
                            var13_17 = $this$trace$iv3;
                            boolean bl = false;
                            var13_17.trace("Renamed files to apply changes for: " + CollectionsKt.joinToString$default((Iterable)projectFilesToRename, null, null, null, (int)0, null, prepareChange.1::beforeVfsChange$lambda$3$lambda$2, (int)31, null));
                        }
                        BackendRecentFileEventsController.INSTANCE.applyRelevantEventsToModel(projectFilesToRename, FileChangeKind.ADDED, project2);
                    }
                    if (!(!((Collection)(projectFilesToUpdate = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)(projectFilesToMove = RecentFilesVfsListener.access$filterProjectFiles(this.this$0, this.$movedFiles, project2)), (Iterable)(projectFilesWithChangedContents = RecentFilesVfsListener.access$filterProjectFiles(this.this$0, this.$filesWithChangedContents, project2)))))).isEmpty())) continue;
                    prepareChange.1 $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(prepareChange.1.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    $this$thisLogger$iv = logger;
                    boolean $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        var13_17 = $this$trace$iv;
                        boolean bl = false;
                        var13_17.trace("Moved files to apply changes for: " + CollectionsKt.joinToString$default((Iterable)projectFilesToMove, null, null, null, (int)0, null, prepareChange.1::beforeVfsChange$lambda$5$lambda$4, (int)31, null));
                    }
                    $this$thisLogger$iv = this;
                    $i$f$thisLogger = false;
                    Logger logger2 = Logger.getInstance(prepareChange.1.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                    $this$thisLogger$iv = logger2;
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        var13_17 = $this$trace$iv;
                        boolean bl = false;
                        var13_17.trace("Changed content files to apply changes for: " + CollectionsKt.joinToString$default((Iterable)projectFilesWithChangedContents, null, null, null, (int)0, null, prepareChange.1::beforeVfsChange$lambda$7$lambda$6, (int)31, null));
                    }
                    BackendRecentFileEventsController.INSTANCE.applyRelevantEventsToModel(projectFilesToUpdate, FileChangeKind.UPDATED, project2);
                }
            }

            private static final CharSequence beforeVfsChange$lambda$1$lambda$0(VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                return string;
            }

            private static final CharSequence beforeVfsChange$lambda$3$lambda$2(VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                return string;
            }

            private static final CharSequence beforeVfsChange$lambda$5$lambda$4(VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                return string;
            }

            private static final CharSequence beforeVfsChange$lambda$7$lambda$6(VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                return string;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> filterProjectFiles(List<? extends VirtualFile> files, Project project) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = files;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile file = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(VirtualFileUtil.isFile((VirtualFile)file) && file.isValid() && ProjectFileIndex.getInstance((Project)project).isInContent(file))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> collectRenamedFiles(List<? extends VFileEvent> events) {
        void $this$mapTo$iv$iv;
        VFilePropertyChangeEvent it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = events;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof VFilePropertyChangeEvent)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (VFilePropertyChangeEvent)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getPropertyName(), (Object)"name")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (VFilePropertyChangeEvent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFile());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> collectMovedFiles(List<? extends VFileEvent> events) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = events;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof VFileMoveEvent)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VFileMoveEvent vFileMoveEvent = (VFileMoveEvent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFile());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> collectRemovedFiles(List<? extends VFileEvent> events) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = events;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof VFileDeleteEvent)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VFileDeleteEvent vFileDeleteEvent = (VFileDeleteEvent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFile());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> collectFilesWithChangedContents(List<? extends VFileEvent> events) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = events;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof VFileContentChangeEvent)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VFileContentChangeEvent vFileContentChangeEvent = (VFileContentChangeEvent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFile());
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ List access$filterProjectFiles(RecentFilesVfsListener $this, List files, Project project) {
        return $this.filterProjectFiles(files, project);
    }
}

