/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.spell;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.tokenizer.Tokenizer;
import ai.grazie.nlp.tokenizer.word.HeuristicWordTokenizer;
import ai.grazie.nlp.utils.Symbols;
import ai.grazie.spell.Speller;
import ai.grazie.spell.dictionary.RuleDictionary;
import ai.grazie.spell.language.LanguageModel;
import ai.grazie.spell.lists.WordListWithFrequency;
import ai.grazie.spell.suggestion.filter.SuggestionFilter;
import ai.grazie.spell.suggestion.ranker.SuggestionRanker;
import ai.grazie.spell.utils.UtilsKt;
import ai.grazie.utils.TextKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u0000 +2\u00020\u0001:\u0005+,-./B\u0019\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0002J0\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u001a\u001a\u00020\rH\u0002J \u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\rH\u0016J\u0018\u0010 \u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J0\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u00142\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010#\u001a\u00020\rH\u0002J0\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u00142\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010#\u001a\u00020\rH\u0002J0\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u00142\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010#\u001a\u00020\rH\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\r2\u0006\u0010#\u001a\u00020\rH\u0002J0\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u00142\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010#\u001a\u00020\rH\u0002J0\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u00142\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010#\u001a\u00020\rH\u0002J0\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u00142\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010#\u001a\u00020\rH\u0002J$\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lai/grazie/spell/GrazieSpeller;", "Lai/grazie/spell/Speller;", "model", "Lai/grazie/spell/language/LanguageModel;", "tokenizer", "Lai/grazie/nlp/tokenizer/Tokenizer;", "(Lai/grazie/spell/language/LanguageModel;Lai/grazie/nlp/tokenizer/Tokenizer;)V", "config", "Lai/grazie/spell/GrazieSpeller$UserConfig;", "(Lai/grazie/spell/GrazieSpeller$UserConfig;)V", "areStringsEqualWithExtra", "", "s1", "", "s2", "extra", "differBySwappingAdjacent", "str1", "str2", "filter", "", "", "suggested", "max", "", "getSuggestionsWithWeights", "word", "hasApEnding", "dictionary", "Lai/grazie/spell/lists/WordListWithFrequency;", "caseSensitive", "isAlien", "isMisspelled", "preferCompoundSuggestions", "suggestScores", "wordText", "preferCorrectPluralSuggestions", "preferGeminateSuggestions", "preferNormalizedForm", "preferOneSilentLetterSuggestions", "preferSameLengthSuggestions", "preferSuggestionsWithDiacritics", "suggestAndRank", "Companion", "EnglishVerbChecker", "GermanNumeralChecker", "GermanVerbChecker", "UserConfig", "gec-spell-engine-local"})
@SourceDebugExtension(value={"SMAP\nGrazieSpeller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieSpeller.kt\nai/grazie/spell/GrazieSpeller\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,397:1\n774#2:398\n865#2,2:399\n1246#2,4:403\n1246#2,4:409\n1246#2,4:415\n1246#2,4:421\n1246#2,4:427\n1246#2,4:433\n1246#2,4:447\n1062#2:451\n1279#2,2:452\n1293#2,4:454\n1557#2:458\n1628#2,3:459\n1279#2,2:462\n1293#2,4:464\n1279#2,2:468\n1293#2,4:470\n1062#2:474\n1062#2:475\n1062#2:476\n462#3:401\n412#3:402\n462#3:407\n412#3:408\n462#3:413\n412#3:414\n462#3:419\n412#3:420\n462#3:425\n412#3:426\n462#3:431\n412#3:432\n535#3:438\n520#3,6:439\n462#3:445\n412#3:446\n1#4:437\n*S KotlinDebug\n*F\n+ 1 GrazieSpeller.kt\nai/grazie/spell/GrazieSpeller\n*L\n207#1:398\n207#1:399,2\n213#1:403,4\n219#1:409,4\n229#1:415,4\n235#1:421,4\n259#1:427,4\n268#1:433,4\n282#1:447,4\n326#1:451\n333#1:452,2\n333#1:454,4\n341#1:458\n341#1:459,3\n341#1:462,2\n341#1:464,4\n351#1:468,2\n351#1:470,4\n353#1:474\n357#1:475\n373#1:476\n213#1:401\n213#1:402\n219#1:407\n219#1:408\n229#1:413\n229#1:414\n235#1:419\n235#1:420\n259#1:425\n259#1:426\n268#1:431\n268#1:432\n278#1:438\n278#1:439,6\n282#1:445\n282#1:446\n*E\n"})
public final class GrazieSpeller
implements Speller {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UserConfig config;
    public static final int PREFERRED_MAX_SUGGESTION_COUNT = 3;
    public static final int PREFERRED_MAX_RERANKING_CANDIDATES = 30;
    @NotNull
    private static final Regex sRegex = new Regex("[" + CollectionsKt.joinToString$default((Iterable)Symbols.INSTANCE.getApostrophes(), (CharSequence)"", null, null, (int)0, null, null, (int)62, null) + "]s$");
    @NotNull
    private static final Regex inRegex = new Regex("in[" + CollectionsKt.joinToString$default((Iterable)Symbols.INSTANCE.getApostrophes(), (CharSequence)"", null, null, (int)0, null, null, (int)62, null) + "]$");
    @NotNull
    private static final Regex geminatePattern = new Regex("([^s])\\1+");
    @NotNull
    private static final Regex schPattern = new Regex("(.+[^s])ch([^s].+)");
    @NotNull
    private static final Regex silentLetterPattern = new Regex("([aeiou\u00f6\u00e4\u00fc])h([aeiou\u00f6\u00e4\u00fc])");

    public GrazieSpeller(@NotNull UserConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    @JvmOverloads
    public GrazieSpeller(@NotNull LanguageModel model, @NotNull Tokenizer tokenizer) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        this(new UserConfig(model, tokenizer));
    }

    public /* synthetic */ GrazieSpeller(LanguageModel languageModel, Tokenizer tokenizer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            tokenizer = new HeuristicWordTokenizer(true, false);
        }
        this(languageModel, tokenizer);
    }

    @Override
    public boolean isMisspelled(@NotNull String word, boolean caseSensitive) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (this.config.getDictionary().getRules().check(word) == RuleDictionary.Result.CORRECT) {
            return false;
        }
        WordListWithFrequency dictionary = this.config.getDictionary().getDictionary();
        if (this.config.getLanguageModel().getLanguage() == Language.GERMAN && new GermanNumeralChecker().isComplexNumeral(word)) {
            return false;
        }
        if (this.config.getLanguageModel().getLanguage() == Language.GERMAN && new GermanVerbChecker(dictionary, caseSensitive).isVerb(word)) {
            return false;
        }
        if (this.config.getLanguageModel().getLanguage() == Language.ENGLISH && (this.hasApEnding(word, dictionary, caseSensitive) || new EnglishVerbChecker(dictionary, caseSensitive).isOldVerb(word))) {
            return false;
        }
        if (!dictionary.contains(word, caseSensitive)) {
            Object normalized;
            Object object = this.config.getLanguageModel().getNormalizer();
            if (object == null || (object = object.normalize(word)) == null) {
                object = word;
            }
            if (Intrinsics.areEqual((Object)(normalized = object), (Object)word) || !dictionary.contains((String)normalized, caseSensitive)) {
                return true;
            }
        }
        return false;
    }

    private final boolean hasApEnding(String word, WordListWithFrequency dictionary, boolean caseSensitive) {
        CharSequence charSequence = word;
        Regex regex = sRegex;
        String string2 = "";
        charSequence = regex.replace(charSequence, string2);
        regex = inRegex;
        string2 = "ing";
        return dictionary.contains(regex.replace(charSequence, string2), caseSensitive);
    }

    private final String preferNormalizedForm(String wordText) {
        String string2 = wordText.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String lowercased = string2;
        char[] cArray = wordText.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        if (Character.isUpperCase(ArraysKt.first((char[])cArray)) && !this.isMisspelled(TextKt.capitalize(lowercased), true)) {
            return TextKt.capitalize(lowercased);
        }
        return !this.isMisspelled(lowercased, true) ? lowercased : null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean differBySwappingAdjacent(String str1, String str2) {
        void $this$filterTo$iv$iv;
        if (str1.length() != str2.length()) {
            return false;
        }
        Iterable $this$filter$iv = (Iterable)StringsKt.getIndices((CharSequence)str1);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(str1.charAt(it) != str2.charAt(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List diffIndices = (List)destination$iv$iv;
        return diffIndices.size() == 2 && ((Number)diffIndices.get(1)).intValue() - ((Number)diffIndices.get(0)).intValue() == 1 && str1.charAt(((Number)diffIndices.get(0)).intValue()) == str2.charAt(((Number)diffIndices.get(1)).intValue()) && str1.charAt(((Number)diffIndices.get(1)).intValue()) == str2.charAt(((Number)diffIndices.get(0)).intValue());
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Double> preferSameLengthSuggestions(Map<String, Double> suggestScores, String wordText) {
        void $this$mapValuesTo$iv$iv;
        if (wordText.length() < 15) {
            return suggestScores;
        }
        Map<String, Double> $this$mapValues$iv = suggestScores;
        boolean $i$f$mapValues = false;
        Map<String, Double> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Double d = this.differBySwappingAdjacent((String)it.getKey(), wordText) ? ((Number)it.getValue()).doubleValue() * 1.5 : ((Number)it.getValue()).doubleValue();
            map3.put(k, d);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Double> preferOneSilentLetterSuggestions(Map<String, Double> suggestScores, String wordText) {
        void $this$mapValuesTo$iv$iv;
        Map<String, Double> $this$mapValues$iv = suggestScores;
        boolean $i$f$mapValues = false;
        Map<String, Double> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            CharSequence charSequence = (CharSequence)it.getKey();
            Object object = silentLetterPattern;
            String string2 = "$1$2";
            String ff = object.replace(charSequence, string2);
            object = wordText;
            string2 = silentLetterPattern;
            String string3 = "$1$2";
            String pp = string2.replace((CharSequence)object, string3);
            Double d = Math.abs(((String)it.getKey()).length() - wordText.length()) == 1 && (ff.equals(wordText) || pp.equals(it.getKey())) ? ((Number)it.getValue()).doubleValue() * 1.2 : ((Number)it.getValue()).doubleValue();
            map3.put(k, d);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Double> preferCorrectPluralSuggestions(Map<String, Double> suggestScores, String wordText) {
        void $this$mapValuesTo$iv$iv;
        if (wordText.length() < 5 || !TextKt.isCapitalized(wordText) || !StringsKt.endsWith$default((String)wordText, (String)"e", (boolean)false, (int)2, null)) {
            return suggestScores;
        }
        Map<String, Double> $this$mapValues$iv = suggestScores;
        boolean $i$f$mapValues = false;
        Map<String, Double> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Double d = ((String)it.getKey()).equals(wordText + "n") ? ((Number)it.getValue()).doubleValue() * 1.5 : ((Number)it.getValue()).doubleValue();
            map3.put(k, d);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Double> preferGeminateSuggestions(Map<String, Double> suggestScores, String wordText) {
        void $this$mapValuesTo$iv$iv;
        Map<String, Double> $this$mapValues$iv = suggestScores;
        boolean $i$f$mapValues = false;
        Map<String, Double> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            String string2;
            void it;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Regex regex = geminatePattern;
            CharSequence charSequence = (CharSequence)it.getKey();
            Double d = regex.replace(charSequence, string2 = "$1").equals(wordText) || (regex = geminatePattern).replace(charSequence = (CharSequence)wordText, string2 = "$1").equals(it.getKey()) ? ((Number)it.getValue()).doubleValue() * 1.2 : ((Number)it.getValue()).doubleValue();
            map3.put(k, d);
        }
        return destination$iv$iv;
    }

    private final boolean areStringsEqualWithExtra(String s1, String s2, String extra) {
        if (s1.length() < 8 || s2.length() < 8) {
            return false;
        }
        String prefix = StringsKt.commonPrefixWith$default((CharSequence)s1, (CharSequence)s2, (boolean)false, (int)2, null);
        String suffix = StringsKt.commonSuffixWith$default((CharSequence)s1, (CharSequence)s2, (boolean)false, (int)2, null);
        if (prefix.length() < 3 || suffix.length() < 4) {
            return false;
        }
        String noExtra = prefix + suffix;
        String withExtra = prefix + extra + suffix;
        if (this.isMisspelled(prefix, false) && this.isMisspelled(prefix + extra, false) || this.isMisspelled(TextKt.capitalize(suffix), false)) {
            return false;
        }
        return Intrinsics.areEqual((Object)s1, (Object)noExtra) && Intrinsics.areEqual((Object)s2, (Object)withExtra) || Intrinsics.areEqual((Object)s1, (Object)withExtra) && Intrinsics.areEqual((Object)s2, (Object)noExtra);
    }

    private final Map<String, Double> preferCompoundSuggestions(Map<String, Double> suggestScores, String wordText) {
        Double d;
        Map.Entry it;
        Map map;
        Object k;
        Map.Entry it$iv$iv;
        boolean bl;
        Map map2;
        Map<String, Double> $this$mapValuesTo$iv$iv;
        boolean flag = false;
        Map<String, Double> $this$mapValues$iv = suggestScores;
        boolean $i$f$mapValues = false;
        Map<String, Double> map3 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            double d2;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            bl = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            map = map2;
            boolean bl2 = false;
            if (this.areStringsEqualWithExtra((String)it.getKey(), wordText, "s") || this.areStringsEqualWithExtra((String)it.getKey(), wordText, "en")) {
                flag = true;
                d2 = ((Number)it.getValue()).doubleValue() * 1.35;
            } else {
                d2 = ((Number)it.getValue()).doubleValue();
            }
            d = d2;
            map.put(k, d);
        }
        Map newScores = destination$iv$iv;
        if (flag) {
            return newScores;
        }
        $this$mapValues$iv = suggestScores;
        $i$f$mapValues = false;
        $this$mapValuesTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            String string2;
            CharSequence charSequence;
            Regex regex;
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            bl = false;
            it = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            map = map2;
            boolean bl3 = false;
            d = StringsKt.replace$default((String)wordText, (String)"sh", (String)"sch", (boolean)false, (int)4, null).equals(it.getKey()) || (regex = schPattern).replace(charSequence = (CharSequence)wordText, string2 = "$1sch$2").equals(it.getKey()) || (regex = schPattern).replace(charSequence = (CharSequence)wordText, string2 = "$1chs$2").equals(it.getKey()) ? ((Number)it.getValue()).doubleValue() * 1.2 : ((Number)it.getValue()).doubleValue();
            map.put(k, d);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Double> preferSuggestionsWithDiacritics(Map<String, Double> suggestScores, String wordText) {
        void $this$mapValuesTo$iv$iv;
        Object v2;
        double it32;
        Object object;
        Object object2;
        Iterable iterable = suggestScores.entrySet();
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            object2 = null;
        } else {
            object = iterator.next();
            if (!iterator.hasNext()) {
                object2 = object;
            } else {
                Map.Entry it22 = (Map.Entry)object;
                boolean bl2 = false;
                double it22 = ((Number)it22.getValue()).doubleValue();
                do {
                    Object bl2 = iterator.next();
                    Map.Entry it32 = (Map.Entry)bl2;
                    boolean $i$a$-maxByOrNull-GrazieSpeller$preferSuggestionsWithDiacritics$2 = false;
                    it32 = ((Number)it32.getValue()).doubleValue();
                    if (Double.compare(it22, it32) >= 0) continue;
                    object = bl2;
                    it22 = it32;
                } while (iterator.hasNext());
                object2 = object;
            }
        }
        Map.Entry entry2 = (Map.Entry)object2;
        Intrinsics.checkNotNull((Object)entry2);
        if (Intrinsics.areEqual((Object)TextKt.normalizeAccents((String)entry2.getKey()), (Object)wordText)) {
            void $this$filterTo$iv$iv;
            Map<String, Double> $this$filter$iv = suggestScores;
            boolean $i$f$filter = false;
            iterator = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            bl2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (bl2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = (Map.Entry)bl2.next();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)TextKt.normalizeAccents((String)it.getKey()), (Object)wordText)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            return destination$iv$iv;
        }
        object = suggestScores.entrySet();
        Iterator $i$f$filterTo = object.iterator();
        if (!$i$f$filterTo.hasNext()) {
            v2 = null;
        } else {
            bl2 = $i$f$filterTo.next();
            if (!$i$f$filterTo.hasNext()) {
                v2 = bl2;
            } else {
                Map.Entry it = (Map.Entry)bl2;
                boolean bl3 = false;
                it32 = ((Number)it.getValue()).doubleValue();
                do {
                    Object bl3 = $i$f$filterTo.next();
                    Map.Entry it42 = (Map.Entry)bl3;
                    boolean $i$a$-maxByOrNull-GrazieSpeller$preferSuggestionsWithDiacritics$maxWeight$2 = false;
                    double it42 = ((Number)it42.getValue()).doubleValue();
                    if (Double.compare(it32, it42) >= 0) continue;
                    bl2 = bl3;
                    it32 = it42;
                } while ($i$f$filterTo.hasNext());
                v2 = bl2;
            }
        }
        Map.Entry entry3 = v2;
        Intrinsics.checkNotNull((Object)entry3);
        double maxWeight = ((Number)entry3.getValue()).doubleValue();
        double increment = maxWeight * 0.18;
        Map<String, Double> $this$mapValues$iv = suggestScores;
        boolean $i$f$mapValues = false;
        Map<String, Double> it = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it2;
            void it$iv$iv;
            Map.Entry entry4 = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry5 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl4 = false;
            Double d = Intrinsics.areEqual((Object)TextKt.normalizeAccents((String)it2.getKey()), (Object)wordText) ? ((Number)it2.getValue()).doubleValue() + increment : ((Number)it2.getValue()).doubleValue();
            map2.put(k, d);
        }
        return destination$iv$iv;
    }

    @Override
    public boolean isAlien(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return (Boolean)this.config.getDictionary().isAlien().invoke((Object)word);
    }

    @Override
    @NotNull
    public Map<String, Double> suggestAndRank(@NotNull String word, int max) {
        String normalized;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (!Speller.isMisspelled$default(this, word, false, 2, null)) {
            return MapsKt.emptyMap();
        }
        String string2 = normalized = this.preferNormalizedForm(word);
        if (string2 != null) {
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)string2, (Object)1.0));
        }
        Iterable $this$sortedByDescending$iv = this.getSuggestionsWithWeights(word).entrySet();
        boolean $i$f$sortedByDescending = false;
        return UtilsKt.toMap(CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Double)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getValue()));
            }
        }), (int)max));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Double> getSuggestionsWithWeights(String word) {
        Map<String, Double> map;
        WordListWithFrequency dictionary;
        LinkedHashSet<String> suggested;
        MatchResult ending;
        Double d;
        Object object;
        Object t;
        Object result$iv;
        LinkedHashMap<String, Double> linkedHashMap;
        LinkedHashMap<String, Double> suggestedWithWeight = new LinkedHashMap<String, Double>();
        if (this.config.getDictionary().getRules().check(word) == RuleDictionary.Result.INCORRECT) {
            void $this$associateWith$iv;
            Iterable iterable = this.config.getDictionary().getRules().suggest(word);
            linkedHashMap = suggestedWithWeight;
            boolean $i$f$associateWith = false;
            result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                String string2 = (String)element$iv$iv;
                t = element$iv$iv;
                object = (Map)result$iv;
                boolean bl = false;
                d = 1.0;
                object.put(t, d);
            }
            linkedHashMap.putAll((Map)result$iv);
        }
        if (this.config.getLanguageModel().getLanguage() == Language.ENGLISH && (ending = Regex.find$default((Regex)sRegex, (CharSequence)word, (int)0, (int)2, null)) != null) {
            String string3 = word.substring(0, word.length() - ending.getValue().length());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String withoutEnding = string3;
            if (this.config.getDictionary().getRules().check(withoutEnding) == RuleDictionary.Result.INCORRECT) {
                void $this$associateWith$iv;
                String it;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                result$iv = this.config.getDictionary().getRules().suggest(withoutEnding);
                linkedHashMap = suggestedWithWeight;
                boolean $i$f$map = false;
                void $i$f$associateWithTo = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string4 = (String)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    object.add(it + ending.getValue());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$associateWith = false;
                LinkedHashMap result$iv2 = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                void $this$associateWithTo$iv$iv = $this$associateWith$iv;
                boolean $i$f$associateWithTo2 = false;
                for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                    it = (String)element$iv$iv;
                    t = element$iv$iv;
                    object = result$iv2;
                    boolean bl = false;
                    d = 1.0;
                    object.put(t, d);
                }
                linkedHashMap.putAll(result$iv2);
            }
        }
        if (!(!(suggested = (dictionary = this.config.getDictionary().getDictionary()).suggest(word)).contains(""))) {
            boolean $i$a$-check-GrazieSpeller$getSuggestionsWithWeights$52 = false;
            String $i$a$-check-GrazieSpeller$getSuggestionsWithWeights$52 = "Empty suggestion was provided by dictionary " + dictionary + " for input word '" + word + "'";
            throw new IllegalStateException($i$a$-check-GrazieSpeller$getSuggestionsWithWeights$52.toString());
        }
        Map<String, Double> weights = this.config.getModel().getRanker().score(word, suggested);
        if (this.config.getModel().getDisableFiltering()) {
            map = weights;
        } else {
            void $this$associateWith$iv;
            Iterable result$iv2 = suggested;
            linkedHashMap = this.config.getModel().getFilter();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv3 = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                String string5 = (String)element$iv$iv;
                t = element$iv$iv;
                object = result$iv3;
                boolean bl = false;
                Double d2 = weights.get(it);
                Intrinsics.checkNotNull((Object)d2);
                d = ((Number)d2).doubleValue();
                object.put(t, d);
            }
            map = linkedHashMap.filter(result$iv3);
        }
        Map<String, Double> filtered = map;
        Object $this$sortedByDescending$iv2 = filtered.entrySet();
        boolean $i$f$sortedByDescending = false;
        for (Object $this$sortedByDescending$iv2 : CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Double)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getValue()));
            }
        })) {
            String key2 = (String)$this$sortedByDescending$iv2.getKey();
            double value = ((Number)$this$sortedByDescending$iv2.getValue()).doubleValue();
            suggestedWithWeight.putIfAbsent(key2, value);
        }
        Set set = suggestedWithWeight.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"suggestedWithWeight.entries");
        $this$sortedByDescending$iv2 = set;
        $i$f$sortedByDescending = false;
        Map<String, Double> result2 = UtilsKt.toMap(CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Double)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getValue()));
            }
        }));
        if (this.config.getLanguageModel().getLanguage() == Language.GERMAN && result2.size() > 1) {
            result2 = this.preferCompoundSuggestions(result2, word);
            result2 = this.preferSuggestionsWithDiacritics(result2, word);
            result2 = this.preferGeminateSuggestions(result2, word);
            result2 = this.preferSameLengthSuggestions(result2, word);
            result2 = this.preferOneSilentLetterSuggestions(result2, word);
            result2 = this.preferCorrectPluralSuggestions(result2, word);
        }
        return result2;
    }

    @Override
    @NotNull
    public Map<String, Double> filter(@NotNull Map<String, Double> suggested, int max) {
        Intrinsics.checkNotNullParameter(suggested, (String)"suggested");
        Map<String, Double> filtered = this.config.getModel().getFilter().filter(suggested);
        Iterable $this$sortedByDescending$iv = filtered.entrySet();
        boolean $i$f$sortedByDescending = false;
        return UtilsKt.toMap(CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Double)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getValue()));
            }
        }), (int)max));
    }

    @JvmOverloads
    public GrazieSpeller(@NotNull LanguageModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this(model, null, 2, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lai/grazie/spell/GrazieSpeller$Companion;", "", "()V", "PREFERRED_MAX_RERANKING_CANDIDATES", "", "PREFERRED_MAX_SUGGESTION_COUNT", "geminatePattern", "Lkotlin/text/Regex;", "inRegex", "sRegex", "schPattern", "silentLetterPattern", "gec-spell-engine-local"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lai/grazie/spell/GrazieSpeller$EnglishVerbChecker;", "", "dictionary", "Lai/grazie/spell/lists/WordListWithFrequency;", "caseSensitive", "", "(Lai/grazie/spell/lists/WordListWithFrequency;Z)V", "getDictionary", "()Lai/grazie/spell/lists/WordListWithFrequency;", "isOldVerb", "word", "", "Companion", "gec-spell-engine-local"})
    public static final class EnglishVerbChecker {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final WordListWithFrequency dictionary;
        private final boolean caseSensitive;
        @NotNull
        private static final Regex oldVerb = new Regex("(.{2,})e(d?st|th)");

        public EnglishVerbChecker(@NotNull WordListWithFrequency dictionary, boolean caseSensitive) {
            Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
            this.dictionary = dictionary;
            this.caseSensitive = caseSensitive;
        }

        @NotNull
        public final WordListWithFrequency getDictionary() {
            return this.dictionary;
        }

        public final boolean isOldVerb(@NotNull String word) {
            Intrinsics.checkNotNullParameter((Object)word, (String)"word");
            MatchResult matchResult = oldVerb.matchEntire((CharSequence)word);
            if (matchResult == null) {
                return false;
            }
            MatchResult match = matchResult;
            String stem = (String)match.getGroupValues().get(1);
            return this.dictionary.contains(stem + "ing", this.caseSensitive);
        }

        @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/grazie/spell/GrazieSpeller$EnglishVerbChecker$Companion;", "", "()V", "oldVerb", "Lkotlin/text/Regex;", "gec-spell-engine-local"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lai/grazie/spell/GrazieSpeller$GermanNumeralChecker;", "", "()V", "isComplexNumeral", "", "word", "", "Companion", "gec-spell-engine-local"})
    public static final class GermanNumeralChecker {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final String NUM45689 = "drei|vier|f\u00fcnf|sechs|acht|neun";
        @NotNull
        private static final String TO9 = "((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))";
        @NotNull
        private static final String TO99 = "(((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))(und((zwan|sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zig|drei\u00dfig))?|zehn|elf|zw\u00f6lf|(sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zehn)";
        @NotNull
        private static final String TO999 = "((((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))?hundert)?(((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))(und((zwan|sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zig|drei\u00dfig))?|zehn|elf|zw\u00f6lf|(sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zehn)|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))?hundert)";
        @NotNull
        private static final Regex numeralRegex = new Regex("((((((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))?hundert)?(((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))(und((zwan|sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zig|drei\u00dfig))?|zehn|elf|zw\u00f6lf|(sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zehn)|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))?hundert)tausend)?((((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))?hundert)?(((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))(und((zwan|sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zig|drei\u00dfig))?|zehn|elf|zw\u00f6lf|(sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zehn)|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))?hundert)?|((((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))?hundert)?(((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))(und((zwan|sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zig|drei\u00dfig))?|zehn|elf|zw\u00f6lf|(sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zehn)|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))?hundert)tausend|((((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))(und((zwan|sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zig|drei\u00dfig))?|zehn|elf|zw\u00f6lf|(sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zehn)hundert)(((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))(und((zwan|sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zig|drei\u00dfig))?|zehn|elf|zw\u00f6lf|(sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zehn)?)");

        public final boolean isComplexNumeral(@NotNull String word) {
            Intrinsics.checkNotNullParameter((Object)word, (String)"word");
            CharSequence charSequence = word;
            return numeralRegex.matches(charSequence);
        }

        @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lai/grazie/spell/GrazieSpeller$GermanNumeralChecker$Companion;", "", "()V", "NUM45689", "", "TO9", "TO99", "TO999", "numeralRegex", "Lkotlin/text/Regex;", "gec-spell-engine-local"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lai/grazie/spell/GrazieSpeller$GermanVerbChecker;", "", "dictionary", "Lai/grazie/spell/lists/WordListWithFrequency;", "caseSensitive", "", "(Lai/grazie/spell/lists/WordListWithFrequency;Z)V", "getDictionary", "()Lai/grazie/spell/lists/WordListWithFrequency;", "isInDictionary", "word", "", "isVerb", "looksLikeNoun", "looksLikeVerb", "Companion", "gec-spell-engine-local"})
    public static final class GermanVerbChecker {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final WordListWithFrequency dictionary;
        private final boolean caseSensitive;
        @NotNull
        private static final Regex presPartRegex = new Regex(".+nde[mnsr]");
        @NotNull
        private static final String PREFIX = "(ab|aus(einander)?|vorbei|zur\u00fcck|umher|hoch|durch|empor|entlang|entgegen|da?(rauf|r\u00fcber)|da(bei|von)|(he)?r(ab|an|aus|auf|ein|um|unter|\u00fcber)|her(ab|bei|vor)?|hin(ab|aus|durch|ein|ter(her)?)?)";
        @NotNull
        private static final Regex verbRegex = new Regex("(ab|aus(einander)?|vorbei|zur\u00fcck|umher|hoch|durch|empor|entlang|entgegen|da?(rauf|r\u00fcber)|da(bei|von)|(he)?r(ab|an|aus|auf|ein|um|unter|\u00fcber)|her(ab|bei|vor)?|hin(ab|aus|durch|ein|ter(her)?)?)(zu)?(.+)");

        public GermanVerbChecker(@NotNull WordListWithFrequency dictionary, boolean caseSensitive) {
            Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
            this.dictionary = dictionary;
            this.caseSensitive = caseSensitive;
        }

        @NotNull
        public final WordListWithFrequency getDictionary() {
            return this.dictionary;
        }

        private final boolean isInDictionary(String word) {
            return this.dictionary.contains(word, this.caseSensitive);
        }

        private final boolean looksLikeNoun(String word) {
            return this.isInDictionary(TextKt.capitalize(word) + "s") || this.isInDictionary(TextKt.capitalize(word) + "es");
        }

        private final boolean looksLikeVerb(String word) {
            CharSequence charSequence;
            return (StringsKt.endsWith$default((String)word, (String)"t", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)word, (String)"en", (boolean)false, (int)2, null)) && StringsKt.startsWith$default((String)word, (String)"ge", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)word, (String)"nd", (boolean)false, (int)2, null) && this.isInDictionary(StringsKt.dropLast((String)word, (int)1)) || StringsKt.endsWith$default((String)word, (String)"nde", (boolean)false, (int)2, null) && this.isInDictionary(StringsKt.dropLast((String)word, (int)2)) || presPartRegex.matches(charSequence = (CharSequence)word) && this.isInDictionary(StringsKt.dropLast((String)word, (int)3)) || StringsKt.endsWith$default((String)word, (String)"en", (boolean)false, (int)2, null) && (this.isInDictionary(StringsKt.dropLast((String)word, (int)1) + "st") || this.isInDictionary(StringsKt.dropLast((String)word, (int)2) + "st")) || StringsKt.endsWith$default((String)word, (String)"n", (boolean)false, (int)2, null) && this.isInDictionary(StringsKt.dropLast((String)word, (int)1) + "st") || StringsKt.endsWith$default((String)word, (String)"te", (boolean)false, (int)2, null) && this.isInDictionary(word + "st") || StringsKt.endsWith$default((String)word, (String)"t", (boolean)false, (int)2, null) && this.isInDictionary(StringsKt.dropLast((String)word, (int)1) + "st") && (this.isInDictionary(StringsKt.dropLast((String)word, (int)1) + "en") || this.isInDictionary(StringsKt.dropLast((String)word, (int)1) + "n")) || StringsKt.endsWith$default((String)word, (String)"st", (boolean)false, (int)2, null) && this.isInDictionary(StringsKt.dropLast((String)word, (int)2) + "t") || !this.looksLikeNoun(word) && this.isInDictionary(word + "en") && this.isInDictionary(word + "et");
        }

        public final boolean isVerb(@NotNull String word) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)word, (String)"word");
            if (!TextKt.isLowercase(word) || !verbRegex.matches(charSequence = (CharSequence)word)) {
                return false;
            }
            Object object = verbRegex;
            CharSequence charSequence2 = word;
            String string2 = "$11";
            String cleanVerb = object.replace(charSequence2, string2);
            if (cleanVerb.equals("sein")) {
                return true;
            }
            object = word;
            string2 = verbRegex;
            String string3 = "$10";
            boolean zu = Intrinsics.areEqual((Object)string2.replace((CharSequence)object, string3), (Object)"zu");
            return this.isInDictionary(cleanVerb) && this.looksLikeVerb(cleanVerb) && (!zu || this.isInDictionary(cleanVerb + "d"));
        }

        @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lai/grazie/spell/GrazieSpeller$GermanVerbChecker$Companion;", "", "()V", "PREFIX", "", "presPartRegex", "Lkotlin/text/Regex;", "verbRegex", "gec-spell-engine-local"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u0019\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\nH\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\u0002\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lai/grazie/spell/GrazieSpeller$UserConfig;", "", "model", "Lai/grazie/spell/language/LanguageModel;", "tokenizer", "Lai/grazie/nlp/tokenizer/Tokenizer;", "(Lai/grazie/spell/language/LanguageModel;Lai/grazie/nlp/tokenizer/Tokenizer;)V", "dictionary", "Lai/grazie/spell/GrazieSpeller$UserConfig$Dictionary;", "languageModel", "Lai/grazie/spell/GrazieSpeller$UserConfig$Model;", "(Lai/grazie/spell/GrazieSpeller$UserConfig$Dictionary;Lai/grazie/spell/language/LanguageModel;Lai/grazie/spell/GrazieSpeller$UserConfig$Model;)V", "getDictionary", "()Lai/grazie/spell/GrazieSpeller$UserConfig$Dictionary;", "getLanguageModel", "()Lai/grazie/spell/language/LanguageModel;", "getModel", "()Lai/grazie/spell/GrazieSpeller$UserConfig$Model;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Dictionary", "Model", "gec-spell-engine-local"})
    public static final class UserConfig {
        @NotNull
        private final Dictionary dictionary;
        @NotNull
        private final LanguageModel languageModel;
        @NotNull
        private final Model model;

        public UserConfig(@NotNull Dictionary dictionary, @NotNull LanguageModel languageModel, @NotNull Model model) {
            Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
            Intrinsics.checkNotNullParameter((Object)languageModel, (String)"languageModel");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            this.dictionary = dictionary;
            this.languageModel = languageModel;
            this.model = model;
        }

        @NotNull
        public final Dictionary getDictionary() {
            return this.dictionary;
        }

        @NotNull
        public final LanguageModel getLanguageModel() {
            return this.languageModel;
        }

        @NotNull
        public final Model getModel() {
            return this.model;
        }

        @JvmOverloads
        public UserConfig(@NotNull LanguageModel model, @NotNull Tokenizer tokenizer) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
            this(new Dictionary(tokenizer, model.getWords(), model.isAlien(), model.getRules()), model, new Model(model.getFilter(), model.getRanker(), model.getDisableFiltering()));
        }

        public /* synthetic */ UserConfig(LanguageModel languageModel, Tokenizer tokenizer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                tokenizer = new HeuristicWordTokenizer(true, false);
            }
            this(languageModel, tokenizer);
        }

        @NotNull
        public final Dictionary component1() {
            return this.dictionary;
        }

        @NotNull
        public final LanguageModel component2() {
            return this.languageModel;
        }

        @NotNull
        public final Model component3() {
            return this.model;
        }

        @NotNull
        public final UserConfig copy(@NotNull Dictionary dictionary, @NotNull LanguageModel languageModel, @NotNull Model model) {
            Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
            Intrinsics.checkNotNullParameter((Object)languageModel, (String)"languageModel");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            return new UserConfig(dictionary, languageModel, model);
        }

        public static /* synthetic */ UserConfig copy$default(UserConfig userConfig, Dictionary dictionary, LanguageModel languageModel, Model model, int n, Object object) {
            if ((n & 1) != 0) {
                dictionary = userConfig.dictionary;
            }
            if ((n & 2) != 0) {
                languageModel = userConfig.languageModel;
            }
            if ((n & 4) != 0) {
                model = userConfig.model;
            }
            return userConfig.copy(dictionary, languageModel, model);
        }

        @NotNull
        public String toString() {
            return "UserConfig(dictionary=" + this.dictionary + ", languageModel=" + this.languageModel + ", model=" + this.model + ")";
        }

        public int hashCode() {
            int result2 = this.dictionary.hashCode();
            result2 = result2 * 31 + this.languageModel.hashCode();
            result2 = result2 * 31 + this.model.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UserConfig)) {
                return false;
            }
            UserConfig userConfig = (UserConfig)other;
            if (!Intrinsics.areEqual((Object)this.dictionary, (Object)userConfig.dictionary)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.languageModel, (Object)userConfig.languageModel)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.model, (Object)userConfig.model);
        }

        @JvmOverloads
        public UserConfig(@NotNull LanguageModel model) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            this(model, null, 2, null);
        }

        @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u000bH\u00c6\u0003J?\u0010\u0018\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lai/grazie/spell/GrazieSpeller$UserConfig$Dictionary;", "", "tokenizer", "Lai/grazie/nlp/tokenizer/Tokenizer;", "dictionary", "Lai/grazie/spell/lists/WordListWithFrequency;", "isAlien", "Lkotlin/Function1;", "", "", "rules", "Lai/grazie/spell/dictionary/RuleDictionary;", "(Lai/grazie/nlp/tokenizer/Tokenizer;Lai/grazie/spell/lists/WordListWithFrequency;Lkotlin/jvm/functions/Function1;Lai/grazie/spell/dictionary/RuleDictionary;)V", "getDictionary", "()Lai/grazie/spell/lists/WordListWithFrequency;", "()Lkotlin/jvm/functions/Function1;", "getRules", "()Lai/grazie/spell/dictionary/RuleDictionary;", "getTokenizer", "()Lai/grazie/nlp/tokenizer/Tokenizer;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "gec-spell-engine-local"})
        public static final class Dictionary {
            @Nullable
            private final Tokenizer tokenizer;
            @NotNull
            private final WordListWithFrequency dictionary;
            @NotNull
            private final Function1<String, Boolean> isAlien;
            @NotNull
            private final RuleDictionary rules;

            public Dictionary(@Nullable Tokenizer tokenizer, @NotNull WordListWithFrequency dictionary, @NotNull Function1<? super String, Boolean> isAlien, @NotNull RuleDictionary rules2) {
                Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
                Intrinsics.checkNotNullParameter(isAlien, (String)"isAlien");
                Intrinsics.checkNotNullParameter((Object)rules2, (String)"rules");
                this.tokenizer = tokenizer;
                this.dictionary = dictionary;
                this.isAlien = isAlien;
                this.rules = rules2;
            }

            public /* synthetic */ Dictionary(Tokenizer tokenizer, WordListWithFrequency wordListWithFrequency, Function1 function1, RuleDictionary ruleDictionary, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    tokenizer = new HeuristicWordTokenizer(true, false);
                }
                this(tokenizer, wordListWithFrequency, (Function1<? super String, Boolean>)function1, ruleDictionary);
            }

            @Nullable
            public final Tokenizer getTokenizer() {
                return this.tokenizer;
            }

            @NotNull
            public final WordListWithFrequency getDictionary() {
                return this.dictionary;
            }

            @NotNull
            public final Function1<String, Boolean> isAlien() {
                return this.isAlien;
            }

            @NotNull
            public final RuleDictionary getRules() {
                return this.rules;
            }

            @Nullable
            public final Tokenizer component1() {
                return this.tokenizer;
            }

            @NotNull
            public final WordListWithFrequency component2() {
                return this.dictionary;
            }

            @NotNull
            public final Function1<String, Boolean> component3() {
                return this.isAlien;
            }

            @NotNull
            public final RuleDictionary component4() {
                return this.rules;
            }

            @NotNull
            public final Dictionary copy(@Nullable Tokenizer tokenizer, @NotNull WordListWithFrequency dictionary, @NotNull Function1<? super String, Boolean> isAlien, @NotNull RuleDictionary rules2) {
                Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
                Intrinsics.checkNotNullParameter(isAlien, (String)"isAlien");
                Intrinsics.checkNotNullParameter((Object)rules2, (String)"rules");
                return new Dictionary(tokenizer, dictionary, isAlien, rules2);
            }

            public static /* synthetic */ Dictionary copy$default(Dictionary dictionary, Tokenizer tokenizer, WordListWithFrequency wordListWithFrequency, Function1 function1, RuleDictionary ruleDictionary, int n, Object object) {
                if ((n & 1) != 0) {
                    tokenizer = dictionary.tokenizer;
                }
                if ((n & 2) != 0) {
                    wordListWithFrequency = dictionary.dictionary;
                }
                if ((n & 4) != 0) {
                    function1 = dictionary.isAlien;
                }
                if ((n & 8) != 0) {
                    ruleDictionary = dictionary.rules;
                }
                return dictionary.copy(tokenizer, wordListWithFrequency, function1, ruleDictionary);
            }

            @NotNull
            public String toString() {
                return "Dictionary(tokenizer=" + this.tokenizer + ", dictionary=" + this.dictionary + ", isAlien=" + this.isAlien + ", rules=" + this.rules + ")";
            }

            public int hashCode() {
                int result2 = this.tokenizer == null ? 0 : this.tokenizer.hashCode();
                result2 = result2 * 31 + this.dictionary.hashCode();
                result2 = result2 * 31 + this.isAlien.hashCode();
                result2 = result2 * 31 + this.rules.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Dictionary)) {
                    return false;
                }
                Dictionary dictionary = (Dictionary)other;
                if (!Intrinsics.areEqual((Object)this.tokenizer, (Object)dictionary.tokenizer)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.dictionary, (Object)dictionary.dictionary)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.isAlien, dictionary.isAlien)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.rules, (Object)dictionary.rules);
            }
        }

        @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lai/grazie/spell/GrazieSpeller$UserConfig$Model;", "", "filter", "Lai/grazie/spell/suggestion/filter/SuggestionFilter;", "ranker", "Lai/grazie/spell/suggestion/ranker/SuggestionRanker;", "disableFiltering", "", "(Lai/grazie/spell/suggestion/filter/SuggestionFilter;Lai/grazie/spell/suggestion/ranker/SuggestionRanker;Z)V", "getDisableFiltering", "()Z", "getFilter", "()Lai/grazie/spell/suggestion/filter/SuggestionFilter;", "getRanker", "()Lai/grazie/spell/suggestion/ranker/SuggestionRanker;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "gec-spell-engine-local"})
        public static final class Model {
            @NotNull
            private final SuggestionFilter filter;
            @NotNull
            private final SuggestionRanker ranker;
            private final boolean disableFiltering;

            public Model(@NotNull SuggestionFilter filter2, @NotNull SuggestionRanker ranker, boolean disableFiltering) {
                Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
                Intrinsics.checkNotNullParameter((Object)ranker, (String)"ranker");
                this.filter = filter2;
                this.ranker = ranker;
                this.disableFiltering = disableFiltering;
            }

            @NotNull
            public final SuggestionFilter getFilter() {
                return this.filter;
            }

            @NotNull
            public final SuggestionRanker getRanker() {
                return this.ranker;
            }

            public final boolean getDisableFiltering() {
                return this.disableFiltering;
            }

            @NotNull
            public final SuggestionFilter component1() {
                return this.filter;
            }

            @NotNull
            public final SuggestionRanker component2() {
                return this.ranker;
            }

            public final boolean component3() {
                return this.disableFiltering;
            }

            @NotNull
            public final Model copy(@NotNull SuggestionFilter filter2, @NotNull SuggestionRanker ranker, boolean disableFiltering) {
                Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
                Intrinsics.checkNotNullParameter((Object)ranker, (String)"ranker");
                return new Model(filter2, ranker, disableFiltering);
            }

            public static /* synthetic */ Model copy$default(Model model, SuggestionFilter suggestionFilter, SuggestionRanker suggestionRanker, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    suggestionFilter = model.filter;
                }
                if ((n & 2) != 0) {
                    suggestionRanker = model.ranker;
                }
                if ((n & 4) != 0) {
                    bl = model.disableFiltering;
                }
                return model.copy(suggestionFilter, suggestionRanker, bl);
            }

            @NotNull
            public String toString() {
                return "Model(filter=" + this.filter + ", ranker=" + this.ranker + ", disableFiltering=" + this.disableFiltering + ")";
            }

            public int hashCode() {
                int result2 = this.filter.hashCode();
                result2 = result2 * 31 + this.ranker.hashCode();
                result2 = result2 * 31 + Boolean.hashCode(this.disableFiltering);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Model)) {
                    return false;
                }
                Model model = (Model)other;
                if (!Intrinsics.areEqual((Object)this.filter, (Object)model.filter)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.ranker, (Object)model.ranker)) {
                    return false;
                }
                return this.disableFiltering == model.disableFiltering;
            }
        }
    }
}

