/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.spell.dictionary.rule;

import ai.grazie.spell.dictionary.RuleDictionary;
import ai.grazie.utils.CollectionsKt;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u000f\u001a\u00020\u0007H\u0016R7\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0004`\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lai/grazie/spell/dictionary/rule/ReplacingRuleDictionary;", "Lai/grazie/spell/dictionary/RuleDictionary;", "rules", "", "Lai/grazie/spell/dictionary/rule/ReplacingRuleDictionary$Descriptor;", "(Ljava/util/Collection;)V", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getRules", "()Ljava/util/HashMap;", "rules$delegate", "Lkotlin/Lazy;", "check", "Lai/grazie/spell/dictionary/RuleDictionary$Result;", "word", "suggest", "", "Descriptor", "gec-spell-engine-local"})
public final class ReplacingRuleDictionary
implements RuleDictionary {
    @NotNull
    private final Lazy rules$delegate;

    public ReplacingRuleDictionary(@NotNull Collection<Descriptor> rules2) {
        Intrinsics.checkNotNullParameter(rules2, (String)"rules");
        this.rules$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HashMap<String, Descriptor>>(rules2){
            final /* synthetic */ Collection<Descriptor> $rules;
            {
                this.$rules = $rules;
                super(0);
            }

            public final HashMap<String, Descriptor> invoke() {
                HashMap<String, Descriptor> prepared = new HashMap<String, Descriptor>();
                for (Descriptor rule : this.$rules) {
                    for (String incorrect : rule.getIncorrect()) {
                        ((Map)prepared).put(incorrect, rule);
                    }
                }
                return prepared;
            }
        }));
    }

    private final HashMap<String, Descriptor> getRules() {
        Lazy lazy = this.rules$delegate;
        return (HashMap)lazy.getValue();
    }

    @Override
    @NotNull
    public RuleDictionary.Result check(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (this.getRules().containsKey(word)) {
            return RuleDictionary.Result.INCORRECT;
        }
        return RuleDictionary.Result.UNKNOWN;
    }

    @Override
    @NotNull
    public Set<String> suggest(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Descriptor descriptor2 = this.getRules().get(word);
        if (descriptor2 == null) {
            return CollectionsKt.emptyLinkedSet();
        }
        Descriptor rule = descriptor2;
        return CollectionsKt.toLinkedSet(rule.getCorrect());
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\u0004H\u0016R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\n\u0010\b\u00a8\u0006\f"}, d2={"Lai/grazie/spell/dictionary/rule/ReplacingRuleDictionary$Descriptor;", "", "incorrect", "", "", "correct", "([Ljava/lang/String;[Ljava/lang/String;)V", "getCorrect", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getIncorrect", "toString", "gec-spell-engine-local"})
    public static final class Descriptor {
        @NotNull
        private final String[] incorrect;
        @NotNull
        private final String[] correct;

        public Descriptor(@NotNull String[] incorrect, @NotNull String[] correct2) {
            Intrinsics.checkNotNullParameter((Object)incorrect, (String)"incorrect");
            Intrinsics.checkNotNullParameter((Object)correct2, (String)"correct");
            this.incorrect = incorrect;
            this.correct = correct2;
        }

        @NotNull
        public final String[] getIncorrect() {
            return this.incorrect;
        }

        @NotNull
        public final String[] getCorrect() {
            return this.correct;
        }

        @NotNull
        public String toString() {
            return ArraysKt.joinToString$default((Object[])this.incorrect, null, null, null, (int)0, null, null, (int)63, null) + " -> " + ArraysKt.joinToString$default((Object[])this.correct, null, null, null, (int)0, null, null, (int)63, null);
        }
    }
}

