/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.output;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Disposer;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.output.PartialCommandOutput;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputChangesTracker;
import org.jetbrains.plugins.terminal.block.util.ActionCoordinator;
import org.jetbrains.plugins.terminal.fus.TerminalUsageTriggerCollector;
import org.jetbrains.plugins.terminal.fus.TimeSpanType;
import org.jetbrains.plugins.terminal.util.ShellIntegration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u0019\u001a\u00020\u000bJ\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\nH\u0002J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputContentUpdatesScheduler;", "", "textBuffer", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "shellIntegration", "Lorg/jetbrains/plugins/terminal/util/ShellIntegration;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "applyUpdate", "Lkotlin/Function1;", "Lorg/jetbrains/plugins/terminal/block/output/PartialCommandOutput;", "", "<init>", "(Lcom/jediterm/terminal/model/TerminalTextBuffer;Lorg/jetbrains/plugins/terminal/util/ShellIntegration;Lkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/functions/Function1;)V", "changesTracker", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputChangesTracker;", "trackerDisposable", "Lcom/intellij/openapi/Disposable;", "updatingJob", "Lkotlinx/coroutines/Job;", "value", "", "finished", "getFinished", "()Z", "startUpdating", "scheduleChangeApplying", "output", "finishUpdating", "", "metricTextInBufferToTextVisible", "Lorg/jetbrains/plugins/terminal/block/util/ActionCoordinator;", "Lkotlin/time/TimeMark;", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalOutputContentUpdatesScheduler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOutputContentUpdatesScheduler.kt\norg/jetbrains/plugins/terminal/block/output/TerminalOutputContentUpdatesScheduler\n+ 2 TerminalUiUtils.kt\norg/jetbrains/plugins/terminal/block/ui/TerminalUiUtilsKt\n*L\n1#1,108:1\n534#2,7:109\n534#2,7:116\n*S KotlinDebug\n*F\n+ 1 TerminalOutputContentUpdatesScheduler.kt\norg/jetbrains/plugins/terminal/block/output/TerminalOutputContentUpdatesScheduler\n*L\n39#1:109,7\n77#1:116,7\n*E\n"})
public final class TerminalOutputContentUpdatesScheduler {
    @NotNull
    private final TerminalTextBuffer textBuffer;
    @NotNull
    private final ShellIntegration shellIntegration;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Function1<PartialCommandOutput, Unit> applyUpdate;
    @Nullable
    private TerminalOutputChangesTracker changesTracker;
    @NotNull
    private Disposable trackerDisposable;
    @Nullable
    private Job updatingJob;
    private boolean finished;
    @NotNull
    private final ActionCoordinator<Unit, TimeMark> metricTextInBufferToTextVisible;

    public TerminalOutputContentUpdatesScheduler(@NotNull TerminalTextBuffer textBuffer, @NotNull ShellIntegration shellIntegration, @NotNull CoroutineScope coroutineScope, @NotNull Function1<? super PartialCommandOutput, Unit> applyUpdate) {
        Intrinsics.checkNotNullParameter((Object)textBuffer, (String)"textBuffer");
        Intrinsics.checkNotNullParameter((Object)shellIntegration, (String)"shellIntegration");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(applyUpdate, (String)"applyUpdate");
        this.textBuffer = textBuffer;
        this.shellIntegration = shellIntegration;
        this.coroutineScope = coroutineScope;
        this.applyUpdate = applyUpdate;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.trackerDisposable = disposable;
        this.metricTextInBufferToTextVisible = new ActionCoordinator(10, (arg_0, arg_1) -> TerminalOutputContentUpdatesScheduler.metricTextInBufferToTextVisible$lambda$4(this, arg_0, arg_1), TerminalOutputContentUpdatesScheduler::metricTextInBufferToTextVisible$lambda$5, TerminalOutputContentUpdatesScheduler::metricTextInBufferToTextVisible$lambda$6);
    }

    public final boolean getFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startUpdating() {
        TerminalTextBuffer $this$withLock$iv = this.textBuffer;
        boolean $i$f$withLock = false;
        $this$withLock$iv.lock();
        try {
            TerminalOutputChangesTracker tracker;
            TerminalTextBuffer it = $this$withLock$iv;
            boolean bl = false;
            this.changesTracker = tracker = new TerminalOutputChangesTracker(this.textBuffer, this.shellIntegration, this.trackerDisposable, (Function0<Unit>)((Function0)() -> TerminalOutputContentUpdatesScheduler.startUpdating$lambda$2$lambda$0(this)));
            Job job2 = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(tracker, this, null){
                Object L$0;
                int label;
                final /* synthetic */ TerminalOutputChangesTracker $tracker;
                final /* synthetic */ TerminalOutputContentUpdatesScheduler this$0;
                {
                    this.$tracker = $tracker;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = DelayKt.delay((long)100L, (Continuation)((Continuation)this));
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 3 sources

                            while (true) {
                                this.L$0 = null;
                                this.label = 2;
                                v1 = this.$tracker.collectChangedOutputOrWait((Continuation<? super PartialCommandOutput>)((Continuation)this));
                                if (v1 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl23
                                break;
                            }
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl23:
                            // 2 sources

                            partialChange = (PartialCommandOutput)v1;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)partialChange);
                            this.label = 3;
                            v2 = TerminalOutputContentUpdatesScheduler.access$scheduleChangeApplying(this.this$0, partialChange).join((Continuation)this);
                            if (v2 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl34
                        }
                        case 3: {
                            partialChange = (PartialCommandOutput)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl34:
                            // 2 sources

                            this.$tracker.onOutputApplied$intellij_terminal();
                            ** continue;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            job2.invokeOnCompletion(arg_0 -> TerminalOutputContentUpdatesScheduler.startUpdating$lambda$2$lambda$1(this, arg_0));
            this.updatingJob = job2;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$withLock$iv.unlock();
        }
    }

    private final Job scheduleChangeApplying(PartialCommandOutput output) {
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        return BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, output, null){
            int label;
            final /* synthetic */ TerminalOutputContentUpdatesScheduler this$0;
            final /* synthetic */ PartialCommandOutput $output;
            {
                this.this$0 = $receiver;
                this.$output = $output;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        TerminalOutputContentUpdatesScheduler.access$getApplyUpdate$p(this.this$0).invoke((Object)this.$output);
                        TerminalOutputContentUpdatesScheduler.access$getMetricTextInBufferToTextVisible$p(this.this$0).finished(Unit.INSTANCE);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<PartialCommandOutput> finishUpdating() {
        TerminalTextBuffer $this$withLock$iv = this.textBuffer;
        boolean $i$f$withLock = false;
        $this$withLock$iv.lock();
        try {
            TerminalTextBuffer it = $this$withLock$iv;
            boolean bl = false;
            TerminalOutputChangesTracker terminalOutputChangesTracker = this.changesTracker;
            if (terminalOutputChangesTracker == null) {
                throw new IllegalStateException("Finish updating called before start updating".toString());
            }
            TerminalOutputChangesTracker tracker = terminalOutputChangesTracker;
            this.changesTracker = null;
            Job job2 = this.updatingJob;
            if (job2 != null) {
                Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
            }
            this.finished = true;
            Object[] objectArray = new PartialCommandOutput[]{tracker.getPendingOutput(), tracker.collectChangedOutputOrNull()};
            List list = CollectionsKt.listOfNotNull((Object[])objectArray);
            return list;
        }
        finally {
            $this$withLock$iv.unlock();
        }
    }

    private static final Unit startUpdating$lambda$2$lambda$0(TerminalOutputContentUpdatesScheduler this$0) {
        this$0.metricTextInBufferToTextVisible.started(Unit.INSTANCE, (TimeMark)TimeSource.Monotonic.ValueTimeMark.box-impl((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto()));
        return Unit.INSTANCE;
    }

    private static final Unit startUpdating$lambda$2$lambda$1(TerminalOutputContentUpdatesScheduler this$0, Throwable it) {
        Disposer.dispose((Disposable)this$0.trackerDisposable);
        return Unit.INSTANCE;
    }

    private static final Unit metricTextInBufferToTextVisible$lambda$4(TerminalOutputContentUpdatesScheduler this$0, Unit unit, TimeMark startTime) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        TerminalUsageTriggerCollector.logBlockTerminalTimeSpanFinished-Wn2Vu4Y$intellij_terminal(null, this$0.shellIntegration.getShellType(), TimeSpanType.FROM_TEXT_IN_BUFFER_TO_TEXT_VISIBLE, startTime.elapsedNow-UwyO8pc());
        return Unit.INSTANCE;
    }

    private static final Unit metricTextInBufferToTextVisible$lambda$5(Unit unit, TimeMark startTime) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        return Unit.INSTANCE;
    }

    private static final Unit metricTextInBufferToTextVisible$lambda$6(Unit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Function1 access$getApplyUpdate$p(TerminalOutputContentUpdatesScheduler $this) {
        return $this.applyUpdate;
    }

    public static final /* synthetic */ ActionCoordinator access$getMetricTextInBufferToTextVisible$p(TerminalOutputContentUpdatesScheduler $this) {
        return $this.metricTextInBufferToTextVisible;
    }

    public static final /* synthetic */ Job access$scheduleChangeApplying(TerminalOutputContentUpdatesScheduler $this, PartialCommandOutput output) {
        return $this.scheduleChangeApplying(output);
    }
}

