/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.util;

import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0001\u001a\u0014\u0010\u000e\u001a\u00020\u00012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"S_IRUSR", "", "S_IWUSR", "S_IXUSR", "S_IRGRP", "S_IWGRP", "S_IXGRP", "S_IROTH", "S_IWOTH", "S_IXOTH", "fromUnixMode", "", "Ljava/nio/file/attribute/PosixFilePermission;", "mode", "toUnixMode", "permissions", "intellij.clouds.docker.agent"})
@JvmName(name="PosixFilePermissionsUtil")
@ApiStatus.Internal
public final class PosixFilePermissionsUtil {
    private static final int S_IRUSR = 256;
    private static final int S_IWUSR = 128;
    private static final int S_IXUSR = 64;
    private static final int S_IRGRP = 32;
    private static final int S_IWGRP = 16;
    private static final int S_IXGRP = 8;
    private static final int S_IROTH = 4;
    private static final int S_IWOTH = 2;
    private static final int S_IXOTH = 1;

    @NotNull
    public static final Set<PosixFilePermission> fromUnixMode(int mode) {
        EnumSet<PosixFilePermission> enumSet = EnumSet.noneOf(PosixFilePermission.class);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"noneOf(...)");
        Set permissions = enumSet;
        if ((mode & 0x100) != 0) {
            permissions.add(PosixFilePermission.OWNER_READ);
        }
        if ((mode & 0x80) != 0) {
            permissions.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x40) != 0) {
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x20) != 0) {
            permissions.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x10) != 0) {
            permissions.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 8) != 0) {
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 4) != 0) {
            permissions.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 2) != 0) {
            permissions.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 1) != 0) {
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return permissions;
    }

    public static final int toUnixMode(@NotNull Set<? extends PosixFilePermission> permissions) {
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        int mode = 0;
        if (permissions.contains((Object)PosixFilePermission.OWNER_READ)) {
            mode |= 0x100;
        }
        if (permissions.contains((Object)PosixFilePermission.OWNER_WRITE)) {
            mode |= 0x80;
        }
        if (permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
            mode |= 0x40;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_READ)) {
            mode |= 0x20;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_WRITE)) {
            mode |= 0x10;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
            mode |= 8;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_READ)) {
            mode |= 4;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
            mode |= 2;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            mode |= 1;
        }
        return mode;
    }
}

