/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.searchEverywhere.frontend.tabs.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.icons.IconId;
import com.intellij.ide.ui.icons.IconIdKt;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.FeaturePromoBundle;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.searchEverywhere.SeActionItemPresentation;
import com.intellij.platform.searchEverywhere.SeItemPresentation;
import com.intellij.platform.searchEverywhere.SeOptionActionItemPresentation;
import com.intellij.platform.searchEverywhere.SeRunnableActionItemPresentation;
import com.intellij.platform.searchEverywhere.frontend.ui.SeResultListItemRow;
import com.intellij.platform.searchEverywhere.frontend.ui.SeResultListRow;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HtmlToSimpleColoredComponentConverter;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.ui.dsl.listCellRenderer.LcrInitParams;
import com.intellij.ui.dsl.listCellRenderer.LcrRow;
import com.intellij.ui.dsl.listCellRenderer.LcrSwitchInitParams;
import com.intellij.ui.dsl.listCellRenderer.LcrTextInitParams;
import com.intellij.ui.dsl.listCellRenderer.LcrTextSpeedSearchParams;
import com.intellij.ui.render.IconCompOptionalCompPanel;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J$\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\b\b\u0002\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ6\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J=\u0010\u001d\u001a\u00070\r\u00a2\u0006\u0002\b\u001e2\u000b\u0010\u001f\u001a\u00070\r\u00a2\u0006\u0002\b\u001e2\r\u0010 \u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b!2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010#\u001a\u00020\nH\u0002J&\u0010$\u001a\u00020%2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010#\u001a\u00020\n2\b\u0010 \u001a\u0004\u0018\u00010\rH\u0002J3\u0010&\u001a\u00070\r\u00a2\u0006\u0002\b\u001e2\r\u0010'\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u001e2\r\u0010(\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u001e2\u0006\u0010)\u001a\u00020*H\u0002J2\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,2\u000b\u0010\u001f\u001a\u00070\r\u00a2\u0006\u0002\b\u001e2\u000b\u0010.\u001a\u00070\r\u00a2\u0006\u0002\b!2\u0006\u0010/\u001a\u00020*H\u0002J:\u00100\u001a\u00020\u00132\u0006\u00101\u001a\u00020\u001c2\u000b\u0010\u001f\u001a\u00070\r\u00a2\u0006\u0002\b\u001e2\u000b\u0010.\u001a\u00070\r\u00a2\u0006\u0002\b!2\u0006\u00102\u001a\u00020\u00172\u0006\u0010/\u001a\u00020*H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/platform/searchEverywhere/frontend/tabs/actions/SeActionItemPresentationRenderer;", "", "resultsList", "Ljavax/swing/JList;", "Lcom/intellij/platform/searchEverywhere/frontend/ui/SeResultListRow;", "<init>", "(Ljavax/swing/JList;)V", "get", "Ljavax/swing/ListCellRenderer;", "listFont", "Ljava/awt/Font;", "patternProvider", "Lkotlin/Function0;", "", "EMPTY_ICON", "Ljavax/swing/Icon;", "TOGGLE_BUTTON_BORDER", "Ljavax/swing/border/Border;", "customizePromoAction", "", "promoAction", "Lcom/intellij/platform/searchEverywhere/SeRunnableActionItemPresentation$Promo;", "panelBackground", "Ljava/awt/Color;", "eastBorder", "groupFg", "panel", "Lcom/intellij/ui/render/IconCompOptionalCompPanel;", "Lcom/intellij/ui/SimpleColoredComponent;", "cutName", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "name", "shortcutText", "Lcom/intellij/openapi/util/NlsSafe;", "list", "font", "calcFreeSpace", "", "getName", "text", "groupName", "toggle", "", "speedSearchRange", "", "Lcom/intellij/openapi/util/TextRange;", "pattern", "selected", "appendWithColoredMatches", "nameComponent", "fg", "intellij.platform.searchEverywhere.frontend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSeActionItemPresentationRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeActionItemPresentationRenderer.kt\ncom/intellij/platform/searchEverywhere/frontend/tabs/actions/SeActionItemPresentationRenderer\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,305:1\n106#2:306\n78#2,22:307\n1#3:329\n*S KotlinDebug\n*F\n+ 1 SeActionItemPresentationRenderer.kt\ncom/intellij/platform/searchEverywhere/frontend/tabs/actions/SeActionItemPresentationRenderer\n*L\n230#1:306\n230#1:307,22\n*E\n"})
public final class SeActionItemPresentationRenderer {
    @NotNull
    private final JList<SeResultListRow> resultsList;
    @NotNull
    private final Icon EMPTY_ICON;
    @NotNull
    private final Border TOGGLE_BUTTON_BORDER;

    public SeActionItemPresentationRenderer(@NotNull JList<SeResultListRow> resultsList) {
        Intrinsics.checkNotNullParameter(resultsList, (String)"resultsList");
        this.resultsList = resultsList;
        Icon icon = EmptyIcon.ICON_16;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ICON_16");
        this.EMPTY_ICON = icon;
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty((int)0, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(...)");
        this.TOGGLE_BUTTON_BORDER = (Border)jBEmptyBorder;
    }

    @NotNull
    public final ListCellRenderer<SeResultListRow> get(@NotNull Font listFont, @NotNull Function0<String> patternProvider) {
        Intrinsics.checkNotNullParameter((Object)listFont, (String)"listFont");
        Intrinsics.checkNotNullParameter(patternProvider, (String)"patternProvider");
        return BuilderKt.listCellRenderer(arg_0 -> SeActionItemPresentationRenderer.get$lambda$14(patternProvider, this, listFont, arg_0));
    }

    public static /* synthetic */ ListCellRenderer get$default(SeActionItemPresentationRenderer seActionItemPresentationRenderer, Font font, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            font = StartupUiUtil.getLabelFont();
        }
        return seActionItemPresentationRenderer.get(font, (Function0<String>)function0);
    }

    private final void customizePromoAction(SeRunnableActionItemPresentation.Promo promoAction, Color panelBackground, Border eastBorder, Color groupFg, IconCompOptionalCompPanel<SimpleColoredComponent> panel) {
        SimpleColoredComponent promo = new SimpleColoredComponent();
        promo.setBackground(panelBackground);
        promo.setForeground(groupFg);
        promo.setIcon(AllIcons.Ide.External_link_arrow);
        promo.setIconOnTheRight(true);
        promo.setTransparentIconBackground(true);
        promo.append(promoAction.getCallToActionText());
        SimpleColoredComponent upgradeTo = new SimpleColoredComponent();
        IconId iconId = promoAction.getProductIconId();
        Icon icon = iconId != null ? IconIdKt.icon((IconId)iconId) : null;
        upgradeTo.setIcon(icon);
        upgradeTo.setBackground(panelBackground);
        upgradeTo.setForeground(groupFg);
        upgradeTo.setIconOnTheRight(true);
        upgradeTo.append(FeaturePromoBundle.message((String)"get.prefix", (Object[])new Object[0]) + " ");
        upgradeTo.setTransparentIconBackground(true);
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel((Component)((Component)promo));
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel, (String)"simplePanel(...)");
        BorderLayoutPanel compositeUpgradeHint = borderLayoutPanel;
        if (icon != null) {
            compositeUpgradeHint.addToLeft((Component)upgradeTo);
        }
        compositeUpgradeHint.andTransparent();
        compositeUpgradeHint.setBorder(eastBorder);
        panel.setRight((JComponent)compositeUpgradeHint);
    }

    private final String cutName(String name, String shortcutText, JList<?> list, Font font) {
        String name2 = name;
        if (!list.isShowing() || list.getWidth() <= 0) {
            String string = StringUtil.first((String)name2, (int)60, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"first(...)");
            return string;
        }
        if (StringsKt.startsWith$default((String)name2, (String)"<html>", (boolean)false, (int)2, null)) {
            return name2;
        }
        if (name2.length() < 40) {
            return name2;
        }
        int freeSpace = this.calcFreeSpace(list, font, shortcutText);
        if (freeSpace <= 0) {
            return name2;
        }
        FontMetrics fm = this.resultsList.getFontMetrics(font);
        int strWidth = fm.stringWidth(name2);
        if (strWidth <= freeSpace) {
            return name2;
        }
        int cutSymbolIndex = (int)(((double)freeSpace - (double)fm.stringWidth("...")) / (double)strWidth * (double)name2.length());
        cutSymbolIndex = Integer.max(1, cutSymbolIndex);
        String string = name2.substring(0, cutSymbolIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        name2 = string;
        while (fm.stringWidth(name2 + "...") > freeSpace && name2.length() > 1) {
            Intrinsics.checkNotNullExpressionValue((Object)name2.substring(0, name2.length() - 1), (String)"substring(...)");
        }
        String $this$trim$iv = name2;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString() + "...";
    }

    private final int calcFreeSpace(JList<?> list, Font font, String shortcutText) {
        int freeSpace = list.getWidth() - (list.getInsets().right + list.getInsets().left);
        if (StringUtil.isNotEmpty((String)shortcutText)) {
            FontMetrics fm = list.getFontMetrics(font.deriveFont(1));
            freeSpace -= fm.stringWidth(" " + shortcutText);
        }
        return freeSpace;
    }

    private final String getName(String text, String groupName, boolean toggle) {
        String string;
        if (text != null && StringsKt.startsWith$default((String)text, (String)"<html>", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)text, (String)"</html>", (boolean)false, (int)2, null)) {
            String string2 = text.substring(6, text.length() - 7);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String rawText = string2;
            return "<html>" + this.getName(rawText, groupName, toggle) + "</html>";
        }
        if (toggle && StringUtil.isNotEmpty((String)groupName)) {
            Object object = StringUtil.isNotEmpty((String)text) ? groupName + ": " + text : groupName;
            string = object;
            Intrinsics.checkNotNull((Object)object);
        } else {
            string = text;
            if (string == null) {
                string = "";
            }
        }
        return string;
    }

    private final List<TextRange> speedSearchRange(String name, String pattern, boolean selected) {
        if (!selected) {
            return null;
        }
        int matchStart = StringUtil.indexOfIgnoreCase((String)name, (String)pattern, (int)0);
        if (matchStart >= 0) {
            return CollectionsKt.listOf((Object)TextRange.from((int)matchStart, (int)pattern.length()));
        }
        return null;
    }

    private final void appendWithColoredMatches(SimpleColoredComponent nameComponent, String name, String pattern, Color fg, boolean selected) {
        int matchStart;
        String name2 = name;
        SimpleTextAttributes plain = new SimpleTextAttributes(0, fg);
        if (StringsKt.startsWith$default((String)name2, (String)"<html>", (boolean)false, (int)2, null)) {
            new HtmlToSimpleColoredComponentConverter(HtmlToSimpleColoredComponentConverter.DEFAULT_TAG_HANDLER).appendHtml(nameComponent, name2, plain);
            name2 = ((Object)nameComponent.getCharSequence(false)).toString();
        } else {
            nameComponent.append(name2, plain);
        }
        nameComponent.setDynamicSearchMatchHighlighting(false);
        if (selected && (matchStart = StringUtil.indexOfIgnoreCase((String)name2, (String)pattern, (int)0)) >= 0) {
            nameComponent.setDynamicSearchMatchHighlighting(true);
            List fragments = CollectionsKt.listOf((Object)TextRange.from((int)matchStart, (int)pattern.length()));
            SpeedSearchUtil.applySpeedSearchHighlighting((SimpleColoredComponent)nameComponent, (Iterable)fragments, (boolean)true);
        }
    }

    private static final Unit get$lambda$14$lambda$4$lambda$3$lambda$2(List $it, LcrTextSpeedSearchParams $this$speedSearch) {
        Intrinsics.checkNotNullParameter((Object)$this$speedSearch, (String)"$this$speedSearch");
        $this$speedSearch.setRanges((Iterable)$it);
        return Unit.INSTANCE;
    }

    private static final Unit get$lambda$14$lambda$4(Font $listFont, boolean $selected, boolean $hasFocus, SeActionItemPresentation $presentation, SeActionItemPresentationRenderer this$0, Ref.ObjectRef $name, String $pattern, LcrTextInitParams $this$text) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$text, (String)"$this$text");
            $this$text.setFont($listFont);
            Color color = GotoActionModel.defaultActionForeground((boolean)$selected, (boolean)$hasFocus, (boolean)((SeRunnableActionItemPresentation)$presentation).isEnabled());
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"defaultActionForeground(...)");
            $this$text.setForeground(color);
            List<TextRange> list = this$0.speedSearchRange((String)$name.element, $pattern, $selected);
            if (list == null) break block0;
            List<TextRange> it = list;
            boolean bl = false;
            $this$text.speedSearch(arg_0 -> SeActionItemPresentationRenderer.get$lambda$14$lambda$4$lambda$3$lambda$2(it, arg_0));
        }
        return Unit.INSTANCE;
    }

    private static final Unit get$lambda$14$lambda$5(LcrTextInitParams $this$text) {
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"$this$text");
        $this$text.setAttributes(SimpleTextAttributes.GRAYED_ATTRIBUTES);
        return Unit.INSTANCE;
    }

    private static final Unit get$lambda$14$lambda$7$lambda$6(Ref.ObjectRef $groupForeground, LcrTextInitParams $this$text) {
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"$this$text");
        $this$text.setAttributes(new SimpleTextAttributes(129, (Color)$groupForeground.element));
        return Unit.INSTANCE;
    }

    private static final Unit get$lambda$14$lambda$10$lambda$9$lambda$8(List $it, LcrTextSpeedSearchParams $this$speedSearch) {
        Intrinsics.checkNotNullParameter((Object)$this$speedSearch, (String)"$this$speedSearch");
        $this$speedSearch.setRanges((Iterable)$it);
        return Unit.INSTANCE;
    }

    private static final Unit get$lambda$14$lambda$10(Font $listFont, boolean $selected, boolean $hasFocus, SeActionItemPresentationRenderer this$0, SeActionItemPresentation $presentation, String $pattern, LcrTextInitParams $this$text) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$text, (String)"$this$text");
            $this$text.setFont($listFont);
            Color color = UIUtil.getListForeground((boolean)$selected, (boolean)$hasFocus);
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getListForeground(...)");
            $this$text.setForeground(color);
            List<TextRange> list = this$0.speedSearchRange(((SeOptionActionItemPresentation)$presentation).getText(), $pattern, $selected);
            if (list == null) break block0;
            List<TextRange> it = list;
            boolean bl = false;
            $this$text.speedSearch(arg_0 -> SeActionItemPresentationRenderer.get$lambda$14$lambda$10$lambda$9$lambda$8(it, arg_0));
        }
        return Unit.INSTANCE;
    }

    private static final Unit get$lambda$14$lambda$11(LcrSwitchInitParams $this$switch) {
        Intrinsics.checkNotNullParameter((Object)$this$switch, (String)"$this$switch");
        $this$switch.setAlign(LcrInitParams.Align.RIGHT);
        return Unit.INSTANCE;
    }

    private static final Unit get$lambda$14$lambda$13$lambda$12(LcrTextInitParams $this$text) {
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"$this$text");
        $this$text.setAlign(LcrInitParams.Align.RIGHT);
        return Unit.INSTANCE;
    }

    private static final Unit get$lambda$14(Function0 $patternProvider, SeActionItemPresentationRenderer this$0, Font $listFont, LcrRow $this$listCellRenderer) {
        block21: {
            Border eastBorder;
            Ref.ObjectRef groupForeground;
            SeActionItemPresentation presentation;
            block20: {
                Boolean switcherState;
                block19: {
                    Object actionId;
                    SeActionItemPresentation seActionItemPresentation;
                    boolean hasFocus;
                    boolean selected;
                    String pattern;
                    boolean showIcon;
                    block15: {
                        SeActionItemPresentation.Common commonData;
                        block16: {
                            Object object;
                            boolean disabled;
                            block18: {
                                block17: {
                                    IconId iconId;
                                    Color color;
                                    Intrinsics.checkNotNullParameter((Object)$this$listCellRenderer, (String)"$this$listCellRenderer");
                                    Object object2 = $this$listCellRenderer.getValue();
                                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.platform.searchEverywhere.frontend.ui.SeResultListItemRow");
                                    SeItemPresentation seItemPresentation = ((SeResultListItemRow)object2).getItem().getPresentation();
                                    Intrinsics.checkNotNull((Object)seItemPresentation, (String)"null cannot be cast to non-null type com.intellij.platform.searchEverywhere.SeActionItemPresentation");
                                    presentation = (SeActionItemPresentation)seItemPresentation;
                                    showIcon = UISettings.Companion.getInstance().getShowIconsInMenus();
                                    commonData = presentation.getCommonData();
                                    pattern = (String)$patternProvider.invoke();
                                    selected = $this$listCellRenderer.getSelected();
                                    hasFocus = $this$listCellRenderer.getCellHasFocus();
                                    $this$listCellRenderer.setSelectionColor(UIUtil.getListBackground((boolean)selected, (boolean)selected));
                                    groupForeground = new Ref.ObjectRef();
                                    if (selected) {
                                        Color color2 = NamedColorUtil.getListSelectionForeground((boolean)true);
                                        color = color2;
                                        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getListSelectionForeground(...)");
                                    } else {
                                        Color color3 = NamedColorUtil.getInactiveTextColor();
                                        color = color3;
                                        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"getInactiveTextColor(...)");
                                    }
                                    groupForeground.element = color;
                                    JBEmptyBorder jBEmptyBorder = JBUI.Borders.emptyRight((int)2);
                                    Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"emptyRight(...)");
                                    eastBorder = (Border)jBEmptyBorder;
                                    switcherState = commonData.getSwitcherState();
                                    seActionItemPresentation = presentation;
                                    if (!(seActionItemPresentation instanceof SeRunnableActionItemPresentation)) break block15;
                                    boolean bl = disabled = !selected && !((SeRunnableActionItemPresentation)presentation).isEnabled();
                                    if (disabled) {
                                        Color color4 = UIUtil.getLabelDisabledForeground();
                                        Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"getLabelDisabledForeground(...)");
                                        groupForeground.element = color4;
                                    }
                                    if (!showIcon) break block16;
                                    object = ((SeRunnableActionItemPresentation)presentation).getSelectedIconId();
                                    if (object == null) break block17;
                                    IconId it = iconId = object;
                                    boolean bl2 = false;
                                    object = selected ? iconId : null;
                                    if (object != null && (object = IconIdKt.icon((IconId)object)) != null) break block18;
                                }
                                IconId iconId = ((SeRunnableActionItemPresentation)presentation).getIconId();
                                object = iconId != null ? IconIdKt.icon((IconId)iconId) : this$0.EMPTY_ICON;
                            }
                            Object icon = object;
                            LayeredIcon layeredIcon = GotoActionModel.createLayeredIcon((Icon)icon, (boolean)disabled);
                            Intrinsics.checkNotNullExpressionValue((Object)layeredIcon, (String)"createLayeredIcon(...)");
                            LcrRow.icon$default((LcrRow)$this$listCellRenderer, (Icon)((Icon)layeredIcon), null, (int)2, null);
                        }
                        SeRunnableActionItemPresentation.Promo promo = ((SeRunnableActionItemPresentation)presentation).getPromo();
                        if (promo != null) {
                            SeRunnableActionItemPresentation.Promo promo2 = promo;
                            boolean bl = false;
                        }
                        $this$listCellRenderer.setToolTipText(((SeRunnableActionItemPresentation)presentation).getToolTip());
                        actionId = ((SeRunnableActionItemPresentation)presentation).getActionId();
                        Ref.ObjectRef name = new Ref.ObjectRef();
                        name.element = this$0.getName(((SeRunnableActionItemPresentation)presentation).getText(), commonData.getLocation(), switcherState != null);
                        name.element = this$0.cutName((String)name.element, ((SeRunnableActionItemPresentation)presentation).getShortcut(), this$0.resultsList, $listFont);
                        $this$listCellRenderer.text((String)name.element, arg_0 -> SeActionItemPresentationRenderer.get$lambda$14$lambda$4($listFont, selected, hasFocus, presentation, this$0, name, pattern, arg_0));
                        if (UISettings.Companion.getInstance().getShowInplaceCommentsInternal() && actionId != null) {
                            $this$listCellRenderer.text((String)actionId, SeActionItemPresentationRenderer::get$lambda$14$lambda$5);
                        }
                        String string = ((SeRunnableActionItemPresentation)presentation).getShortcut();
                        if (string != null) {
                            String shortcutText = string;
                            boolean bl = false;
                            $this$listCellRenderer.text(shortcutText, arg_0 -> SeActionItemPresentationRenderer.get$lambda$14$lambda$7$lambda$6(groupForeground, arg_0));
                        }
                        break block19;
                    }
                    if (seActionItemPresentation instanceof SeOptionActionItemPresentation) {
                        if (!selected && !((SeOptionActionItemPresentation)presentation).isBooleanOption()) {
                            actionId = StartupUiUtil.isUnderDarcula() ? ColorUtil.brighter((Color)UIUtil.getListBackground(), (int)1) : JBUI.CurrentTheme.BigPopup.LIST_SETTINGS_BACKGROUND;
                            Intrinsics.checkNotNull((Object)actionId);
                            Color descriptorBg = actionId;
                            $this$listCellRenderer.setBackground(descriptorBg);
                        }
                        if (showIcon) {
                            LcrRow.icon$default((LcrRow)$this$listCellRenderer, (Icon)this$0.EMPTY_ICON, null, (int)2, null);
                        }
                        $this$listCellRenderer.text(((SeOptionActionItemPresentation)presentation).getText(), arg_0 -> SeActionItemPresentationRenderer.get$lambda$14$lambda$10($listFont, selected, hasFocus, this$0, presentation, pattern, arg_0));
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                if (switcherState == null) break block20;
                $this$listCellRenderer.switch(switcherState.booleanValue(), SeActionItemPresentationRenderer::get$lambda$14$lambda$11);
                break block21;
            }
            String string = presentation.getCommonData().getLocation();
            if (string == null) break block21;
            String location = string;
            boolean bl = false;
            JLabel groupLabel = new JLabel(location);
            groupLabel.setBorder(eastBorder);
            groupLabel.setForeground((Color)groupForeground.element);
            $this$listCellRenderer.text(location, SeActionItemPresentationRenderer::get$lambda$14$lambda$13$lambda$12);
        }
        return Unit.INSTANCE;
    }
}

