/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.calendar;

import circlet.common.calendar.CalendarEventSpec;
import circlet.common.calendar.EventCountersKt;
import circlet.common.calendar.RecurrenceRule;
import circlet.common.calendar.SpecInstance;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.ADateKt;
import circlet.platform.api.ATimeZone;
import circlet.platform.api.KotlinXDate;
import circlet.platform.api.KotlinXDateTime;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a-\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\n\u0010\u0004\u001a\u00060\u0006j\u0002`\u00052\n\u0010\u0007\u001a\u00060\u0006j\u0002`\u0005\u00a2\u0006\u0002\u0010\b\u001a\n\u0010\t\u001a\u00020\u0003*\u00020\u0002\u001a-\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\n\u0010\u0004\u001a\u00060\u000bj\u0002`\n2\n\u0010\u0007\u001a\u00060\u000bj\u0002`\n\u00a2\u0006\u0002\u0010\f\u001a-\u0010\r\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00050\u00012\n\u0010\u0004\u001a\u00060\u0006j\u0002`\u00052\n\u0010\u0007\u001a\u00060\u0006j\u0002`\u0005\u00a2\u0006\u0002\u0010\u000e\u001a1\u0010\u000f\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\n2\u0006\u0010\u0010\u001a\u00020\u00032\n\u0010\u0011\u001a\u00060\u000bj\u0002`\n2\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014\u001a\u001f\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00032\n\u0010\u0011\u001a\u00060\u0006j\u0002`\u0005\u00a2\u0006\u0002\u0010\u0017\u001a%\u0010\u0018\u001a\u00020\u0003*\u00020\u00032\n\u0010\u0011\u001a\u00060\u0006j\u0002`\u00052\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001b\u001a\u0014\u0010\u001c\u001a\u00020\u0013*\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\u001a\u001a(\u0010\u001c\u001a\u00020\u0013*\u0016\u0012\b\u0012\u00060\u000bj\u0002`\n\u0012\b\u0012\u00060\u000bj\u0002`\n0\u001e2\b\b\u0002\u0010\u001d\u001a\u00020\u001a\u00a8\u0006\u001f"}, d2={"instancesForPeriod", "", "Lcirclet/common/calendar/SpecInstance;", "Lcirclet/common/calendar/CalendarEventSpec;", "start", "Lcirclet/platform/api/ADate;", "Lcirclet/platform/api/KotlinXDate;", "end", "(Lcirclet/common/calendar/CalendarEventSpec;Lcirclet/platform/api/KotlinXDate;Lcirclet/platform/api/KotlinXDate;)Ljava/util/List;", "toShiftedSpec", "Lcirclet/platform/api/ADateTime;", "Lcirclet/platform/api/KotlinXDateTime;", "(Lcirclet/common/calendar/CalendarEventSpec;Lcirclet/platform/api/KotlinXDateTime;Lcirclet/platform/api/KotlinXDateTime;)Ljava/util/List;", "iterateDays", "(Lcirclet/platform/api/KotlinXDate;Lcirclet/platform/api/KotlinXDate;)Ljava/util/List;", "getRecurringMeetingStart", "occurrence", "date", "lookBehind", "", "(Lcirclet/common/calendar/CalendarEventSpec;Lcirclet/platform/api/KotlinXDateTime;I)Lcirclet/platform/api/KotlinXDateTime;", "isRecurrentMeetingPresent", "", "(Lcirclet/common/calendar/CalendarEventSpec;Lcirclet/platform/api/KotlinXDate;)Z", "shiftedSpec", "timeZone", "Lcirclet/platform/api/ATimeZone;", "(Lcirclet/common/calendar/CalendarEventSpec;Lcirclet/platform/api/KotlinXDate;Lcirclet/platform/api/ATimeZone;)Lcirclet/common/calendar/CalendarEventSpec;", "durationInDays", "timezone", "Lkotlin/Pair;", "spaceport-common"})
public final class SpecInstancesKt {
    @NotNull
    public static final List<SpecInstance> instancesForPeriod(@NotNull CalendarEventSpec $this$instancesForPeriod, @NotNull KotlinXDate start2, @NotNull KotlinXDate end) {
        Intrinsics.checkNotNullParameter((Object)$this$instancesForPeriod, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return SpecInstancesKt.instancesForPeriod($this$instancesForPeriod, ADateJvmKt.toDateTimeAtStartOfDay(start2), ADateJvmKt.plusDays(ADateJvmKt.toDateTimeAtStartOfDay(end), 1));
    }

    @NotNull
    public static final CalendarEventSpec toShiftedSpec(@NotNull SpecInstance $this$toShiftedSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$toShiftedSpec, (String)"<this>");
        KotlinXDate date2 = ADateJvmKt.toDate(ADateJvmKt.withZone($this$toShiftedSpec.getStart(), $this$toShiftedSpec.getSpec().getTimezone()));
        CalendarEventSpec shifted = SpecInstancesKt.shiftedSpec($this$toShiftedSpec.getSpec(), date2, $this$toShiftedSpec.getSpec().getTimezone());
        return CalendarEventSpec.copy$default(shifted, $this$toShiftedSpec.getStart(), $this$toShiftedSpec.getEnd(), null, false, null, null, null, null, null, 508, null);
    }

    @NotNull
    public static final List<SpecInstance> instancesForPeriod(@NotNull CalendarEventSpec $this$instancesForPeriod, @NotNull KotlinXDateTime start2, @NotNull KotlinXDateTime end) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)$this$instancesForPeriod, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        KotlinXDateTime convertedStart = ADateJvmKt.withZone(start2, $this$instancesForPeriod.getTimezone());
        KotlinXDateTime convertedEnd = ADateJvmKt.withZone(end, $this$instancesForPeriod.getTimezone());
        int between = ADateJvmKt.daysBetween(convertedStart, convertedEnd);
        if ($this$instancesForPeriod.getRecurrenceRule() == null) {
            list2 = convertedStart.compareTo($this$instancesForPeriod.getEnd()) <= 0 && $this$instancesForPeriod.getStart().compareTo(convertedEnd) < 0 ? CollectionsKt.listOf((Object)new SpecInstance(ADateJvmKt.withZone($this$instancesForPeriod.getStart(), ADateJvmKt.getClientTimeZone()), ADateJvmKt.withZone($this$instancesForPeriod.getEnd(), ADateJvmKt.getClientTimeZone()), $this$instancesForPeriod)) : CollectionsKt.emptyList();
        } else {
            CalendarEventSpec shiftedSpec;
            KotlinXDateTime localStartAtDay;
            KotlinXDate kotlinXDate;
            KotlinXDateTime kotlinXDateTime;
            List result2 = new ArrayList();
            KotlinXDateTime kotlinXDateTime2 = SpecInstancesKt.getRecurringMeetingStart$default($this$instancesForPeriod, convertedStart, 0, 4, null);
            KotlinXDate nextOccurrence = kotlinXDateTime2 != null && (kotlinXDateTime = ADateJvmKt.withZone(kotlinXDateTime2, $this$instancesForPeriod.getTimezone())) != null && (kotlinXDate = ADateJvmKt.toDate(kotlinXDateTime)) != null ? kotlinXDate : EventCountersKt.nextOccurrence$default($this$instancesForPeriod, convertedStart, false, 4, null);
            int day = -1;
            while (nextOccurrence != null && ++day <= between + 1 && (localStartAtDay = ADateJvmKt.withZone((shiftedSpec = SpecInstancesKt.shiftedSpec($this$instancesForPeriod, nextOccurrence, $this$instancesForPeriod.getTimezone())).getStart(), ADateJvmKt.getClientTimeZone())).compareTo(convertedEnd) <= 0) {
                KotlinXDate following;
                KotlinXDateTime localEndAtDay = ADateJvmKt.withZone(shiftedSpec.getEnd(), ADateJvmKt.getClientTimeZone());
                if (shiftedSpec.getAllDay()) {
                    localStartAtDay = ADateJvmKt.toDateTimeAtStartOfDay(ADateJvmKt.toDate(localStartAtDay));
                    localEndAtDay = ADateJvmKt.plusDays(localStartAtDay, SpecInstancesKt.durationInDays$default(shiftedSpec, null, 1, null) + 1);
                }
                if (localEndAtDay.compareTo(convertedStart) >= 0) {
                    result2.add(new SpecInstance(localStartAtDay, localEndAtDay, $this$instancesForPeriod));
                }
                KotlinXDateTime fromDateTime = ADateJvmKt.plusDays(localStartAtDay, 1);
                KotlinXDate next2 = EventCountersKt.nextOccurrence$default($this$instancesForPeriod, fromDateTime, false, 4, null);
                while (next2 != null && next2.compareTo(nextOccurrence) <= 0 && ((following = EventCountersKt.nextOccurrence$default($this$instancesForPeriod, fromDateTime = ADateJvmKt.plusDays(fromDateTime, 1), false, 4, null)) == null || following.compareTo(next2) > 0)) {
                    next2 = following;
                }
                if (next2 != null && next2.compareTo(nextOccurrence) <= 0) break;
                nextOccurrence = next2;
            }
            list2 = result2;
        }
        return list2;
    }

    @NotNull
    public static final List<KotlinXDate> iterateDays(@NotNull KotlinXDate start2, @NotNull KotlinXDate end) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        KotlinXDate current = start2;
        List result2 = new ArrayList();
        while (current.compareTo(end) <= 0) {
            result2.add(current);
            current = ADateJvmKt.plusDays(current, 1);
        }
        return result2;
    }

    @Nullable
    public static final KotlinXDateTime getRecurringMeetingStart(@NotNull CalendarEventSpec occurrence, @NotNull KotlinXDateTime date2, int lookBehind) {
        int daysBetween;
        CalendarEventSpec shiftedSpec;
        KotlinXDate behindOne;
        Intrinsics.checkNotNullParameter((Object)occurrence, (String)"occurrence");
        Intrinsics.checkNotNullParameter((Object)date2, (String)"date");
        if (lookBehind == 0 && (behindOne = EventCountersKt.nextOccurrence$default(occurrence, ADateJvmKt.plusDays(date2, -1), false, 4, null)) != null && (shiftedSpec = SpecInstancesKt.shiftedSpec(occurrence, behindOne, occurrence.getTimezone())).getEnd().compareTo(date2) > 0) {
            return shiftedSpec.getStart();
        }
        KotlinXDate next2 = EventCountersKt.nextOccurrence$default(occurrence, date2, false, 4, null);
        if (next2 != null) {
            shiftedSpec = SpecInstancesKt.shiftedSpec(occurrence, next2, occurrence.getTimezone());
            if (shiftedSpec.getEnd().compareTo(date2) < 0) {
                return null;
            }
            int i = 0;
            if (i <= lookBehind) {
                while (true) {
                    if (shiftedSpec.getStart().compareTo(ADateJvmKt.plusDays(date2, i)) <= 0 && shiftedSpec.getEnd().compareTo(ADateJvmKt.plusDays(date2, i)) >= 0) {
                        return shiftedSpec.getStart();
                    }
                    if (i == lookBehind) break;
                    ++i;
                }
            }
        }
        if ((daysBetween = SpecInstancesKt.durationInDays(occurrence, occurrence.getTimezone())) < 1 || lookBehind > daysBetween) {
            return null;
        }
        return SpecInstancesKt.getRecurringMeetingStart(occurrence, ADateJvmKt.plusDays(date2, -1), lookBehind + 1);
    }

    public static /* synthetic */ KotlinXDateTime getRecurringMeetingStart$default(CalendarEventSpec calendarEventSpec, KotlinXDateTime kotlinXDateTime, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return SpecInstancesKt.getRecurringMeetingStart(calendarEventSpec, kotlinXDateTime, n);
    }

    public static final boolean isRecurrentMeetingPresent(@NotNull CalendarEventSpec occurrence, @NotNull KotlinXDate date2) {
        Intrinsics.checkNotNullParameter((Object)occurrence, (String)"occurrence");
        Intrinsics.checkNotNullParameter((Object)date2, (String)"date");
        return Intrinsics.areEqual((Object)SpecInstancesKt.getRecurringMeetingStart$default(occurrence, ADateJvmKt.toDateTimeAtStartOfDay(date2), 0, 4, null), (Object)ADateJvmKt.toDateTimeAtStartOfDay(date2));
    }

    @NotNull
    public static final CalendarEventSpec shiftedSpec(@NotNull CalendarEventSpec $this$shiftedSpec, @NotNull KotlinXDate date2, @NotNull ATimeZone timeZone) {
        RecurrenceRule recurrenceRule;
        Intrinsics.checkNotNullParameter((Object)$this$shiftedSpec, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)date2, (String)"date");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        KotlinXDate targetDate = Intrinsics.areEqual((Object)timeZone, (Object)$this$shiftedSpec.getTimezone()) ? date2 : ADateJvmKt.toDate(ADateJvmKt.withZone(ADateJvmKt.plusMinutes(ADateJvmKt.toDateTimeAtStartOfDay(date2, timeZone), ADateKt.toLocalMinutesOnDate($this$shiftedSpec.getStart(), $this$shiftedSpec.getTimezone(), date2, timeZone)), $this$shiftedSpec.getTimezone()));
        KotlinXDateTime newStart = $this$shiftedSpec.getAllDay() ? ADateJvmKt.toDateTimeAtStartOfDay(date2, timeZone) : ADateKt.toLocalTimeOnDate($this$shiftedSpec.getStart(), $this$shiftedSpec.getTimezone(), targetDate, $this$shiftedSpec.getTimezone());
        KotlinXDateTime kotlinXDateTime = ADateJvmKt.plusMinutes(newStart, EventCountersKt.durationInMinutes($this$shiftedSpec));
        if ($this$shiftedSpec.getAllDay()) {
            recurrenceRule = $this$shiftedSpec.getRecurrenceRule();
        } else {
            RecurrenceRule recurrenceRule2 = $this$shiftedSpec.getRecurrenceRule();
            recurrenceRule = recurrenceRule2 != null ? RecurrenceRule.copy$default(recurrenceRule2, EventCountersKt.fix($this$shiftedSpec.getRecurrenceRule().getFreq(), newStart, $this$shiftedSpec.getTimezone()), null, 2, null) : null;
        }
        return CalendarEventSpec.copy$default($this$shiftedSpec, newStart, kotlinXDateTime, recurrenceRule, false, null, null, null, null, null, 504, null);
    }

    public static /* synthetic */ CalendarEventSpec shiftedSpec$default(CalendarEventSpec calendarEventSpec, KotlinXDate kotlinXDate, ATimeZone aTimeZone, int n, Object object) {
        if ((n & 2) != 0) {
            aTimeZone = ADateJvmKt.getClientTimeZone();
        }
        return SpecInstancesKt.shiftedSpec(calendarEventSpec, kotlinXDate, aTimeZone);
    }

    public static final int durationInDays(@NotNull CalendarEventSpec $this$durationInDays, @NotNull ATimeZone timezone) {
        KotlinXDateTime endDate;
        Intrinsics.checkNotNullParameter((Object)$this$durationInDays, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        KotlinXDateTime kotlinXDateTime = endDate = ADateJvmKt.getMinuteOfDay($this$durationInDays.getEnd()) == 0 ? ADateJvmKt.plusMinutes($this$durationInDays.getEnd(), -1) : $this$durationInDays.getEnd();
        if ($this$durationInDays.getAllDay()) {
            return ADateJvmKt.daysBetween(ADateJvmKt.withZone($this$durationInDays.getStart(), $this$durationInDays.getTimezone()), ADateJvmKt.withZone(endDate, $this$durationInDays.getTimezone()));
        }
        return ADateJvmKt.daysBetween(ADateJvmKt.toDate(ADateJvmKt.withZone($this$durationInDays.getStart(), timezone)), ADateJvmKt.toDate(ADateJvmKt.withZone(endDate, timezone)));
    }

    public static /* synthetic */ int durationInDays$default(CalendarEventSpec calendarEventSpec, ATimeZone aTimeZone, int n, Object object) {
        if ((n & 1) != 0) {
            aTimeZone = ADateJvmKt.getClientTimeZone();
        }
        return SpecInstancesKt.durationInDays(calendarEventSpec, aTimeZone);
    }

    public static final int durationInDays(@NotNull Pair<? extends KotlinXDateTime, ? extends KotlinXDateTime> $this$durationInDays, @NotNull ATimeZone timezone) {
        Intrinsics.checkNotNullParameter($this$durationInDays, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        KotlinXDateTime endDate = ADateJvmKt.getMinuteOfDay((KotlinXDateTime)$this$durationInDays.getSecond()) == 0 ? ADateJvmKt.plusMinutes((KotlinXDateTime)$this$durationInDays.getSecond(), -1) : (KotlinXDateTime)$this$durationInDays.getSecond();
        return ADateJvmKt.daysBetween(ADateJvmKt.toDate(ADateJvmKt.withZone((KotlinXDateTime)$this$durationInDays.getFirst(), timezone)), ADateJvmKt.toDate(ADateJvmKt.withZone(endDate, timezone)));
    }

    public static /* synthetic */ int durationInDays$default(Pair pair, ATimeZone aTimeZone, int n, Object object) {
        if ((n & 1) != 0) {
            aTimeZone = ADateJvmKt.getClientTimeZone();
        }
        return SpecInstancesKt.durationInDays((Pair<? extends KotlinXDateTime, ? extends KotlinXDateTime>)pair, aTimeZone);
    }
}

