/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerIcons;
import com.intellij.docker.DockerServerRuntimesManager;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerServerRuntime;
import com.intellij.docker.ui.utils.DockerUiUtilsKt;
import com.intellij.docker.view.ActionGroups;
import com.intellij.docker.view.DockerRuntimeServiceViewContributor;
import com.intellij.docker.view.DockerServiceViewDeleteProvider;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewLazyContributor;
import com.intellij.execution.services.ServiceViewToolWindowDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.util.PlatformUtils;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/docker/view/DockerMainServiceViewContributor;", "Lcom/intellij/execution/services/ServiceViewContributor;", "Lcom/intellij/docker/view/DockerRuntimeServiceViewContributor;", "Lcom/intellij/execution/services/ServiceViewLazyContributor;", "<init>", "()V", "myServersManager", "Lcom/intellij/remoteServer/configuration/RemoteServersManager;", "kotlin.jvm.PlatformType", "myCloudType", "Lcom/intellij/docker/DockerCloudType;", "getViewDescriptor", "Lcom/intellij/execution/services/ServiceViewDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "getServices", "", "getServiceDescriptor", "service", "Companion", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerMainServiceViewContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerMainServiceViewContributor.kt\ncom/intellij/docker/view/DockerMainServiceViewContributor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,121:1\n14#2:122\n*S KotlinDebug\n*F\n+ 1 DockerMainServiceViewContributor.kt\ncom/intellij/docker/view/DockerMainServiceViewContributor\n*L\n71#1:122\n*E\n"})
public final class DockerMainServiceViewContributor
implements ServiceViewContributor<DockerRuntimeServiceViewContributor>,
ServiceViewLazyContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final RemoteServersManager myServersManager = RemoteServersManager.getInstance();
    private final DockerCloudType myCloudType = DockerCloudType.getInstance();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final ServiceViewDescriptor CONTRIBUTOR_DESCRIPTOR;
    @NotNull
    private static final ActionGroups DOCKER_ACTION_GROUPS;
    @NotNull
    private static final DataProvider DATA_PROVIDER;

    public DockerMainServiceViewContributor() {
        if (PlatformUtils.isIdeaUltimate() && ConfigImportHelper.isNewUser() && this.myServersManager.getServers((ServerType)this.myCloudType).isEmpty()) {
            this.myServersManager.addServer(this.myServersManager.createServer((ServerType)this.myCloudType));
        }
    }

    @NotNull
    public ServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CONTRIBUTOR_DESCRIPTOR;
    }

    @NotNull
    public List<DockerRuntimeServiceViewContributor> getServices(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List servers = this.myServersManager.getServers((ServerType)this.myCloudType);
        DockerServerRuntimesManager manager = DockerServerRuntimesManager.Companion.getInstance(project);
        Intrinsics.checkNotNull((Object)servers);
        return SequencesKt.toList((Sequence)SequencesKt.map(DockerUiUtilsKt.withNaturalSorting(SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)servers), arg_0 -> DockerMainServiceViewContributor.getServices$lambda$0(manager, arg_0))), DockerMainServiceViewContributor::getServices$lambda$1));
    }

    @NotNull
    public ServiceViewDescriptor getServiceDescriptor(@NotNull Project project, @NotNull DockerRuntimeServiceViewContributor service) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        return service.getViewDescriptor(project);
    }

    private static final DockerServerRuntime getServices$lambda$0(DockerServerRuntimesManager $manager, RemoteServer it) {
        Intrinsics.checkNotNull((Object)it);
        return $manager.getServerRuntime((RemoteServer<DockerCloudConfiguration>)it);
    }

    private static final DockerRuntimeServiceViewContributor getServices$lambda$1(DockerServerRuntime it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getServiceViewContributor$intellij_clouds_docker();
    }

    private static final Object DATA_PROVIDER$lambda$2(String dataId) {
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return new DockerServiceViewDeleteProvider();
        }
        return null;
    }

    public static final /* synthetic */ DataProvider access$getDATA_PROVIDER$cp() {
        return DATA_PROVIDER;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DockerMainServiceViewContributor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DockerMainServiceViewContributor.logger = logger;
        String string = DockerBundle.message((String)"DockerServiceViewContributor.contributor.descriptor.name", (Object[])new Object[0]);
        Icon icon = DockerIcons.Docker;
        CONTRIBUTOR_DESCRIPTOR = (ServiceViewDescriptor)new ServiceViewToolWindowDescriptor(string, icon){

            public DataProvider getDataProvider() {
                return DockerMainServiceViewContributor.access$getDATA_PROVIDER$cp();
            }

            public ActionGroup getToolbarActions() {
                return DockerMainServiceViewContributor.Companion.getDOCKER_ACTION_GROUPS$intellij_clouds_docker().getToolbarActions();
            }

            public ActionGroup getPopupActions() {
                return DockerMainServiceViewContributor.Companion.getDOCKER_ACTION_GROUPS$intellij_clouds_docker().getPopupActions();
            }

            public String getToolWindowId() {
                return "Docker";
            }

            public Icon getToolWindowIcon() {
                Icon icon = DockerIcons.Docker_toolwin;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Docker_toolwin");
                return icon;
            }

            public String getStripeTitle() {
                String string = DockerBundle.message((String)"DockerServiceViewContributor.contributor.descriptor.name", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
        };
        DOCKER_ACTION_GROUPS = new ActionGroups("Docker.RemoteServersViewToolbar", "Docker.RemoteServersViewToolbar.Top", "Docker.RemoteServersViewPopup");
        DATA_PROVIDER = DockerMainServiceViewContributor::DATA_PROVIDER$lambda$2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/docker/view/DockerMainServiceViewContributor$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "refresh", "", "target", "Lcom/intellij/execution/services/ServiceViewContributor;", "trace", "Lkotlin/Function0;", "", "CONTRIBUTOR_DESCRIPTOR", "Lcom/intellij/execution/services/ServiceViewDescriptor;", "DOCKER_ACTION_GROUPS", "Lcom/intellij/docker/view/ActionGroups;", "getDOCKER_ACTION_GROUPS$intellij_clouds_docker", "()Lcom/intellij/docker/view/ActionGroups;", "DATA_PROVIDER", "Lcom/intellij/openapi/actionSystem/DataProvider;", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerMainServiceViewContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerMainServiceViewContributor.kt\ncom/intellij/docker/view/DockerMainServiceViewContributor$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,121:1\n68#2,4:122\n*S KotlinDebug\n*F\n+ 1 DockerMainServiceViewContributor.kt\ncom/intellij/docker/view/DockerMainServiceViewContributor$Companion\n*L\n74#1:122,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void refresh(@NotNull ServiceViewContributor<?> target, @NotNull Function0<String> trace) {
            Intrinsics.checkNotNullParameter(target, (String)"target");
            Intrinsics.checkNotNullParameter(trace, (String)"trace");
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                $this$trace$iv.trace((String)trace.invoke());
            }
            MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
            Topic topic = ServiceEventListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            ((ServiceEventListener)messageBus.syncPublisher(topic)).handle(ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_STRUCTURE_CHANGED, target, DockerMainServiceViewContributor.class));
        }

        @NotNull
        public final ActionGroups getDOCKER_ACTION_GROUPS$intellij_clouds_docker() {
            return DOCKER_ACTION_GROUPS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

