/*
 * Decompiled with CFR 0.152.
 */
package runtime.utils;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import runtime.utils.PrintableTreeNode;
import runtime.utils.TreeNodeConverter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JM\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u0002H\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\n\u0010\u000f\u001a\u00060\u0011j\u0002`\u0010H\u0002\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015J'\u0010\u0013\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0014\u001a\u0002H\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\t\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lruntime/utils/TreePrinter;", "", "<init>", "()V", "process", "", "T", "current", "treeNodeConverter", "Lruntime/utils/TreeNodeConverter;", "prefix", "", "isRoot", "", "lastInPeers", "stringBuilder", "Lkotlin/text/StringBuilder;", "Ljava/lang/StringBuilder;", "(Ljava/lang/Object;Lruntime/utils/TreeNodeConverter;Ljava/lang/String;ZZLjava/lang/StringBuilder;)V", "toString", "root", "Lruntime/utils/PrintableTreeNode;", "(Ljava/lang/Object;Lruntime/utils/TreeNodeConverter;)Ljava/lang/String;", "platform-runtime"})
public final class TreePrinter {
    @NotNull
    public static final TreePrinter INSTANCE = new TreePrinter();

    private TreePrinter() {
    }

    private final <T> void process(T current, TreeNodeConverter<T> treeNodeConverter, String prefix, boolean isRoot, boolean lastInPeers, StringBuilder stringBuilder) {
        stringBuilder.append(prefix);
        StringBuilder stringBuilder2 = !isRoot ? stringBuilder.append(lastInPeers ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ") : stringBuilder.append(" \u2500\u2500 ");
        stringBuilder.append(treeNodeConverter.name(current));
        stringBuilder.append('\n');
        List<T> children = treeNodeConverter.children(current);
        String indentation = isRoot ? "    " : "    ";
        int n = children.size() - 1;
        for (int i = 0; i < n; ++i) {
            this.process(children.get(i), treeNodeConverter, prefix + (lastInPeers ? indentation : "\u2502   "), false, false, stringBuilder);
        }
        if (!((Collection)children).isEmpty()) {
            this.process(children.get(children.size() - 1), treeNodeConverter, prefix + (lastInPeers ? indentation : "\u2502   "), false, true, stringBuilder);
        }
    }

    @NotNull
    public final String toString(@NotNull PrintableTreeNode root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        StringBuilder stringBuilder = new StringBuilder();
        TreeNodeConverter converter2 = new TreeNodeConverter<PrintableTreeNode>(){

            public String name(PrintableTreeNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                return node.name();
            }

            public List<PrintableTreeNode> children(PrintableTreeNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                return node.children();
            }
        };
        this.process(root, converter2, "", true, true, stringBuilder);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final <T> String toString(T root, @NotNull TreeNodeConverter<T> treeNodeConverter) {
        Intrinsics.checkNotNullParameter(treeNodeConverter, (String)"treeNodeConverter");
        StringBuilder stringBuilder = new StringBuilder();
        this.process(root, treeNodeConverter, "", true, true, stringBuilder);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

