/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.docker.gateway.ui;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.clouds.docker.gateway.DevcontainerDeployContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.ImageUtil;
import com.jetbrains.gateway.thinClientLink.ThinClientHandle;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Taskbar;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.nio.file.Path;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/clouds/docker/gateway/ui/DevcontainerMainIdeWindowManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "appImages", "Lcom/intellij/clouds/docker/gateway/ui/DevcontainerMainIdeWindowManager$AppImages;", "getAppImages", "()Lcom/intellij/clouds/docker/gateway/ui/DevcontainerMainIdeWindowManager$AppImages;", "appImages$delegate", "Lkotlin/Lazy;", "onClientStart", "", "handle", "Lcom/jetbrains/gateway/thinClientLink/ThinClientHandle;", "toGrayScaleImage", "Ljava/awt/Image;", "originalImage", "getIdeFrame", "Ljava/awt/Container;", "AppImages", "Companion", "intellij.clouds.docker.gateway"})
@SourceDebugExtension(value={"SMAP\nDevcontainerMainIdeWindowManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevcontainerMainIdeWindowManager.kt\ncom/intellij/clouds/docker/gateway/ui/DevcontainerMainIdeWindowManager\n+ 2 promise.kt\norg/jetbrains/concurrency/Promises__PromiseKt\n*L\n1#1,122:1\n212#2,12:123\n*S KotlinDebug\n*F\n+ 1 DevcontainerMainIdeWindowManager.kt\ncom/intellij/clouds/docker/gateway/ui/DevcontainerMainIdeWindowManager\n*L\n79#1:123,12\n*E\n"})
public final class DevcontainerMainIdeWindowManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy appImages$delegate;

    public DevcontainerMainIdeWindowManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.appImages$delegate = LazyKt.lazy(() -> DevcontainerMainIdeWindowManager.appImages_delegate$lambda$0(this));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final AppImages getAppImages() {
        Lazy lazy = this.appImages$delegate;
        return (AppImages)lazy.getValue();
    }

    public final void onClientStart(@NotNull ThinClientHandle handle2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)handle2, (String)"handle");
            long startTime = System.currentTimeMillis();
            Ref.BooleanRef initial = new Ref.BooleanRef();
            initial.element = true;
            Container container = this.getIdeFrame();
            if (container == null) break block0;
            Container frame = container;
            boolean bl = false;
            handle2.getOnClientPresenceChanged().advise(Lifetime.Companion.getEternal(), arg_0 -> DevcontainerMainIdeWindowManager.onClientStart$lambda$5$lambda$2(initial, startTime, handle2, frame, this, arg_0));
            handle2.getClientClosed().advise(Lifetime.Companion.getEternal(), arg_0 -> DevcontainerMainIdeWindowManager.onClientStart$lambda$5$lambda$4(frame, this, arg_0));
        }
    }

    private final Image toGrayScaleImage(Image originalImage) {
        BufferedImage bufferedImage = ImageUtil.createImage((int)originalImage.getWidth(null), (int)originalImage.getHeight(null), (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
        BufferedImage bufferedImage2 = bufferedImage;
        Graphics2D g2d = bufferedImage2.createGraphics();
        g2d.drawImage(originalImage, 0, 0, null);
        g2d.dispose();
        BufferedImage bufferedImage3 = ImageUtil.createImage((int)bufferedImage2.getWidth(), (int)bufferedImage2.getHeight(), (int)10);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage3, (String)"createImage(...)");
        BufferedImage grayscaleImage = bufferedImage3;
        g2d = grayscaleImage.createGraphics();
        g2d.drawImage((Image)bufferedImage2, 0, 0, null);
        g2d.dispose();
        return grayscaleImage;
    }

    private final Container getIdeFrame() {
        IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(this.project);
        Object object = ideFrame;
        return object != null && (object = object.getComponent()) != null ? ((Component)object).getParent() : null;
    }

    private static final AppImages appImages_delegate$lambda$0(DevcontainerMainIdeWindowManager this$0) {
        Taskbar taskbar = Taskbar.getTaskbar();
        Image appImage = taskbar.getIconImage();
        Intrinsics.checkNotNull((Object)appImage);
        return new AppImages(appImage, this$0.toGrayScaleImage(appImage));
    }

    private static final Unit onClientStart$lambda$5$lambda$2(Ref.BooleanRef $initial, long $startTime, ThinClientHandle $handle, Container $frame, DevcontainerMainIdeWindowManager this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($initial.element) {
            long delay = System.currentTimeMillis() - $startTime;
            boolean $i$f$runAsync = false;
            AsyncPromise promise$iv = new AsyncPromise();
            AppExecutorUtil.getAppExecutorService().execute(new Runnable(promise$iv, $initial, $handle, delay, $frame, this$0){
                final /* synthetic */ AsyncPromise $promise;
                final /* synthetic */ Ref.BooleanRef $initial$inlined;
                final /* synthetic */ ThinClientHandle $handle$inlined;
                final /* synthetic */ long $delay$inlined;
                final /* synthetic */ Container $frame$inlined;
                final /* synthetic */ DevcontainerMainIdeWindowManager this$0;
                {
                    this.$promise = $promise;
                    this.$initial$inlined = booleanRef;
                    this.$handle$inlined = thinClientHandle;
                    this.$delay$inlined = l;
                    this.$frame$inlined = container;
                    this.this$0 = devcontainerMainIdeWindowManager;
                }

                public final void run() {
                    Unit unit;
                    try {
                        boolean bl = false;
                        this.$initial$inlined.element = false;
                        this.$handle$inlined.focusClientWindow();
                        TimeoutUtil.sleep((long)this.$delay$inlined);
                        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this.$frame$inlined, this.this$0){
                            final /* synthetic */ Container $frame;
                            final /* synthetic */ DevcontainerMainIdeWindowManager this$0;
                            {
                                this.$frame = $frame;
                                this.this$0 = $receiver;
                            }

                            public final void invoke() {
                                this.$frame.setVisible(false);
                                if (SystemInfoRt.isMac) {
                                    Taskbar.getTaskbar().setIconImage(DevcontainerMainIdeWindowManager.access$getAppImages(this.this$0).getGrayed());
                                }
                            }
                        }), (int)1, null);
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable e) {
                        this.$promise.setError(e);
                        return;
                    }
                    Unit result2 = unit;
                    this.$promise.setResult((Object)result2);
                }
            });
            Promise cfr_ignored_0 = (Promise)promise$iv;
        }
        return Unit.INSTANCE;
    }

    private static final Unit onClientStart$lambda$5$lambda$4$lambda$3(Container $frame, DevcontainerMainIdeWindowManager this$0) {
        $frame.setVisible(true);
        if (SystemInfoRt.isMac) {
            Taskbar.getTaskbar().setIconImage(this$0.getAppImages().getNormal());
        }
        return Unit.INSTANCE;
    }

    private static final Unit onClientStart$lambda$5$lambda$4(Container $frame, DevcontainerMainIdeWindowManager this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ActionsKt.runInEdt$default(null, () -> DevcontainerMainIdeWindowManager.onClientStart$lambda$5$lambda$4$lambda$3($frame, this$0), (int)1, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ AppImages access$getAppImages(DevcontainerMainIdeWindowManager $this) {
        return $this.getAppImages();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/clouds/docker/gateway/ui/DevcontainerMainIdeWindowManager$AppImages;", "", "normal", "Ljava/awt/Image;", "grayed", "<init>", "(Ljava/awt/Image;Ljava/awt/Image;)V", "getNormal", "()Ljava/awt/Image;", "getGrayed", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.clouds.docker.gateway"})
    private static final class AppImages {
        @NotNull
        private final Image normal;
        @NotNull
        private final Image grayed;

        public AppImages(@NotNull Image normal, @NotNull Image grayed) {
            Intrinsics.checkNotNullParameter((Object)normal, (String)"normal");
            Intrinsics.checkNotNullParameter((Object)grayed, (String)"grayed");
            this.normal = normal;
            this.grayed = grayed;
        }

        @NotNull
        public final Image getNormal() {
            return this.normal;
        }

        @NotNull
        public final Image getGrayed() {
            return this.grayed;
        }

        @NotNull
        public final Image component1() {
            return this.normal;
        }

        @NotNull
        public final Image component2() {
            return this.grayed;
        }

        @NotNull
        public final AppImages copy(@NotNull Image normal, @NotNull Image grayed) {
            Intrinsics.checkNotNullParameter((Object)normal, (String)"normal");
            Intrinsics.checkNotNullParameter((Object)grayed, (String)"grayed");
            return new AppImages(normal, grayed);
        }

        public static /* synthetic */ AppImages copy$default(AppImages appImages, Image image, Image image2, int n, Object object) {
            if ((n & 1) != 0) {
                image = appImages.normal;
            }
            if ((n & 2) != 0) {
                image2 = appImages.grayed;
            }
            return appImages.copy(image, image2);
        }

        @NotNull
        public String toString() {
            return "AppImages(normal=" + this.normal + ", grayed=" + this.grayed + ")";
        }

        public int hashCode() {
            int result2 = this.normal.hashCode();
            result2 = result2 * 31 + this.grayed.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AppImages)) {
                return false;
            }
            AppImages appImages = (AppImages)other;
            if (!Intrinsics.areEqual((Object)this.normal, (Object)appImages.normal)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.grayed, (Object)appImages.grayed);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/clouds/docker/gateway/ui/DevcontainerMainIdeWindowManager$Companion;", "", "<init>", "()V", "isEnabled", "", "getInstance", "Lcom/intellij/clouds/docker/gateway/ui/DevcontainerMainIdeWindowManager;", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/clouds/docker/gateway/DevcontainerDeployContext;", "extractModelFile", "Ljava/nio/file/Path;", "extractModelPath", "", "jsonString", "intellij.clouds.docker.gateway"})
    @SourceDebugExtension(value={"SMAP\nDevcontainerMainIdeWindowManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevcontainerMainIdeWindowManager.kt\ncom/intellij/clouds/docker/gateway/ui/DevcontainerMainIdeWindowManager$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n13472#2,2:123\n1#3:125\n*S KotlinDebug\n*F\n+ 1 DevcontainerMainIdeWindowManager.kt\ncom/intellij/clouds/docker/gateway/ui/DevcontainerMainIdeWindowManager$Companion\n*L\n44#1:123,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isEnabled() {
            return Registry.Companion.is("devcontainers.hide.project.window.on.client.start");
        }

        @NotNull
        public final DevcontainerMainIdeWindowManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(DevcontainerMainIdeWindowManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (DevcontainerMainIdeWindowManager)object;
        }

        @Nullable
        public final DevcontainerMainIdeWindowManager getInstance(@NotNull DevcontainerDeployContext context) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Path path = this.extractModelFile(context);
                if (path == null) break block1;
                Path modelFile = path;
                boolean bl = false;
                Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
                Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
                Object[] $this$forEach$iv = projectArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it;
                    Project project = (Project)element$iv;
                    boolean bl2 = false;
                    if (project.getBasePath() == null) continue;
                    boolean bl3 = false;
                    if (!modelFile.startsWith(Path.of(it, new String[0]))) continue;
                    Intrinsics.checkNotNull((Object)project);
                    return Companion.getInstance(project);
                }
            }
            return null;
        }

        private final Path extractModelFile(DevcontainerDeployContext context) {
            Object object = context.getBuildFromLocalSources();
            if (object != null && (object = object.getModelFile()) != null) {
                Object it = object;
                boolean bl = false;
                return it;
            }
            Object object2 = context.getDevcontainer();
            if (object2 != null && (object2 = object2.getAgentContainer()) != null && (object2 = object2.getContainerLabels()) != null) {
                Object labels = object2;
                boolean bl = false;
                String string = (String)labels.get("com.intellij.devcontainer.local.source");
                if (string != null) {
                    String it = string;
                    boolean bl2 = false;
                    String string2 = Companion.extractModelPath(it);
                    if (string2 != null) {
                        String it2 = string2;
                        boolean bl3 = false;
                        return Path.of(new URI(it2));
                    }
                }
            }
            return null;
        }

        private final String extractModelPath(String jsonString) {
            ObjectMapper mapper = new ObjectMapper(JsonFactory.builder().build());
            JsonNode jsonNode = mapper.readTree(jsonString);
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"readTree(...)");
            JsonNode rootNode = jsonNode;
            return rootNode.get("modelFile").asText();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

