/*
 * Decompiled with CFR 0.152.
 */
package runtime.routing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.net.EncodingKt;
import runtime.routing.Location;
import runtime.routing.LocationMatchType;
import runtime.routing.LocationParameterBuilder;
import runtime.routing.LocationParameterBuilderKt;
import runtime.routing.LocationParameters;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001aB\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00012\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\r2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\r\u001a\u0018\u0010\u000f\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0001\u001a:\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00032\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\r2\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\r\u001a:\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00032\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\r2\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\r\u001a\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0003\u001a\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0003\u001a$\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\u00032\b\b\u0002\u0010\u001c\u001a\u00020\u0001\u001a$\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001d\u001a\u00020\u00062\b\b\u0002\u0010\u001c\u001a\u00020\u0001\u001a&\u0010\u0005\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u001e*\b\u0012\u0004\u0012\u0002H\u001e0\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001e0\u001fH\u0002\u00a8\u0006!"}, d2={"isPrefixMatch", "", "href", "", "baseHref", "startsWith", "Lruntime/routing/Location;", "other", "joinUrlParamsToQueryString", "params", "Lruntime/routing/LocationParameters;", "ignoreEmptyValues", "encodeKey", "Lkotlin/Function1;", "encodeValue", "encodeAndJoinUrlParamsToQueryString", "parseUrlParameters", "url", "decodeKey", "decodeValue", "parseUrlParametersFromQueryString", "queryString", "parseAndDecodeUrlParametersFromQueryString", "parseAndDecodeUrlParameters", "matchLocation", "Lruntime/routing/LocationMatchType;", "location", "currentUrl", "matchQueryParameters", "currentLocation", "T", "", "prefix", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nLocation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Location.kt\nruntime/routing/LocationKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,249:1\n774#2:250\n865#2,2:251\n774#2:253\n865#2,2:254\n1863#2,2:257\n1863#2,2:260\n1317#3:256\n1318#3:259\n*S KotlinDebug\n*F\n+ 1 Location.kt\nruntime/routing/LocationKt\n*L\n119#1:250\n119#1:251,2\n120#1:253\n120#1:254,2\n144#1:257,2\n183#1:260,2\n143#1:256\n143#1:259\n*E\n"})
public final class LocationKt {
    /*
     * WARNING - void declaration
     */
    public static final boolean isPrefixMatch(@NotNull String href, @NotNull String baseHref) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)href, (String)"href");
        Intrinsics.checkNotNullParameter((Object)baseHref, (String)"baseHref");
        String[] stringArray = new String[]{"/"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)StringsKt.substringBefore$default((String)href, (String)"?", null, (int)2, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)""))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List pathPrefix = (List)destination$iv$iv;
        String[] $i$f$filter22 = new String[]{"/"};
        Iterable $this$filter$iv2 = StringsKt.split$default((CharSequence)StringsKt.substringBefore$default((String)baseHref, (String)"?", null, (int)2, null), (String[])$i$f$filter22, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)""))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List hrefPrefix = (List)destination$iv$iv2;
        if (pathPrefix.isEmpty() || hrefPrefix.isEmpty()) {
            return false;
        }
        return Intrinsics.areEqual((Object)CollectionsKt.take((Iterable)pathPrefix, (int)hrefPrefix.size()), (Object)hrefPrefix);
    }

    public static final boolean startsWith(@NotNull Location $this$startsWith, @NotNull Location other) {
        Intrinsics.checkNotNullParameter((Object)$this$startsWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return LocationKt.isPrefixMatch($this$startsWith.getUrl(), other.getUrl());
    }

    @NotNull
    public static final String joinUrlParamsToQueryString(@NotNull LocationParameters params, boolean ignoreEmptyValues, @NotNull Function1<? super String, String> encodeKey, @NotNull Function1<? super String, String> encodeValue) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(encodeKey, (String)"encodeKey");
        Intrinsics.checkNotNullParameter(encodeValue, (String)"encodeValue");
        StringBuilder $this$joinUrlParamsToQueryString_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Map<String, List<String>> filtered = ignoreEmptyValues ? params.getParametersNotEmpty() : params.getParameters();
        boolean needAmp = false;
        Sequence $this$forEach$iv = MapsKt.asSequence(filtered);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl2 = false;
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            Iterable $this$forEach$iv2 = values;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String value2 = (String)element$iv2;
                boolean bl3 = false;
                if (needAmp) {
                    $this$joinUrlParamsToQueryString_u24lambda_u246.append("&");
                }
                $this$joinUrlParamsToQueryString_u24lambda_u246.append((String)encodeKey.invoke((Object)key));
                $this$joinUrlParamsToQueryString_u24lambda_u246.append("=");
                $this$joinUrlParamsToQueryString_u24lambda_u246.append((String)encodeValue.invoke((Object)value2));
                needAmp = true;
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String joinUrlParamsToQueryString$default(LocationParameters locationParameters, boolean bl, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = LocationKt::joinUrlParamsToQueryString$lambda$2;
        }
        if ((n & 8) != 0) {
            function12 = LocationKt::joinUrlParamsToQueryString$lambda$3;
        }
        return LocationKt.joinUrlParamsToQueryString(locationParameters, bl, (Function1<? super String, String>)function1, (Function1<? super String, String>)function12);
    }

    @NotNull
    public static final String encodeAndJoinUrlParamsToQueryString(@NotNull LocationParameters params, boolean ignoreEmptyValues) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return LocationKt.joinUrlParamsToQueryString(params, ignoreEmptyValues, (Function1<? super String, String>)((Function1)LocationKt::encodeAndJoinUrlParamsToQueryString$lambda$7), (Function1<? super String, String>)((Function1)LocationKt::encodeAndJoinUrlParamsToQueryString$lambda$8));
    }

    public static /* synthetic */ String encodeAndJoinUrlParamsToQueryString$default(LocationParameters locationParameters, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return LocationKt.encodeAndJoinUrlParamsToQueryString(locationParameters, bl);
    }

    @NotNull
    public static final LocationParameters parseUrlParameters(@NotNull String url2, @NotNull Function1<? super String, String> decodeKey, @NotNull Function1<? super String, String> decodeValue) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        Intrinsics.checkNotNullParameter(decodeKey, (String)"decodeKey");
        Intrinsics.checkNotNullParameter(decodeValue, (String)"decodeValue");
        String queryString = StringsKt.substringAfter((String)url2, (char)'?', (String)"");
        return LocationKt.parseUrlParametersFromQueryString(queryString, decodeKey, decodeValue);
    }

    public static /* synthetic */ LocationParameters parseUrlParameters$default(String string, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = LocationKt::parseUrlParameters$lambda$9;
        }
        if ((n & 4) != 0) {
            function12 = LocationKt::parseUrlParameters$lambda$10;
        }
        return LocationKt.parseUrlParameters(string, (Function1<? super String, String>)function1, (Function1<? super String, String>)function12);
    }

    @NotNull
    public static final LocationParameters parseUrlParametersFromQueryString(@NotNull String queryString, @NotNull Function1<? super String, String> decodeKey, @NotNull Function1<? super String, String> decodeValue) {
        Intrinsics.checkNotNullParameter((Object)queryString, (String)"queryString");
        Intrinsics.checkNotNullParameter(decodeKey, (String)"decodeKey");
        Intrinsics.checkNotNullParameter(decodeValue, (String)"decodeValue");
        return LocationParameterBuilderKt.locationParameters((Function1<? super LocationParameterBuilder, Unit>)((Function1)arg_0 -> LocationKt.parseUrlParametersFromQueryString$lambda$14(queryString, decodeKey, decodeValue, arg_0)));
    }

    public static /* synthetic */ LocationParameters parseUrlParametersFromQueryString$default(String string, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = LocationKt::parseUrlParametersFromQueryString$lambda$11;
        }
        if ((n & 4) != 0) {
            function12 = LocationKt::parseUrlParametersFromQueryString$lambda$12;
        }
        return LocationKt.parseUrlParametersFromQueryString(string, (Function1<? super String, String>)function1, (Function1<? super String, String>)function12);
    }

    @NotNull
    public static final LocationParameters parseAndDecodeUrlParametersFromQueryString(@NotNull String queryString) {
        Intrinsics.checkNotNullParameter((Object)queryString, (String)"queryString");
        return LocationKt.parseUrlParametersFromQueryString(queryString, (Function1<? super String, String>)((Function1)LocationKt::parseAndDecodeUrlParametersFromQueryString$lambda$15), (Function1<? super String, String>)((Function1)LocationKt::parseAndDecodeUrlParametersFromQueryString$lambda$16));
    }

    @NotNull
    public static final LocationParameters parseAndDecodeUrlParameters(@NotNull String url2) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        return LocationKt.parseUrlParameters(url2, (Function1<? super String, String>)((Function1)LocationKt::parseAndDecodeUrlParameters$lambda$17), (Function1<? super String, String>)((Function1)LocationKt::parseAndDecodeUrlParameters$lambda$18));
    }

    @Nullable
    public static final LocationMatchType matchLocation(@Nullable Location location2, @NotNull String currentUrl, boolean matchQueryParameters) {
        Intrinsics.checkNotNullParameter((Object)currentUrl, (String)"currentUrl");
        Location currentLocation = Location.Companion.parse(currentUrl);
        return LocationKt.matchLocation(location2, currentLocation, matchQueryParameters);
    }

    public static /* synthetic */ LocationMatchType matchLocation$default(Location location2, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return LocationKt.matchLocation(location2, string, bl);
    }

    @Nullable
    public static final LocationMatchType matchLocation(@Nullable Location location2, @NotNull Location currentLocation, boolean matchQueryParameters) {
        LocationMatchType locationMatchType;
        boolean areParametersMatching;
        Intrinsics.checkNotNullParameter((Object)currentLocation, (String)"currentLocation");
        Object object = location2;
        if (object == null || (object = ((Location)object).getUrl()) == null) {
            return null;
        }
        Object locationUrl = object;
        if (matchQueryParameters && !(areParametersMatching = location2.getLocationParameters().match(currentLocation.getLocationParameters()))) {
            return null;
        }
        if (Intrinsics.areEqual((Object)currentLocation.getUrl(), (Object)locationUrl)) {
            locationMatchType = LocationMatchType.EXACT;
        } else {
            char[] cArray = new char[]{'/'};
            List list2 = StringsKt.split$default((CharSequence)currentLocation.getUrl(), (char[])cArray, (boolean)false, (int)0, (int)6, null);
            cArray = new char[]{'/'};
            locationMatchType = LocationKt.startsWith(list2, StringsKt.split$default((CharSequence)((CharSequence)locationUrl), (char[])cArray, (boolean)false, (int)0, (int)6, null)) ? LocationMatchType.PREFIX : null;
        }
        return locationMatchType;
    }

    public static /* synthetic */ LocationMatchType matchLocation$default(Location location2, Location location3, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return LocationKt.matchLocation(location2, location3, bl);
    }

    private static final <T> boolean startsWith(List<? extends T> $this$startsWith, List<? extends T> prefix) {
        if ($this$startsWith.size() < prefix.size()) {
            return false;
        }
        int n = ((Collection)prefix).size();
        for (int i = 0; i < n; ++i) {
            if (Intrinsics.areEqual($this$startsWith.get(i), prefix.get(i))) continue;
            return false;
        }
        return true;
    }

    private static final String joinUrlParamsToQueryString$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final String joinUrlParamsToQueryString$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final String encodeAndJoinUrlParamsToQueryString$lambda$7(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return EncodingKt.urlEncode(it);
    }

    private static final String encodeAndJoinUrlParamsToQueryString$lambda$8(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return EncodingKt.urlEncode(it);
    }

    private static final String parseUrlParameters$lambda$9(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final String parseUrlParameters$lambda$10(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final String parseUrlParametersFromQueryString$lambda$11(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final String parseUrlParametersFromQueryString$lambda$12(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit parseUrlParametersFromQueryString$lambda$14(String $queryString, Function1 $decodeKey, Function1 $decodeValue, LocationParameterBuilder $this$locationParameters) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)$queryString, (String)"$queryString");
        Intrinsics.checkNotNullParameter((Object)$decodeKey, (String)"$decodeKey");
        Intrinsics.checkNotNullParameter((Object)$decodeValue, (String)"$decodeValue");
        Intrinsics.checkNotNullParameter((Object)$this$locationParameters, (String)"$this$locationParameters");
        Object object = new char[]{'&'};
        object = StringsKt.split$default((CharSequence)StringsKt.substringBefore$default((String)$queryString, (String)"#", null, (int)2, null), (char[])object, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            String key = StringsKt.substringBefore$default((String)it, (char)'=', null, (int)2, null);
            String value2 = StringsKt.substringAfter((String)it, (char)'=', (String)"");
            if (!(!StringsKt.isBlank((CharSequence)key))) continue;
            $this$locationParameters.put((String)$decodeKey.invoke((Object)key), (String)$decodeValue.invoke((Object)value2));
        }
        return Unit.INSTANCE;
    }

    private static final String parseAndDecodeUrlParametersFromQueryString$lambda$15(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return EncodingKt.urlDecode(it);
    }

    private static final String parseAndDecodeUrlParametersFromQueryString$lambda$16(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return EncodingKt.urlDecode(it);
    }

    private static final String parseAndDecodeUrlParameters$lambda$17(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return EncodingKt.urlDecode(it);
    }

    private static final String parseAndDecodeUrlParameters$lambda$18(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return EncodingKt.urlDecode(StringsKt.replace$default((String)it, (String)"+", (String)"%20", (boolean)false, (int)4, null));
    }
}

